/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import java.util.Objects;

public class DocumentNode
extends NonTerminalNode {
    public DocumentNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<DocumentMemberDeclarationNode> members() {
        return new NodeList<DocumentMemberDeclarationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Token eofToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"members", "eofToken"};
    }

    public DocumentNode modify(NodeList<DocumentMemberDeclarationNode> members, Token eofToken) {
        if (this.checkForReferenceEquality(members.underlyingListNode(), eofToken)) {
            return this;
        }
        return NodeFactory.createDocumentNode(members, eofToken);
    }

    public DocumentNodeModifier modify() {
        return new DocumentNodeModifier(this);
    }

    public static class DocumentNodeModifier {
        private final DocumentNode oldNode;
        private NodeList<DocumentMemberDeclarationNode> members;
        private Token eofToken;

        public DocumentNodeModifier(DocumentNode oldNode) {
            this.oldNode = oldNode;
            this.members = oldNode.members();
            this.eofToken = oldNode.eofToken();
        }

        public DocumentNodeModifier withMembers(NodeList<DocumentMemberDeclarationNode> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public DocumentNodeModifier withEofToken(Token eofToken) {
            Objects.requireNonNull(eofToken, "eofToken must not be null");
            this.eofToken = eofToken;
            return this;
        }

        public DocumentNode apply() {
            return this.oldNode.modify(this.members, this.eofToken);
        }
    }
}

