/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator;

import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.NumericSchema;
import io.ballerina.toml.validator.schema.ObjectSchema;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SchemaValidator
extends TomlNodeVisitor {
    private AbstractSchema schema;
    private String key;

    public SchemaValidator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void visit(TomlTableNode tomlTableNode) {
        if (this.schema.type() != Type.OBJECT) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlTableNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found object", new Object[]{this.key, this.schema.type()}));
            tomlTableNode.addDiagnostic(diagnostic);
            return;
        }
        ObjectSchema objectSchema = (ObjectSchema)this.schema;
        Map<String, AbstractSchema> properties = objectSchema.properties();
        Map<String, TopLevelNode> tableEntries = tomlTableNode.entries();
        for (Map.Entry<String, TopLevelNode> tableEntry : tableEntries.entrySet()) {
            String key = tableEntry.getKey();
            TopLevelNode value = tableEntry.getValue();
            AbstractSchema schema = properties.get(key);
            if (schema != null) {
                this.visitNode(value, schema, key);
                continue;
            }
            if (objectSchema.hasAdditionalProperties()) continue;
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo("TVE0001", "warn.unexpected.property", DiagnosticSeverity.WARNING);
            TomlDiagnostic diagnostic = new TomlDiagnostic(value.location(), diagnosticInfo, "Unexpected Property \"" + key + "\"");
            tomlTableNode.addDiagnostic(diagnostic);
        }
    }

    @Override
    public void visit(TomlTableArrayNode tomlTableArrayNode) {
        if (this.schema.type() != Type.ARRAY) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlTableArrayNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found array", new Object[]{this.key, this.schema.type()}));
            tomlTableArrayNode.addDiagnostic(diagnostic);
            return;
        }
        ArraySchema arraySchema = (ArraySchema)this.schema;
        AbstractSchema memberSchema = arraySchema.items();
        List<TomlTableNode> children = tomlTableArrayNode.children();
        for (TomlTableNode child : children) {
            this.visitNode(child, memberSchema);
        }
    }

    @Override
    public void visit(TomlKeyValueNode keyValue) {
        TomlValueNode value = keyValue.value();
        this.visitNode(value);
    }

    @Override
    public void visit(TomlValueNode tomlValue) {
        this.visitNode(tomlValue);
    }

    @Override
    public void visit(TomlStringValueNode tomlStringValueNode) {
        String pattern;
        if (this.schema.type() != Type.STRING) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlStringValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found string", new Object[]{this.key, this.schema.type()}));
            tomlStringValueNode.addDiagnostic(diagnostic);
            return;
        }
        StringSchema stringSchema = (StringSchema)this.schema;
        if (stringSchema.pattern().isPresent() && !Pattern.compile(pattern = stringSchema.pattern().get()).matcher((CharSequence)tomlStringValueNode.getValue()).matches()) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlStringValueNode.location(), "TVE0003", "error.regex.mismatch", DiagnosticSeverity.ERROR, String.format("Key \"%s\" value does not match the Regex provided in Schema %s", this.key, pattern));
            tomlStringValueNode.addDiagnostic(diagnostic);
        }
    }

    @Override
    public void visit(TomlDoubleValueNodeNode tomlDoubleValueNodeNode) {
        if (this.schema.type() != Type.NUMBER) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlDoubleValueNodeNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found number", new Object[]{this.key, this.schema.type()}));
            tomlDoubleValueNodeNode.addDiagnostic(diagnostic);
            return;
        }
        List<Diagnostic> diagnostics = this.validateMinMaxValues((NumericSchema)this.schema, (Double)tomlDoubleValueNodeNode.getValue(), tomlDoubleValueNodeNode.location());
        tomlDoubleValueNodeNode.addDiagnostics(diagnostics);
    }

    @Override
    public void visit(TomlLongValueNode tomlLongValueNode) {
        if (this.schema.type() != Type.INTEGER) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlLongValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found integer", new Object[]{this.key, this.schema.type()}));
            tomlLongValueNode.addDiagnostic(diagnostic);
            return;
        }
        List<Diagnostic> diagnostics = this.validateMinMaxValues((NumericSchema)this.schema, (double)((Long)tomlLongValueNode.getValue()), tomlLongValueNode.location());
        for (Diagnostic diagnostic : diagnostics) {
            tomlLongValueNode.addDiagnostic(diagnostic);
        }
    }

    private List<Diagnostic> validateMinMaxValues(NumericSchema numericSchema, Double value, TomlNodeLocation location) {
        TomlDiagnostic diagnostic;
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (numericSchema.maximum().isPresent()) {
            Double max = numericSchema.maximum().get();
            if (value >= max) {
                diagnostic = this.getTomlDiagnostic(location, "TVE0005", "error.maximum.value.exceed", DiagnosticSeverity.ERROR, String.format("Key \"%s\" value can't be higher than %f", this.key, max));
                diagnostics.add(diagnostic);
            }
        }
        if (numericSchema.minimum().isPresent()) {
            Double min = numericSchema.minimum().get();
            if (value <= min) {
                diagnostic = this.getTomlDiagnostic(location, "TVE0004", "error.minimum.value.deceed", DiagnosticSeverity.ERROR, String.format("Key \"%s\" value can't be lower than %f", this.key, min));
                diagnostics.add(diagnostic);
            }
        }
        return diagnostics;
    }

    @Override
    public void visit(TomlBooleanValueNode tomlBooleanValueNode) {
        if (this.schema.type() != Type.BOOLEAN) {
            TomlDiagnostic diagnostic = this.getTomlDiagnostic(tomlBooleanValueNode.location(), "TVE0002", "error.invalid.type", DiagnosticSeverity.ERROR, String.format("Key \"%s\" expects %s . Found boolean", new Object[]{this.key, this.schema.type()}));
            tomlBooleanValueNode.addDiagnostic(diagnostic);
        }
    }

    private void visitNode(TomlNode node) {
        AbstractSchema previousSchema = this.schema;
        String previousKey = this.key;
        node.accept(this);
        this.schema = previousSchema;
        this.key = previousKey;
    }

    private void visitNode(TomlNode node, AbstractSchema schema) {
        AbstractSchema previousSchema = this.schema;
        this.schema = schema;
        node.accept(this);
        this.schema = previousSchema;
    }

    private void visitNode(TomlNode node, AbstractSchema schema, String key) {
        AbstractSchema previousSchema = this.schema;
        String previousKey = this.key;
        this.schema = schema;
        this.key = key;
        node.accept(this);
        this.schema = previousSchema;
        this.key = previousKey;
    }

    private TomlDiagnostic getTomlDiagnostic(TomlNodeLocation location, String code, String template, DiagnosticSeverity severity, String message) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, template, severity);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }
}

