/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import io.ballerina.tools.text.LinePosition;
import java.util.Objects;

public class LineRange {
    private final String filePath;
    private final LinePosition startLine;
    private final LinePosition endLine;

    private LineRange(String filePath, LinePosition startLine, LinePosition endLine) {
        this.filePath = filePath;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public static LineRange from(String filePath, LinePosition startLine, LinePosition endLine) {
        return new LineRange(filePath, startLine, endLine);
    }

    public String filePath() {
        return this.filePath;
    }

    public LinePosition startLine() {
        return this.startLine;
    }

    public LinePosition endLine() {
        return this.endLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineRange lineRange = (LineRange)o;
        return Objects.equals(this.startLine, lineRange.startLine) && Objects.equals(this.endLine, lineRange.endLine);
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.endLine);
    }

    public String toString() {
        return "(" + this.startLine + "," + this.endLine + ")";
    }
}

