/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import io.ballerina.tools.text.LineMap;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextLine;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;

class StringTextDocument
extends TextDocument {
    private final String text;
    private LineMap textLineMap;

    StringTextDocument(String text) {
        this.text = text;
    }

    @Override
    public TextDocument apply(TextDocumentChange textDocumentChange) {
        int startOffset = 0;
        StringBuilder sb = new StringBuilder();
        int textEditCount = textDocumentChange.getTextEditCount();
        for (int i = 0; i < textEditCount; ++i) {
            TextEdit textEdit = textDocumentChange.getTextEdit(i);
            TextRange textRange = textEdit.range();
            sb.append(this.text, startOffset, textRange.startOffset());
            sb.append(textEdit.text());
            startOffset = textRange.endOffset();
        }
        sb.append(this.text, startOffset, this.text.length());
        return new StringTextDocument(sb.toString());
    }

    @Override
    protected LineMap populateTextLineMap() {
        if (this.textLineMap != null) {
            return this.textLineMap;
        }
        this.textLineMap = new LineMap(this.calculateTextLines());
        return this.textLineMap;
    }

    @Override
    public char[] toCharArray() {
        return this.text.toCharArray();
    }

    public String toString() {
        return this.text;
    }

    private TextLine[] calculateTextLines() {
        int startOffset = 0;
        ArrayList<TextLine> textLines = new ArrayList<TextLine>();
        StringBuilder lineBuilder = new StringBuilder();
        int index = 0;
        int line = 0;
        int textLength = this.text.length();
        while (index < textLength) {
            char c = this.text.charAt(index);
            if (c == '\r' || c == '\n') {
                int nextCharIndex = index + 1;
                int lengthOfNewLineChars = c == '\r' && textLength != nextCharIndex && this.text.charAt(nextCharIndex) == '\n' ? 2 : 1;
                String strLine = lineBuilder.toString();
                int endOffset = startOffset + strLine.length();
                textLines.add(new TextLine(line++, strLine, startOffset, endOffset, lengthOfNewLineChars));
                startOffset = endOffset + lengthOfNewLineChars;
                lineBuilder = new StringBuilder();
                index += lengthOfNewLineChars;
                continue;
            }
            lineBuilder.append(c);
            ++index;
        }
        String strLine = lineBuilder.toString();
        textLines.add(new TextLine(line, strLine, startOffset, startOffset + strLine.length(), 0));
        return textLines.toArray(new TextLine[0]);
    }
}

