/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.ballerinalang.central.client.BuildLogFormatter;
import org.ballerinalang.central.client.LogFormatter;
import org.ballerinalang.central.client.Utils;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.ConnectionErrorException;
import org.ballerinalang.central.client.exceptions.NoPackageException;
import org.ballerinalang.central.client.model.Error;
import org.ballerinalang.central.client.model.Package;
import org.ballerinalang.central.client.model.PackageSearchResult;

public class CentralAPIClient {
    private Proxy proxy;
    private String baseUrl;
    protected PrintStream outStream = System.out;
    private static final String PACKAGES = "packages";
    private static final String ERR_CANNOT_CONNECT = "error: could not connect to remote repository to find package: ";
    private static final String ERR_CANNOT_PUSH = "error: failed to push the package: ";

    public CentralAPIClient(String baseUrl, Proxy proxy) {
        this.baseUrl = baseUrl;
        this.proxy = proxy;
    }

    public Package getPackage(String orgNamePath, String packageNamePath, String version, String supportedPlatform) throws CentralClientException {
        int statusCode;
        HttpURLConnection conn;
        String pkg;
        block28: {
            Utils.initializeSsl();
            String url = "packages/" + orgNamePath + "/" + packageNamePath;
            if (null != version && !version.isEmpty()) {
                url = url + "/" + version;
            }
            pkg = orgNamePath + "/" + packageNamePath + ":" + version;
            conn = this.createHttpUrlConnection(url);
            conn.setInstanceFollowRedirects(false);
            Utils.setRequestMethod(conn, Utils.RequestMethod.GET);
            conn.setRequestProperty("Ballerina-Platform", supportedPlatform);
            statusCode = Utils.getStatusCode(conn);
            if (statusCode == 200) {
                Package package_;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                try {
                    package_ = new Gson().fromJson((Reader)reader, Package.class);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CentralClientException(e.getMessage());
                    }
                }
                reader.close();
                return package_;
            }
            if (statusCode != 404) break block28;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));
                try {
                    Error errorJsonSchema = new Gson().fromJson((Reader)reader, Error.class);
                    if (errorJsonSchema.getMessage().contains("package not found for:")) {
                        throw new NoPackageException(errorJsonSchema.getMessage());
                    }
                    throw new CentralClientException(ERR_CANNOT_CONNECT + pkg + ". reason: " + errorJsonSchema.getMessage());
                }
                catch (Throwable errorJsonSchema) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        errorJsonSchema.addSuppressed(throwable);
                    }
                    throw errorJsonSchema;
                }
            }
            catch (IOException e) {
                throw new CentralClientException(e.getMessage());
            }
        }
        if (statusCode == 400) {
            try {
                BufferedReader errorStream = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                try {
                    Error errorJsonSchema = new Gson().fromJson((Reader)errorStream, Error.class);
                    if (errorJsonSchema.getMessage() != null && !"".equals(errorJsonSchema.getMessage())) {
                        throw new CentralClientException(errorJsonSchema.getMessage());
                    }
                    throw new CentralClientException(ERR_CANNOT_CONNECT + pkg + ". reason:" + errorStream.lines().collect(Collectors.joining("\n")));
                }
                catch (Throwable throwable) {
                    try {
                        errorStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CentralClientException(e.getMessage());
            }
        }
        throw new CentralClientException(ERR_CANNOT_CONNECT + pkg + ".");
        finally {
            conn.disconnect();
            Authenticator.setDefault(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getPackageVersions(String orgNamePath, String packageNamePath, String supportedPlatform) throws CentralClientException {
        Utils.initializeSsl();
        url = "packages/" + orgNamePath + "/" + packageNamePath;
        conn = this.createHttpUrlConnection(url);
        conn.setInstanceFollowRedirects(false);
        Utils.setRequestMethod(conn, Utils.RequestMethod.GET);
        conn.setRequestProperty("Ballerina-Platform", supportedPlatform);
        statusCode = Utils.getStatusCode(conn);
        if (statusCode == 200) {
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
            try {
                collect = reader.lines().collect(Collectors.joining());
                var9_15 = Utils.getAsList(collect);
            }
            catch (Throwable collect) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable var9_16) {
                        collect.addSuppressed(var9_16);
                    }
                    throw collect;
                }
                catch (IOException e) {
                    throw new CentralClientException(e.getMessage());
                }
            }
            reader.close();
            return var9_15;
        }
        if (statusCode != 404) break block21;
        reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));
        errorJsonSchema = new Gson().fromJson((Reader)reader, Error.class);
        if (!errorJsonSchema.getMessage().contains("package not found")) ** GOTO lbl-1000
        var9_17 = new ArrayList<String>();
        reader.close();
        return var9_17;
lbl-1000:
        // 1 sources

        {
            block21: {
                try {
                    throw new CentralClientException("error: could not connect to remote repository to find versions for: " + orgNamePath + "/" + packageNamePath + ". reason: " + errorJsonSchema.getMessage());
                    {
                        catch (Throwable var8_14) {
                            try {
                                reader.close();
                            }
                            catch (Throwable var9_18) {
                                var8_14.addSuppressed(var9_18);
                            }
                            throw var8_14;
                        }
                    }
                }
                catch (IOException e) {
                    throw new CentralClientException(e.getMessage());
                }
            }
            throw new CentralClientException("error: could not connect to remote repository to find versions for: " + orgNamePath + "/" + packageNamePath + ".");
        }
        finally {
            conn.disconnect();
            Authenticator.setDefault(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPackage(Path baloPath, String org, String name, String version, String accessToken) throws CentralClientException {
        block32: {
            int noOfBytes = 64;
            int bufferSize = 65536;
            Utils.initializeSsl();
            HttpURLConnection conn = this.createHttpUrlConnection(PACKAGES);
            conn.setInstanceFollowRedirects(false);
            Utils.setRequestMethod(conn, Utils.RequestMethod.POST);
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(65536);
            try (DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());){
                byte[] buffer = new byte[65536];
                try (ProgressBar progressBar = new ProgressBar(org + "/" + name + ":" + version + " [project repo -> central]", Utils.getTotalFileSizeInKB(baloPath), 1000, this.outStream, ProgressBarStyle.ASCII, " KB", 1L);
                     FileInputStream fis = new FileInputStream(baloPath.toFile());){
                    int count;
                    while ((count = fis.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, count);
                        outputStream.flush();
                        progressBar.stepBy(64L);
                    }
                }
            }
            catch (IOException e) {
                throw new CentralClientException("error occurred while uploading balo to central: " + e.getMessage());
            }
            try {
                int statusCode = Utils.getStatusCode(conn);
                if (statusCode == 204) {
                    this.outStream.println(org + "/" + name + ":" + version + " pushed to central successfully");
                    break block32;
                }
                if (statusCode == 400) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));
                        try {
                            Error errorJsonSchema = new Gson().fromJson((Reader)reader, Error.class);
                            if (errorJsonSchema.getMessage() != null && !"".equals(errorJsonSchema.getMessage())) {
                                throw new CentralClientException(errorJsonSchema.getMessage());
                            }
                            throw new CentralClientException("error: failed to push the package: '" + org + "/" + name + ":" + version + "' reason:" + reader.lines().collect(Collectors.joining("\n")));
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new CentralClientException("error: failed to push the package: '" + org + "/" + name + ":" + version + "' to the remote repository '" + conn.getURL() + "'");
                    }
                }
                if (statusCode == 401) {
                    throw new CentralClientException("unauthorized access token for organization: " + org);
                }
                throw new CentralClientException("error: failed to push the package: '" + org + "/" + name + ":" + version + "' to the remote repository '" + conn.getURL() + "'");
            }
            finally {
                conn.disconnect();
                Authenticator.setDefault(null);
            }
        }
    }

    public void pullPackage(String org, String name, String version, Path packagePathInBaloCache, String supportedPlatform, String ballerinaVersion, boolean isBuild) throws CentralClientException {
        block13: {
            LogFormatter logFormatter = new LogFormatter();
            if (isBuild) {
                logFormatter = new BuildLogFormatter();
            }
            String url = "packages/" + org + "/" + name;
            url = null != version && !version.isEmpty() ? url + "/" + version : url + "/*";
            Utils.initializeSsl();
            HttpURLConnection conn = this.createHttpUrlConnection(url);
            conn.setInstanceFollowRedirects(false);
            Utils.setRequestMethod(conn, Utils.RequestMethod.GET);
            conn.setRequestProperty("Ballerina-Platform", supportedPlatform);
            conn.setRequestProperty("Accept-Encoding", "identity");
            conn.setRequestProperty("User-Agent", ballerinaVersion);
            conn.setRequestProperty("Accept", "application/octet-stream");
            try {
                if (Utils.getStatusCode(conn) == 302) {
                    String newUrl = conn.getHeaderField("Location");
                    String contentDisposition = conn.getHeaderField("Content-Disposition");
                    conn = this.proxy == null ? (HttpURLConnection)Utils.convertToUrl(newUrl).openConnection() : (HttpURLConnection)Utils.convertToUrl(newUrl).openConnection(this.proxy);
                    conn.setRequestProperty("Content-Disposition", contentDisposition);
                    boolean isNightlyBuild = ballerinaVersion.contains("SNAPSHOT");
                    Utils.createBaloInHomeRepo(conn, packagePathInBaloCache, org + "/" + name, isNightlyBuild, newUrl, contentDisposition, this.outStream, logFormatter);
                    break block13;
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));
                    try {
                        Error errorJsonSchema = new Gson().fromJson((Reader)reader, Error.class);
                        throw new CentralClientException(logFormatter.formatLog("error: " + errorJsonSchema.getMessage()));
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new CentralClientException(logFormatter.formatLog("failed to pull the package '" + org + "/" + name + "' from the remote repository '" + url + "'"));
                }
            }
            catch (IOException e) {
                throw new CentralClientException(e.getMessage());
            }
            finally {
                conn.disconnect();
                Authenticator.setDefault(null);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public PackageSearchResult searchPackage(String query) throws CentralClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HttpURLConnection createHttpUrlConnection(String paths) throws ConnectionErrorException {
        URL url = Utils.convertToUrl(this.baseUrl + "/" + paths);
        try {
            if (this.proxy == null) {
                return (HttpURLConnection)url.openConnection();
            }
            return (HttpURLConnection)url.openConnection(this.proxy);
        }
        catch (IOException e) {
            throw new ConnectionErrorException("Creating connection to '" + url + "' failed:" + e.getMessage());
        }
    }
}

