/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.values;

import java.math.BigDecimal;
import java.util.Map;
import org.ballerinalang.core.model.types.BType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueType;

public final class BBoolean
extends BValueType
implements BRefType<Boolean> {
    public static final BBoolean TRUE = new BBoolean(true);
    public static final BBoolean FALSE = new BBoolean(false);
    private boolean value;
    private BType type = BTypes.typeBoolean;

    public BBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public long byteValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double floatValue() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value ? BigDecimal.ONE.setScale(1, 6) : BigDecimal.ZERO.setScale(1, 6);
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoolean bBoolean = (BBoolean)o;
        return this.value == bBoolean.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public Boolean value() {
        return this.value;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }
}

