/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ErrorTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.generator.model.Annotation;
import org.ballerinalang.docgen.generator.model.BAbstractObject;
import org.ballerinalang.docgen.generator.model.BClass;
import org.ballerinalang.docgen.generator.model.BType;
import org.ballerinalang.docgen.generator.model.Client;
import org.ballerinalang.docgen.generator.model.Constant;
import org.ballerinalang.docgen.generator.model.DefaultableVariable;
import org.ballerinalang.docgen.generator.model.Error;
import org.ballerinalang.docgen.generator.model.Function;
import org.ballerinalang.docgen.generator.model.Listener;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.Record;
import org.ballerinalang.docgen.generator.model.Type;
import org.ballerinalang.docgen.generator.model.Variable;

public class Generator {
    private static final String EMPTY_STRING = "";
    private static final String RETURN_PARAM_NAME = "return";

    public static boolean setModuleFromSyntaxTree(Module module, SyntaxTree syntaxTree, BallerinaSemanticModel semanticModel, String fileName) {
        boolean hasPublicConstructs = false;
        if (syntaxTree.containsModulePart()) {
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            for (Node node : modulePartNode.members()) {
                if (node.kind().equals((Object)SyntaxKind.TYPE_DEFINITION)) {
                    TypeDefinitionNode typeDefinition = (TypeDefinitionNode)node;
                    if ((!typeDefinition.visibilityQualifier().isPresent() || !typeDefinition.visibilityQualifier().get().kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) && !Generator.isTypePram(typeDefinition.metadata())) continue;
                    if (typeDefinition.typeDescriptor().kind().equals((Object)SyntaxKind.RECORD_TYPE_DESC)) {
                        hasPublicConstructs = true;
                        module.records.add(Generator.getRecordTypeModel(typeDefinition, semanticModel, fileName));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.OBJECT_TYPE_DESC) {
                        hasPublicConstructs = true;
                        module.abstractObjects.add(Generator.getAbstractObjectModel(typeDefinition, semanticModel, fileName));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.UNION_TYPE_DESC) {
                        hasPublicConstructs = true;
                        module.types.add(Generator.getUnionTypeModel(typeDefinition, semanticModel, fileName));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                        hasPublicConstructs = true;
                        module.types.add(Generator.getUnionTypeModel(typeDefinition, semanticModel, fileName));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.DISTINCT_TYPE_DESC && ((DistinctTypeDescriptorNode)typeDefinition.typeDescriptor()).typeDescriptor().kind() == SyntaxKind.ERROR_TYPE_DESC) {
                        hasPublicConstructs = true;
                        module.errors.add(new Error(typeDefinition.typeName().text(), Generator.getDocFromMetadata(typeDefinition.metadata()), Generator.isDeprecated(typeDefinition.metadata()), null));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.ERROR_TYPE_DESC) {
                        hasPublicConstructs = true;
                        ErrorTypeDescriptorNode errorTypeDescriptor = (ErrorTypeDescriptorNode)typeDefinition.typeDescriptor();
                        Type type = null;
                        if (errorTypeDescriptor.errorTypeParamsNode().isPresent()) {
                            type = Type.fromNode(errorTypeDescriptor.errorTypeParamsNode().get().parameter(), semanticModel, fileName);
                        }
                        module.errors.add(new Error(typeDefinition.typeName().text(), Generator.getDocFromMetadata(typeDefinition.metadata()), Generator.isDeprecated(typeDefinition.metadata()), type));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() == SyntaxKind.TUPLE_TYPE_DESC) {
                        hasPublicConstructs = true;
                        module.types.add(Generator.getTupleTypeModel(typeDefinition, semanticModel, fileName));
                        continue;
                    }
                    if (typeDefinition.typeDescriptor().kind() != SyntaxKind.INTERSECTION_TYPE_DESC) continue;
                    hasPublicConstructs = true;
                    module.types.add(Generator.getIntersectionTypeModel(typeDefinition, semanticModel, fileName));
                    continue;
                }
                if (node.kind() == SyntaxKind.CLASS_DEFINITION) {
                    ClassDefinitionNode classDefinition = (ClassDefinitionNode)node;
                    if (!classDefinition.visibilityQualifier().isPresent() || !classDefinition.visibilityQualifier().get().kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                    hasPublicConstructs = true;
                    BClass cls = Generator.getClassModel((ClassDefinitionNode)node, semanticModel, fileName);
                    if (cls instanceof Client) {
                        module.clients.add((Client)cls);
                        continue;
                    }
                    if (cls instanceof Listener) {
                        module.listeners.add((Listener)cls);
                        continue;
                    }
                    module.classes.add(cls);
                    continue;
                }
                if (node.kind() == SyntaxKind.FUNCTION_DEFINITION && Generator.containsToken(((FunctionDefinitionNode)node).qualifierList(), SyntaxKind.PUBLIC_KEYWORD)) {
                    hasPublicConstructs = true;
                    module.functions.add(Generator.getFunctionModel((FunctionDefinitionNode)node, semanticModel, fileName));
                    continue;
                }
                if (node.kind() == SyntaxKind.CONST_DECLARATION && ((ConstantDeclarationNode)node).visibilityQualifier().isPresent() && ((ConstantDeclarationNode)node).visibilityQualifier().get().kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) {
                    hasPublicConstructs = true;
                    module.constants.add(Generator.getConstantTypeModel((ConstantDeclarationNode)node, semanticModel, fileName));
                    continue;
                }
                if (node.kind() != SyntaxKind.ANNOTATION_DECLARATION || !((AnnotationDeclarationNode)node).visibilityQualifier().isPresent() || !((AnnotationDeclarationNode)node).visibilityQualifier().get().kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                hasPublicConstructs = true;
                module.annotations.add(Generator.getAnnotationModel((AnnotationDeclarationNode)node, semanticModel, fileName));
            }
        }
        return hasPublicConstructs;
    }

    private static boolean containsToken(NodeList<Token> nodeList, SyntaxKind kind) {
        for (Node node : nodeList) {
            if (node.kind() != kind) continue;
            return true;
        }
        return false;
    }

    public static Annotation getAnnotationModel(AnnotationDeclarationNode annotationDeclaration, BallerinaSemanticModel semanticModel, String fileName) {
        String annotationName = annotationDeclaration.annotationTag().text();
        StringJoiner attachPointJoiner = new StringJoiner(", ");
        for (int i = 0; i < annotationDeclaration.attachPoints().size(); ++i) {
            AnnotationAttachPointNode annotationAttachPointNode = (AnnotationAttachPointNode)annotationDeclaration.attachPoints().get(i);
            attachPointJoiner.add(annotationAttachPointNode.toString());
        }
        Type dataType = annotationDeclaration.typeDescriptor().isPresent() ? Type.fromNode(annotationDeclaration.typeDescriptor().get(), semanticModel, fileName) : null;
        return new Annotation(annotationName, Generator.getDocFromMetadata(annotationDeclaration.metadata()), Generator.isDeprecated(annotationDeclaration.metadata()), dataType, attachPointJoiner.toString());
    }

    public static Constant getConstantTypeModel(ConstantDeclarationNode constantNode, BallerinaSemanticModel semanticModel, String fileName) {
        Type type;
        String constantName = constantNode.variableName().text();
        String value = constantNode.initializer().toString();
        String desc = Generator.getDocFromMetadata(constantNode.metadata());
        if (constantNode.typeDescriptor().isPresent()) {
            type = Type.fromNode(constantNode.typeDescriptor().get(), semanticModel, fileName);
        } else {
            String dataType = EMPTY_STRING;
            if (constantNode.initializer().kind() == SyntaxKind.STRING_LITERAL) {
                dataType = "string";
            } else if (constantNode.initializer().kind() == SyntaxKind.BOOLEAN_LITERAL) {
                dataType = "boolean";
            } else if (constantNode.initializer().kind() == SyntaxKind.NUMERIC_LITERAL) {
                if (((BasicLiteralNode)constantNode.initializer()).literalToken().kind().equals((Object)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN)) {
                    dataType = "int";
                } else if (((BasicLiteralNode)constantNode.initializer()).literalToken().kind().equals((Object)SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN)) {
                    dataType = "float";
                }
            }
            type = new Type(dataType);
        }
        return new Constant(constantName, desc, Generator.isDeprecated(constantNode.metadata()), type, value);
    }

    private static BType getIntersectionTypeModel(TypeDefinitionNode typeDefinition, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        IntersectionTypeDescriptorNode typeDescriptor = (IntersectionTypeDescriptorNode)typeDefinition.typeDescriptor();
        memberTypes.add(Type.fromNode(typeDescriptor.leftTypeDesc(), semanticModel, fileName));
        memberTypes.add(Type.fromNode(typeDescriptor.rightTypeDesc(), semanticModel, fileName));
        BType bType = new BType(typeDefinition.typeName().text(), Generator.getDocFromMetadata(typeDefinition.metadata()), Generator.isDeprecated(typeDefinition.metadata()), memberTypes);
        bType.isIntersectionType = true;
        return bType;
    }

    private static BType getTupleTypeModel(TypeDefinitionNode typeDefinition, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        TupleTypeDescriptorNode typeDescriptor = (TupleTypeDescriptorNode)typeDefinition.typeDescriptor();
        memberTypes.addAll(typeDescriptor.memberTypeDesc().stream().map(type -> Type.fromNode(type, semanticModel, fileName)).collect(Collectors.toList()));
        BType bType = new BType(typeDefinition.typeName().text(), Generator.getDocFromMetadata(typeDefinition.metadata()), Generator.isDeprecated(typeDefinition.metadata()), memberTypes);
        bType.isTuple = true;
        return bType;
    }

    private static BType getUnionTypeModel(TypeDefinitionNode typeDefinition, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        Node typeDescriptor = typeDefinition.typeDescriptor();
        while (typeDescriptor.kind().equals((Object)SyntaxKind.UNION_TYPE_DESC)) {
            UnionTypeDescriptorNode unionType = (UnionTypeDescriptorNode)typeDescriptor;
            memberTypes.add(Type.fromNode(unionType.leftTypeDesc(), semanticModel, fileName));
            typeDescriptor = unionType.rightTypeDesc();
        }
        memberTypes.add(Type.fromNode(typeDescriptor, semanticModel, fileName));
        BType bType = new BType(typeDefinition.typeName().text(), Generator.getDocFromMetadata(typeDefinition.metadata()), Generator.isDeprecated(typeDefinition.metadata()), memberTypes);
        bType.isAnonymousUnionType = true;
        return bType;
    }

    private static BClass getClassModel(ClassDefinitionNode classDefinitionNode, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<Function> functions = new ArrayList<Function>();
        String name = classDefinitionNode.className().text();
        String description = Generator.getDocFromMetadata(classDefinitionNode.metadata());
        boolean isDeprecated = Generator.isDeprecated(classDefinitionNode.metadata());
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(classDefinitionNode.members(), classDefinitionNode.metadata(), semanticModel, fileName);
        for (Node member : classDefinitionNode.members()) {
            if (!(member instanceof FunctionDefinitionNode) || !Generator.containsToken(((FunctionDefinitionNode)member).qualifierList(), SyntaxKind.PUBLIC_KEYWORD)) continue;
            functions.add(Generator.getFunctionModel((FunctionDefinitionNode)member, semanticModel, fileName));
        }
        if (Generator.containsToken(classDefinitionNode.classTypeQualifiers(), SyntaxKind.CLIENT_KEYWORD)) {
            return new Client(name, description, isDeprecated, fields, functions);
        }
        if (Generator.containsToken(classDefinitionNode.classTypeQualifiers(), SyntaxKind.LISTENER_KEYWORD) || name.equals("Listener")) {
            return new Listener(name, description, isDeprecated, fields, functions);
        }
        return new BClass(name, description, isDeprecated, fields, functions);
    }

    private static BAbstractObject getAbstractObjectModel(TypeDefinitionNode typeDefinition, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<Function> functions = new ArrayList<Function>();
        String name = typeDefinition.typeName().text();
        String description = Generator.getDocFromMetadata(typeDefinition.metadata());
        ObjectTypeDescriptorNode typeDescriptorNode = (ObjectTypeDescriptorNode)typeDefinition.typeDescriptor();
        boolean isDeprecated = Generator.isDeprecated(typeDefinition.metadata());
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(typeDescriptorNode.members(), typeDefinition.metadata(), semanticModel, fileName);
        for (Node member : typeDescriptorNode.members()) {
            MethodDeclarationNode methodNode;
            if (!(member instanceof MethodDeclarationNode) || !Generator.containsToken((methodNode = (MethodDeclarationNode)member).qualifierList(), SyntaxKind.PUBLIC_KEYWORD)) continue;
            String methodName = methodNode.methodName().text();
            ArrayList<Variable> returnParams = new ArrayList<Variable>();
            FunctionSignatureNode methodSignature = methodNode.methodSignature();
            ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>(Generator.getDefaultableVariableList(methodSignature.parameters(), methodNode.metadata(), semanticModel, fileName));
            if (methodSignature.returnTypeDesc().isPresent()) {
                ReturnTypeDescriptorNode returnType = methodSignature.returnTypeDesc().get();
                Type type = Type.fromNode(returnType.type(), semanticModel, fileName);
                returnParams.add(new Variable(EMPTY_STRING, Generator.getParameterDocFromMetadataList(RETURN_PARAM_NAME, methodNode.metadata()), false, type));
            }
            boolean isRemote = Generator.containsToken(methodNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD);
            functions.add(new Function(methodName, Generator.getDocFromMetadata(methodNode.metadata()), isRemote, false, Generator.isDeprecated(methodNode.metadata()), Generator.containsToken(methodNode.qualifierList(), SyntaxKind.ISOLATED_KEYWORD), parameters, returnParams));
        }
        return new BAbstractObject(name, description, isDeprecated, fields, functions);
    }

    private static Function getFunctionModel(FunctionDefinitionNode functionDefinitionNode, BallerinaSemanticModel semanticModel, String fileName) {
        String functionName = functionDefinitionNode.functionName().text();
        ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        FunctionSignatureNode functionSignature = functionDefinitionNode.functionSignature();
        parameters.addAll(Generator.getDefaultableVariableList(functionSignature.parameters(), functionDefinitionNode.metadata(), semanticModel, fileName));
        if (functionSignature.returnTypeDesc().isPresent()) {
            ReturnTypeDescriptorNode returnType = functionSignature.returnTypeDesc().get();
            Type type = Type.fromNode(returnType.type(), semanticModel, fileName);
            returnParams.add(new Variable(EMPTY_STRING, Generator.getParameterDocFromMetadataList(RETURN_PARAM_NAME, functionDefinitionNode.metadata()), false, type));
        }
        boolean isExtern = functionDefinitionNode.functionBody() instanceof ExternalFunctionBodyNode;
        boolean isRemote = Generator.containsToken(functionDefinitionNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD);
        return new Function(functionName, Generator.getDocFromMetadata(functionDefinitionNode.metadata()), isRemote, isExtern, Generator.isDeprecated(functionDefinitionNode.metadata()), Generator.containsToken(functionDefinitionNode.qualifierList(), SyntaxKind.ISOLATED_KEYWORD), parameters, returnParams);
    }

    private static Record getRecordTypeModel(TypeDefinitionNode recordTypeDefinition, BallerinaSemanticModel semanticModel, String fileName) {
        String recordName = recordTypeDefinition.typeName().text();
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(((RecordTypeDescriptorNode)recordTypeDefinition.typeDescriptor()).fields(), recordTypeDefinition.metadata(), semanticModel, fileName);
        boolean isClosed = ((RecordTypeDescriptorNode)recordTypeDefinition.typeDescriptor()).bodyStartDelimiter().kind().equals((Object)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
        return new Record(recordName, Generator.getDocFromMetadata(recordTypeDefinition.metadata()), Generator.isDeprecated(recordTypeDefinition.metadata()), isClosed, fields);
    }

    public static List<DefaultableVariable> getDefaultableVariableList(NodeList nodeList, Optional<MetadataNode> optionalMetadataNode, BallerinaSemanticModel semanticModel, String fileName) {
        ArrayList<DefaultableVariable> variables = new ArrayList<DefaultableVariable>();
        for (int i = 0; i < nodeList.size(); ++i) {
            Type type;
            String paramName;
            DefaultableVariable defaultableVariable;
            Type type2;
            String defaultValue;
            String doc;
            String name;
            NonTerminalNode recordField;
            Object node = nodeList.get(i);
            if (node instanceof RecordFieldWithDefaultValueNode) {
                recordField = (RecordFieldWithDefaultValueNode)node;
                name = ((RecordFieldWithDefaultValueNode)recordField).fieldName().text();
                doc = Generator.getDocFromMetadata(((RecordFieldWithDefaultValueNode)recordField).metadata());
                if (doc.equals(EMPTY_STRING)) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                defaultValue = ((RecordFieldWithDefaultValueNode)recordField).expression().toString();
                type2 = Type.fromNode(((RecordFieldWithDefaultValueNode)recordField).typeName(), semanticModel, fileName);
                defaultableVariable = new DefaultableVariable(name, doc, false, type2, defaultValue);
                variables.add(defaultableVariable);
                continue;
            }
            if (node instanceof RecordFieldNode) {
                recordField = (RecordFieldNode)node;
                name = ((RecordFieldNode)recordField).fieldName().text();
                doc = Generator.getDocFromMetadata(((RecordFieldNode)recordField).metadata());
                if (doc.equals(EMPTY_STRING)) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                Type type3 = Type.fromNode(((RecordFieldNode)recordField).typeName(), semanticModel, fileName);
                DefaultableVariable defaultableVariable2 = new DefaultableVariable(name, doc, false, type3, EMPTY_STRING);
                variables.add(defaultableVariable2);
                continue;
            }
            if (node instanceof ObjectFieldNode) {
                ObjectFieldNode objectField = (ObjectFieldNode)node;
                if (!objectField.visibilityQualifier().isPresent() || !objectField.visibilityQualifier().get().kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                name = objectField.fieldName().text();
                doc = Generator.getDocFromMetadata(objectField.metadata());
                if (doc.equals(EMPTY_STRING)) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                defaultValue = objectField.expression().isPresent() ? objectField.expression().get().toString() : EMPTY_STRING;
                type2 = Type.fromNode(objectField.typeName(), semanticModel, fileName);
                defaultableVariable = new DefaultableVariable(name, doc, Generator.isDeprecated(objectField.metadata()), type2, defaultValue);
                variables.add(defaultableVariable);
                continue;
            }
            if (node instanceof RequiredParameterNode) {
                RequiredParameterNode requiredParameter = (RequiredParameterNode)node;
                paramName = requiredParameter.paramName().isPresent() ? requiredParameter.paramName().get().text() : EMPTY_STRING;
                type = Type.fromNode(requiredParameter.typeName(), semanticModel, fileName);
                variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), Generator.isDeprecated(requiredParameter.annotations()), type, EMPTY_STRING));
                continue;
            }
            if (node instanceof DefaultableParameterNode) {
                DefaultableParameterNode defaultableParameter = (DefaultableParameterNode)node;
                paramName = defaultableParameter.paramName().isPresent() ? defaultableParameter.paramName().get().text() : EMPTY_STRING;
                type = Type.fromNode(defaultableParameter.typeName(), semanticModel, fileName);
                variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), Generator.isDeprecated(defaultableParameter.annotations()), type, defaultableParameter.expression().toString()));
                continue;
            }
            if (!(node instanceof RestParameterNode)) continue;
            RestParameterNode restParameter = (RestParameterNode)node;
            paramName = restParameter.paramName().isPresent() ? restParameter.paramName().get().text() : EMPTY_STRING;
            type = new Type(paramName);
            type.isRestParam = true;
            type.elementType = Type.fromNode(restParameter.typeName(), semanticModel, fileName);
            variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), false, type, EMPTY_STRING));
        }
        return variables;
    }

    private static boolean isTypePram(Optional<MetadataNode> metadataNode) {
        if (metadataNode.isEmpty()) {
            return false;
        }
        NodeList<AnnotationNode> annotations = metadataNode.get().annotations();
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationNode.toString().contains("@typeParam")) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecated(NodeList<AnnotationNode> annotations) {
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationNode.toString().contains("@deprecated")) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecated(Optional<MetadataNode> metadataNode) {
        if (!metadataNode.isPresent()) {
            return false;
        }
        MetadataNode metaData = metadataNode.get();
        for (AnnotationNode annotationNode : metaData.annotations()) {
            if (!annotationNode.toString().contains("@deprecated")) continue;
            return true;
        }
        return false;
    }

    private static String getDocFromMetadata(Optional<MetadataNode> optionalMetadataNode) {
        MarkdownDocumentationNode docLines;
        if (optionalMetadataNode.isEmpty()) {
            return EMPTY_STRING;
        }
        Object doc = EMPTY_STRING;
        MarkdownDocumentationNode markdownDocumentationNode = docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        if (docLines != null) {
            for (Node docLine : docLines.documentationLines()) {
                if (!(docLine instanceof MarkdownDocumentationLineNode)) break;
                doc = (String)doc + (!((MarkdownDocumentationLineNode)docLine).documentElements().isEmpty() ? Generator.getDocString(((MarkdownDocumentationLineNode)docLine).documentElements()) : "\n");
            }
            return BallerinaDocUtils.mdToHtml((String)doc, false);
        }
        return EMPTY_STRING;
    }

    private static String getParameterDocFromMetadataList(String parameterName, Optional<MetadataNode> optionalMetadataNode) {
        if (optionalMetadataNode.isEmpty()) {
            return EMPTY_STRING;
        }
        MarkdownDocumentationNode docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        StringBuilder parameterDoc = new StringBuilder();
        if (docLines != null) {
            boolean lookForMoreLines = false;
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownParameterDocumentationLineNode) {
                    if (((MarkdownParameterDocumentationLineNode)docLine).parameterName().text().equals(parameterName)) {
                        parameterDoc.append(Generator.getDocString(((MarkdownParameterDocumentationLineNode)docLine).documentElements()));
                        lookForMoreLines = true;
                        continue;
                    }
                    lookForMoreLines = false;
                    continue;
                }
                if (!lookForMoreLines || !(docLine instanceof MarkdownDocumentationLineNode)) continue;
                parameterDoc.append(Generator.getDocString(((MarkdownDocumentationLineNode)docLine).documentElements()));
            }
            return BallerinaDocUtils.mdToHtml(parameterDoc.toString(), false);
        }
        return EMPTY_STRING;
    }

    private static String getDocString(NodeList<Node> documentElements) {
        if (documentElements.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder doc = new StringBuilder();
        for (Node docNode : documentElements) {
            doc.append(docNode.toString());
        }
        return doc.toString();
    }
}

