/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.docs.utils.PathToJson;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.ModuleDoc;
import org.ballerinalang.docgen.generator.model.Project;
import org.ballerinalang.docgen.generator.model.search.ConstructSearchJson;
import org.ballerinalang.docgen.generator.model.search.ModuleSearchJson;
import org.ballerinalang.docgen.generator.model.search.SearchJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(BallerinaDocGenerator.class);
    private static PrintStream out = System.out;
    private static final String MODULE_CONTENT_FILE = "Module.md";
    private static final Path BAL_BUILTIN = Paths.get("ballerina", "builtin");
    private static final String HTML = ".html";
    private static final String DOC_JSON = "api-doc-data.json";
    private static final String JSON = ".json";
    private static final String MODULE_SEARCH = "search";
    private static final String SEARCH_DATA = "search-data.js";
    private static final String SEARCH_DIR = "doc-search";
    private static Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, new PathToJson()).excludeFieldsWithoutExposeAnnotation().create();

    public static void mergeApiDocs(String apiDocsRoot) {
        out.println("docerina: API documentation generation for doc path - " + apiDocsRoot);
        File directory = new File(apiDocsRoot);
        Object[] fList = directory.listFiles();
        if (fList == null) {
            String errorMsg = String.format("docerina: API documentation generation failed. Could not find any module in given path %s", apiDocsRoot);
            out.println(errorMsg);
            log.error(errorMsg);
            return;
        }
        Arrays.sort(fList);
        Project project = new Project();
        for (Object file : fList) {
            Path docJsonPath;
            if (!((File)file).isDirectory() || !(docJsonPath = Paths.get(((File)file).getAbsolutePath(), "data", "doc_data.json")).toFile().exists()) continue;
            try (BufferedReader br = Files.newBufferedReader(docJsonPath, StandardCharsets.UTF_8);){
                Project jsonProject = gson.fromJson((Reader)br, Project.class);
                project.resources.addAll(BallerinaDocGenerator.getResourcePaths(Paths.get(((File)file).getAbsolutePath(), new String[0])));
                project.modules.addAll(jsonProject.modules);
                File newIndex = new File(((File)file).getAbsolutePath() + File.separator + "index.html");
                String htmlData = "<!DOCTYPE html>\n<html>\n<head>\n\t<meta http-equiv=\"refresh\" content=\"0; URL=../index.html#/" + jsonProject.name + "\" />\n</head>\n<body>\n\t<h1>If you are not redirected please click this <a href=\"../index.html#/" + jsonProject.name + "\">link</a> </h1>\n</body>\n</html>";
                FileUtils.write(newIndex, (CharSequence)htmlData, StandardCharsets.UTF_8, false);
            }
            catch (IOException e) {
                String errorMsg = String.format("API documentation generation failed. Cause: %s", e.getMessage());
                out.println(errorMsg);
                log.error(errorMsg, e);
                return;
            }
        }
        BallerinaDocGenerator.writeAPIDocs(project, apiDocsRoot, true);
    }

    public static void generateAPIDocs(io.ballerina.projects.Project project, String output) throws IOException {
        Map<String, ModuleDoc> moduleDocMap = BallerinaDocGenerator.generateModuleDocMap(project);
        Project docerinaProject = BallerinaDocGenerator.getDocsGenModel(moduleDocMap, project.currentPackage().packageOrg().toString(), project.currentPackage().packageVersion().toString());
        docerinaProject.name = project.currentPackage().descriptor().name().toString();
        Path packageMdPath = project.sourceRoot().resolve("Package.md");
        if (packageMdPath.toFile().exists()) {
            String mdContent = new String(Files.readAllBytes(packageMdPath), "UTF-8");
            docerinaProject.description = BallerinaDocUtils.mdToHtml(mdContent, true);
        }
        if (!docerinaProject.modules.isEmpty()) {
            BallerinaDocGenerator.writeAPIDocs(docerinaProject, output, false);
        }
    }

    public static void writeAPIDocs(Project project, String output, boolean isMerge) {
        File dest;
        File source;
        if (project.modules.size() != 0) {
            if (!isMerge) {
                output = project.name.equals("") ? (String)output + File.separator + project.modules.get((int)0).id : (String)output + File.separator + project.name;
            }
            String dataDir = (String)output + File.separator + "data";
            String searchDir = (String)output + File.separator + SEARCH_DIR;
            try {
                Files.createDirectories(Paths.get(dataDir, new String[0]), new FileAttribute[0]);
                Files.createDirectories(Paths.get(searchDir, new String[0]), new FileAttribute[0]);
                BallerinaDocGenerator.genSearchJson(project, searchDir);
                BallerinaDocGenerator.genProjectJson(project, dataDir);
            }
            catch (IOException e) {
                out.printf("docerina: API documentation generation failed%n", e.getMessage());
                log.error("API documentation generation failed:", e);
            }
        }
        if (!project.resources.isEmpty()) {
            String resourcesDir = (String)output + File.separator + "resources";
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("docerina: copying project resources ");
            }
            for (Path resourcePath : project.resources) {
                File resourcesDirFile = new File(resourcesDir);
                try {
                    FileUtils.copyFileToDirectory(resourcePath.toFile(), resourcesDirFile);
                }
                catch (IOException e) {
                    out.println(String.format("docerina: failed to copy [resource] %s into [resources directory] %s. Cause: %s", resourcePath.toString(), resourcesDirFile.toString(), e.getMessage()));
                    log.error(String.format("docerina: failed to copy [resource] %s into [resources directory] %s. Cause: %s", resourcePath.toString(), resourcesDirFile.toString(), e.getMessage()), e);
                }
            }
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("docerina: successfully copied project resources into " + resourcesDir);
            }
        }
        if ((source = new File(System.getProperty("ballerina.home") + File.separator + "lib" + File.separator + "tools" + File.separator + "doc-ui")).exists()) {
            dest = new File((String)output);
            try {
                FileUtils.copyDirectory(source, dest);
            }
            catch (IOException e) {
                out.println(String.format("docerina: failed to copy doc ui. Cause: %s", e.getMessage()));
                log.error("Failed to copy the doc ui.", e);
            }
        } else {
            dest = new File((String)output, "index.html");
            try {
                FileUtils.copyInputStreamToFile(BallerinaDocGenerator.class.getResourceAsStream("/doc-ui/index.html"), dest);
            }
            catch (IOException e) {
                out.println(String.format("docerina: failed to copy doc ui. Cause: %s", e.getMessage()));
                log.error("Failed to copy the doc ui.", e);
            }
        }
        try {
            String zipPath = System.getProperty("output.zip.path");
            if (zipPath != null) {
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: generating the documentation zip file.");
                }
                BallerinaDocUtils.packageToZipFile((String)output, zipPath);
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("docerina: successfully generated the documentation zip file.");
                }
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: API documentation zip packaging failed for %s: %s", output, e.getMessage()));
            log.error(String.format("API documentation zip packaging failed for %s", output), e);
        }
    }

    private static void genProjectJson(Project project, String dataDir) {
        OutputStreamWriter writer;
        boolean deleted;
        File jsFile = new File(dataDir + File.separator + "doc_data.js");
        File jsonFile = new File(dataDir + File.separator + "doc_data.json");
        if (jsFile.exists() && !(deleted = jsFile.delete())) {
            out.println("docerina: failed to delete " + jsFile.toString());
        }
        if (jsonFile.exists() && !(deleted = jsonFile.delete())) {
            out.println("docerina: failed to delete " + jsonFile.toString());
        }
        String json = gson.toJson(project);
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsFile), StandardCharsets.UTF_8);
            try {
                String js = "var docData = " + json + ";";
                writer.write(new String(js.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to create the doc_data.js. Cause: %s", e.getMessage()));
            log.error("Failed to create doc_data.js file.", e);
        }
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            try {
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to create the doc_data.json. Cause: %s", e.getMessage()));
            log.error("Failed to create doc_data.json file.", e);
        }
    }

    private static void genSearchJson(Project project, String searchDir) {
        OutputStreamWriter writer;
        boolean deleted;
        ArrayList<ModuleSearchJson> searchModules = new ArrayList<ModuleSearchJson>();
        ArrayList<ConstructSearchJson> searchFunctions = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchClasses = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchRecords = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchConstants = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchErrors = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchTypes = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchClients = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchListeners = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchAnnotations = new ArrayList<ConstructSearchJson>();
        ArrayList<ConstructSearchJson> searchAbstractObjects = new ArrayList<ConstructSearchJson>();
        for (Module module : project.modules) {
            if (module.summary != null) {
                searchModules.add(new ModuleSearchJson(module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(module.summary)));
            }
            module.functions.forEach(function -> searchFunctions.add(new ConstructSearchJson(function.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(function.description))));
            module.classes.forEach(bClass -> searchClasses.add(new ConstructSearchJson(bClass.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(bClass.description))));
            module.abstractObjects.forEach(absObj -> searchAbstractObjects.add(new ConstructSearchJson(absObj.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(absObj.description))));
            module.clients.forEach(client -> searchClients.add(new ConstructSearchJson(client.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(client.description))));
            module.listeners.forEach(listener -> searchListeners.add(new ConstructSearchJson(listener.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(listener.description))));
            module.records.forEach(record -> searchRecords.add(new ConstructSearchJson(record.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(record.description))));
            module.constants.forEach(constant -> searchConstants.add(new ConstructSearchJson(constant.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(constant.description))));
            module.errors.forEach(error -> searchErrors.add(new ConstructSearchJson(error.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(error.description))));
            module.types.forEach(unionType -> searchTypes.add(new ConstructSearchJson(unionType.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(unionType.description))));
            module.annotations.forEach(annotation -> searchAnnotations.add(new ConstructSearchJson(annotation.name, module.id, module.orgName, module.version, BallerinaDocGenerator.getFirstLine(annotation.description))));
        }
        SearchJson searchJson = new SearchJson(searchModules, searchClasses, searchFunctions, searchRecords, searchConstants, searchErrors, searchTypes, searchClients, searchListeners, searchAnnotations, searchAbstractObjects);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File jsonFile = new File(searchDir + File.separator + "search-data.json");
        File jsFile = new File(searchDir + File.separator + SEARCH_DATA);
        if (jsFile.exists() && !(deleted = jsFile.delete())) {
            out.println("docerina: failed to delete " + jsFile.toString());
        }
        if (jsonFile.exists() && !(deleted = jsonFile.delete())) {
            out.println("docerina: failed to delete " + jsonFile.toString());
        }
        String json = gson.toJson(searchJson);
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            try {
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to create the search-data.json. Cause: %s", e.getMessage()));
            log.error("Failed to create search-data.json file.", e);
        }
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsFile), StandardCharsets.UTF_8);
            try {
                String js = "var searchData = " + json + ";";
                writer.write(new String(js.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: failed to create the search-data.js. Cause: %s", e.getMessage()));
            log.error("Failed to create search-data.js file.", e);
        }
    }

    private static String getFirstLine(String description) {
        String[] splits = description.split("\\.", 2);
        if (splits.length < 2) {
            return splits[0];
        }
        if (splits[0].contains("<p>")) {
            return splits[0] + ".</p>";
        }
        return splits[0] + ".";
    }

    public static Map<String, ModuleDoc> generateModuleDocMap(io.ballerina.projects.Project project) throws IOException {
        HashMap<String, ModuleDoc> moduleDocMap = new HashMap<String, ModuleDoc>();
        for (io.ballerina.projects.Module module : project.currentPackage().modules()) {
            Path modulePath;
            Object moduleName;
            if (module.isDefaultModule()) {
                moduleName = module.moduleName().packageName().toString();
                modulePath = project.sourceRoot();
            } else {
                moduleName = module.moduleName().packageName() + "." + module.moduleName().moduleNamePart();
                modulePath = project.sourceRoot().resolve("modules").resolve(module.moduleName().moduleNamePart());
            }
            Path moduleMd = BallerinaDocGenerator.getModuleDocPath(modulePath, MODULE_CONTENT_FILE);
            if (moduleMd == null && module.isDefaultModule()) {
                moduleMd = BallerinaDocGenerator.getModuleDocPath(modulePath, "Package.md");
            }
            List<Path> resources = BallerinaDocGenerator.getResourcePaths(modulePath);
            HashMap<String, SyntaxTree> syntaxTreeMap = new HashMap<String, SyntaxTree>();
            module.documentIds().forEach(documentId -> {
                Document document = module.document((DocumentId)documentId);
                syntaxTreeMap.put(document.name(), document.syntaxTree());
            });
            ModuleDoc moduleDoc = new ModuleDoc(moduleMd == null ? null : moduleMd.toAbsolutePath(), resources, syntaxTreeMap, (BallerinaSemanticModel)module.getCompilation().getSemanticModel());
            moduleDocMap.put((String)moduleName, moduleDoc);
        }
        return moduleDocMap;
    }

    public static void setPrintStream(PrintStream out) {
        BallerinaDocGenerator.out = out;
    }

    public static Project getDocsGenModel(Map<String, ModuleDoc> docsMap, String orgName, String version) {
        Project project = new Project();
        project.name = "";
        project.description = "";
        ArrayList<Module> moduleDocs = new ArrayList<Module>();
        for (Map.Entry<String, ModuleDoc> moduleDoc : docsMap.entrySet()) {
            BallerinaSemanticModel model = moduleDoc.getValue().semanticModel;
            Module module = new Module();
            module.id = moduleDoc.getKey();
            module.orgName = orgName;
            String moduleVersion = version;
            module.version = moduleVersion.equals("") ? System.getProperty("version") : moduleVersion;
            module.summary = moduleDoc.getValue().summary;
            module.description = moduleDoc.getValue().description;
            project.resources.addAll(moduleDoc.getValue().resources);
            boolean hasPublicConstructs = false;
            for (Map.Entry<String, SyntaxTree> syntaxTreeMapEntry : moduleDoc.getValue().syntaxTreeMap.entrySet()) {
                boolean hasPublicConstructsTemp = Generator.setModuleFromSyntaxTree(module, syntaxTreeMapEntry.getValue(), model, syntaxTreeMapEntry.getKey());
                if (!hasPublicConstructsTemp) continue;
                hasPublicConstructs = true;
            }
            if (!hasPublicConstructs) continue;
            moduleDocs.add(module);
        }
        project.modules = moduleDocs;
        return project;
    }

    private static List<Path> getResourcePaths(Path absolutePkgPath) throws IOException {
        Path resourcesDirPath = absolutePkgPath.resolve("resources");
        List<Path> resources = new ArrayList<Path>();
        if (resourcesDirPath.toFile().exists()) {
            resources = Files.walk(resourcesDirPath, new FileVisitOption[0]).filter(path -> !path.equals(resourcesDirPath)).collect(Collectors.toList());
        }
        return resources;
    }

    private static Path getModuleDocPath(Path absolutePkgPath, String mdFileName) throws IOException {
        Optional<Path> o = Files.find(absolutePkgPath, 1, (path, attr) -> {
            Path fileName = path.getFileName();
            if (fileName != null) {
                return fileName.toString().equals(mdFileName);
            }
            return false;
        }, new FileVisitOption[0]).findFirst();
        Path packageMd = o.isPresent() ? o.get() : null;
        return packageMd;
    }
}

