/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.Node;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class BallerinaDocUtils {
    private static final boolean debugEnabled = "true".equals(System.getProperty("debugDocerina"));
    private static final PrintStream out = System.out;

    public static String mdToHtml(String mdContent, boolean pureMdFile) {
        if (mdContent != null) {
            mdContent = !pureMdFile ? mdContent.replaceAll("\n[\\s]*#", "\n") : mdContent;
        }
        List<Extension> extensions = Arrays.asList(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).enabledBlockTypes(new HashSet<Class<? extends Block>>(Arrays.asList(Heading.class, HtmlBlock.class, ThematicBreak.class, FencedCodeBlock.class, BlockQuote.class, ListBlock.class))).build();
        Node document = parser.parse(mdContent != null ? mdContent.trim() : "");
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        return renderer.render(document);
    }

    public static Node parseMD(String mdContent) {
        List<Extension> extensions = Arrays.asList(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).enabledBlockTypes(new HashSet<Class<? extends Block>>(Arrays.asList(Heading.class, HtmlBlock.class, ThematicBreak.class, FencedCodeBlock.class, BlockQuote.class, ListBlock.class))).build();
        return parser.parse(mdContent != null ? mdContent.trim() : "");
    }

    public static List<String> loadPrimitivesDescriptions(boolean filterDescription) {
        List<String> list = new ArrayList<String>();
        String filename = "/primitives-descriptions.properties";
        InputStream inputStream = BallerinaDocUtils.class.getResourceAsStream(filename);
        try (Stream stream = BallerinaDocUtils.readFromInputStream(inputStream).stream();){
            list = stream.map(line -> {
                if (filterDescription) {
                    return line.split("=")[0];
                }
                return line;
            }).collect(Collectors.toList());
        }
        catch (IOException | FileSystemNotFoundException e) {
            return list;
        }
        return list;
    }

    private static List<String> readFromInputStream(InputStream inputStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static void packageToZipFile(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static String getPrimitiveDescription(List<String> descriptions, String type) {
        Optional<String> desc = descriptions.stream().filter(description -> description.startsWith(type)).map(description -> description.split("=")[1]).findFirst();
        return desc.isPresent() ? desc.get() : "";
    }

    static class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        Path source;
        Path target;

        public RecursiveFileVisitor(Path aSource, Path aTarget) {
            this.source = aSource;
            this.target = aTarget;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
            block2: {
                Path targetdir = this.target.resolve(this.source.relativize(dir2).toString());
                try {
                    Files.copy(dir2, targetdir, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetdir, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.target.resolve(this.source.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
            if (BallerinaDocUtils.isDebugEnabled()) {
                out.println("File copied: " + file.toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

