/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.generator.model;

import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Heading;
import org.commonmark.node.Node;
import org.commonmark.node.Paragraph;
import org.commonmark.node.Text;
import org.commonmark.renderer.html.HtmlRenderer;

public class ModuleDoc {
    public final String description;
    public final String summary;
    public final Map<String, SyntaxTree> syntaxTreeMap;
    public final BallerinaSemanticModel semanticModel;
    public final List<Path> resources;

    public ModuleDoc(Path descriptionPath, List<Path> resources, Map<String, SyntaxTree> syntaxTreeMap, BallerinaSemanticModel semanticModel) throws IOException {
        this.description = this.getDescription(descriptionPath);
        this.summary = this.getSummary(descriptionPath);
        this.resources = resources;
        this.syntaxTreeMap = syntaxTreeMap;
        this.semanticModel = semanticModel;
    }

    private String getDescription(Path descriptionPath) throws IOException {
        if (descriptionPath != null) {
            String mdContent = new String(Files.readAllBytes(descriptionPath), "UTF-8");
            return BallerinaDocUtils.mdToHtml(mdContent, true);
        }
        return null;
    }

    private String getSummary(Path descriptionPath) throws IOException {
        if (descriptionPath != null) {
            String mdContent = new String(Files.readAllBytes(descriptionPath), "UTF-8");
            Node document = BallerinaDocUtils.parseMD(mdContent);
            SummaryVisitor summaryVisitor = new SummaryVisitor();
            document.accept(summaryVisitor);
            return summaryVisitor.getSummary();
        }
        return null;
    }

    static class SummaryVisitor
    extends AbstractVisitor {
        protected Node summary;

        SummaryVisitor() {
        }

        @Override
        public void visit(Heading heading) {
            if (heading.getFirstChild() instanceof Text && (StringUtils.equalsIgnoreCase(((Text)heading.getFirstChild()).getLiteral(), "module overview") || StringUtils.equalsIgnoreCase(((Text)heading.getFirstChild()).getLiteral(), "package overview")) && heading.getNext() instanceof Paragraph) {
                this.summary = heading.getNext();
            }
        }

        public String getSummary() {
            if (this.summary != null) {
                return HtmlRenderer.builder().build().render(this.summary);
            }
            return "";
        }
    }
}

