/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.generator.model;

import com.google.gson.annotations.Expose;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.SimpleTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ErrorTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.NilTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.XmlTypeDescriptorNode;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.generator.model.DefaultableVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    @Expose
    public String orgName;
    @Expose
    public String moduleName;
    @Expose
    public String version;
    @Expose
    public String name;
    @Expose
    public String description;
    @Expose
    public String category;
    @Expose
    public boolean isAnonymousUnionType;
    @Expose
    public boolean isArrayType;
    @Expose
    public boolean isNullable;
    @Expose
    public boolean isTuple;
    @Expose
    public boolean isIntersectionType;
    @Expose
    public boolean isParenthesisedType;
    @Expose
    public boolean isRestParam;
    @Expose
    public boolean isLambda;
    @Expose
    public boolean isDeprecated;
    @Expose
    public boolean generateUserDefinedTypeLink = true;
    @Expose
    public List<Type> memberTypes = new ArrayList<Type>();
    @Expose
    public List<Type> paramTypes = new ArrayList<Type>();
    @Expose
    public int arrayDimensions;
    @Expose
    public Type elementType;
    @Expose
    public Type returnType;
    @Expose
    public Type constraint;
    private static final Logger log = LoggerFactory.getLogger(BallerinaDocGenerator.class);

    private Type() {
    }

    public static Type fromNode(Node node, BallerinaSemanticModel semanticModel, String fileName) {
        Type type = new Type();
        if (node instanceof SimpleNameReferenceNode) {
            Optional<Symbol> symbol;
            block47: {
                SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)node;
                type.name = simpleNameReferenceNode.name().text();
                type.category = "reference";
                symbol = null;
                try {
                    symbol = semanticModel.symbol(fileName, LinePosition.from(node.lineRange().startLine().line(), node.lineRange().startLine().offset()));
                }
                catch (NullPointerException nullException) {
                    if (!BallerinaDocUtils.isDebugEnabled()) break block47;
                    log.error("Symbol find threw null pointer in " + fileName + " : Line range:" + node.lineRange());
                }
            }
            if (symbol != null && symbol.isPresent()) {
                Type.resolveSymbol(type, (Symbol)symbol.get());
            }
        } else if (node instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)node;
            type.moduleName = qualifiedNameReferenceNode.modulePrefix().text();
            type.category = "reference";
            type.name = qualifiedNameReferenceNode.identifier().text();
            Optional<Symbol> symbol = null;
            try {
                symbol = semanticModel.symbol(fileName, LinePosition.from(qualifiedNameReferenceNode.identifier().lineRange().startLine().line(), qualifiedNameReferenceNode.identifier().lineRange().startLine().offset()));
            }
            catch (NullPointerException nullException) {
                System.out.print(Arrays.toString(nullException.getStackTrace()));
            }
            if (symbol != null && symbol.isPresent()) {
                Type.resolveSymbol(type, symbol.get());
            }
        } else if (node instanceof BuiltinSimpleNameReferenceNode) {
            BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode = (BuiltinSimpleNameReferenceNode)node;
            type.name = builtinSimpleNameReferenceNode.name().text();
            type.category = "builtin";
        } else if (node instanceof XmlTypeDescriptorNode) {
            XmlTypeDescriptorNode xmlType = (XmlTypeDescriptorNode)node;
            type.name = xmlType.xmlKeywordToken().text();
            type.category = "builtin";
        } else if (node instanceof NilTypeDescriptorNode) {
            type.name = node.toString();
            type.category = "builtin";
        } else if (node instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)node;
            type.isArrayType = true;
            type.arrayDimensions = 1;
            type.elementType = Type.fromNode(arrayTypeDescriptorNode.memberTypeDesc(), semanticModel, fileName);
        } else if (node instanceof OptionalTypeDescriptorNode) {
            OptionalTypeDescriptorNode optionalTypeDescriptorNode = (OptionalTypeDescriptorNode)node;
            type = Type.fromNode(optionalTypeDescriptorNode.typeDescriptor(), semanticModel, fileName);
            type.isNullable = true;
        } else if (node instanceof UnionTypeDescriptorNode) {
            type.isAnonymousUnionType = true;
            Node unionTypeNode = node;
            while (unionTypeNode instanceof UnionTypeDescriptorNode) {
                UnionTypeDescriptorNode unionType = (UnionTypeDescriptorNode)unionTypeNode;
                type.memberTypes.add(Type.fromNode(unionType.leftTypeDesc(), semanticModel, fileName));
                unionTypeNode = unionType.rightTypeDesc();
            }
            type.memberTypes.add(Type.fromNode(unionTypeNode, semanticModel, fileName));
        } else if (node instanceof IntersectionTypeDescriptorNode) {
            type.isIntersectionType = true;
            IntersectionTypeDescriptorNode intersectionType = (IntersectionTypeDescriptorNode)node;
            type.memberTypes.add(Type.fromNode(intersectionType.leftTypeDesc(), semanticModel, fileName));
            type.memberTypes.add(Type.fromNode(intersectionType.rightTypeDesc(), semanticModel, fileName));
        } else if (node instanceof RecordTypeDescriptorNode) {
            type.name = node.toString();
            type.generateUserDefinedTypeLink = false;
        } else if (node instanceof StreamTypeDescriptorNode) {
            StreamTypeDescriptorNode streamNode = (StreamTypeDescriptorNode)node;
            StreamTypeParamsNode streamParams = streamNode.streamTypeParamsNode().isPresent() ? (StreamTypeParamsNode)streamNode.streamTypeParamsNode().get() : null;
            type.name = streamNode.streamKeywordToken().text();
            type.category = "stream";
            if (streamParams != null) {
                type.memberTypes.add(Type.fromNode(streamParams.leftTypeDescNode(), semanticModel, fileName));
                if (streamParams.rightTypeDescNode().isPresent()) {
                    type.memberTypes.add(Type.fromNode(streamParams.rightTypeDescNode().get(), semanticModel, fileName));
                }
            }
        } else if (node instanceof FunctionTypeDescriptorNode) {
            type.isLambda = true;
            FunctionTypeDescriptorNode functionDescNode = (FunctionTypeDescriptorNode)node;
            FunctionSignatureNode functionSignature = functionDescNode.functionSignature();
            List<DefaultableVariable> variables = Generator.getDefaultableVariableList(functionSignature.parameters(), Optional.empty(), semanticModel, fileName);
            type.paramTypes.addAll(variables.stream().map(defaultableVariable -> defaultableVariable.type).collect(Collectors.toList()));
            if (functionSignature.returnTypeDesc().isPresent()) {
                ReturnTypeDescriptorNode returnType = functionSignature.returnTypeDesc().get();
                type.returnType = Type.fromNode(returnType.type(), semanticModel, fileName);
            }
        } else if (node instanceof ParameterizedTypeDescriptorNode) {
            ParameterizedTypeDescriptorNode parameterizedNode = (ParameterizedTypeDescriptorNode)node;
            if (parameterizedNode.parameterizedType().kind().equals((Object)SyntaxKind.MAP_KEYWORD)) {
                type.name = "map";
                type.category = "map";
                type.constraint = Type.fromNode(parameterizedNode.typeParameter().typeNode(), semanticModel, fileName);
            }
        } else if (node instanceof ErrorTypeDescriptorNode) {
            ErrorTypeDescriptorNode errorType = (ErrorTypeDescriptorNode)node;
            type.name = errorType.errorKeywordToken().text();
            type.category = "builtin";
        } else if (node instanceof ObjectTypeDescriptorNode) {
            ObjectTypeDescriptorNode objectType = (ObjectTypeDescriptorNode)node;
            type.name = objectType.toString();
            type.category = "builtin";
        } else if (node instanceof SingletonTypeDescriptorNode) {
            SingletonTypeDescriptorNode singletonTypeDesc = (SingletonTypeDescriptorNode)node;
            type.name = singletonTypeDesc.simpleContExprNode().toString();
            type.category = "builtin";
        } else if (node instanceof ParenthesisedTypeDescriptorNode) {
            ParenthesisedTypeDescriptorNode parenthesisedNode = (ParenthesisedTypeDescriptorNode)node;
            type.elementType = Type.fromNode(parenthesisedNode.typedesc(), semanticModel, fileName);
            type.isParenthesisedType = true;
        } else if (node instanceof TupleTypeDescriptorNode) {
            TupleTypeDescriptorNode typeDescriptor = (TupleTypeDescriptorNode)node;
            type.memberTypes.addAll(typeDescriptor.memberTypeDesc().stream().map(memberType -> Type.fromNode(memberType, semanticModel, fileName)).collect(Collectors.toList()));
            type.isTuple = true;
        } else {
            type.category = "UNKNOWN";
        }
        return type;
    }

    public static void resolveSymbol(Type type, Symbol symbol) {
        VariableSymbol variableSymbol;
        if (symbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeSymbol = (TypeReferenceTypeSymbol)symbol;
            type.moduleName = typeSymbol.moduleID().moduleName();
            type.orgName = typeSymbol.moduleID().orgName();
            type.version = typeSymbol.moduleID().version();
            if (typeSymbol.typeDescriptor() != null) {
                type.category = Type.getTypeCategory(typeSymbol.typeDescriptor());
            }
        } else if (symbol instanceof ConstantSymbol) {
            ConstantSymbol constantSymbol = (ConstantSymbol)symbol;
            type.moduleName = constantSymbol.moduleID().moduleName();
            type.orgName = constantSymbol.moduleID().orgName();
            type.version = constantSymbol.moduleID().version();
            type.category = "constants";
        } else if (symbol instanceof VariableSymbol && (variableSymbol = (VariableSymbol)symbol).typeDescriptor() != null) {
            type.category = Type.getTypeCategory(variableSymbol.typeDescriptor());
        }
    }

    public static String getTypeCategory(TypeSymbol typeDescriptor) {
        if (typeDescriptor.kind().equals((Object)SymbolKind.TYPE)) {
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.RECORD)) {
                return "records";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.OBJECT)) {
                return "abstractObjects";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.ERROR)) {
                return "errors";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.UNION)) {
                return "types";
            }
            if (typeDescriptor.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE)) {
                return Type.getTypeCategory(((TypeReferenceTypeSymbol)typeDescriptor).typeDescriptor());
            }
        } else {
            if (typeDescriptor.kind().equals((Object)SymbolKind.CLASS)) {
                Qualifiable classSymbol = (Qualifiable)((Object)typeDescriptor);
                if (classSymbol.qualifiers().contains((Object)Qualifier.CLIENT)) {
                    return "clients";
                }
                if (classSymbol.qualifiers().contains((Object)Qualifier.LISTENER) || typeDescriptor.name().equals("Listener")) {
                    return "listeners";
                }
                return "classes";
            }
            if (typeDescriptor instanceof SimpleTypeSymbol && typeDescriptor.signature().equals("finite")) {
                return "types";
            }
        }
        return "not_found";
    }

    public Type(String name) {
        this.name = name;
        this.category = "builtin";
    }

    public Type(String name, String description, boolean isDeprecated) {
        this.name = name;
        this.description = description;
        this.isDeprecated = isDeprecated;
    }
}

