/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.logging.formatters;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.ballerinalang.logging.BLogManager;
import org.ballerinalang.logging.util.BLogLevelMapper;

public class BallerinaLogFormatter
extends Formatter {
    private static final String format = BLogManager.getLogManager().getProperty(BallerinaLogFormatter.class.getCanonicalName() + ".format");

    @Override
    public String format(LogRecord record) {
        String source = "";
        if (record.getLoggerName().length() > BLogManager.LOGGER_PREFIX_LENGTH) {
            source = record.getLoggerName().substring(BLogManager.LOGGER_PREFIX_LENGTH);
        }
        if (source.equals("")) {
            source = "\"\"";
        }
        return String.format(format, new Date(record.getMillis()), BLogLevelMapper.getBallerinaLogLevel(record.getLevel()), source, record.getMessage());
    }
}

