/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.toml.parser;

import com.moandjiezana.toml.Toml;
import java.io.InputStream;
import java.io.PrintStream;
import org.ballerinalang.toml.model.LockFile;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class LockFileProcessor {
    private static final PrintStream err = System.err;
    private static final CompilerContext.Key<LockFileProcessor> LOCK_FILE_PROC_KEY = new CompilerContext.Key();
    private final LockFile lockFile;

    private LockFileProcessor(LockFile lockFile) {
        this.lockFile = lockFile;
    }

    public static LockFileProcessor getInstance(CompilerContext context, boolean lockEnabled) {
        if (!lockEnabled) {
            return new LockFileProcessor(new LockFile());
        }
        LockFileProcessor lockFileProcessor = context.get(LOCK_FILE_PROC_KEY);
        if (lockFileProcessor == null) {
            SourceDirectory sourceDirectory = context.get(SourceDirectory.class);
            LockFile lockFile = LockFileProcessor.parseTomlContentAsStream(sourceDirectory.getLockFileContent());
            LockFileProcessor instance = new LockFileProcessor(lockFile);
            context.put(LOCK_FILE_PROC_KEY, instance);
            return instance;
        }
        return lockFileProcessor;
    }

    public static LockFile parseTomlContentAsStream(InputStream inputStream) {
        try {
            Toml lockToml = new Toml().read(inputStream);
            return lockToml.to(LockFile.class);
        }
        catch (Exception e) {
            err.println("Ballerina.lock file is corrupted. this build will ignore using the lock file in resolving dependencies. a valid lock file will be generated if '--skip-lock' is set to false when using build command. '--skip-lock' flag is false by default.");
            return null;
        }
    }

    public LockFile getLockFile() {
        return this.lockFile;
    }
}

