/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import org.ballerinalang.tool.util.CompileResult;
import org.testng.Assert;

public class BAssertUtil {
    private static final String CARRIAGE_RETURN_CHAR = "\\r";
    private static final String EMPTY_STRING = "";

    public static void validateError(CompileResult result, int errorIndex, String expectedErrMsg, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, "incorrect diagnostic type");
        Assert.assertEquals(diag.message().replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), expectedErrMsg.replace(CARRIAGE_RETURN_CHAR, EMPTY_STRING), "incorrect error message:");
        Assert.assertEquals(diag.location().lineRange().startLine().line() + 1, expectedErrLine, "incorrect line number:");
        Assert.assertEquals(diag.location().lineRange().startLine().offset() + 1, expectedErrCol, "incorrect column position:");
    }

    public static void validateError(CompileResult result, int errorIndex, int expectedErrLine, int expectedErrCol) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, "incorrect diagnostic type");
        Assert.assertEquals(diag.location().lineRange().startLine().line() + 1, expectedErrLine, "incorrect line number:");
        Assert.assertEquals(diag.location().lineRange().startLine().offset() + 1, expectedErrCol, "incorrect column position:");
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String expectedPartOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, "incorrect diagnostic type");
        Assert.assertTrue(diag.message().contains(expectedPartOfErrMsg), "'" + expectedPartOfErrMsg + "' is not contained in error message '" + diag.message() + "'");
    }

    public static void validateErrorMessageOnly(CompileResult result, int errorIndex, String[] expectedPartsOfErrMsg) {
        Diagnostic diag = result.getDiagnostics()[errorIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.ERROR, "incorrect diagnostic type");
        boolean contains = false;
        for (String part : expectedPartsOfErrMsg) {
            if (!diag.message().contains(part)) continue;
            contains = true;
            break;
        }
        Assert.assertTrue(contains, "None of given strings is contained in the error message '" + diag.message() + "'");
    }

    public static void validateWarning(CompileResult result, int warningIndex, String expectedWarnMsg, int expectedWarnLine, int expectedWarnCol) {
        Diagnostic diag = result.getDiagnostics()[warningIndex];
        Assert.assertEquals((Object)diag.diagnosticInfo().severity(), (Object)DiagnosticSeverity.WARNING, "incorrect diagnostic type");
        Assert.assertEquals(diag.message(), expectedWarnMsg, "incorrect warning message:");
        Assert.assertEquals(diag.location().lineRange().startLine().line() + 1, expectedWarnLine, "incorrect line number:");
        Assert.assertEquals(diag.location().lineRange().startLine().offset() + 1, expectedWarnCol, "incorrect column position:");
    }
}

