/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.repository.CompilerOutputEntry;
import org.wso2.ballerinalang.compiler.ByteArrayBasedCompiledPackageEntry;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.programfile.PackageFileWriter;

public class BinaryFileWriter {
    private static final CompilerContext.Key<BinaryFileWriter> BINARY_FILE_WRITER_KEY = new CompilerContext.Key();
    private static final String JAVA_IO_TMP_DIR = "java.io.tmpdir";
    private static PrintStream outStream = System.out;
    private final SourceDirectory sourceDirectory;
    private final CompilerPhase compilerPhase;

    public static BinaryFileWriter getInstance(CompilerContext context) {
        BinaryFileWriter binaryFileWriter = context.get(BINARY_FILE_WRITER_KEY);
        if (binaryFileWriter == null) {
            binaryFileWriter = new BinaryFileWriter(context);
        }
        return binaryFileWriter;
    }

    private BinaryFileWriter(CompilerContext context) {
        context.put(BINARY_FILE_WRITER_KEY, this);
        this.sourceDirectory = context.get(SourceDirectory.class);
        if (this.sourceDirectory == null) {
            throw new IllegalArgumentException("source directory has not been initialized");
        }
        this.compilerPhase = CompilerOptions.getInstance(context).getCompilerPhase();
    }

    public void write(BLangPackage packageNode) {
        if (packageNode.symbol.entryPointExists) {
            this.writeExecutableBinary(packageNode);
        }
        this.writeLibraryPackage(packageNode);
    }

    public void write(BLangPackage packageNode, String fileName) {
        if (this.compilerPhase == CompilerPhase.BIR_GEN) {
            if (packageNode.packageID.isUnnamed) {
                this.writeBIR(packageNode, fileName);
            } else {
                this.writePackageBIR(packageNode);
            }
        }
        if (packageNode.symbol.entryPointExists) {
            outStream.println("Generating executable");
            this.writeExecutableBinary(packageNode, fileName);
        }
        this.writeLibraryPackage(packageNode);
    }

    private void writeBIR(BLangPackage packageNode, String fileName) {
        if (packageNode.symbol.birPackageFile != null) {
            String birFilename = this.cleanupExecFileName(fileName, ".balo");
            Path destDirPath = this.createAndGetTempDir(packageNode);
            try {
                this.addFileBirContent(this.cleanupExecFileName(fileName, ".bir"), packageNode.symbol.birPackageFile, packageNode.symbol.compiledPackage);
                this.sourceDirectory.saveCompiledPackage(packageNode.symbol.compiledPackage, destDirPath, birFilename);
            }
            catch (IOException e) {
                String msg = "error writing the compiled module(bir) of '" + packageNode.packageID + "' to '" + destDirPath + "': " + e.getMessage();
                throw new BLangCompilerException(msg, e);
            }
        }
    }

    private void writePackageBIR(BLangPackage packageNode) {
        if (packageNode.symbol.birPackageFile != null) {
            String birFilename = this.cleanupExecFileName(packageNode.packageID.name.value, ".balo");
            Path destDirPath = this.getPackageDirPathInProjectRepo(packageNode.packageID);
            try {
                this.addPackageBirContent(packageNode.packageID, packageNode.symbol.birPackageFile, packageNode.symbol.compiledPackage);
                this.sourceDirectory.saveCompiledPackage(packageNode.symbol.compiledPackage, destDirPath, birFilename);
            }
            catch (IOException e) {
                String msg = "error writing the compiled module(bir) of '" + packageNode.packageID + "' to '" + destDirPath + "': " + e.getMessage();
                throw new BLangCompilerException(msg, e);
            }
        }
    }

    private void writeExecutableBinary(BLangPackage packageNode) {
        String fileName = this.getOutputFileName(packageNode, ".balx");
        this.writeExecutableBinary(packageNode, fileName);
    }

    private void writeExecutableBinary(BLangPackage packageNode, String fileName) {
        if (this.compilerPhase == CompilerPhase.BIR_GEN && packageNode.jarBinaryContent != null) {
            String jarFilename = this.cleanupExecFileName(fileName, ".jar");
            this.sourceDirectory.saveCompiledProgram(new ByteArrayInputStream(packageNode.jarBinaryContent), jarFilename);
            return;
        }
        String birFilename = this.cleanupExecFileName(fileName, ".balo");
        Path destDirPath = this.createAndGetTempDir(packageNode);
        try {
            this.addFileBirContent(this.cleanupExecFileName(fileName, ".bir"), packageNode.symbol.birPackageFile, packageNode.symbol.compiledPackage);
            this.sourceDirectory.saveCompiledPackage(packageNode.symbol.compiledPackage, destDirPath, birFilename);
        }
        catch (IOException e) {
            String msg = "error writing the compiled module(bir) of '" + packageNode.packageID + "' to '" + destDirPath + "': " + e.getMessage();
            throw new BLangCompilerException(msg, e);
        }
    }

    private void writeLibraryPackage(BLangPackage packageNode) {
        String fileName = this.getOutputFileName(packageNode, ".balo");
        this.writeLibraryPackage(packageNode.symbol, fileName);
    }

    public void writeLibraryPackage(BPackageSymbol symbol, String compiledPackageFileName) {
        PackageID packageID = symbol.pkgID;
        CompiledPackage compiledPackage = symbol.compiledPackage;
        if (compiledPackage.getKind() == CompiledPackage.Kind.FROM_BINARY) {
            return;
        }
        if (packageID.isUnnamed) {
            return;
        }
        if (compiledPackageFileName == null || ((String)compiledPackageFileName).isEmpty()) {
            throw new IllegalArgumentException("invalid target file name");
        }
        if (!((String)compiledPackageFileName).endsWith(".balo")) {
            compiledPackageFileName = (String)compiledPackageFileName + ".balo";
        }
        Path destDirPath = this.getPackageDirPathInProjectRepo(packageID);
        try {
            if (symbol.birPackageFile != null) {
                this.addPackageBirContent(packageID, symbol.birPackageFile, compiledPackage);
            }
            if (symbol.packageFile != null) {
                this.addPackageBinaryContent(packageID, symbol.packageFile, compiledPackage);
            }
            this.sourceDirectory.saveCompiledPackage(compiledPackage, destDirPath, (String)compiledPackageFileName);
        }
        catch (IOException e) {
            String msg = "error writing the compiled module(balo) of '" + packageID + "' to '" + destDirPath + "': " + e.getMessage();
            throw new BLangCompilerException(msg, e);
        }
    }

    private Path createAndGetTempDir(BLangPackage packageNode) {
        Path tempDir = Paths.get(System.getProperty(JAVA_IO_TMP_DIR), new String[0]).resolve(packageNode.packageID.orgName.value).resolve(packageNode.packageID.version.value).resolve(packageNode.packageID.name.value);
        if (!Files.exists(tempDir, new LinkOption[0])) {
            this.createDirectory(tempDir);
        }
        return tempDir;
    }

    private void createDirectory(Path tempDir) {
        try {
            Files.createDirectories(tempDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to create directory '" + tempDir.toString() + "'", e);
        }
    }

    private String getOutputFileName(BLangPackage packageNode, String suffix) {
        if (packageNode.packageID.isUnnamed) {
            String sourceFileName = packageNode.packageID.sourceFileName.value;
            if (sourceFileName.endsWith(".bal")) {
                sourceFileName = StringUtils.removeEnd(sourceFileName, ".bal").concat(".balx");
            }
            return sourceFileName;
        }
        return packageNode.packageID.name.value + suffix;
    }

    private Path getPackageDirPathInProjectRepo(PackageID pkgId) {
        Path relativePkgPath = Paths.get(".ballerina", "repo", pkgId.getOrgName().getValue(), pkgId.getName().getValue(), pkgId.getPackageVersion().getValue());
        return this.sourceDirectory.getPath().resolve(relativePkgPath);
    }

    private void addPackageBinaryContent(PackageID pkgId, CompiledBinaryFile.PackageFile packageFile, CompiledPackage compiledPackage) throws IOException {
        byte[] pkgBinaryContent = PackageFileWriter.writePackage(packageFile);
        ByteArrayBasedCompiledPackageEntry pkgBinaryEntry = new ByteArrayBasedCompiledPackageEntry(pkgBinaryContent, this.getPackageBinaryName(pkgId), CompilerOutputEntry.Kind.OBJ);
        compiledPackage.setPackageBinaryEntry(pkgBinaryEntry);
    }

    private void addPackageBirContent(PackageID pkgId, CompiledBinaryFile.BIRPackageFile birPackageFile, CompiledPackage compiledPackage) throws IOException {
        byte[] pkgBirBinaryContent = PackageFileWriter.writePackage(birPackageFile);
        ByteArrayBasedCompiledPackageEntry pkgBinaryEntry = new ByteArrayBasedCompiledPackageEntry(pkgBirBinaryContent, this.getPackageBirName(pkgId), CompilerOutputEntry.Kind.BIR);
        compiledPackage.setPackageBirEntry(pkgBinaryEntry);
    }

    private void addFileBirContent(String fileName, CompiledBinaryFile.BIRPackageFile birPackageFile, CompiledPackage compiledPackage) throws IOException {
        byte[] pkgBirBinaryContent = PackageFileWriter.writePackage(birPackageFile);
        ByteArrayBasedCompiledPackageEntry pkgBinaryEntry = new ByteArrayBasedCompiledPackageEntry(pkgBirBinaryContent, fileName, CompilerOutputEntry.Kind.BIR);
        compiledPackage.setPackageBirEntry(pkgBinaryEntry);
    }

    private String getPackageBinaryName(PackageID packageID) {
        return packageID.getName().value + ".balo";
    }

    private String getPackageBirName(PackageID packageID) {
        return packageID.getName().value + ".bir";
    }

    private String cleanupExecFileName(String fileName, String extension) {
        Object updatedFileName = fileName;
        if (updatedFileName == null || ((String)updatedFileName).isEmpty()) {
            throw new IllegalArgumentException("invalid target file name");
        }
        if (((String)updatedFileName).endsWith(".bal")) {
            updatedFileName = ((String)updatedFileName).substring(0, ((String)updatedFileName).length() - ".bal".length());
        }
        if (!((String)updatedFileName).endsWith(extension)) {
            updatedFileName = (String)updatedFileName + extension;
        }
        return updatedFileName;
    }
}

