/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import com.moandjiezana.toml.TomlWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.LockFile;
import org.ballerinalang.toml.model.LockFileImport;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.util.RepoUtils;

public class LockFileWriter {
    private static final CompilerContext.Key<LockFileWriter> LOCK_FILE_WRITER_KEY = new CompilerContext.Key();
    private final Manifest manifest;
    private LockFile lockFile = new LockFile();

    private LockFileWriter(CompilerContext context, Manifest manifest) {
        context.put(LOCK_FILE_WRITER_KEY, this);
        this.manifest = manifest;
    }

    public static LockFileWriter getInstance(CompilerContext context, Manifest manifest) {
        LockFileWriter lockFileWriter = context.get(LOCK_FILE_WRITER_KEY);
        if (lockFileWriter == null) {
            lockFileWriter = new LockFileWriter(context, manifest);
        }
        return lockFileWriter;
    }

    private void addImportsToLockFileModel(BPackageSymbol moduleSymbol) {
        if (moduleSymbol.pkgID.version.value.isEmpty() || "*".equals(moduleSymbol.pkgID.version.value)) {
            return;
        }
        Optional<Dependency> hasPathDependency = this.manifest.getDependencies().stream().filter(dep -> dep.getOrgName().equals(moduleSymbol.pkgID.orgName.value) && dep.getModuleName().equals(moduleSymbol.pkgID.name.value) && null != dep.getMetadata().getPath()).findFirst();
        if (!hasPathDependency.isPresent() && moduleSymbol.imports.size() > 0) {
            List<LockFileImport> importsForLockFile = this.getImports(moduleSymbol.imports);
            if (importsForLockFile.size() > 0) {
                this.lockFile.getImports().put(moduleSymbol.pkgID.toString(), importsForLockFile);
            }
            for (BPackageSymbol importSymbol : moduleSymbol.imports) {
                this.addImportsToLockFileModel(importSymbol);
            }
        }
    }

    private List<LockFileImport> getImports(List<BPackageSymbol> moduleSymbols) {
        return moduleSymbols.stream().filter(symbol -> !"".equals(symbol.pkgID.version.value)).filter(symbol -> this.isModuleShouldAddedToLockFile(symbol.pkgID)).map(symbol -> new LockFileImport(symbol.pkgID.orgName.value, symbol.pkgID.name.value, symbol.pkgID.version.value)).distinct().collect(Collectors.toList());
    }

    private void updateProject() {
        this.lockFile.setOrgName(this.manifest.getProject().getOrgName());
        this.lockFile.setVersion(this.manifest.getProject().getVersion());
        this.lockFile.setLockfileVersion("1.0.0");
        this.lockFile.setBallerinaVersion(RepoUtils.getBallerinaVersion());
    }

    private void updateDependencies(List<BLangPackage> modules) {
        for (BLangPackage module : modules) {
            this.addImportsToLockFileModel(module.symbol);
        }
    }

    public void writeLockFile(List<BLangPackage> modules, Path lockFilePath) {
        this.updateProject();
        this.updateDependencies(modules);
        try {
            TomlWriter tomlLockWriter = new TomlWriter();
            String tomlString = tomlLockWriter.write(this.lockFile);
            Files.write(lockFilePath, tomlString.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isModuleShouldAddedToLockFile(PackageID packageID) {
        if (this.isBuiltInModule(packageID)) {
            if (packageID.getName().getValue().startsWith("lang.")) {
                return false;
            }
            Path cachedModulePath = Paths.get(System.getProperty("ballerina.home"), "cache", "bir", packageID.getOrgName().getValue(), packageID.getName().getValue());
            return cachedModulePath.toFile().exists();
        }
        return true;
    }

    private boolean isBuiltInModule(PackageID packageID) {
        String packageOrgName = packageID.orgName.getValue().trim();
        return packageOrgName.equals("ballerina") || packageOrgName.equals("ballerinax");
    }
}

