/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.wso2.ballerinalang.compiler.CompiledJarFile;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmObservabilityGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.emit.BIREmitter;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public class CodeGenerator {
    private static final CompilerContext.Key<CodeGenerator> CODE_GEN = new CompilerContext.Key();
    private SymbolTable symbolTable;
    private PackageCache packageCache;
    private BLangDiagnosticLog dlog;
    private BIREmitter birEmitter;
    private CompilerContext compilerContext;
    private boolean dumbBIR;
    private final String dumpBIRFile;

    private CodeGenerator(CompilerContext compilerContext) {
        compilerContext.put(CODE_GEN, this);
        this.symbolTable = SymbolTable.getInstance(compilerContext);
        this.packageCache = PackageCache.getInstance(compilerContext);
        this.dlog = BLangDiagnosticLog.getInstance(compilerContext);
        this.birEmitter = BIREmitter.getInstance(compilerContext);
        this.compilerContext = compilerContext;
        CompilerOptions compilerOptions = CompilerOptions.getInstance(compilerContext);
        this.dumbBIR = this.getBooleanValueIfSet(compilerOptions, CompilerOptionName.DUMP_BIR);
        this.dumpBIRFile = compilerOptions.get(CompilerOptionName.DUMP_BIR_FILE);
    }

    public static CodeGenerator getInstance(CompilerContext context) {
        CodeGenerator codeGenerator = context.get(CODE_GEN);
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(context);
        }
        return codeGenerator;
    }

    private boolean getBooleanValueIfSet(CompilerOptions compilerOptions, CompilerOptionName optionName) {
        return compilerOptions.isSet(optionName) && Boolean.parseBoolean(compilerOptions.get(optionName));
    }

    public CompiledJarFile generate(ModuleId moduleId, CompilerBackend compilerBackend, BLangPackage bLangPackage) {
        if (this.dumbBIR) {
            this.birEmitter.emit(bLangPackage.symbol.bir);
        }
        if (this.dumpBIRFile != null) {
            try {
                Files.write(Paths.get(this.dumpBIRFile, new String[0]), bLangPackage.symbol.birPackageFile.pkgBirBinaryContent, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BLangCompilerException("BIR file dumping failed", e);
            }
        }
        Set<Path> moduleDependencyPaths = this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.DEFAULT);
        Path runtimeJar = compilerBackend.runtimeLibrary().path();
        if (Files.exists(runtimeJar, new LinkOption[0])) {
            moduleDependencyPaths.add(runtimeJar);
        }
        return this.generate(bLangPackage.symbol, moduleDependencyPaths);
    }

    public CompiledJarFile generateTestModule(ModuleId moduleId, CompilerBackend compilerBackend, BLangPackage bLangTestablePackage) {
        Set<Path> testDependencies = this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.DEFAULT);
        testDependencies.addAll(this.getPlatformDependencyPaths(moduleId, compilerBackend, PlatformLibraryScope.TEST_ONLY));
        Path runtimeJar = compilerBackend.runtimeLibrary().path();
        if (Files.exists(runtimeJar, new LinkOption[0])) {
            testDependencies.add(runtimeJar);
        }
        return this.generate(bLangTestablePackage.symbol, testDependencies);
    }

    private Set<Path> getPlatformDependencyPaths(ModuleId moduleId, CompilerBackend compilerBackend, PlatformLibraryScope scope) {
        return this.getPlatformDependencyPaths(compilerBackend.platformLibraryDependencies(moduleId.packageId(), scope));
    }

    public Set<Path> getPlatformDependencyPaths(Collection<PlatformLibrary> platformLibraries) {
        return platformLibraries.stream().map(PlatformLibrary::path).collect(Collectors.toSet());
    }

    private CompiledJarFile generate(BPackageSymbol packageSymbol, Set<Path> moduleDependencies) {
        JvmObservabilityGen jvmObservabilityGen = new JvmObservabilityGen(this.packageCache, this.symbolTable);
        jvmObservabilityGen.instrumentPackage(packageSymbol.bir);
        this.dlog.setCurrentPackageId(packageSymbol.pkgID);
        JvmPackageGen jvmPackageGen = new JvmPackageGen(this.symbolTable, this.packageCache, this.dlog);
        this.populateExternalMap(jvmPackageGen);
        ClassLoader interopValidationClassLoader = this.makeClassLoader(moduleDependencies);
        InteropValidator interopValidator = new InteropValidator(interopValidationClassLoader, this.symbolTable);
        JvmDesugarPhase.encodeModuleIdentifiers(packageSymbol.bir, Names.getInstance(this.compilerContext));
        packageSymbol.compiledJarFile = jvmPackageGen.generate(packageSymbol.bir, interopValidator, true);
        return packageSymbol.compiledJarFile;
    }

    private ClassLoader makeClassLoader(Set<Path> moduleDependencies) {
        if (moduleDependencies == null || moduleDependencies.size() == 0) {
            return Thread.currentThread().getContextClassLoader();
        }
        ArrayList<URL> dependentJars = new ArrayList<URL>();
        for (Path dependency : moduleDependencies) {
            try {
                dependentJars.add(dependency.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(dependentJars.toArray(new URL[0]), ClassLoader.getPlatformClassLoader());
    }

    private void populateExternalMap(JvmPackageGen jvmPackageGen) {
        String nativeMap = System.getenv("BALLERINA_NATIVE_MAP");
        if (nativeMap == null) {
            return;
        }
        File mapFile = new File(nativeMap);
        if (!mapFile.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(mapFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("\"")) continue;
                int firstQuote = line.indexOf(34, 1);
                String key = line.substring(1, firstQuote);
                String value = line.substring(line.indexOf(34, firstQuote + 1) + 1, line.lastIndexOf(34));
                jvmPackageGen.addExternClassMapping(key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

