/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.ScheduleFunctionInfo;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmCodeGenUtil {
    public static final ResolvedTypeBuilder TYPE_BUILDER = new ResolvedTypeBuilder();
    public static final String INITIAL_METHOD_DESC = String.format("(L%s;", "io/ballerina/runtime/internal/scheduling/Strand");
    private static final Pattern JVM_RESERVED_CHAR_SET = Pattern.compile("[\\.:/<>]");
    public static final String SCOPE_PREFIX = "_SCOPE_";

    static void visitInvokeDynamic(MethodVisitor mv, String currentClass, String lambdaName, int size) {
        String mapDesc = JvmCodeGenUtil.getMapsDesc(size);
        Handle handle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        mv.visitInvokeDynamicInsn("apply", "(" + mapDesc + ")Ljava/util/function/Function;", handle, Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, currentClass, lambdaName, "(" + mapDesc + "[Ljava/lang/Object;)Ljava/lang/Object;", false), Type.getType("([Ljava/lang/Object;)Ljava/lang/Object;"));
    }

    private static String getMapsDesc(long count) {
        StringBuilder builder = new StringBuilder();
        for (long i = count; i > 0L; --i) {
            builder.append("Lio/ballerina/runtime/internal/values/MapValue;");
        }
        return builder.toString();
    }

    public static void createFunctionPointer(MethodVisitor mv, String className, String lambdaName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/FPValue");
        mv.visitInsn(89);
        JvmCodeGenUtil.visitInvokeDynamic(mv, className, lambdaName, 0);
        mv.visitInsn(1);
        mv.visitInsn(1);
        mv.visitInsn(3);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/FPValue", "<init>", String.format("(L%s;L%s;L%s;Z)V", "java/util/function/Function", "io/ballerina/runtime/api/types/Type", "java/lang/String"), false);
    }

    public static String cleanupPathSeparators(String name) {
        name = JvmCodeGenUtil.cleanupBalExt(name);
        return name.replace("\\", "/");
    }

    public static String rewriteVirtualCallTypeName(String value) {
        return IdentifierUtils.encodeFunctionIdentifier(JvmCodeGenUtil.cleanupObjectTypeName(value));
    }

    private static String cleanupBalExt(String name) {
        return name.replace(".bal", "");
    }

    public static String getFieldTypeSignature(BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/api/values/BString");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue");
        }
        switch (bType.tag) {
            case 2: {
                return "I";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue");
            }
            case 6: {
                return "Z";
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                return String.format("L%s;", "java/lang/Object");
            }
            case 12: 
            case 15: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue");
            }
            case 14: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue");
            }
            case 9: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl");
            }
            case 19: 
            case 30: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue");
            }
            case 28: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue");
            }
            case 31: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue");
            }
            case 33: {
                return String.format("L%s;", "io/ballerina/runtime/api/values/BObject");
            }
            case 13: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue");
            }
            case 16: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue");
            }
            case 36: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue");
            }
            case 0x7FFFFFFF: {
                return InteropMethodGen.getJTypeSignature((JType)bType);
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + bType);
    }

    public static void generateDefaultConstructor(ClassWriter cw, String ownerClass) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, ownerClass, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    static void generateStrandMetadata(MethodVisitor mv, String moduleClass, PackageID packageID, AsyncDataCollector asyncDataCollector) {
        asyncDataCollector.getStrandMetadata().forEach((varName, metaData) -> JvmCodeGenUtil.genStrandMetadataField(mv, moduleClass, packageID, varName, metaData));
    }

    private static void genStrandMetadataField(MethodVisitor mv, String moduleClass, PackageID packageID, String varName, ScheduleFunctionInfo metaData) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/api/async/StrandMetadata");
        mv.visitInsn(89);
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(packageID.orgName.value));
        mv.visitLdcInsn(IdentifierUtils.decodeIdentifier(packageID.name.value));
        mv.visitLdcInsn(packageID.version.value);
        if (metaData.typeName == null) {
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn(metaData.typeName);
        }
        mv.visitLdcInsn(metaData.parentFunctionName);
        mv.visitMethodInsn(183, "io/ballerina/runtime/api/async/StrandMetadata", "<init>", String.format("(L%s;L%s;L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        mv.visitFieldInsn(179, moduleClass, varName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"));
    }

    static void visitStrandMetadataField(ClassWriter cw, AsyncDataCollector asyncDataCollector) {
        asyncDataCollector.getStrandMetadata().keySet().forEach(varName -> JvmCodeGenUtil.visitStrandMetadataField(cw, varName));
    }

    private static void visitStrandMetadataField(ClassWriter cw, String varName) {
        FieldVisitor fv = cw.visitField(8, varName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"), null, null);
        fv.visitEnd();
    }

    public static String getStrandMetadataVarName(String parentFunction) {
        return "$strand_metadata$" + parentFunction + "$";
    }

    public static boolean isExternFunc(BIRNode.BIRFunction func) {
        return (func.flags & 2L) == 2L;
    }

    public static String getPackageName(PackageID packageID) {
        return JvmCodeGenUtil.getPackageNameWithSeparator(packageID, "/");
    }

    private static String getPackageNameWithSeparator(PackageID packageID, String separator) {
        Object packageName = "";
        String orgName = IdentifierUtils.encodeNonFunctionIdentifier(packageID.orgName.value);
        String moduleName = IdentifierUtils.encodeNonFunctionIdentifier(packageID.name.value);
        String version = packageID.version.value;
        if (!moduleName.equals("$0046")) {
            if (!version.equals("")) {
                packageName = JvmCodeGenUtil.getVersionDirectoryName(version) + separator;
            }
            packageName = moduleName + separator + (String)packageName;
        }
        if (!orgName.equalsIgnoreCase("$anon")) {
            packageName = orgName + separator + (String)packageName;
        }
        return packageName;
    }

    static String getVersionDirectoryName(String name) {
        return name.replace(".", "_");
    }

    public static String getModuleLevelClassName(PackageID packageID, String sourceFileName) {
        return JvmCodeGenUtil.getModuleLevelClassName(packageID, sourceFileName, "/");
    }

    static String getModuleLevelClassName(PackageID packageID, String sourceFileName, String separator) {
        String className = JvmCodeGenUtil.cleanupSourceFileName(sourceFileName);
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        return JvmCodeGenUtil.getPackageNameWithSeparator(packageID, separator) + className;
    }

    private static String cleanupSourceFileName(String name) {
        return name.replace(".", "$$$");
    }

    public static String getMethodDesc(List<BType> paramTypes, BType retType) {
        return INITIAL_METHOD_DESC + JvmCodeGenUtil.populateMethodDesc(paramTypes) + JvmCodeGenUtil.generateReturnType(retType);
    }

    public static String getMethodDesc(List<BType> paramTypes, BType retType, BType attachedType) {
        return INITIAL_METHOD_DESC + JvmCodeGenUtil.getArgTypeSignature(attachedType) + JvmCodeGenUtil.populateMethodDesc(paramTypes) + JvmCodeGenUtil.generateReturnType(retType);
    }

    public static String populateMethodDesc(List<BType> paramTypes) {
        StringBuilder descBuilder = new StringBuilder();
        for (BType type : paramTypes) {
            descBuilder.append(JvmCodeGenUtil.getArgTypeSignature(type));
        }
        return descBuilder.toString();
    }

    public static String getArgTypeSignature(BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/api/values/BString");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue");
        }
        switch (bType.tag) {
            case 2: {
                return "I";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue");
            }
            case 6: {
                return "Z";
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                return String.format("L%s;", "java/lang/Object");
            }
            case 19: 
            case 30: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue");
            }
            case 28: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue");
            }
            case 12: 
            case 15: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue");
            }
            case 31: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue");
            }
            case 14: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue");
            }
            case 9: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl");
            }
            case 16: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue");
            }
            case 13: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue");
            }
            case 33: {
                return String.format("L%s;", "io/ballerina/runtime/api/values/BObject");
            }
            case 36: {
                return String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue");
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
    }

    public static String generateReturnType(BType bType) {
        if ((bType = TYPE_BUILDER.build(bType)) == null || bType.tag == 10 || bType.tag == 49) {
            return String.format(")L%s;", "java/lang/Object");
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return ")J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format(")L%s;", "io/ballerina/runtime/api/values/BString");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format(")L%s;", "io/ballerina/runtime/internal/values/XmlValue");
        }
        switch (bType.tag) {
            case 2: {
                return ")I";
            }
            case 3: {
                return ")D";
            }
            case 4: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/DecimalValue");
            }
            case 6: {
                return ")Z";
            }
            case 19: 
            case 30: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/ArrayValue");
            }
            case 12: 
            case 15: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/MapValue");
            }
            case 28: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/ErrorValue");
            }
            case 14: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/StreamValue");
            }
            case 9: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/TableValueImpl");
            }
            case 31: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/FutureValue");
            }
            case 13: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/TypedescValue");
            }
            case 7: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: {
                return String.format(")L%s;", "java/lang/Object");
            }
            case 33: {
                return String.format(")L%s;", "io/ballerina/runtime/api/values/BObject");
            }
            case 16: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/FPValue");
            }
            case 36: {
                return String.format(")L%s;", "io/ballerina/runtime/internal/values/HandleValue");
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + bType);
    }

    static String cleanupObjectTypeName(String typeName) {
        int index = typeName.lastIndexOf(".");
        if (index > 0) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    public static void loadChannelDetails(MethodVisitor mv, List<BIRNode.ChannelDetails> channels) {
        mv.visitIntInsn(16, channels.size());
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/values/ChannelDetails");
        int index = 0;
        for (BIRNode.ChannelDetails ch : channels) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, index);
            ++index;
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ChannelDetails");
            mv.visitInsn(89);
            mv.visitLdcInsn(ch.name);
            if (ch.channelInSameStrand) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            if (ch.send) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ChannelDetails", "<init>", String.format("(L%s;ZZ)V", "java/lang/String"), false);
            mv.visitInsn(83);
        }
    }

    public static String toNameString(BType t) {
        return IdentifierUtils.encodeNonFunctionIdentifier(t.tsymbol.name.value);
    }

    public static boolean isBallerinaBuiltinModule(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.equals("builtin");
    }

    public static BirScope getLastScopeFromBBInsGen(MethodVisitor mv, LabelGenerator labelGen, JvmInstructionGen instGen, int localVarOffset, AsyncDataCollector asyncDataCollector, String funcName, BIRNode.BIRBasicBlock bb, Set<BirScope> visitedScopesSet, BirScope lastScope) {
        int insCount = bb.instructions.size();
        for (int i = 0; i < insCount; ++i) {
            Label insLabel = labelGen.getLabel(funcName + bb.id.value + "ins" + i);
            mv.visitLabel(insLabel);
            BIRAbstractInstruction inst = bb.instructions.get(i);
            if (inst == null) continue;
            lastScope = JvmCodeGenUtil.getLastScopeFromDiagnosticGen(inst, funcName, mv, labelGen, visitedScopesSet, lastScope);
            instGen.generateInstructions(localVarOffset, asyncDataCollector, inst);
        }
        return lastScope;
    }

    private static BirScope getLastScopeFromDiagnosticGen(BIRAbstractInstruction instruction, String funcName, MethodVisitor mv, LabelGenerator labelGen, Set<BirScope> visitedScopesSet, BirScope lastScope) {
        BirScope scope = instruction.scope;
        if (scope != null && scope != lastScope) {
            lastScope = scope;
            Label scopeLabel = labelGen.getLabel(funcName + SCOPE_PREFIX + scope.id);
            JvmCodeGenUtil.generateDiagnosticPos(instruction.pos, mv, scopeLabel);
            JvmCodeGenUtil.storeLabelForParentScopes(scope, scopeLabel, labelGen, funcName, visitedScopesSet);
            visitedScopesSet.add(scope);
        } else {
            JvmCodeGenUtil.generateDiagnosticPos(instruction.pos, mv);
        }
        return lastScope;
    }

    public static void generateDiagnosticPos(Location pos, MethodVisitor mv) {
        Label label = new Label();
        JvmCodeGenUtil.generateDiagnosticPos(pos, mv, label);
    }

    private static void generateDiagnosticPos(Location pos, MethodVisitor mv, Label label) {
        if (pos != null && pos.lineRange().startLine().line() != Integer.MIN_VALUE) {
            mv.visitLabel(label);
            mv.visitLineNumber(pos.lineRange().startLine().line() + 1, label);
        }
    }

    private static void storeLabelForParentScopes(BirScope scope, Label scopeLabel, LabelGenerator labelGen, String funcName, Set<BirScope> visitedScopesSet) {
        BirScope parent = scope.parent;
        if (parent != null && !visitedScopesSet.contains(parent)) {
            String labelName = funcName + SCOPE_PREFIX + parent.id;
            labelGen.putLabel(labelName, scopeLabel);
            visitedScopesSet.add(parent);
            JvmCodeGenUtil.storeLabelForParentScopes(parent, scopeLabel, labelGen, funcName, visitedScopesSet);
        }
    }

    public static void genYieldCheck(MethodVisitor mv, LabelGenerator labelGen, BIRNode.BIRBasicBlock thenBB, String funcName, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "isYielded", "()Z", false);
        Label yieldLabel = labelGen.getLabel(funcName + "yield");
        mv.visitJumpInsn(154, yieldLabel);
        Label gotoLabel = labelGen.getLabel(funcName + thenBB.id.value);
        mv.visitJumpInsn(167, gotoLabel);
    }

    public static PackageID cleanupPackageID(PackageID pkgID) {
        Name org = new Name(IdentifierUtils.encodeNonFunctionIdentifier(pkgID.orgName.value));
        Name module = new Name(IdentifierUtils.encodeNonFunctionIdentifier(pkgID.name.value));
        return new PackageID(org, module, pkgID.version);
    }

    public static boolean isBuiltInPackage(PackageID packageID) {
        packageID = JvmCodeGenUtil.cleanupPackageID(packageID);
        return "ballerina".equals(packageID.orgName.value) && "lang$0046annotations".equals(packageID.name.value);
    }

    public static String cleanupFunctionName(String functionName) {
        return StringUtils.containsAny((CharSequence)functionName, (CharSequence)"\\.:/<>") ? "$" + JVM_RESERVED_CHAR_SET.matcher(functionName).replaceAll("_") : functionName;
    }

    private JvmCodeGenUtil() {
    }
}

