/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.api.utils.IdentifierUtils;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JCast;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInsKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmInstructionGen {
    static BType anyType;
    private final MethodVisitor mv;
    private final BIRVarToJVMIndexMap indexMap;
    private final String currentPackageName;
    private final PackageID currentPackage;
    private final JvmPackageGen jvmPackageGen;
    private final SymbolTable symbolTable;

    public JvmInstructionGen(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, PackageID currentPackage, JvmPackageGen jvmPackageGen) {
        this.mv = mv;
        this.indexMap = indexMap;
        this.currentPackage = currentPackage;
        this.jvmPackageGen = jvmPackageGen;
        this.symbolTable = jvmPackageGen.symbolTable;
        this.currentPackageName = JvmCodeGenUtil.getPackageName(currentPackage);
    }

    static void addJUnboxInsn(MethodVisitor mv, JType jType) {
        if (jType == null) {
            return;
        }
        switch (jType.jTag) {
            case 1: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJByte", String.format("(L%s;)B", "java/lang/Object"), false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJChar", String.format("(L%s;)C", "java/lang/Object"), false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJShort", String.format("(L%s;)S", "java/lang/Object"), false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJInt", String.format("(L%s;)I", "java/lang/Object"), false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJLong", String.format("(L%s;)J", "java/lang/Object"), false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJFloat", String.format("(L%s;)F", "java/lang/Object"), false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJDouble", String.format("(L%s;)D", "java/lang/Object"), false);
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJBoolean", String.format("(L%s;)Z", "java/lang/Object"), false);
                break;
            }
            case 10: {
                mv.visitTypeInsn(192, ((JType.JRefType)jType).typeValue);
            }
        }
    }

    private static void generateJVarLoad(MethodVisitor mv, JType jType, int valueIndex) {
        switch (jType.jTag) {
            case 1: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 2: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 3: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 4: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 5: {
                mv.visitVarInsn(22, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(23, valueIndex);
                break;
            }
            case 7: {
                mv.visitVarInsn(24, valueIndex);
                break;
            }
            case 8: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 9: 
            case 10: {
                mv.visitVarInsn(25, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    private static void generateJVarStore(MethodVisitor mv, JType jType, int valueIndex) {
        switch (jType.jTag) {
            case 1: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 2: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 3: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 4: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 5: {
                mv.visitVarInsn(55, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(56, valueIndex);
                break;
            }
            case 7: {
                mv.visitVarInsn(57, valueIndex);
                break;
            }
            case 8: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 9: 
            case 10: {
                mv.visitVarInsn(58, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    private static int[] listHighSurrogates(String str) {
        ArrayList<Integer> highSurrogates = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            highSurrogates.add(i - highSurrogates.size());
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return highSurrogatesArr;
    }

    static void loadConstantValue(BType bType, Object constVal, MethodVisitor mv) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            long intValue = constVal instanceof Long ? (Long)constVal : Long.parseLong(String.valueOf(constVal));
            mv.visitLdcInsn(intValue);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            String val = String.valueOf(constVal);
            int[] highSurrogates = JvmInstructionGen.listHighSurrogates(val);
            if (highSurrogates.length > 0) {
                JvmInstructionGen.createNonBmpString(mv, val, highSurrogates);
            } else {
                JvmInstructionGen.createBmpString(mv, val);
            }
            return;
        }
        switch (bType.tag) {
            case 2: {
                int byteValue = ((Number)constVal).intValue();
                mv.visitLdcInsn(byteValue);
                break;
            }
            case 3: {
                double doubleValue = constVal instanceof Double ? (Double)constVal : Double.parseDouble(String.valueOf(constVal));
                mv.visitLdcInsn(doubleValue);
                break;
            }
            case 6: {
                boolean booleanVal = constVal instanceof Boolean ? (Boolean)constVal : Boolean.parseBoolean(String.valueOf(constVal));
                mv.visitLdcInsn(booleanVal);
                break;
            }
            case 4: {
                mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/DecimalValue");
                mv.visitInsn(89);
                mv.visitLdcInsn(String.valueOf(constVal));
                mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/DecimalValue", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
                break;
            }
            case 10: 
            case 49: {
                mv.visitInsn(1);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type : " + String.format("%s", bType));
            }
        }
    }

    private static void createBmpString(MethodVisitor mv, String val) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn(val);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
    }

    private static void createNonBmpString(MethodVisitor mv, String val, int[] highSurrogates) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/NonBmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn(val);
        mv.visitIntInsn(16, highSurrogates.length);
        mv.visitIntInsn(188, 10);
        int i = 0;
        for (int ch : highSurrogates) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            mv.visitIntInsn(16, ch);
            ++i;
            mv.visitInsn(79);
        }
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/NonBmpStringValue", "<init>", String.format("(L%s;[I)V", "java/lang/String"), false);
    }

    private static void generateIntToUnsignedIntConversion(MethodVisitor mv, BType targetType) {
        switch (targetType.tag) {
            case 2: 
            case 43: {
                mv.visitInsn(136);
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedLong", "(B)J", false);
                return;
            }
            case 42: {
                mv.visitInsn(136);
                mv.visitInsn(147);
                mv.visitMethodInsn(184, "java/lang/Short", "toUnsignedLong", "(S)J", false);
                return;
            }
            case 41: {
                mv.visitInsn(136);
                mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
            }
        }
    }

    public void generateVarLoad(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, int valueIndex) {
        BType bType = varDcl.type;
        switch (varDcl.kind) {
            case GLOBAL: {
                BIRNode.BIRGlobalVariableDcl globalVar = (BIRNode.BIRGlobalVariableDcl)varDcl;
                String moduleName = JvmCodeGenUtil.getPackageName(globalVar.pkgId);
                String varName = varDcl.name.value;
                String className = this.jvmPackageGen.lookupGlobalVarClassName(moduleName, varName);
                String typeSig = JvmTypeGen.getTypeDesc(bType);
                mv.visitFieldInsn(178, className, varName, typeSig);
                return;
            }
            case SELF: {
                mv.visitVarInsn(25, 0);
                return;
            }
            case CONSTANT: {
                String varName = varDcl.name.value;
                PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
                String pkgName = JvmCodeGenUtil.getPackageName(moduleId);
                String className = this.jvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
                String typeSig = JvmTypeGen.getTypeDesc(bType);
                mv.visitFieldInsn(178, className, varName, typeSig);
                return;
            }
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(22, valueIndex);
            return;
        }
        if (TypeTags.isXMLTypeTag(bType.tag) || TypeTags.isStringTypeTag(bType.tag)) {
            mv.visitVarInsn(25, valueIndex);
            return;
        }
        switch (bType.tag) {
            case 2: {
                mv.visitVarInsn(21, valueIndex);
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                break;
            }
            case 3: {
                mv.visitVarInsn(24, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 49: {
                mv.visitVarInsn(25, valueIndex);
                break;
            }
            case 0x7FFFFFFF: {
                JvmInstructionGen.generateJVarLoad(mv, (JType)bType, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
            }
        }
    }

    public void generateVarStore(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, int valueIndex) {
        BType bType = varDcl.type;
        if (varDcl.kind == VarKind.GLOBAL) {
            String varName = varDcl.name.value;
            String className = this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(179, className, varName, typeSig);
            return;
        }
        if (varDcl.kind == VarKind.CONSTANT) {
            String varName = varDcl.name.value;
            PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
            String pkgName = JvmCodeGenUtil.getPackageName(moduleId);
            String className = this.jvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(179, className, varName, typeSig);
            return;
        }
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(55, valueIndex);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag)) {
            mv.visitVarInsn(58, valueIndex);
            return;
        }
        switch (bType.tag) {
            case 2: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 3: {
                mv.visitVarInsn(57, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 49: {
                mv.visitVarInsn(58, valueIndex);
                break;
            }
            case 0x7FFFFFFF: {
                JvmInstructionGen.generateJVarStore(mv, (JType)bType, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
            }
        }
    }

    private BType getSmallerUnsignedIntSubType(BType lhsType, BType rhsType) {
        if (TypeTags.isSignedIntegerTypeTag(lhsType.tag) || TypeTags.isSignedIntegerTypeTag(rhsType.tag)) {
            throw new BLangCompilerException("expected two unsigned int subtypes, found '" + lhsType + "' and '" + rhsType + "'");
        }
        if (lhsType.tag == 2 || rhsType.tag == 2) {
            return this.symbolTable.unsigned8IntType;
        }
        if (lhsType.tag == 43 || rhsType.tag == 43) {
            return this.symbolTable.unsigned8IntType;
        }
        if (lhsType.tag == 42 || rhsType.tag == 42) {
            return this.symbolTable.unsigned16IntType;
        }
        return this.symbolTable.unsigned32IntType;
    }

    void generatePlatformIns(JInstruction ins) {
        if (ins.jKind == JInsKind.JCAST) {
            JCast castIns = (JCast)ins;
            BType targetType = castIns.targetType;
            this.loadVar(castIns.rhsOp.variableDcl);
            JvmCastGen.generatePlatformCheckCast(this.mv, this.indexMap, castIns.rhsOp.variableDcl.type, targetType);
            this.storeToVar(castIns.lhsOp.variableDcl);
        }
    }

    void generateMoveIns(BIRNonTerminator.Move moveIns) {
        this.loadVar(moveIns.rhsOp.variableDcl);
        this.storeToVar(moveIns.lhsOp.variableDcl);
    }

    void generateBinaryOpIns(BIRNonTerminator.BinaryOp binaryIns) {
        InstructionKind insKind = binaryIns.kind;
        switch (insKind) {
            case ADD: {
                this.generateAddIns(binaryIns);
                break;
            }
            case SUB: {
                this.generateSubIns(binaryIns);
                break;
            }
            case MUL: {
                this.generateMulIns(binaryIns);
                break;
            }
            case DIV: {
                this.generateDivIns(binaryIns);
                break;
            }
            case MOD: {
                this.generateRemIns(binaryIns);
                break;
            }
            case EQUAL: {
                this.generateEqualIns(binaryIns);
                break;
            }
            case NOT_EQUAL: {
                this.generateNotEqualIns(binaryIns);
                break;
            }
            case GREATER_THAN: {
                this.generateGreaterThanIns(binaryIns);
                break;
            }
            case GREATER_EQUAL: {
                this.generateGreaterEqualIns(binaryIns);
                break;
            }
            case LESS_THAN: {
                this.generateLessThanIns(binaryIns);
                break;
            }
            case LESS_EQUAL: {
                this.generateLessEqualIns(binaryIns);
                break;
            }
            case REF_EQUAL: {
                this.generateRefEqualIns(binaryIns);
                break;
            }
            case REF_NOT_EQUAL: {
                this.generateRefNotEqualIns(binaryIns);
                break;
            }
            case CLOSED_RANGE: {
                this.generateClosedRangeIns(binaryIns);
                break;
            }
            case HALF_OPEN_RANGE: {
                this.generateClosedRangeIns(binaryIns);
                break;
            }
            case ANNOT_ACCESS: {
                this.generateAnnotAccessIns(binaryIns);
                break;
            }
            case BITWISE_AND: {
                this.generateBitwiseAndIns(binaryIns);
                break;
            }
            case BITWISE_OR: {
                this.generateBitwiseOrIns(binaryIns);
                break;
            }
            case BITWISE_XOR: {
                this.generateBitwiseXorIns(binaryIns);
                break;
            }
            case BITWISE_LEFT_SHIFT: {
                this.generateBitwiseLeftShiftIns(binaryIns);
                break;
            }
            case BITWISE_RIGHT_SHIFT: {
                this.generateBitwiseRightShiftIns(binaryIns);
                break;
            }
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                this.generateBitwiseUnsignedRightShiftIns(binaryIns);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for instruction kind : " + String.format("%s", new Object[]{insKind}));
            }
        }
    }

    private void generateBinaryRhsAndLhsLoad(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
    }

    private void generateLessThanIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 155);
    }

    private void generateGreaterThanIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 157);
    }

    private void generateLessEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 158);
    }

    private void generateGreaterEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 156);
    }

    private void generateBinaryCompareIns(BIRNonTerminator.BinaryOp binaryIns, int opcode) {
        if (opcode != 155 && opcode != 157 && opcode != 158 && opcode != 156) {
            throw new BLangCompilerException(String.format("Unsupported opcode '%s' for binary operator.", opcode));
        }
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
        BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(opcode, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            if (opcode == 155) {
                this.mv.visitJumpInsn(161, label1);
            } else if (opcode != 157) {
                this.mv.visitJumpInsn(163, label1);
            } else if (opcode != 158) {
                this.mv.visitJumpInsn(164, label1);
            } else if (opcode == 156) {
                this.mv.visitJumpInsn(162, label1);
            }
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(opcode, label1);
        } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
            String compareFuncName = this.getDecimalCompareFuncName(opcode);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", compareFuncName, String.format("(L%s;L%s;)Z", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.mv.visitInsn(3);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(4);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private String getDecimalCompareFuncName(int opcode) {
        switch (opcode) {
            case 157: {
                return "checkDecimalGreaterThan";
            }
            case 156: {
                return "checkDecimalGreaterThanOrEqual";
            }
            case 155: {
                return "checkDecimalLessThan";
            }
            case 158: {
                return "checkDecimalLessThanOrEqual";
            }
        }
        throw new BLangCompilerException(String.format("Opcode: '%s' is not a comparison opcode.", opcode));
    }

    private void generateEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
        BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.mv.visitJumpInsn(160, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.mv.visitJumpInsn(160, label1);
        } else {
            if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalEqual", String.format("(L%s;L%s;)Z", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
        BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalEqual", String.format("(L%s;L%s;)Z", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
            this.mv.visitJumpInsn(154, label1);
        } else {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
            this.mv.visitJumpInsn(154, label1);
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRefEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
        BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.mv.visitJumpInsn(160, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.mv.visitJumpInsn(160, label1);
        } else {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isReferenceEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRefNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = binaryIns.rhsOp1.variableDcl.type;
        BType rhsOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.mv.visitJumpInsn(159, label1);
        } else {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isReferenceEqual", String.format("(L%s;L%s;)Z", "java/lang/Object", "java/lang/Object"), false);
            this.mv.visitJumpInsn(154, label1);
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateClosedRangeIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
        this.mv.visitInsn(89);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        this.mv.visitMethodInsn(184, "java/util/stream/LongStream", "rangeClosed", String.format("(JJ)L%s;", "java/util/stream/LongStream"), true);
        this.mv.visitMethodInsn(185, "java/util/stream/LongStream", "toArray", "()[J", true);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "([J)V", false);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateAnnotAccessIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "getAnnotValue", String.format("(L%s;L%s;)L%s;", "io/ballerina/runtime/internal/values/TypedescValue", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), false);
        BType targetType = binaryIns.lhsOp.variableDcl.type;
        JvmCastGen.addUnboxInsn(this.mv, targetType);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateAddIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = binaryIns.lhsOp.variableDcl.type;
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitInsn(97);
        } else if (bType.tag == 2) {
            this.mv.visitInsn(96);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "concat", String.format("(L%s;)L%s;", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString"), true);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "add", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(99);
        } else if (TypeTags.isXMLTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/XmlFactory", "concatenate", String.format("(L%s;L%s;)L%s;", "io/ballerina/runtime/internal/values/XmlValue", "io/ballerina/runtime/internal/values/XmlValue", "io/ballerina/runtime/internal/values/XmlValue"), false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateSubIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = binaryIns.lhsOp.variableDcl.type;
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitInsn(101);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(103);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "subtract", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateDivIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = binaryIns.lhsOp.variableDcl.type;
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/MathUtils", "divide", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(111);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "divide", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateMulIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = binaryIns.lhsOp.variableDcl.type;
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitInsn(105);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(107);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "multiply", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRemIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = binaryIns.lhsOp.variableDcl.type;
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/MathUtils", "remainder", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(115);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "remainder", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/values/DecimalValue", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseAndIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = binaryIns.rhsOp1.variableDcl.type;
        BType opType2 = binaryIns.rhsOp2.variableDcl.type;
        int opType1Tag = opType1.tag;
        int opType2Tag = opType2.tag;
        if (opType1Tag == 2 && opType2Tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            JvmCastGen.generateCheckCastToByte(this.mv, opType1);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            JvmCastGen.generateCheckCastToByte(this.mv, opType2);
            this.mv.visitInsn(126);
        } else {
            boolean byteResult = false;
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            if (opType1Tag == 2) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
                byteResult = true;
            }
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            if (opType2Tag == 2) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "toUnsignedLong", "(I)J", false);
                byteResult = true;
            }
            this.mv.visitInsn(127);
            if (byteResult) {
                JvmCastGen.generateCheckCastToByte(this.mv, this.symbolTable.intType);
            }
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseOrIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = binaryIns.rhsOp1.variableDcl.type;
        BType opType2 = binaryIns.rhsOp2.variableDcl.type;
        if (opType1.tag == 2 && opType2.tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitInsn(128);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        JvmCastGen.generateCheckCast(this.mv, opType1, this.symbolTable.intType, this.indexMap);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        JvmCastGen.generateCheckCast(this.mv, opType2, this.symbolTable.intType, this.indexMap);
        this.mv.visitInsn(129);
        if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag)) {
            JvmInstructionGen.generateIntToUnsignedIntConversion(this.mv, this.getSmallerUnsignedIntSubType(opType1, opType2));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseXorIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = binaryIns.rhsOp1.variableDcl.type;
        BType opType2 = binaryIns.rhsOp2.variableDcl.type;
        if (opType1.tag == 2 && opType2.tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitInsn(130);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        JvmCastGen.generateCheckCast(this.mv, opType1, this.symbolTable.intType, this.indexMap);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        JvmCastGen.generateCheckCast(this.mv, opType2, this.symbolTable.intType, this.indexMap);
        this.mv.visitInsn(131);
        if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag)) {
            JvmInstructionGen.generateIntToUnsignedIntConversion(this.mv, this.getSmallerUnsignedIntSubType(opType1, opType2));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseLeftShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        BType secondOpType = binaryIns.rhsOp2.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(secondOpType.tag)) {
            this.mv.visitInsn(136);
        }
        BType firstOpType = binaryIns.rhsOp1.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(firstOpType.tag)) {
            this.mv.visitInsn(121);
        } else {
            this.mv.visitInsn(120);
            this.mv.visitInsn(133);
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp2.variableDcl.type.tag)) {
            this.mv.visitInsn(136);
        }
        if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp1.variableDcl.type.tag)) {
            this.mv.visitInsn(123);
        } else {
            this.mv.visitInsn(122);
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseUnsignedRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp2.variableDcl.type.tag)) {
            this.mv.visitInsn(136);
        }
        if (TypeTags.isIntegerTypeTag(binaryIns.rhsOp1.variableDcl.type.tag)) {
            this.mv.visitInsn(125);
        } else {
            this.mv.visitInsn(124);
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
        return this.indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
    }

    void generateMapNewIns(BIRNonTerminator.NewStructure mapNewIns, int localVarOffset) {
        this.loadVar(mapNewIns.rhsOp.variableDcl);
        this.mv.visitVarInsn(25, localVarOffset);
        List<BIRNode.BIRMappingConstructorEntry> initialValues = mapNewIns.initialValues;
        this.mv.visitLdcInsn(initialValues.size());
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/api/values/BMapInitialValueEntry");
        int i = 0;
        for (BIRNode.BIRMappingConstructorEntry initialValue : initialValues) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(i);
            this.mv.visitInsn(136);
            ++i;
            if (initialValue.isKeyValuePair()) {
                this.createKeyValueEntry(this.mv, (BIRNode.BIRMappingConstructorKeyValueEntry)initialValue);
            } else {
                this.createSpreadFieldEntry(this.mv, (BIRNode.BIRMappingConstructorSpreadFieldEntry)initialValue);
            }
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TypedescValue", "instantiate", String.format("(L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/values/BInitialValueEntry", "java/lang/Object"), true);
        this.storeToVar(mapNewIns.lhsOp.variableDcl);
    }

    private void createKeyValueEntry(MethodVisitor mv, BIRNode.BIRMappingConstructorKeyValueEntry keyValueEntry) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$KeyValueEntry");
        mv.visitInsn(89);
        BIRNode.BIRVariableDcl keyOpVarDecl = keyValueEntry.keyOp.variableDcl;
        this.loadVar(keyOpVarDecl);
        JvmCastGen.addBoxInsn(this.mv, keyOpVarDecl.type);
        BIRNode.BIRVariableDcl valueOpVarDecl = keyValueEntry.valueOp.variableDcl;
        this.loadVar(valueOpVarDecl);
        JvmCastGen.addBoxInsn(this.mv, valueOpVarDecl.type);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$KeyValueEntry", "<init>", String.format("(L%s;L%s;)V", "java/lang/Object", "java/lang/Object"), false);
    }

    private void createSpreadFieldEntry(MethodVisitor mv, BIRNode.BIRMappingConstructorSpreadFieldEntry spreadFieldEntry) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$SpreadFieldEntry");
        mv.visitInsn(89);
        BIRNode.BIRVariableDcl variableDcl = spreadFieldEntry.exprOp.variableDcl;
        this.loadVar(variableDcl);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$SpreadFieldEntry", "<init>", String.format("(L%s;)V", "io/ballerina/runtime/api/values/BMap"), false);
    }

    void generateMapStoreIns(BIRNonTerminator.FieldAccess mapStoreIns) {
        this.loadVar(mapStoreIns.lhsOp.variableDcl);
        BType varRefType = mapStoreIns.lhsOp.variableDcl.type;
        this.loadVar(mapStoreIns.keyOp.variableDcl);
        BType valueType = mapStoreIns.rhsOp.variableDcl.type;
        this.loadVar(mapStoreIns.rhsOp.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, valueType);
        if (varRefType.tag == 7) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/JsonUtils", "setElement", String.format("(L%s;L%s;L%s;)V", "java/lang/Object", "io/ballerina/runtime/api/values/BString"), false);
        } else if (mapStoreIns.onInitialization) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "populateInitialValue", String.format("(L%s;L%s;)V", "java/lang/Object", "java/lang/Object"), true);
        } else {
            String signature = String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/internal/values/MapValue", "io/ballerina/runtime/api/values/BString", "java/lang/Object");
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/MapUtils", "handleMapStore", signature, false);
        }
    }

    void generateMapLoadIns(BIRNonTerminator.FieldAccess mapLoadIns) {
        this.loadVar(mapLoadIns.rhsOp.variableDcl);
        BType varRefType = mapLoadIns.rhsOp.variableDcl.type;
        JvmCastGen.addUnboxInsn(this.mv, varRefType);
        this.loadVar(mapLoadIns.keyOp.variableDcl);
        if (varRefType.tag == 7) {
            if (mapLoadIns.optionalFieldAccess) {
                this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/JsonUtils", "getElementOrNil", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), false);
            } else {
                this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/JsonUtils", "getElement", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), false);
            }
        } else if (mapLoadIns.fillingRead) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "fillAndGet", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
        } else {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "get", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
        }
        BType targetType = mapLoadIns.lhsOp.variableDcl.type;
        JvmCastGen.addUnboxInsn(this.mv, targetType);
        this.storeToVar(mapLoadIns.lhsOp.variableDcl);
    }

    void generateObjectLoadIns(BIRNonTerminator.FieldAccess objectLoadIns) {
        this.loadVar(objectLoadIns.rhsOp.variableDcl);
        this.loadVar(objectLoadIns.keyOp.variableDcl);
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "get", String.format("(L%s;)L%s;", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), true);
        BType targetType = objectLoadIns.lhsOp.variableDcl.type;
        JvmCastGen.addUnboxInsn(this.mv, targetType);
        this.storeToVar(objectLoadIns.lhsOp.variableDcl);
    }

    void generateObjectStoreIns(BIRNonTerminator.FieldAccess objectStoreIns) {
        this.loadVar(objectStoreIns.lhsOp.variableDcl);
        this.loadVar(objectStoreIns.keyOp.variableDcl);
        BType valueType = objectStoreIns.rhsOp.variableDcl.type;
        this.loadVar(objectStoreIns.rhsOp.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, valueType);
        if (objectStoreIns.onInitialization) {
            BObjectType objectType = (BObjectType)objectStoreIns.lhsOp.variableDcl.type;
            this.mv.visitMethodInsn(183, JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(objectType.tsymbol.pkgID), JvmCodeGenUtil.toNameString(objectType)), "setOnInitialization", String.format("(L%s;L%s;)V", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), false);
            return;
        }
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "set", String.format("(L%s;L%s;)V", "io/ballerina/runtime/api/values/BString", "java/lang/Object"), true);
    }

    void generateStringLoadIns(BIRNonTerminator.FieldAccess stringLoadIns) {
        this.loadVar(stringLoadIns.rhsOp.variableDcl);
        this.loadVar(stringLoadIns.keyOp.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "getStringAt", String.format("(L%s;J)L%s;", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString"), false);
        this.storeToVar(stringLoadIns.lhsOp.variableDcl);
    }

    void generateArrayNewIns(BIRNonTerminator.NewArray inst) {
        if (inst.type.tag == 19) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
            this.mv.visitInsn(89);
            JvmTypeGen.loadType(this.mv, inst.type);
            this.loadVar(inst.sizeOp.variableDcl);
            this.loadListInitialValues(inst);
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", String.format("(L%s;J[L%s;)V", "io/ballerina/runtime/api/types/ArrayType", "io/ballerina/runtime/internal/values/ListInitialValueEntry"), false);
            this.storeToVar(inst.lhsOp.variableDcl);
        } else {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/TupleValueImpl");
            this.mv.visitInsn(89);
            JvmTypeGen.loadType(this.mv, inst.type);
            this.loadVar(inst.sizeOp.variableDcl);
            this.loadListInitialValues(inst);
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TupleValueImpl", "<init>", String.format("(L%s;J[L%s;)V", "io/ballerina/runtime/api/types/TupleType", "io/ballerina/runtime/internal/values/ListInitialValueEntry"), false);
            this.storeToVar(inst.lhsOp.variableDcl);
        }
    }

    void generateArrayStoreIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.lhsOp.variableDcl);
        this.loadVar(inst.keyOp.variableDcl);
        this.loadVar(inst.rhsOp.variableDcl);
        BType valueType = inst.rhsOp.variableDcl.type;
        String method = "add";
        if (TypeTags.isIntegerTypeTag(valueType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, "(JJ)V", true);
        } else if (valueType.tag == 3) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, "(JD)V", true);
        } else if (TypeTags.isStringTypeTag(valueType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, String.format("(JL%s;)V", "io/ballerina/runtime/api/values/BString"), true);
        } else if (valueType.tag == 6) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, "(JZ)V", true);
        } else if (valueType.tag == 2) {
            this.mv.visitInsn(145);
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, "(JB)V", true);
        } else {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", method, String.format("(JL%s;)V", "java/lang/Object"), true);
        }
    }

    void generateArrayValueLoad(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.rhsOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/ArrayValue");
        this.loadVar(inst.keyOp.variableDcl);
        BType bType = inst.lhsOp.variableDcl.type;
        BType varRefType = inst.rhsOp.variableDcl.type;
        if (varRefType.tag == 30) {
            if (inst.fillingRead) {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "fillAndGetRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
            } else {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
            }
            JvmCastGen.addUnboxInsn(this.mv, bType);
        } else if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getInt", "(J)J", true);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBString", String.format("(J)L%s;", "io/ballerina/runtime/api/values/BString"), true);
        } else if (bType.tag == 6) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBoolean", "(J)Z", true);
        } else if (bType.tag == 2) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getByte", "(J)B", true);
            this.mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
        } else if (bType.tag == 3) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getFloat", "(J)D", true);
        } else {
            if (inst.fillingRead) {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "fillAndGetRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
            } else {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", String.format("(J)L%s;", "java/lang/Object"), true);
            }
            String targetTypeClass = JvmCastGen.getTargetClass(bType);
            if (targetTypeClass != null) {
                this.mv.visitTypeInsn(192, targetTypeClass);
            } else {
                JvmCastGen.addUnboxInsn(this.mv, bType);
            }
        }
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableNewIns(BIRNonTerminator.NewTable inst) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/TableValueImpl");
        this.mv.visitInsn(89);
        JvmTypeGen.loadType(this.mv, inst.type);
        this.loadVar(inst.dataOp.variableDcl);
        this.loadVar(inst.keyColOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TableValueImpl", "<init>", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/internal/types/BTableType", "io/ballerina/runtime/internal/values/ArrayValue", "io/ballerina/runtime/internal/values/ArrayValue"), false);
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableLoadIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.rhsOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/TableValue");
        this.loadVar(inst.keyOp.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, inst.keyOp.variableDcl.type);
        BType bType = inst.lhsOp.variableDcl.type;
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TableValue", "getOrThrow", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
        String targetTypeClass = JvmCastGen.getTargetClass(bType);
        if (targetTypeClass != null) {
            this.mv.visitTypeInsn(192, targetTypeClass);
        } else {
            JvmCastGen.addUnboxInsn(this.mv, bType);
        }
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableStoreIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.lhsOp.variableDcl);
        this.loadVar(inst.keyOp.variableDcl);
        BType keyType = inst.keyOp.variableDcl.type;
        JvmCastGen.addBoxInsn(this.mv, keyType);
        BType valueType = inst.rhsOp.variableDcl.type;
        this.loadVar(inst.rhsOp.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, valueType);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TableUtils", "handleTableStore", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/internal/values/TableValue", "java/lang/Object", "java/lang/Object"), false);
    }

    void generateNewErrorIns(BIRNonTerminator.NewError newErrorIns) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ErrorValue");
        this.mv.visitInsn(89);
        JvmTypeGen.loadType(this.mv, newErrorIns.type);
        this.loadVar(newErrorIns.messageOp.variableDcl);
        this.loadVar(newErrorIns.causeOp.variableDcl);
        this.loadVar(newErrorIns.detailOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ErrorValue", "<init>", String.format("(L%s;L%s;L%s;L%s;)V", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BError", "java/lang/Object"), false);
        this.storeToVar(newErrorIns.lhsOp.variableDcl);
    }

    void generateCastIns(BIRNonTerminator.TypeCast typeCastIns) {
        this.loadVar(typeCastIns.rhsOp.variableDcl);
        if (typeCastIns.checkTypes) {
            JvmCastGen.generateCheckCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type, this.indexMap);
        } else {
            JvmCastGen.generateCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type);
        }
        this.storeToVar(typeCastIns.lhsOp.variableDcl);
    }

    void generateTypeTestIns(BIRNonTerminator.TypeTest typeTestIns) {
        this.loadVar(typeTestIns.rhsOp.variableDcl);
        JvmTypeGen.loadType(this.mv, typeTestIns.type);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkIsType", String.format("(L%s;L%s;)Z", "java/lang/Object", "io/ballerina/runtime/api/types/Type"), false);
        this.storeToVar(typeTestIns.lhsOp.variableDcl);
    }

    void generateIsLikeIns(BIRNonTerminator.IsLike isLike) {
        this.loadVar(isLike.rhsOp.variableDcl);
        JvmTypeGen.loadType(this.mv, isLike.type);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkIsLikeType", String.format("(L%s;L%s;)Z", "java/lang/Object", "io/ballerina/runtime/api/types/Type"), false);
        this.storeToVar(isLike.lhsOp.variableDcl);
    }

    void generateObjectNewIns(BIRNonTerminator.NewInstance objectNewIns, int strandIndex) {
        BType type = this.jvmPackageGen.lookupTypeDef(objectNewIns);
        String className = objectNewIns.isExternalDef ? JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(objectNewIns.externalPackageId), objectNewIns.objectName) : JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(this.currentPackage), objectNewIns.def.name.value);
        this.mv.visitTypeInsn(187, className);
        this.mv.visitInsn(89);
        JvmTypeGen.loadType(this.mv, type);
        this.reloadObjectCtorAnnots(type, strandIndex);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "io/ballerina/runtime/internal/types/BObjectType"), false);
        this.storeToVar(objectNewIns.lhsOp.variableDcl);
    }

    private void reloadObjectCtorAnnots(BType type, int strandIndex) {
        if ((type.flags & 0x100000000L) == 0x100000000L) {
            this.mv.visitInsn(89);
            this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
            String pkgClassName = this.currentPackageName.equals(".") || this.currentPackageName.equals("") ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$annotation_data");
            this.mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
            this.mv.visitVarInsn(25, strandIndex);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "processObjectCtorAnnots", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/values/MapValue", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        }
    }

    void generateFPLoadIns(BIRNonTerminator.FPLoad inst, AsyncDataCollector asyncDataCollector) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/FPValue");
        this.mv.visitInsn(89);
        String lambdaName = IdentifierUtils.encodeFunctionIdentifier(inst.funcName.value) + "$lambda" + asyncDataCollector.getLambdaIndex() + "$";
        asyncDataCollector.incrementLambdaIndex();
        String pkgName = JvmCodeGenUtil.getPackageName(inst.pkgId);
        BType returnType = inst.lhsOp.variableDcl.type;
        if (returnType.tag != 16) {
            throw new BLangCompilerException("Expected BInvokableType, found " + String.format("%s", returnType));
        }
        for (BIROperand operand : inst.closureMaps) {
            if (operand == null) continue;
            this.loadVar(operand.variableDcl);
        }
        JvmCodeGenUtil.visitInvokeDynamic(this.mv, asyncDataCollector.getEnclosingClass(), lambdaName, inst.closureMaps.size());
        JvmTypeGen.loadType(this.mv, returnType);
        if (inst.strandName != null) {
            this.mv.visitLdcInsn(inst.strandName);
        } else {
            this.mv.visitInsn(1);
        }
        if (inst.schedulerPolicy == SchedulerPolicy.ANY) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/FPValue", "<init>", String.format("(L%s;L%s;L%s;Z)V", "java/util/function/Function", "io/ballerina/runtime/api/types/Type", "java/lang/String"), false);
        this.mv.visitInsn(89);
        String pkgClassName = pkgName.equals("") ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
        this.mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
        this.mv.visitLdcInsn(inst.funcName.value);
        this.mv.visitMethodInsn(184, String.format("%s", "io/ballerina/runtime/internal/AnnotationUtils"), "processFPValueAnnotations", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/internal/values/FPValue", "io/ballerina/runtime/internal/values/MapValue", "java/lang/String"), false);
        this.storeToVar(inst.lhsOp.variableDcl);
        asyncDataCollector.add(lambdaName, inst);
    }

    void generateNewXMLElementIns(BIRNonTerminator.NewXMLElement newXMLElement) {
        this.loadVar(newXMLElement.startTagOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.loadVar(newXMLElement.defaultNsURIOp.variableDcl);
        if (newXMLElement.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/XmlFactory", "createXMLElement", String.format("(L%s;L%s;Z)L%s;", "io/ballerina/runtime/api/values/BXmlQName", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/internal/values/XmlValue"), false);
        this.storeToVar(newXMLElement.lhsOp.variableDcl);
    }

    void generateNewXMLQNameIns(BIRNonTerminator.NewXMLQName newXMLQName) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitInsn(89);
        this.loadVar(newXMLQName.localnameOp.variableDcl);
        this.loadVar(newXMLQName.nsURIOp.variableDcl);
        this.loadVar(newXMLQName.prefixOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/XmlQName", "<init>", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString"), false);
        this.storeToVar(newXMLQName.lhsOp.variableDcl);
    }

    void generateNewStringXMLQNameIns(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitInsn(89);
        this.loadVar(newStringXMLQName.stringQNameOP.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/XmlQName", "<init>", String.format("(L%s;)V", "java/lang/String"), false);
        this.storeToVar(newStringXMLQName.lhsOp.variableDcl);
    }

    void generateNewXMLTextIns(BIRNonTerminator.NewXMLText newXMLText) {
        this.loadVar(newXMLText.textOp.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/XmlFactory", "createXMLText", String.format("(L%s;)L%s;", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/internal/values/XmlValue"), false);
        this.storeToVar(newXMLText.lhsOp.variableDcl);
    }

    void generateNewXMLCommentIns(BIRNonTerminator.NewXMLComment newXMLComment) {
        this.loadVar(newXMLComment.textOp.variableDcl);
        if (newXMLComment.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/XmlFactory", "createXMLComment", String.format("(L%s;Z)L%s;", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/internal/values/XmlValue"), false);
        this.storeToVar(newXMLComment.lhsOp.variableDcl);
    }

    void generateNewXMLProcIns(BIRNonTerminator.NewXMLProcIns newXMLPI) {
        this.loadVar(newXMLPI.targetOp.variableDcl);
        this.loadVar(newXMLPI.dataOp.variableDcl);
        if (newXMLPI.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/XmlFactory", "createXMLProcessingInstruction", String.format("(L%s;L%s;Z)L%s;", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/api/values/BString", "io/ballerina/runtime/internal/values/XmlValue"), false);
        this.storeToVar(newXMLPI.lhsOp.variableDcl);
    }

    void generateXMLStoreIns(BIRNonTerminator.XMLAccess xmlStoreIns) {
        this.loadVar(xmlStoreIns.lhsOp.variableDcl);
        this.loadVar(xmlStoreIns.rhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "addChildren", String.format("(L%s;)V", "io/ballerina/runtime/internal/values/XmlValue"), false);
    }

    void generateXMLLoadAllIns(BIRNonTerminator.XMLAccess xmlLoadAllIns) {
        this.loadVar(xmlLoadAllIns.rhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "children", String.format("()L%s;", "io/ballerina/runtime/internal/values/XmlValue"), false);
        this.storeToVar(xmlLoadAllIns.lhsOp.variableDcl);
    }

    void generateXMLAttrLoadIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
        this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
        this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getAttribute", String.format("(L%s;)L%s;", "io/ballerina/runtime/api/values/BXmlQName", "java/lang/String"), false);
        BType targetType = xmlAttrStoreIns.lhsOp.variableDcl.type;
        this.storeToVar(xmlAttrStoreIns.lhsOp.variableDcl);
    }

    void generateXMLAttrStoreIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
        this.loadVar(xmlAttrStoreIns.lhsOp.variableDcl);
        this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
        String signature = String.format("(L%s;L%s;)V", "io/ballerina/runtime/api/values/BXmlQName", "io/ballerina/runtime/api/values/BString");
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "setAttribute", signature, false);
    }

    void generateXMLLoadIns(BIRNonTerminator.FieldAccess xmlLoadIns) {
        this.loadVar(xmlLoadIns.rhsOp.variableDcl);
        this.loadVar(xmlLoadIns.keyOp.variableDcl);
        if (TypeTags.isStringTypeTag(xmlLoadIns.keyOp.variableDcl.type.tag)) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "children", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/values/XmlValue"), false);
        } else {
            this.mv.visitInsn(136);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getItem", String.format("(I)L%s;", "io/ballerina/runtime/internal/values/XmlValue"), false);
        }
        BType targetType = xmlLoadIns.lhsOp.variableDcl.type;
        this.storeToVar(xmlLoadIns.lhsOp.variableDcl);
    }

    void generateTypeofIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, unaryOp.rhsOp.variableDcl.type);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "getTypedesc", String.format("(L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/internal/values/TypedescValue"), false);
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNotIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        Label label1 = new Label();
        Label label2 = new Label();
        this.mv.visitJumpInsn(154, label1);
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNegateIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        BType btype = unaryOp.rhsOp.variableDcl.type;
        if (TypeTags.isIntegerTypeTag(btype.tag)) {
            this.mv.visitInsn(117);
        } else if (btype.tag == 2) {
            this.mv.visitInsn(116);
        } else if (btype.tag == 3) {
            this.mv.visitInsn(119);
        } else if (btype.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "negate", String.format("()L%s;", "io/ballerina/runtime/internal/values/DecimalValue"), false);
        } else {
            throw new BLangCompilerException(String.format("Negation is not supported for type: %s", btype));
        }
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNewTypedescIns(BIRNonTerminator.NewTypeDesc newTypeDesc) {
        BType type = newTypeDesc.type;
        String className = "io/ballerina/runtime/internal/values/TypedescValueImpl";
        if (type.tag == 12) {
            className = JvmValueGen.getTypeDescClassName(JvmCodeGenUtil.getPackageName(type.tsymbol.pkgID), JvmCodeGenUtil.toNameString(type));
        }
        this.mv.visitTypeInsn(187, className);
        this.mv.visitInsn(89);
        JvmTypeGen.loadType(this.mv, newTypeDesc.type);
        List<BIROperand> closureVars = newTypeDesc.closureVars;
        this.mv.visitIntInsn(16, closureVars.size());
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/internal/values/MapValue");
        for (int i = 0; i < closureVars.size(); ++i) {
            BIROperand closureVar = closureVars.get(i);
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, i);
            this.loadVar(closureVar.variableDcl);
            this.mv.visitInsn(83);
        }
        String descriptor = String.format("(L%s;[L%s;)V", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/internal/values/MapValue");
        this.mv.visitMethodInsn(183, className, "<init>", descriptor, false);
        this.storeToVar(newTypeDesc.lhsOp.variableDcl);
    }

    private void loadVar(BIRNode.BIRVariableDcl varDcl) {
        this.generateVarLoad(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    private void storeToVar(BIRNode.BIRVariableDcl varDcl) {
        this.generateVarStore(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    void generateConstantLoadIns(BIRNonTerminator.ConstantLoad loadIns) {
        JvmInstructionGen.loadConstantValue(loadIns.type, loadIns.value, this.mv);
        this.storeToVar(loadIns.lhsOp.variableDcl);
    }

    private void loadListInitialValues(BIRNonTerminator.NewArray arrayNewIns) {
        List<BIROperand> initialValues = arrayNewIns.values;
        this.mv.visitLdcInsn(initialValues.size());
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/internal/values/ListInitialValueEntry$ExpressionEntry");
        int i = 0;
        for (BIROperand initialValueOp : initialValues) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(i);
            this.mv.visitInsn(136);
            ++i;
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ListInitialValueEntry$ExpressionEntry");
            this.mv.visitInsn(89);
            BIRNode.BIRVariableDcl varDecl = initialValueOp.variableDcl;
            this.loadVar(varDecl);
            JvmCastGen.addBoxInsn(this.mv, varDecl.type);
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ListInitialValueEntry$ExpressionEntry", "<init>", String.format("(L%s;)V", "java/lang/Object"), false);
            this.mv.visitInsn(83);
        }
    }

    void generateInstructions(int localVarOffset, AsyncDataCollector asyncDataCollector, BIRInstruction inst) {
        if (inst instanceof BIRNonTerminator.BinaryOp) {
            this.generateBinaryOpIns((BIRNonTerminator.BinaryOp)inst);
        } else {
            switch (inst.getKind()) {
                case MOVE: {
                    this.generateMoveIns((BIRNonTerminator.Move)inst);
                    break;
                }
                case CONST_LOAD: {
                    this.generateConstantLoadIns((BIRNonTerminator.ConstantLoad)inst);
                    break;
                }
                case NEW_STRUCTURE: {
                    this.generateMapNewIns((BIRNonTerminator.NewStructure)inst, localVarOffset);
                    break;
                }
                case NEW_INSTANCE: {
                    this.generateObjectNewIns((BIRNonTerminator.NewInstance)inst, localVarOffset);
                    break;
                }
                case MAP_STORE: {
                    this.generateMapStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_TABLE: {
                    this.generateTableNewIns((BIRNonTerminator.NewTable)inst);
                    break;
                }
                case TABLE_STORE: {
                    this.generateTableStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case TABLE_LOAD: {
                    this.generateTableLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_ARRAY: {
                    this.generateArrayNewIns((BIRNonTerminator.NewArray)inst);
                    break;
                }
                case ARRAY_STORE: {
                    this.generateArrayStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case MAP_LOAD: {
                    this.generateMapLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case ARRAY_LOAD: {
                    this.generateArrayValueLoad((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_ERROR: {
                    this.generateNewErrorIns((BIRNonTerminator.NewError)inst);
                    break;
                }
                case TYPE_CAST: {
                    this.generateCastIns((BIRNonTerminator.TypeCast)inst);
                    break;
                }
                case IS_LIKE: {
                    this.generateIsLikeIns((BIRNonTerminator.IsLike)inst);
                    break;
                }
                case TYPE_TEST: {
                    this.generateTypeTestIns((BIRNonTerminator.TypeTest)inst);
                    break;
                }
                case OBJECT_STORE: {
                    this.generateObjectStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case OBJECT_LOAD: {
                    this.generateObjectLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_XML_ELEMENT: {
                    this.generateNewXMLElementIns((BIRNonTerminator.NewXMLElement)inst);
                    break;
                }
                case NEW_XML_TEXT: {
                    this.generateNewXMLTextIns((BIRNonTerminator.NewXMLText)inst);
                    break;
                }
                case NEW_XML_COMMENT: {
                    this.generateNewXMLCommentIns((BIRNonTerminator.NewXMLComment)inst);
                    break;
                }
                case NEW_XML_PI: {
                    this.generateNewXMLProcIns((BIRNonTerminator.NewXMLProcIns)inst);
                    break;
                }
                case NEW_XML_QNAME: {
                    this.generateNewXMLQNameIns((BIRNonTerminator.NewXMLQName)inst);
                    break;
                }
                case NEW_STRING_XML_QNAME: {
                    this.generateNewStringXMLQNameIns((BIRNonTerminator.NewStringXMLQName)inst);
                    break;
                }
                case XML_SEQ_STORE: {
                    this.generateXMLStoreIns((BIRNonTerminator.XMLAccess)inst);
                    break;
                }
                case XML_SEQ_LOAD: 
                case XML_LOAD: {
                    this.generateXMLLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case XML_LOAD_ALL: {
                    this.generateXMLLoadAllIns((BIRNonTerminator.XMLAccess)inst);
                    break;
                }
                case XML_ATTRIBUTE_STORE: {
                    this.generateXMLAttrStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case XML_ATTRIBUTE_LOAD: {
                    this.generateXMLAttrLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case FP_LOAD: {
                    this.generateFPLoadIns((BIRNonTerminator.FPLoad)inst, asyncDataCollector);
                    break;
                }
                case STRING_LOAD: {
                    this.generateStringLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case TYPEOF: {
                    this.generateTypeofIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case NOT: {
                    this.generateNotIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case NEW_TYPEDESC: {
                    this.generateNewTypedescIns((BIRNonTerminator.NewTypeDesc)inst);
                    break;
                }
                case NEGATE: {
                    this.generateNegateIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case PLATFORM: {
                    this.generatePlatformIns((JInstruction)inst);
                    break;
                }
                default: {
                    throw new BLangCompilerException("JVM generation is not supported for operation " + inst);
                }
            }
        }
    }
}

