/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.runtime.api.utils.IdentifierUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.ScheduleFunctionInfo;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JIConstructorCall;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JavaMethodCall;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmTerminatorGen {
    private final MethodVisitor mv;
    private final BIRVarToJVMIndexMap indexMap;
    private final LabelGenerator labelGen;
    private final JvmErrorGen errorGen;
    private final String currentPackageName;
    private final String moduleInitClass;
    private final JvmPackageGen jvmPackageGen;
    private final JvmInstructionGen jvmInstructionGen;
    private final PackageCache packageCache;
    private final SymbolTable symbolTable;
    private final ResolvedTypeBuilder typeBuilder;

    public JvmTerminatorGen(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, LabelGenerator labelGen, JvmErrorGen errorGen, PackageID packageID, JvmInstructionGen jvmInstructionGen, JvmPackageGen jvmPackageGen) {
        this.mv = mv;
        this.indexMap = indexMap;
        this.labelGen = labelGen;
        this.errorGen = errorGen;
        this.jvmPackageGen = jvmPackageGen;
        this.packageCache = jvmPackageGen.packageCache;
        this.jvmInstructionGen = jvmInstructionGen;
        this.symbolTable = jvmPackageGen.symbolTable;
        this.currentPackageName = JvmCodeGenUtil.getPackageName(packageID);
        this.moduleInitClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "$_init");
        this.typeBuilder = new ResolvedTypeBuilder();
    }

    private static void genYieldCheckForLock(MethodVisitor mv, LabelGenerator labelGen, String funcName, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "isYielded", "()Z", false);
        Label yieldLabel = labelGen.getLabel(funcName + "yield");
        mv.visitJumpInsn(154, yieldLabel);
    }

    private void loadDefaultValue(MethodVisitor mv, BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag) || bType.tag == 2) {
            mv.visitInsn(9);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag)) {
            mv.visitInsn(1);
            return;
        }
        switch (bType.tag) {
            case 3: {
                mv.visitInsn(14);
                break;
            }
            case 6: {
                mv.visitInsn(3);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 49: {
                mv.visitInsn(1);
                break;
            }
            case 0x7FFFFFFF: {
                this.loadDefaultJValue(mv, (JType)bType);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
            }
        }
    }

    private void loadDefaultJValue(MethodVisitor mv, JType jType) {
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                mv.visitInsn(3);
                break;
            }
            case 5: {
                mv.visitInsn(9);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                break;
            }
            case 7: {
                mv.visitInsn(14);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    public void genTerminator(BIRTerminator terminator, String moduleClassName, BIRNode.BIRFunction func, String funcName, int localVarOffset, int returnVarRefIndex, BType attachedType, AsyncDataCollector asyncDataCollector) {
        switch (terminator.kind) {
            case LOCK: {
                this.genLockTerm((BIRTerminator.Lock)terminator, funcName, localVarOffset);
                return;
            }
            case UNLOCK: {
                this.genUnlockTerm((BIRTerminator.Unlock)terminator, funcName);
                return;
            }
            case GOTO: {
                this.genGoToTerm((BIRTerminator.GOTO)terminator, funcName);
                return;
            }
            case CALL: {
                this.genCallTerm((BIRTerminator.Call)terminator, localVarOffset);
                return;
            }
            case ASYNC_CALL: {
                this.genAsyncCallTerm((BIRTerminator.AsyncCall)terminator, localVarOffset, moduleClassName, attachedType, funcName, asyncDataCollector);
                return;
            }
            case BRANCH: {
                this.genBranchTerm((BIRTerminator.Branch)terminator, funcName);
                return;
            }
            case RETURN: {
                this.genReturnTerm(returnVarRefIndex, func);
                return;
            }
            case PANIC: {
                this.errorGen.genPanic((BIRTerminator.Panic)terminator);
                return;
            }
            case WAIT: {
                this.generateWaitIns((BIRTerminator.Wait)terminator, localVarOffset);
                return;
            }
            case WAIT_ALL: {
                this.genWaitAllIns((BIRTerminator.WaitAll)terminator, localVarOffset);
                return;
            }
            case FP_CALL: {
                this.genFPCallIns((BIRTerminator.FPCall)terminator, moduleClassName, attachedType, funcName, asyncDataCollector, localVarOffset);
                return;
            }
            case WK_SEND: {
                this.genWorkerSendIns((BIRTerminator.WorkerSend)terminator, localVarOffset);
                return;
            }
            case WK_RECEIVE: {
                this.genWorkerReceiveIns((BIRTerminator.WorkerReceive)terminator, localVarOffset);
                return;
            }
            case FLUSH: {
                this.genFlushIns((BIRTerminator.Flush)terminator, localVarOffset);
                return;
            }
            case PLATFORM: {
                if (terminator instanceof JavaMethodCall) {
                    this.genJCallTerm((JavaMethodCall)terminator, attachedType, localVarOffset);
                    return;
                }
                if (terminator instanceof JIMethodCall) {
                    this.genJICallTerm((JIMethodCall)terminator, localVarOffset);
                    return;
                }
                if (!(terminator instanceof JIConstructorCall)) break;
                this.genJIConstructorTerm((JIConstructorCall)terminator, localVarOffset);
                return;
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for terminator instruction " + String.format("%s", terminator));
    }

    private void genGoToTerm(BIRTerminator.GOTO gotoIns, String funcName) {
        Label gotoLabel = this.labelGen.getLabel(funcName + gotoIns.targetBB.id.value);
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    private void genLockTerm(BIRTerminator.Lock lockIns, String funcName, int localVarOffset) {
        Label gotoLabel = this.labelGen.getLabel(funcName + lockIns.lockedBB.id.value);
        String lockStore = "Lio/ballerina/runtime/internal/BLockStore;";
        String initClassName = this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$LOCK_STORE");
        String lockName = "lock" + lockIns.lockId;
        this.mv.visitFieldInsn(178, initClassName, "$LOCK_STORE", lockStore);
        this.mv.visitLdcInsn(lockName);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLockStore", "getLockFromMap", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/BLock"), false);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLock", "lock", String.format("(L%s;)Z", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        this.mv.visitInsn(87);
        JvmTerminatorGen.genYieldCheckForLock(this.mv, this.labelGen, funcName, localVarOffset);
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    private void genUnlockTerm(BIRTerminator.Unlock unlockIns, String funcName) {
        Label gotoLabel = this.labelGen.getLabel(funcName + unlockIns.unlockBB.id.value);
        String lockStore = "Lio/ballerina/runtime/internal/BLockStore;";
        String lockName = "lock" + unlockIns.relatedLock.lockId;
        String initClassName = this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$LOCK_STORE");
        this.mv.visitFieldInsn(178, initClassName, "$LOCK_STORE", lockStore);
        this.mv.visitLdcInsn(lockName);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLockStore", "getLockFromMap", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/BLock"), false);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLock", "unlock", "()V", false);
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    private void handleErrorRetInUnion(int returnVarRefIndex, List<BIRNode.ChannelDetails> channels, BUnionType bType) {
        if (channels.size() == 0) {
            return;
        }
        boolean errorIncluded = false;
        for (BType member : bType.getMemberTypes()) {
            if (member.tag != 28) continue;
            errorIncluded = true;
            break;
        }
        if (errorIncluded) {
            this.mv.visitVarInsn(25, returnVarRefIndex);
            this.mv.visitVarInsn(25, 0);
            JvmCodeGenUtil.loadChannelDetails(this.mv, channels);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "handleWorkerError", String.format("(L%s;L%s;[L%s;)V", "io/ballerina/runtime/internal/values/RefValue", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/internal/values/ChannelDetails"), false);
        }
    }

    private void notifyChannels(List<BIRNode.ChannelDetails> channels, int retIndex) {
        if (channels.size() == 0) {
            return;
        }
        this.mv.visitVarInsn(25, 0);
        JvmCodeGenUtil.loadChannelDetails(this.mv, channels);
        this.mv.visitVarInsn(25, retIndex);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "handleChannelError", String.format("([L%s;L%s;)V", "io/ballerina/runtime/internal/values/ChannelDetails", "io/ballerina/runtime/internal/values/ErrorValue"), false);
    }

    private void genBranchTerm(BIRTerminator.Branch branchIns, String funcName) {
        String trueBBId = branchIns.trueBB.id.value;
        String falseBBId = branchIns.falseBB.id.value;
        this.loadVar(branchIns.op.variableDcl);
        Label trueBBLabel = this.labelGen.getLabel(funcName + trueBBId);
        this.mv.visitJumpInsn(157, trueBBLabel);
        Label falseBBLabel = this.labelGen.getLabel(funcName + falseBBId);
        this.mv.visitJumpInsn(167, falseBBLabel);
    }

    private void genCallTerm(BIRTerminator.Call callIns, int localVarOffset) {
        this.genCall(callIns, callIns.calleePkg, localVarOffset);
        this.storeReturnFromCallIns(callIns.lhsOp != null ? callIns.lhsOp.variableDcl : null);
    }

    private void genJCallTerm(JavaMethodCall callIns, BType attachedType, int localVarOffset) {
        Label blockedOnExternLabel = new Label();
        Label notBlockedOnExternLabel = new Label();
        this.genHandlingBlockedOnExternal(localVarOffset, blockedOnExternLabel);
        if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
            JvmCastGen.addUnboxInsn(this.mv, callIns.lhsOp.variableDcl.type);
            this.storeToVar(callIns.lhsOp.variableDcl);
        }
        this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
        this.mv.visitLabel(blockedOnExternLabel);
        int argIndex = 0;
        if (attachedType == null) {
            this.mv.visitVarInsn(25, localVarOffset);
        } else {
            this.mv.visitVarInsn(25, localVarOffset);
            BIRNode.BIRVariableDcl selfArg = callIns.args.get((int)0).variableDcl;
            this.loadVar(selfArg);
            this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BObject");
            ++argIndex;
        }
        int argsCount = callIns.args.size();
        while (argIndex < argsCount) {
            BIROperand arg = callIns.args.get(argIndex);
            this.visitArg(arg);
            ++argIndex;
        }
        String jClassName = callIns.jClassName;
        this.mv.visitMethodInsn(184, jClassName, callIns.name, callIns.jMethodVMSig, false);
        if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
            this.storeToVar(callIns.lhsOp.variableDcl);
        }
        this.mv.visitLabel(notBlockedOnExternLabel);
    }

    private void genJICallTerm(JIMethodCall callIns, int localVarOffset) {
        BIROperand arg;
        int argsCount;
        String jMethodVMSig;
        boolean hasBalEnvParam;
        Label blockedOnExternLabel = new Label();
        Label notBlockedOnExternLabel = new Label();
        this.genHandlingBlockedOnExternal(localVarOffset, blockedOnExternLabel);
        if (callIns.lhsOp != null) {
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
            BIROperand lhsOpVarDcl = callIns.lhsOp;
            JvmInstructionGen.addJUnboxInsn(this.mv, (JType)lhsOpVarDcl.variableDcl.type);
            this.storeToVar(lhsOpVarDcl.variableDcl);
        }
        this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
        this.mv.visitLabel(blockedOnExternLabel);
        boolean isInterface = callIns.invocationType == 185;
        int argIndex = 0;
        if (callIns.invocationType == 182 || isInterface) {
            BIRNode.BIRVariableDcl selfArg = callIns.args.get((int)0).variableDcl;
            this.loadVar(selfArg);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", String.format("()L%s;", "java/lang/Object"), false);
            this.mv.visitTypeInsn(192, callIns.jClassName);
            Label ifNonNullLabel = this.labelGen.getLabel("receiver_null_check");
            this.mv.visitLabel(ifNonNullLabel);
            this.mv.visitInsn(89);
            Label elseBlockLabel = this.labelGen.getLabel("receiver_null_check_else");
            this.mv.visitJumpInsn(199, elseBlockLabel);
            Label thenBlockLabel = this.labelGen.getLabel("receiver_null_check_then");
            this.mv.visitLabel(thenBlockLabel);
            this.mv.visitFieldInsn(178, "io/ballerina/runtime/internal/util/exceptions/BallerinaErrorReasons", "JAVA_NULL_REFERENCE_ERROR", String.format("L%s;", "java/lang/String"));
            this.mv.visitFieldInsn(178, "io/ballerina/runtime/internal/util/exceptions/RuntimeErrors", "JAVA_NULL_REFERENCE", String.format("L%s;", "io/ballerina/runtime/internal/util/exceptions/RuntimeErrors"));
            this.mv.visitInsn(3);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/util/exceptions/BLangExceptionHelper", "getRuntimeException", String.format("(L%s;L%s;[L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/util/exceptions/RuntimeErrors", "java/lang/Object", "io/ballerina/runtime/internal/values/ErrorValue"), false);
            this.mv.visitInsn(191);
            this.mv.visitLabel(elseBlockLabel);
            ++argIndex;
        }
        if (hasBalEnvParam = (jMethodVMSig = callIns.jMethodVMSig).startsWith(String.format("(L%s;", "io/ballerina/runtime/api/Environment"))) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/api/Environment");
            this.mv.visitInsn(89);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(178, this.moduleInitClass, "$moduleName", String.format("L%s;", "io/ballerina/runtime/api/Module"));
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/api/Environment", "<init>", String.format("(L%s;L%s;)V", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/Module"), false);
        }
        int n = argsCount = callIns.varArgExist ? callIns.args.size() - 1 : callIns.args.size();
        while (argIndex < argsCount) {
            arg = callIns.args.get(argIndex);
            this.visitArg(arg);
            ++argIndex;
        }
        if (callIns.varArgExist) {
            arg = callIns.args.get(argIndex);
            int localVarIndex = this.indexMap.addIfNotExists(arg.variableDcl.name.value, arg.variableDcl.type);
            InteropMethodGen.genVarArg(this.mv, this.indexMap, arg.variableDcl.type, callIns.varArgType, localVarIndex, this.symbolTable);
        }
        String jClassName = callIns.jClassName;
        String jMethodName = callIns.name;
        this.mv.visitMethodInsn(callIns.invocationType, jClassName, jMethodName, jMethodVMSig, isInterface);
        boolean isVoidMethod = jMethodVMSig.endsWith(")V");
        if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
            if (hasBalEnvParam && isVoidMethod) {
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
                Label doNotStoreReturn = new Label();
                this.mv.visitJumpInsn(198, doNotStoreReturn);
                this.mv.visitVarInsn(25, localVarOffset);
                this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
                BIROperand lhsOpVarDcl = callIns.lhsOp;
                JvmInstructionGen.addJUnboxInsn(this.mv, (JType)lhsOpVarDcl.variableDcl.type);
                this.storeToVar(lhsOpVarDcl.variableDcl);
                this.mv.visitLabel(doNotStoreReturn);
            } else {
                this.storeToVar(callIns.lhsOp.variableDcl);
            }
        }
        this.mv.visitLabel(notBlockedOnExternLabel);
    }

    private void genJIConstructorTerm(JIConstructorCall callIns, int localVarOffset) {
        Label blockedOnExternLabel = new Label();
        Label notBlockedOnExternLabel = new Label();
        this.genHandlingBlockedOnExternal(localVarOffset, blockedOnExternLabel);
        if (callIns.lhsOp.variableDcl != null) {
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", String.format("L%s;", "java/lang/Object"));
            JvmCastGen.addUnboxInsn(this.mv, callIns.lhsOp.variableDcl.type);
            BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
            this.storeToVar(lhsOpVarDcl);
        }
        this.mv.visitJumpInsn(167, notBlockedOnExternLabel);
        this.mv.visitLabel(blockedOnExternLabel);
        this.mv.visitTypeInsn(187, callIns.jClassName);
        this.mv.visitInsn(89);
        int argsCount = callIns.args.size();
        for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
            BIROperand arg = callIns.args.get(argIndex);
            this.visitArg(arg);
        }
        String jClassName = callIns.jClassName;
        String jMethodName = callIns.name;
        String jMethodVMSig = callIns.jMethodVMSig;
        this.mv.visitMethodInsn(183, jClassName, jMethodName, jMethodVMSig, false);
        BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
        if (lhsOpVarDcl != null) {
            this.storeToVar(lhsOpVarDcl);
        }
        this.mv.visitLabel(notBlockedOnExternLabel);
    }

    private void genHandlingBlockedOnExternal(int localVarOffset, Label blockedOnExternLabel) {
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
        this.mv.visitJumpInsn(153, blockedOnExternLabel);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitInsn(3);
        this.mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "blockedOnExtern", "Z");
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        Label panicLabel = new Label();
        this.mv.visitJumpInsn(198, panicLabel);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitInsn(1);
        this.mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        this.mv.visitInsn(191);
        this.mv.visitLabel(panicLabel);
    }

    private void storeReturnFromCallIns(BIRNode.BIRVariableDcl lhsOpVarDcl) {
        if (lhsOpVarDcl != null) {
            this.storeToVar(lhsOpVarDcl);
        } else {
            this.mv.visitInsn(87);
        }
    }

    private void genCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        if (!callIns.isVirtual) {
            this.genFuncCall(callIns, packageID, localVarOffset);
            return;
        }
        BIRNode.BIRVariableDcl selfArg = callIns.args.get((int)0).variableDcl;
        if (selfArg.type.tag == 33) {
            this.genVirtualCall(callIns, JvmCodeGenUtil.isBallerinaBuiltinModule(packageID.orgName.getValue(), packageID.name.getValue()), localVarOffset);
        } else {
            this.genBuiltinTypeAttachedFuncCall(callIns, packageID, localVarOffset);
        }
    }

    private void genFuncCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        String methodName = callIns.name.value;
        this.genStaticCall(callIns, packageID, localVarOffset, methodName, methodName);
    }

    private void genBuiltinTypeAttachedFuncCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        String methodLookupName = callIns.name.value;
        int optionalIndex = methodLookupName.indexOf(".");
        int index = optionalIndex != -1 ? optionalIndex + 1 : 0;
        String methodName = methodLookupName.substring(index);
        this.genStaticCall(callIns, packageID, localVarOffset, methodName, methodLookupName);
    }

    private void genStaticCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset, String methodName, String methodLookupName) {
        String methodDesc;
        String jvmClass;
        this.mv.visitVarInsn(25, localVarOffset);
        String encodedMethodName = IdentifierUtils.encodeFunctionIdentifier(methodLookupName);
        String lookupKey = JvmCodeGenUtil.getPackageName(packageID) + encodedMethodName;
        int argsCount = callIns.args.size();
        for (int i = 0; i < argsCount; ++i) {
            BIROperand arg = callIns.args.get(i);
            boolean userProvidedArg = this.visitArg(arg);
            this.loadBooleanArgToIndicateUserProvidedArg(JvmCodeGenUtil.isBallerinaBuiltinModule(packageID.orgName.getValue(), packageID.name.getValue()), userProvidedArg);
        }
        BIRFunctionWrapper functionWrapper = this.jvmPackageGen.lookupBIRFunctionWrapper(lookupKey);
        if (functionWrapper != null) {
            jvmClass = functionWrapper.fullQualifiedClassName;
            methodDesc = functionWrapper.jvmMethodDescription;
        } else {
            BPackageSymbol symbol = this.packageCache.getSymbol(packageID.orgName.getValue() + "/" + packageID.name.getValue());
            Name decodedMethodName = new Name(IdentifierUtils.decodeIdentifier(methodName));
            BInvokableSymbol funcSymbol = (BInvokableSymbol)symbol.scope.lookup((Name)decodedMethodName).symbol;
            BInvokableType type = (BInvokableType)funcSymbol.type;
            ArrayList<BType> params = new ArrayList<BType>(type.paramTypes);
            if (type.restType != null) {
                params.add(type.restType);
            }
            for (int j = params.size() - 1; j >= 0; --j) {
                params.add(j + 1, this.symbolTable.booleanType);
            }
            String balFileName = funcSymbol.source;
            if (balFileName == null || !balFileName.endsWith(".bal")) {
                balFileName = "$_init";
            }
            jvmClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, JvmCodeGenUtil.cleanupPathSeparators(balFileName));
            BType retType = this.typeBuilder.build(type.retType);
            methodDesc = JvmCodeGenUtil.getMethodDesc(params, retType);
        }
        this.mv.visitMethodInsn(184, jvmClass, encodedMethodName, methodDesc, false);
    }

    private void genVirtualCall(BIRTerminator.Call callIns, boolean isBuiltInModule, int localVarOffset) {
        BIRNode.BIRVariableDcl selfArg = callIns.args.get((int)0).variableDcl;
        this.loadVar(selfArg);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BObject");
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitLdcInsn(JvmCodeGenUtil.rewriteVirtualCallTypeName(callIns.name.value));
        int argsCount = callIns.args.size() - 1;
        this.mv.visitLdcInsn(argsCount * 2);
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int j = 0;
        for (int i = 0; i < argsCount; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(j);
            this.mv.visitInsn(136);
            ++j;
            BIROperand arg = callIns.args.get(i + 1);
            boolean userProvidedArg = this.visitArg(arg);
            JvmCastGen.addBoxInsn(this.mv, arg.variableDcl.type);
            this.mv.visitInsn(83);
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(j);
            this.mv.visitInsn(136);
            ++j;
            this.loadBooleanArgToIndicateUserProvidedArg(isBuiltInModule, userProvidedArg);
            JvmCastGen.addBoxInsn(this.mv, this.symbolTable.booleanType);
            this.mv.visitInsn(83);
        }
        String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "call", methodDesc, true);
        BType returnType = callIns.lhsOp.variableDcl.type;
        JvmCastGen.addUnboxInsn(this.mv, returnType);
    }

    private void loadBooleanArgToIndicateUserProvidedArg(boolean isBuiltInModule, boolean userProvided) {
        if (isBuiltInModule) {
            return;
        }
        if (userProvided) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
    }

    private boolean visitArg(BIROperand arg) {
        BIRNode.BIRVariableDcl varDcl = arg.variableDcl;
        if (varDcl.name.value.startsWith("_")) {
            this.loadDefaultValue(this.mv, varDcl.type);
            return false;
        }
        this.loadVar(varDcl);
        return true;
    }

    private void genAsyncCallTerm(BIRTerminator.AsyncCall callIns, int localVarOffset, String moduleClassName, BType attachedType, String parentFunction, AsyncDataCollector asyncDataCollector) {
        PackageID calleePkgId = callIns.calleePkg;
        String orgName = calleePkgId.orgName.value;
        String moduleName = calleePkgId.name.value;
        String lockStore = "Lio/ballerina/runtime/internal/BLockStore;";
        String initClassName = this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$LOCK_STORE");
        this.mv.visitFieldInsn(178, initClassName, "$LOCK_STORE", lockStore);
        this.mv.visitLdcInsn("lock");
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLockStore", "panicIfInLock", String.format("(L%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "scheduler", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Scheduler"));
        int argsCount = callIns.args.size();
        this.mv.visitLdcInsn(argsCount * 2 + 1);
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int paramIndex = 1;
        for (BIROperand arg : callIns.args) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(paramIndex);
            this.mv.visitInsn(136);
            boolean userProvidedArg = this.visitArg(arg);
            JvmCastGen.addBoxInsn(this.mv, arg.variableDcl.type);
            this.mv.visitInsn(83);
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(++paramIndex);
            this.mv.visitInsn(136);
            this.loadBooleanArgToIndicateUserProvidedArg(JvmCodeGenUtil.isBallerinaBuiltinModule(orgName, moduleName), userProvidedArg);
            JvmCastGen.addBoxInsn(this.mv, this.symbolTable.booleanType);
            this.mv.visitInsn(83);
            ++paramIndex;
        }
        String funcName = IdentifierUtils.encodeFunctionIdentifier(callIns.name.value);
        String lambdaName = "$" + funcName + "$lambda$_" + asyncDataCollector.getLambdaIndex() + "$";
        JvmCodeGenUtil.createFunctionPointer(this.mv, asyncDataCollector.getEnclosingClass(), lambdaName);
        asyncDataCollector.add(lambdaName, callIns);
        asyncDataCollector.incrementLambdaIndex();
        boolean concurrent = false;
        String strandName = null;
        if (callIns.annotAttachments.size() > 0) {
            for (BIRNode.BIRAnnotationAttachment annotationAttachment : callIns.annotAttachments) {
                BIRNode.BIRAnnotationValue mapVal;
                BIRNode.BIRAnnotationValue strandAnnot;
                if (annotationAttachment == null || !"strand".equals(annotationAttachment.annotTagRef.value) || !JvmCodeGenUtil.isBuiltInPackage(annotationAttachment.packageID)) continue;
                if (annotationAttachment.annotValues.size() == 0 || !((strandAnnot = annotationAttachment.annotValues.get(0)) instanceof BIRNode.BIRAnnotationRecordValue)) break;
                BIRNode.BIRAnnotationRecordValue recordValue = (BIRNode.BIRAnnotationRecordValue)strandAnnot;
                if (recordValue.annotValueEntryMap.containsKey("thread") && (mapVal = recordValue.annotValueEntryMap.get("thread")) instanceof BIRNode.BIRAnnotationLiteralValue && "any".equals(((BIRNode.BIRAnnotationLiteralValue)mapVal).value)) {
                    concurrent = true;
                }
                if (recordValue.annotValueEntryMap.containsKey("name")) {
                    strandName = ((BIRNode.BIRAnnotationLiteralValue)recordValue.annotValueEntryMap.get((Object)"name")).value.toString();
                }
                if (!recordValue.annotValueEntryMap.containsKey("policy") || !((mapVal = recordValue.annotValueEntryMap.get("policy")) instanceof BIRNode.BIRAnnotationLiteralValue) || "DEFAULT".equals(((BIRNode.BIRAnnotationLiteralValue)mapVal).value)) break;
                throw new BLangCompilerException("Unsupported policy. Only 'DEFAULT' policy is supported by jBallerina runtime.");
            }
        }
        this.mv.visitVarInsn(25, localVarOffset);
        this.loadFpReturnType(callIns.lhsOp);
        String workerName = strandName;
        if (workerName == null) {
            if (callIns.lhsOp.variableDcl.metaVarName != null) {
                this.mv.visitLdcInsn(callIns.lhsOp.variableDcl.metaVarName);
            } else {
                this.mv.visitInsn(1);
            }
        } else {
            this.mv.visitLdcInsn(workerName);
        }
        this.submitToScheduler(callIns.lhsOp, moduleClassName, attachedType, parentFunction, asyncDataCollector, concurrent);
    }

    private void generateWaitIns(BIRTerminator.Wait waitInst, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitTypeInsn(187, "java/util/ArrayList");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        for (int i = 0; i < waitInst.exprList.size(); ++i) {
            this.mv.visitInsn(89);
            BIROperand futureVal = waitInst.exprList.get(i);
            if (futureVal != null) {
                this.loadVar(futureVal.variableDcl);
            }
            this.mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            this.mv.visitInsn(87);
        }
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "handleWaitAny", String.format("(L%s;)L%s$WaitResult;", "java/util/List", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(this.symbolTable.anyType, new Name("waitResult"), VarScope.FUNCTION, VarKind.ARG);
        int resultIndex = this.getJVMIndexOfVarRef(tempVar);
        this.mv.visitVarInsn(58, resultIndex);
        Label afterIf = new Label();
        this.mv.visitVarInsn(25, resultIndex);
        this.mv.visitFieldInsn(180, String.format("%s$WaitResult", "io/ballerina/runtime/internal/scheduling/Strand"), "done", "Z");
        this.mv.visitJumpInsn(153, afterIf);
        Label withinIf = new Label();
        this.mv.visitLabel(withinIf);
        this.mv.visitVarInsn(25, resultIndex);
        this.mv.visitFieldInsn(180, String.format("%s$WaitResult", "io/ballerina/runtime/internal/scheduling/Strand"), "result", String.format("L%s;", "java/lang/Object"));
        JvmCastGen.addUnboxInsn(this.mv, waitInst.lhsOp.variableDcl.type);
        this.storeToVar(waitInst.lhsOp.variableDcl);
        this.mv.visitLabel(afterIf);
    }

    private void genWaitAllIns(BIRTerminator.WaitAll waitAll, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitTypeInsn(187, "java/util/HashMap");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        for (int i = 0; i < waitAll.keys.size(); ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(waitAll.keys.get(i));
            BIROperand futureRef = waitAll.valueExprs.get(i);
            if (futureRef != null) {
                this.loadVar(futureRef.variableDcl);
            }
            this.mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
            this.mv.visitInsn(87);
        }
        this.loadVar(waitAll.lhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "handleWaitMultiple", String.format("(L%s;L%s;)V", "java/util/Map", "io/ballerina/runtime/internal/values/MapValue"), false);
    }

    private void genFPCallIns(BIRTerminator.FPCall fpCall, String moduleClassName, BType attachedType, String funcName, AsyncDataCollector asyncDataCollector, int localVarOffset) {
        if (fpCall.isAsync) {
            String lockStore = "Lio/ballerina/runtime/internal/BLockStore;";
            String initClassName = this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$LOCK_STORE");
            this.mv.visitFieldInsn(178, initClassName, "$LOCK_STORE", lockStore);
            this.mv.visitLdcInsn("lock");
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/BLockStore", "panicIfInLock", String.format("(L%s;L%s;)V", "java/lang/String", "io/ballerina/runtime/internal/scheduling/Strand"), false);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "scheduler", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Scheduler"));
        } else {
            this.loadVar(fpCall.fp.variableDcl);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/FPValue", "getFunction", String.format("()L%s;", "java/util/function/Function"), false);
        }
        this.mv.visitIntInsn(16, fpCall.args.size() * 2 + 1);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, 0);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitInsn(83);
        int paramIndex = 1;
        for (BIROperand arg : fpCall.args) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, paramIndex);
            this.loadVar(arg.variableDcl);
            BType bType = arg.variableDcl.type;
            JvmCastGen.addBoxInsn(this.mv, bType);
            this.mv.visitInsn(83);
            this.loadTrueValueAsArg(++paramIndex);
            ++paramIndex;
        }
        if (fpCall.isAsync) {
            String workerName = fpCall.lhsOp.variableDcl.metaVarName;
            this.loadVar(fpCall.fp.variableDcl);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/AnnotationUtils", "isConcurrent", String.format("(L%s;)Z", "io/ballerina/runtime/internal/values/FPValue"), false);
            Label notConcurrent = new Label();
            this.mv.visitJumpInsn(153, notConcurrent);
            Label concurrent = new Label();
            this.mv.visitLabel(concurrent);
            this.loadVar(fpCall.fp.variableDcl);
            this.mv.visitVarInsn(25, localVarOffset);
            this.loadFpReturnType(fpCall.lhsOp);
            this.loadVar(fpCall.fp.variableDcl);
            if (workerName == null) {
                this.mv.visitInsn(1);
            } else {
                this.mv.visitLdcInsn(workerName);
            }
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/AnnotationUtils", "getStrandName", String.format("(L%s;L%s;)L%s;", "io/ballerina/runtime/internal/values/FPValue", "java/lang/String", "java/lang/String"), false);
            this.submitToScheduler(fpCall.lhsOp, moduleClassName, attachedType, funcName, asyncDataCollector, true);
            Label afterSubmit = new Label();
            this.mv.visitJumpInsn(167, afterSubmit);
            this.mv.visitLabel(notConcurrent);
            this.loadVar(fpCall.fp.variableDcl);
            this.mv.visitVarInsn(25, localVarOffset);
            this.loadFpReturnType(fpCall.lhsOp);
            this.loadVar(fpCall.fp.variableDcl);
            if (workerName == null) {
                this.mv.visitInsn(1);
            } else {
                this.mv.visitLdcInsn(workerName);
            }
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/AnnotationUtils", "getStrandName", String.format("(L%s;L%s;)L%s;", "io/ballerina/runtime/internal/values/FPValue", "java/lang/String", "java/lang/String"), false);
            this.submitToScheduler(fpCall.lhsOp, moduleClassName, attachedType, funcName, asyncDataCollector, false);
            this.mv.visitLabel(afterSubmit);
        } else {
            BIRNode.BIRVariableDcl lhsVar;
            this.mv.visitMethodInsn(185, "java/util/function/Function", "apply", String.format("(L%s;)L%s;", "java/lang/Object", "java/lang/Object"), true);
            BType lhsType = fpCall.lhsOp.variableDcl.type;
            if (lhsType != null) {
                JvmCastGen.addUnboxInsn(this.mv, lhsType);
            }
            if ((lhsVar = fpCall.lhsOp.variableDcl) != null) {
                this.storeToVar(lhsVar);
            } else {
                this.mv.visitInsn(87);
            }
        }
    }

    private void loadTrueValueAsArg(int paramIndex) {
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, paramIndex);
        this.mv.visitInsn(4);
        JvmCastGen.addBoxInsn(this.mv, this.symbolTable.booleanType);
        this.mv.visitInsn(83);
    }

    private void genWorkerSendIns(BIRTerminator.WorkerSend ins, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset);
        if (!ins.isSameStrand) {
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "parent", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Strand"));
        }
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "wdChannels", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/WDChannels"));
        this.mv.visitLdcInsn(ins.channel.value);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/WDChannels", "getWorkerDataChannel", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/scheduling/WorkerDataChannel"), false);
        this.loadVar(ins.data.variableDcl);
        JvmCastGen.addBoxInsn(this.mv, ins.data.variableDcl.type);
        this.mv.visitVarInsn(25, localVarOffset);
        if (!ins.isSync) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/WorkerDataChannel", "sendData", String.format("(L%s;L%s;)V", "java/lang/Object", "io/ballerina/runtime/internal/scheduling/Strand"), false);
        } else {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/WorkerDataChannel", "syncSendData", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/Object"), false);
            BIROperand lhsOp = ins.lhsOp;
            if (lhsOp != null) {
                this.storeToVar(lhsOp.variableDcl);
            }
        }
    }

    private void genWorkerReceiveIns(BIRTerminator.WorkerReceive ins, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset);
        if (!ins.isSameStrand) {
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "parent", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Strand"));
        }
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "wdChannels", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/WDChannels"));
        this.mv.visitLdcInsn(ins.workerName.value);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/WDChannels", "getWorkerDataChannel", String.format("(L%s;)L%s;", "java/lang/String", "io/ballerina/runtime/internal/scheduling/WorkerDataChannel"), false);
        this.mv.visitVarInsn(25, localVarOffset);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/WorkerDataChannel", "tryTakeData", String.format("(L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/Object"), false);
        BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(this.symbolTable.anyType, new Name("wrkMsg"), VarScope.FUNCTION, VarKind.ARG);
        int wrkResultIndex = this.getJVMIndexOfVarRef(tempVar);
        this.mv.visitVarInsn(58, wrkResultIndex);
        Label jumpAfterReceive = new Label();
        this.mv.visitVarInsn(25, wrkResultIndex);
        this.mv.visitJumpInsn(198, jumpAfterReceive);
        Label withinReceiveSuccess = new Label();
        this.mv.visitLabel(withinReceiveSuccess);
        this.mv.visitVarInsn(25, wrkResultIndex);
        JvmCastGen.addUnboxInsn(this.mv, ins.lhsOp.variableDcl.type);
        this.storeToVar(ins.lhsOp.variableDcl);
        this.mv.visitLabel(jumpAfterReceive);
    }

    private void genFlushIns(BIRTerminator.Flush ins, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset);
        JvmCodeGenUtil.loadChannelDetails(this.mv, Arrays.asList(ins.channels));
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "handleFlush", String.format("([L%s;)L%s;", "io/ballerina/runtime/internal/values/ChannelDetails", "io/ballerina/runtime/internal/values/ErrorValue"), false);
        this.storeToVar(ins.lhsOp.variableDcl);
    }

    private void submitToScheduler(BIROperand lhsOp, String moduleClassName, BType attachedType, String parentFunction, AsyncDataCollector asyncDataCollector, boolean concurrent) {
        ScheduleFunctionInfo strandMetaData;
        String metaDataVarName;
        if (attachedType != null) {
            metaDataVarName = JvmTerminatorGen.getStrandMetadataVarName(attachedType.tsymbol.name.value, parentFunction);
            strandMetaData = new ScheduleFunctionInfo(attachedType.tsymbol.name.value, parentFunction);
        } else {
            metaDataVarName = JvmCodeGenUtil.getStrandMetadataVarName(parentFunction);
            strandMetaData = new ScheduleFunctionInfo(parentFunction);
        }
        asyncDataCollector.getStrandMetadata().putIfAbsent(metaDataVarName, strandMetaData);
        this.mv.visitFieldInsn(178, moduleClassName, metaDataVarName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"));
        if (concurrent) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BFunctionPointer", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/types/Type", "java/lang/String", "io/ballerina/runtime/api/async/StrandMetadata", "io/ballerina/runtime/internal/values/FutureValue"), false);
        } else {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "scheduleLocal", String.format("([L%s;L%s;L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BFunctionPointer", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/types/Type", "java/lang/String", "io/ballerina/runtime/api/async/StrandMetadata", "io/ballerina/runtime/internal/values/FutureValue"), false);
        }
        if (lhsOp.variableDcl != null) {
            BIRNode.BIRVariableDcl lhsOpVarDcl = lhsOp.variableDcl;
            this.storeToVar(lhsOpVarDcl);
        }
    }

    static String getStrandMetadataVarName(String typeName, String parentFunction) {
        return "$strand_metadata$" + typeName + "$" + parentFunction + "$";
    }

    private void loadFpReturnType(BIROperand lhsOp) {
        BType futureType = lhsOp.variableDcl.type;
        BType returnType = this.symbolTable.anyType;
        if (futureType.tag == 31) {
            returnType = ((BFutureType)futureType).constraint;
        }
        JvmTypeGen.loadType(this.mv, returnType);
    }

    private int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
        return this.indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
    }

    private void loadVar(BIRNode.BIRVariableDcl varDcl) {
        this.jvmInstructionGen.generateVarLoad(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    private void storeToVar(BIRNode.BIRVariableDcl varDcl) {
        this.jvmInstructionGen.generateVarStore(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    public void genReturnTerm(int returnVarRefIndex, BIRNode.BIRFunction func) {
        BType bType = this.typeBuilder.build(func.type.retType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitVarInsn(22, returnVarRefIndex);
            this.mv.visitInsn(173);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag)) {
            this.mv.visitVarInsn(25, returnVarRefIndex);
            this.mv.visitInsn(176);
            return;
        }
        switch (bType.tag) {
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 49: {
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
                break;
            }
            case 2: 
            case 6: {
                this.mv.visitVarInsn(21, returnVarRefIndex);
                this.mv.visitInsn(172);
                break;
            }
            case 3: {
                this.mv.visitVarInsn(24, returnVarRefIndex);
                this.mv.visitInsn(175);
                break;
            }
            case 20: {
                this.handleErrorRetInUnion(returnVarRefIndex, Arrays.asList(func.workerChannels), (BUnionType)bType);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
                break;
            }
            case 28: {
                this.notifyChannels(Arrays.asList(func.workerChannels), returnVarRefIndex);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", func.type.retType));
            }
        }
    }

    public LabelGenerator getLabelGenerator() {
        return this.labelGen;
    }
}

