/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.internal;

import java.util.HashMap;
import java.util.Map;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class BIRVarToJVMIndexMap {
    private int localVarIndex;
    private final Map<String, Integer> jvmLocalVarIndexMap = new HashMap<String, Integer>();

    public BIRVarToJVMIndexMap() {
        this(0);
    }

    public BIRVarToJVMIndexMap(int localVarIndex) {
        this.localVarIndex = localVarIndex;
    }

    private void add(String varRefName, BType bType) {
        this.jvmLocalVarIndexMap.put(varRefName, this.localVarIndex);
        if (TypeTags.isIntegerTypeTag(bType.tag) || bType.tag == 3) {
            this.localVarIndex += 2;
        } else if (bType.tag == Integer.MAX_VALUE) {
            JType jType = (JType)bType;
            this.localVarIndex = jType.jTag == 5 || jType.jTag == 7 ? (this.localVarIndex += 2) : ++this.localVarIndex;
        } else {
            ++this.localVarIndex;
        }
    }

    public int addIfNotExists(String varRefName, BType bType) {
        if (!this.jvmLocalVarIndexMap.containsKey(varRefName)) {
            this.add(varRefName, bType);
        }
        return this.get(varRefName);
    }

    public int get(String varRefName) {
        Integer index = this.jvmLocalVarIndexMap.get(varRefName);
        return index != null ? index : -1;
    }
}

