/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.AnnotationProc;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JavaMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.OldStyleExternalFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class ExternalMethodGen {
    public static void genJMethodForBExternalFunc(BIRNode.BIRFunction birFunc, ClassWriter cw, BIRNode.BIRPackage birModule, BType attachedType, MethodGen methodGen, JvmPackageGen jvmPackageGen, String moduleClassName, AsyncDataCollector lambdaGenMetadata) {
        ExternalFunctionWrapper extFuncWrapper = ExternalMethodGen.getExternalFunctionWrapper(birModule.packageID, birFunc, attachedType, jvmPackageGen);
        if (extFuncWrapper instanceof JFieldFunctionWrapper) {
            InteropMethodGen.genJFieldForInteropField((JFieldFunctionWrapper)extFuncWrapper, cw, birModule.packageID, jvmPackageGen, moduleClassName, lambdaGenMetadata);
        } else {
            methodGen.genJMethodForBFunc(birFunc, cw, birModule, moduleClassName, attachedType, lambdaGenMetadata);
        }
    }

    public static void injectDefaultParamInits(BIRNode.BIRPackage module, InitMethodGen initMethodGen, JvmPackageGen jvmPackageGen) {
        List<BIRNode.BIRFunction> functions = module.functions;
        if (!functions.isEmpty()) {
            int funcSize = functions.size();
            for (int count = 3; count < funcSize; ++count) {
                BIRNode.BIRFunction birFunc = functions.get(count);
                BIRFunctionWrapper extFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(module.packageID, birFunc, null, jvmPackageGen);
                if (extFuncWrapper instanceof OldStyleExternalFunctionWrapper) {
                    ExternalMethodGen.desugarOldExternFuncs((OldStyleExternalFunctionWrapper)extFuncWrapper, birFunc, initMethodGen);
                    JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc, initMethodGen);
                    continue;
                }
                if (!(extFuncWrapper instanceof JMethodFunctionWrapper)) continue;
                InteropMethodGen.desugarInteropFuncs((JMethodFunctionWrapper)extFuncWrapper, birFunc, initMethodGen);
                JvmDesugarPhase.enrichWithDefaultableParamInits(birFunc, initMethodGen);
            }
        }
    }

    public static void desugarOldExternFuncs(OldStyleExternalFunctionWrapper extFuncWrapper, BIRNode.BIRFunction birFunc, InitMethodGen initMethodGen) {
        BType retType = birFunc.type.retType;
        BIROperand retRef = null;
        if (retType.tag != 10) {
            BIRNode.BIRVariableDcl localVar = birFunc.localVars.get(0);
            BIRNode.BIRVariableDcl variableDcl = new BIRNode.BIRVariableDcl(retType, localVar.name, localVar.scope, localVar.kind);
            retRef = new BIROperand(variableDcl);
        }
        initMethodGen.resetIds();
        BIRNode.BIRBasicBlock beginBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, "wrapperGen", initMethodGen);
        BIRNode.BIRBasicBlock retBB = JvmDesugarPhase.insertAndGetNextBasicBlock(birFunc.basicBlocks, "wrapperGen", initMethodGen);
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        BIRNode.BIRVariableDcl receiver = birFunc.receiver;
        if (receiver != null) {
            BIROperand argRef = new BIROperand(receiver);
            args.add(argRef);
        }
        Set<BIRNode.BIRFunctionParameter> birFuncParams = birFunc.parameters.keySet();
        for (BIRNode.BIRFunctionParameter birFuncParam : birFuncParams) {
            BIROperand argRef = new BIROperand(birFuncParam);
            args.add(argRef);
        }
        String jMethodName = birFunc.name.value;
        beginBB.terminator = new JavaMethodCall(birFunc.pos, InstructionKind.PLATFORM, args, retRef, extFuncWrapper.jClassName, extFuncWrapper.jMethodVMSig, jMethodName, retBB);
        retBB.terminator = new BIRTerminator.Return(birFunc.pos);
    }

    private static ExternalFunctionWrapper getExternalFunctionWrapper(PackageID birModule, BIRNode.BIRFunction birFunc, BType attachedType, JvmPackageGen jvmPackageGen) {
        BIRFunctionWrapper birFuncWrapper = ExternalMethodGen.lookupBIRFunctionWrapper(birModule, birFunc, attachedType, jvmPackageGen);
        if (birFuncWrapper instanceof ExternalFunctionWrapper) {
            return (ExternalFunctionWrapper)((Object)birFuncWrapper);
        }
        throw new BLangCompilerException("cannot find function definition for : " + birFunc.name.value);
    }

    public static BIRFunctionWrapper lookupBIRFunctionWrapper(PackageID birModule, BIRNode.BIRFunction birFunc, BType attachedType, JvmPackageGen jvmPackageGen) {
        String lookupKey;
        String currentPackageName = JvmCodeGenUtil.getPackageName(birModule);
        String birFuncName = birFunc.name.value;
        if (attachedType == null) {
            lookupKey = currentPackageName + birFuncName;
        } else if (attachedType.tag == 33) {
            lookupKey = currentPackageName + JvmCodeGenUtil.toNameString(attachedType) + "." + birFuncName;
        } else {
            throw new BLangCompilerException(String.format("Java method generation for the receiver type %s is not supported: ", attachedType));
        }
        BIRFunctionWrapper birFuncWrapper = jvmPackageGen.lookupBIRFunctionWrapper(lookupKey);
        if (birFuncWrapper != null) {
            return birFuncWrapper;
        }
        throw new BLangCompilerException("cannot find function definition for : " + lookupKey);
    }

    public static OldStyleExternalFunctionWrapper createOldStyleExternalFunctionWrapper(BIRNode.BIRFunction birFunc, PackageID packageID, String birModuleClassName, String jClassName, boolean isEntryModule, SymbolTable symbolTable) {
        String jMethodVMSig;
        String jvmMethodDescription;
        BIRNode.BIRVariableDcl receiver;
        ArrayList<BType> jMethodPramTypes = new ArrayList<BType>(birFunc.type.paramTypes);
        if (isEntryModule) {
            JvmDesugarPhase.addDefaultableBooleanVarsToSignature(birFunc, symbolTable.booleanType);
        }
        BInvokableType functionTypeDesc = birFunc.type;
        BType restType = functionTypeDesc.restType;
        if (restType != null) {
            jMethodPramTypes.add(restType);
        }
        if ((receiver = birFunc.receiver) == null) {
            jvmMethodDescription = JvmCodeGenUtil.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType);
            jMethodVMSig = ExternalMethodGen.getExternMethodDesc(jMethodPramTypes, functionTypeDesc.retType);
        } else {
            jvmMethodDescription = JvmCodeGenUtil.getMethodDesc(functionTypeDesc.paramTypes, functionTypeDesc.retType, receiver.type);
            jMethodVMSig = ExternalMethodGen.getExternMethodDesc(jMethodPramTypes, functionTypeDesc.retType, receiver.type);
        }
        return new OldStyleExternalFunctionWrapper(packageID, birFunc, birModuleClassName, jvmMethodDescription, jClassName, jMethodPramTypes, jMethodVMSig);
    }

    public static String getExternMethodDesc(List<BType> paramTypes, BType retType) {
        return JvmCodeGenUtil.INITIAL_METHOD_DESC + JvmCodeGenUtil.populateMethodDesc(paramTypes) + ExternalMethodGen.generateExternReturnType(retType);
    }

    public static String getExternMethodDesc(List<BType> paramTypes, BType retType, BType attachedType) {
        return JvmCodeGenUtil.INITIAL_METHOD_DESC + JvmCodeGenUtil.getArgTypeSignature(attachedType) + JvmCodeGenUtil.populateMethodDesc(paramTypes) + ExternalMethodGen.generateExternReturnType(retType);
    }

    static String generateExternReturnType(BType bType) {
        if ((bType = JvmCodeGenUtil.TYPE_BUILDER.build(bType)) == null || bType.tag == 10 || bType.tag == 49) {
            return ")V";
        }
        return JvmCodeGenUtil.generateReturnType(bType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BIRFunctionWrapper createExternalFunctionWrapper(InteropValidator interopValidator, BIRNode.BIRFunction birFunc, PackageID packageID, String birModuleClassName, String lookupKey, JvmPackageGen jvmPackageGen) {
        InteropValidationRequest jInteropValidationReq = AnnotationProc.getInteropAnnotValue(birFunc);
        if (jInteropValidationReq != null) return InteropMethodGen.createJInteropFunctionWrapper(interopValidator, jInteropValidationReq, birFunc, packageID, birModuleClassName, jvmPackageGen.symbolTable);
        String pkgName = JvmCodeGenUtil.getPackageName(packageID);
        String jClassName = jvmPackageGen.lookupExternClassName(JvmPackageGen.cleanupPackageName(pkgName), lookupKey);
        if (jClassName == null) throw new BLangCompilerException("cannot find full qualified class name for extern function : " + pkgName + birFunc.name.value);
        if (!JvmCodeGenUtil.isBallerinaBuiltinModule(packageID.orgName.value, packageID.name.value)) return ExternalMethodGen.createOldStyleExternalFunctionWrapper(birFunc, packageID, birModuleClassName, jClassName, interopValidator.isEntryModuleValidation(), jvmPackageGen.symbolTable);
        return JvmPackageGen.getFunctionWrapper(birFunc, packageID, jClassName);
    }

    private ExternalMethodGen() {
    }
}

