/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

class JMethod {
    static final JMethod NO_SUCH_METHOD = new JMethod(null, null, null);
    public static final String BAL_ENV_CANONICAL_NAME = Environment.class.getCanonicalName();
    JMethodKind kind;
    private Executable method;
    private BType receiverType;

    private JMethod(JMethodKind kind, Executable executable, BType receiverType) {
        this.kind = kind;
        this.method = executable;
        this.receiverType = receiverType;
    }

    static JMethod build(JMethodKind kind, Executable executable, BType receiverType) {
        return new JMethod(kind, executable, receiverType);
    }

    String getClassName() {
        return this.method.getDeclaringClass().getName();
    }

    boolean isDeclaringClassInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    boolean isInstanceMethod() {
        return !this.isStatic() && !(this.method instanceof Constructor);
    }

    String getName() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return "<init>";
        }
        return this.method.getName();
    }

    JMethodKind getKind() {
        return this.kind;
    }

    Executable getMethod() {
        return this.method;
    }

    String getSignature() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return JInterop.getMethodSig(Void.TYPE, this.method.getParameterTypes());
        }
        return JInterop.getMethodSig(this.getReturnType(), this.method.getParameterTypes());
    }

    Class<?>[] getParamTypes() {
        return this.method.getParameterTypes();
    }

    Class<?> getReturnType() {
        if (this.kind == JMethodKind.CONSTRUCTOR) {
            return this.method.getDeclaringClass();
        }
        return ((Method)this.method).getReturnType();
    }

    public BType getReceiverType() {
        return this.receiverType;
    }

    public void setReceiverType(BType receiverType) {
        this.receiverType = receiverType;
    }

    /*
     * WARNING - void declaration
     */
    BArray getExceptionTypes(ClassLoader classLoader) {
        ArrayList checkedExceptions = new ArrayList();
        try {
            void var6_10;
            Class<?> runtimeException = classLoader.loadClass(RuntimeException.class.getCanonicalName());
            Class<?>[] classArray = this.method.getExceptionTypes();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class<?> exceptionType = classArray[var6_10];
                if (!runtimeException.isAssignableFrom(exceptionType)) {
                    checkedExceptions.add(exceptionType);
                }
                ++var6_10;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
        BArray arrayValue = ValueCreator.createArrayValue(TypeCreator.createArrayType(PredefinedTypes.TYPE_STRING), checkedExceptions.size());
        int i = 0;
        for (Class clazz : checkedExceptions) {
            arrayValue.add((long)i++, clazz.getName().replace(".", "/"));
        }
        return arrayValue;
    }

    Class<?>[] getExceptionTypes() {
        ArrayList checkedExceptions = new ArrayList();
        try {
            Class<?> runtimeException = ClassLoader.getSystemClassLoader().loadClass(RuntimeException.class.getCanonicalName());
            for (Class<?> exceptionType : this.method.getExceptionTypes()) {
                if (runtimeException.isAssignableFrom(exceptionType)) continue;
                checkedExceptions.add(exceptionType);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
        return checkedExceptions.toArray(new Class[0]);
    }

    public boolean isBalEnvAcceptingMethod() {
        Class<?>[] paramTypes = this.getParamTypes();
        return paramTypes.length > 0 && paramTypes[0].getCanonicalName().equals(BAL_ENV_CANONICAL_NAME);
    }
}

