/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;

class JMethodRequest {
    Class<?> declaringClass;
    String methodName;
    JMethodKind kind;
    ParamTypeConstraint[] paramTypeConstraints = new ParamTypeConstraint[0];
    int bFuncParamCount;
    BType[] bParamTypes = null;
    BType bReturnType = null;
    boolean returnsBErrorType = false;
    boolean restParamExist = false;
    BType receiverType = null;
    private static ResolvedTypeBuilder typeBuilder = new ResolvedTypeBuilder();

    private JMethodRequest() {
    }

    static JMethodRequest build(InteropValidationRequest.MethodValidationRequest methodValidationRequest, ClassLoader classLoader, boolean isEntryModuleValidation) {
        BType returnType;
        JMethodRequest jMethodReq = new JMethodRequest();
        jMethodReq.kind = methodValidationRequest.methodKind;
        jMethodReq.methodName = methodValidationRequest.name;
        jMethodReq.declaringClass = JInterop.loadClass(methodValidationRequest.klass, classLoader);
        jMethodReq.receiverType = methodValidationRequest.receiverType;
        jMethodReq.paramTypeConstraints = JInterop.buildParamTypeConstraints(methodValidationRequest.paramTypeConstraints, classLoader);
        BInvokableType bFuncType = methodValidationRequest.bFuncType;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        if (!isEntryModuleValidation) {
            for (int i = 0; i < bFuncType.paramTypes.size(); i += 2) {
                paramTypes.add(bFuncType.paramTypes.get(i));
            }
        } else {
            paramTypes.addAll(bFuncType.paramTypes);
        }
        BType restType = bFuncType.restType;
        if (restType != null) {
            paramTypes.add(restType);
        }
        jMethodReq.bFuncParamCount = paramTypes.size();
        jMethodReq.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodReq.bReturnType = returnType = typeBuilder.build(bFuncType.retType);
        if (returnType.tag == 20) {
            for (BType bType : ((BUnionType)returnType).getMemberTypes()) {
                if (bType.tag != 28) continue;
                jMethodReq.returnsBErrorType = true;
                break;
            }
        } else {
            jMethodReq.returnsBErrorType = returnType.tag == 28;
        }
        jMethodReq.restParamExist = methodValidationRequest.restParamExist;
        return jMethodReq;
    }
}

