/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.TypeTags;

class JMethodResolver {
    private ClassLoader classLoader;
    private SymbolTable symbolTable;
    private final BType[] definedReadOnlyMemberTypes;

    JMethodResolver(ClassLoader classLoader, SymbolTable symbolTable) {
        this.classLoader = classLoader;
        this.symbolTable = symbolTable;
        this.definedReadOnlyMemberTypes = new BType[]{symbolTable.nilType, symbolTable.booleanType, symbolTable.intType, symbolTable.signed8IntType, symbolTable.signed16IntType, symbolTable.signed32IntType, symbolTable.unsigned32IntType, symbolTable.unsigned16IntType, symbolTable.unsigned8IntType, symbolTable.floatType, symbolTable.decimalType, symbolTable.stringType, symbolTable.charStringType};
    }

    JMethod resolve(JMethodRequest jMethodRequest) {
        List<JMethod> jMethods = this.resolveByMethodName(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind);
        if (jMethods.isEmpty()) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor found in class '" + jMethodRequest.declaringClass + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' found in class '" + jMethodRequest.declaringClass + "'");
        }
        if ((jMethods = this.resolveByParamCount(jMethods, jMethodRequest)).isEmpty()) {
            this.throwMethodNotFoundError(jMethodRequest);
        }
        JMethod jMethod = this.resolve(jMethodRequest, jMethods);
        this.validateMethodSignature(jMethodRequest, jMethod);
        return jMethod;
    }

    private List<JMethod> resolveByMethodName(Class<?> declaringClass, String methodName, JMethodKind kind) {
        return this.getExecutables(declaringClass, methodName, kind).stream().map(executable -> JMethod.build(kind, executable, null)).collect(Collectors.toList());
    }

    private List<JMethod> resolveByParamCount(List<JMethod> jMethods, JMethodRequest jMethodRequest) {
        return jMethods.stream().filter(jMethod -> this.hasEqualParamCounts(jMethodRequest, (JMethod)jMethod)).collect(Collectors.toList());
    }

    private boolean hasEqualParamCounts(JMethodRequest jMethodRequest, JMethod jMethod) {
        int expectedCount = this.getBFuncParamCount(jMethodRequest, jMethod);
        int count = jMethod.getParamTypes().length;
        if (count == expectedCount) {
            return true;
        }
        if (count == expectedCount + 1) {
            if (jMethod.isBalEnvAcceptingMethod()) {
                return true;
            }
            jMethod.setReceiverType(jMethodRequest.receiverType);
            return jMethodRequest.receiverType != null;
        }
        if (count == expectedCount + 2) {
            if (jMethodRequest.receiverType != null) {
                jMethod.setReceiverType(jMethodRequest.receiverType);
            }
            return jMethod.isBalEnvAcceptingMethod();
        }
        return false;
    }

    private JMethod resolve(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        boolean noConstraints = this.noConstraintsSpecified(jMethodRequest.paramTypeConstraints);
        if (jMethods.size() == 1 && noConstraints) {
            return jMethods.get(0);
        }
        if (noConstraints) {
            Optional<JMethod> covariantRetTypeMethod = this.findCovariantReturnTypeMethod(jMethods);
            if (covariantRetTypeMethod.isPresent()) {
                return covariantRetTypeMethod.get();
            }
            int paramCount = jMethods.get(0).getParamTypes().length;
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded constructors with '" + paramCount + "' parameter(s) in class '" + jMethodRequest.declaringClass + "', please specify class names for each parameter in 'paramTypes' field in the annotation");
            }
            throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded methods '" + jMethodRequest.methodName + "' with '" + paramCount + "' parameter(s) in class '" + jMethodRequest.declaringClass + "', please specify class names for each parameter with 'paramTypes' field in the annotation");
        }
        JMethod jMethod = this.resolveExactMethod(jMethodRequest.declaringClass, jMethodRequest.methodName, jMethodRequest.kind, jMethodRequest.paramTypeConstraints, jMethodRequest.receiverType);
        if (jMethod == JMethod.NO_SUCH_METHOD) {
            return this.resolveMatchingMethod(jMethodRequest, jMethods);
        }
        return jMethod;
    }

    private Optional<JMethod> findCovariantReturnTypeMethod(List<JMethod> jMethods) {
        for (int i = 0; i < jMethods.size(); ++i) {
            for (int k = i + 1; k < jMethods.size(); ++k) {
                JMethod ithMethod = jMethods.get(i);
                JMethod kthMethod = jMethods.get(k);
                if (!ithMethod.getReturnType().isAssignableFrom(kthMethod.getReturnType()) && !kthMethod.getReturnType().isAssignableFrom(ithMethod.getReturnType())) continue;
                if (ithMethod.getParamTypes().length != kthMethod.getParamTypes().length) {
                    throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "Overloaded methods cannot be differentiated. Please specify the parameterTypes for each parameter in 'paramTypes' field in the annotation");
                }
                return Optional.of(ithMethod);
            }
        }
        return Optional.empty();
    }

    private void validateMethodSignature(JMethodRequest jMethodRequest, JMethod jMethod) {
        this.validateExceptionTypes(jMethodRequest, jMethod);
        this.validateArgumentTypes(jMethodRequest, jMethod);
        this.validateReturnTypes(jMethodRequest, jMethod);
    }

    private void validateExceptionTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        boolean returnsErrorValue;
        Executable method = jMethod.getMethod();
        boolean throwsCheckedException = false;
        try {
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (this.classLoader.loadClass(RuntimeException.class.getCanonicalName()).isAssignableFrom(exceptionType)) continue;
                throwsCheckedException = true;
                break;
            }
            returnsErrorValue = method instanceof Method && (this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()) || this.classLoader.loadClass(Object.class.getCanonicalName()).isAssignableFrom(((Method)method).getReturnType()));
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
        if (throwsCheckedException && !jMethodRequest.returnsBErrorType || jMethodRequest.returnsBErrorType && !throwsCheckedException && !returnsErrorValue) {
            throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "No such Java method '" + jMethodRequest.methodName + "' which throws checked exception found in class '" + jMethodRequest.declaringClass + "'");
        }
    }

    private void validateArgumentTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        Class<?>[] jParamTypes = jMethod.getParamTypes();
        BType[] bParamTypes = jMethodRequest.bParamTypes;
        int bParamCount = bParamTypes.length;
        int i = 0;
        int j = 0;
        if (jMethod.getReceiverType() != null) {
            Class<?> jParamType = jMethod.isBalEnvAcceptingMethod() ? jParamTypes[1] : jParamTypes[0];
            BType bParamType = jMethod.getReceiverType();
            if (!this.isValidParamBType(jParamTypes[0], bParamType, false, jMethodRequest.restParamExist)) {
                this.throwNoSuchMethodError(jMethodRequest.methodName, jParamType, bParamType, jMethodRequest.declaringClass);
            }
            ++bParamCount;
            ++j;
        }
        if (jMethod.isInstanceMethod()) {
            boolean isLastParam;
            if (bParamCount != jParamTypes.length + 1) {
                if (jMethod.isBalEnvAcceptingMethod()) {
                    ++j;
                } else {
                    this.throwParamCountMismatchError(jMethodRequest);
                }
            }
            BType receiverType = bParamTypes[0];
            boolean bl = isLastParam = bParamTypes.length == 1;
            if (!this.isValidParamBType(jMethodRequest.declaringClass, receiverType, isLastParam, jMethodRequest.restParamExist)) {
                if (jParamTypes.length == 0 || bParamTypes[0].tag != 36) {
                    this.throwMethodNotFoundError(jMethodRequest);
                } else {
                    this.throwNoSuchMethodError(jMethodRequest.methodName, jParamTypes[0], receiverType, jMethodRequest.declaringClass);
                }
            }
            ++i;
        } else if (bParamCount != jParamTypes.length) {
            if (jMethod.isBalEnvAcceptingMethod()) {
                ++j;
            } else {
                this.throwParamCountMismatchError(jMethodRequest);
            }
        }
        for (int k = j; k < jParamTypes.length; ++k) {
            boolean isLastPram;
            BType bParamType = bParamTypes[i];
            Class<?> jParamType = jParamTypes[k];
            boolean bl = isLastPram = jParamTypes.length == k + 1;
            if (!this.isValidParamBType(jParamType, bParamType, isLastPram, jMethodRequest.restParamExist)) {
                this.throwNoSuchMethodError(jMethodRequest.methodName, jParamType, bParamType, jMethodRequest.declaringClass);
            }
            ++i;
        }
    }

    private void validateReturnTypes(JMethodRequest jMethodRequest, JMethod jMethod) {
        BType bReturnType;
        Class<?> jReturnType = jMethod.getReturnType();
        if (!(this.isValidReturnBType(jReturnType, bReturnType = jMethodRequest.bReturnType, jMethodRequest) || jMethod.isBalEnvAcceptingMethod() && jReturnType.equals(Void.TYPE))) {
            throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Incompatible return type for method '" + jMethodRequest.methodName + "' in class '" + jMethodRequest.declaringClass.getName() + "': Java type '" + jReturnType.getName() + "' will not be matched to ballerina type '" + (bReturnType.tag == 32 ? bReturnType.tsymbol.name.value : bReturnType) + "'");
        }
    }

    private boolean isValidParamBType(Class<?> jType, BType bType, boolean isLastParam, boolean restParamExist) {
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.tag) {
                case 11: 
                case 17: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive();
                }
                case 36: {
                    return !jType.isPrimitive();
                }
                case 10: {
                    return jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 2: 
                case 3: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (TypeTags.isIntegerTypeTag(bType.tag) && jTypeName.equals(JInterop.J_LONG_OBJ_TNAME)) {
                        return true;
                    }
                    if (bType.tag == 2 && jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME)) {
                        return true;
                    }
                    if (bType.tag == 3 && jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && (jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME));
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: 
                case 44: {
                    return this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 15: {
                    return this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: {
                    return jTypeName.equals(JInterop.J_OBJECT_TNAME);
                }
                case 33: {
                    return this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 28: {
                    return this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    return this.classLoader.loadClass(BXml.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 19: 
                case 30: {
                    return this.isValidListType(jType, isLastParam, restParamExist);
                }
                case 20: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set<BType> members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (this.isValidParamBType(jType, member, isLastParam, restParamExist)) continue;
                        return false;
                    }
                    return true;
                }
                case 37: {
                    return jTypeName.equals(JInterop.J_OBJECT_TNAME);
                }
                case 21: {
                    return this.isValidParamBType(jType, ((BIntersectionType)bType).effectiveType, isLastParam, restParamExist);
                }
                case 32: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set<BLangExpression> valueSpace = ((BFiniteType)bType).getValueSpace();
                    for (BLangExpression value : valueSpace) {
                        if (this.isValidParamBType(jType, value.type, isLastParam, restParamExist)) continue;
                        return false;
                    }
                    return true;
                }
                case 16: 
                case 35: {
                    return this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 31: {
                    return this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 14: {
                    return this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    private boolean isValidReturnBType(Class<?> jType, BType bType, JMethodRequest jMethodRequest) {
        try {
            String jTypeName = jType.getTypeName();
            switch (bType.tag) {
                case 11: 
                case 17: {
                    if (jTypeName.equals(JInterop.J_STRING_TNAME)) {
                        return false;
                    }
                    return !jType.isPrimitive();
                }
                case 36: {
                    return !jType.isPrimitive();
                }
                case 10: {
                    return jTypeName.equals(JInterop.J_VOID_TNAME);
                }
                case 1: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_LONG_OBJ_TNAME);
                }
                case 2: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_INTEGER_OBJ_TNAME);
                }
                case 3: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    if (jType.isPrimitive()) {
                        return jTypeName.equals(JInterop.J_PRIMITIVE_INT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_BYTE_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_SHORT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_LONG_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_CHAR_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_FLOAT_TNAME) || jTypeName.equals(JInterop.J_PRIMITIVE_DOUBLE_TNAME);
                    }
                    return jTypeName.equals(JInterop.J_DOUBLE_OBJ_TNAME);
                }
                case 6: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME) || jTypeName.equals(JInterop.J_BOOLEAN_OBJ_TNAME)) {
                        return true;
                    }
                    return jType.isPrimitive() && jTypeName.equals(JInterop.J_PRIMITIVE_BOOLEAN_TNAME);
                }
                case 4: {
                    return this.classLoader.loadClass(BDecimal.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 5: 
                case 44: {
                    return this.classLoader.loadClass(BString.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 12: 
                case 15: {
                    return this.classLoader.loadClass(BMap.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 7: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    for (BType member : this.getJSONMemberTypes()) {
                        if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 33: {
                    return this.classLoader.loadClass(BObject.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 28: {
                    return this.classLoader.loadClass(BError.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 8: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    return this.classLoader.loadClass(BXml.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 19: 
                case 30: {
                    return this.isValidListType(jType, true, jMethodRequest.restParamExist);
                }
                case 20: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set<BType> members = ((BUnionType)bType).getMemberTypes();
                    for (BType member : members) {
                        if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 37: {
                    return this.isReadOnlyCompatibleReturnType(jType, jMethodRequest);
                }
                case 21: {
                    return this.isValidReturnBType(jType, ((BIntersectionType)bType).effectiveType, jMethodRequest);
                }
                case 32: {
                    if (jTypeName.equals(JInterop.J_OBJECT_TNAME)) {
                        return true;
                    }
                    Set<BLangExpression> valueSpace = ((BFiniteType)bType).getValueSpace();
                    for (BLangExpression value : valueSpace) {
                        if (!this.isValidReturnBType(jType, value.type, jMethodRequest)) continue;
                        return true;
                    }
                    return false;
                }
                case 16: 
                case 35: {
                    return this.classLoader.loadClass(BFunctionPointer.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 31: {
                    return this.classLoader.loadClass(BFuture.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 13: {
                    return this.classLoader.loadClass(BTypedesc.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 14: {
                    return this.classLoader.loadClass(BStream.class.getCanonicalName()).isAssignableFrom(jType);
                }
                case 9: {
                    return this.classLoader.loadClass(BTable.class.getCanonicalName()).isAssignableFrom(jType);
                }
            }
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    private boolean isValidListType(Class<?> jType, boolean isLastParam, boolean restParamExists) throws ClassNotFoundException {
        if (isLastParam && restParamExists) {
            return jType.isArray();
        }
        return this.classLoader.loadClass(BArray.class.getCanonicalName()).isAssignableFrom(jType);
    }

    private BType[] getJSONMemberTypes() {
        return new BType[]{this.symbolTable.nilType, this.symbolTable.stringType, this.symbolTable.intType, this.symbolTable.floatType, this.symbolTable.booleanType, this.symbolTable.mapJsonType, this.symbolTable.arrayJsonType};
    }

    private boolean isReadOnlyCompatibleReturnType(Class<?> jType, JMethodRequest jMethodRequest) throws ClassNotFoundException {
        if (jType.getTypeName().equals(JInterop.J_OBJECT_TNAME)) {
            return true;
        }
        for (BType member : this.definedReadOnlyMemberTypes) {
            if (!this.isValidReturnBType(jType, member, jMethodRequest)) continue;
            return true;
        }
        return this.isAssignableFrom(BError.class, jType) || this.isAssignableFrom(BFunctionPointer.class, jType) || this.isAssignableFrom(BObject.class, jType) || this.isAssignableFrom(BTypedesc.class, jType) || this.isAssignableFrom(BHandle.class, jType) || this.isAssignableFrom(BXml.class, jType) || this.isValidListType(jType, true, jMethodRequest.restParamExist) || this.isAssignableFrom(BMap.class, jType) || this.isAssignableFrom(BTable.class, jType);
    }

    private boolean isAssignableFrom(Class<?> targetType, Class<?> jType) throws ClassNotFoundException {
        return this.classLoader.loadClass(targetType.getCanonicalName()).isAssignableFrom(jType);
    }

    private JMethod resolveExactMethod(Class<?> clazz, String name, JMethodKind kind, ParamTypeConstraint[] constraints, BType receiverType) {
        Executable executable;
        Class[] paramTypes = new Class[constraints.length];
        for (int constraintIndex = 0; constraintIndex < constraints.length; ++constraintIndex) {
            paramTypes[constraintIndex] = constraints[constraintIndex].get();
        }
        Executable executable2 = executable = kind == JMethodKind.CONSTRUCTOR ? this.resolveConstructor(clazz, paramTypes) : this.resolveMethod(clazz, name, paramTypes);
        if (executable == null) {
            executable = this.tryResolveExactWithBalEnv(paramTypes, clazz, name);
        }
        if (executable != null) {
            return JMethod.build(kind, executable, receiverType);
        }
        return JMethod.NO_SUCH_METHOD;
    }

    private Executable tryResolveExactWithBalEnv(Class<?>[] paramTypes, Class<?> clazz, String name) {
        Class[] paramTypesWithBalEnv = new Class[paramTypes.length + 1];
        System.arraycopy(paramTypes, 0, paramTypesWithBalEnv, 1, paramTypes.length);
        paramTypesWithBalEnv[0] = Environment.class;
        return this.resolveMethod(clazz, name, paramTypesWithBalEnv);
    }

    private JMethod resolveMatchingMethod(JMethodRequest jMethodRequest, List<JMethod> jMethods) {
        int paramTypesInitialIndex;
        int constraintsSize;
        ParamTypeConstraint[] constraints = jMethodRequest.paramTypeConstraints;
        String paramTypesSig = this.getParamTypesAsString(constraints);
        if (jMethodRequest.receiverType != null) {
            constraintsSize = constraints.length + 1;
            paramTypesInitialIndex = 1;
        } else {
            constraintsSize = constraints.length;
            paramTypesInitialIndex = 0;
        }
        ArrayList<JMethod> resolvedJMethods = new ArrayList<JMethod>();
        if (constraints.length > 0) {
            for (JMethod jMethod : jMethods) {
                boolean resolved = true;
                Class<?>[] formalParamTypes = jMethod.getParamTypes();
                if (constraintsSize != formalParamTypes.length) continue;
                int paramIndex = paramTypesInitialIndex;
                int constraintIndex = 0;
                while (paramIndex < formalParamTypes.length) {
                    Class<?> formalParamType = formalParamTypes[paramIndex];
                    if (!formalParamType.isAssignableFrom(constraints[constraintIndex].get())) {
                        resolved = false;
                        break;
                    }
                    ++paramIndex;
                    ++constraintIndex;
                }
                if (!resolved) continue;
                resolvedJMethods.add(jMethod);
            }
        }
        if (resolvedJMethods.isEmpty()) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor that matches with parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' that matches with parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass + "'");
        }
        if (resolvedJMethods.size() > 1) {
            if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
                throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "More than one public constructors that match with the parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass + "'");
            }
            throw new JInteropException(DiagnosticErrorCode.OVERLOADED_METHODS, "More than one public methods '" + jMethodRequest.methodName + "' that match with the parameter types '" + paramTypesSig + "' found in class '" + jMethodRequest.declaringClass + "'");
        }
        return (JMethod)resolvedJMethods.get(0);
    }

    private Executable resolveConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Executable resolveMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private List<Executable> getExecutables(Class<?> clazz, String methodName, JMethodKind kind) {
        return kind == JMethodKind.CONSTRUCTOR ? Arrays.asList(clazz.getConstructors()) : Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList());
    }

    private boolean noConstraintsSpecified(ParamTypeConstraint[] constraints) {
        if (constraints == null) {
            return true;
        }
        if (constraints.length == 0) {
            return false;
        }
        for (ParamTypeConstraint constraint : constraints) {
            if (constraint == ParamTypeConstraint.NO_CONSTRAINT) continue;
            return false;
        }
        return true;
    }

    private int getBFuncParamCount(JMethodRequest jMethodRequest, JMethod jMethod) {
        int bFuncParamCount = jMethodRequest.bFuncParamCount;
        if (jMethodRequest.kind == JMethodKind.METHOD) {
            boolean isStaticMethod = jMethod.isStatic();
            bFuncParamCount = isStaticMethod ? bFuncParamCount : bFuncParamCount - 1;
        }
        return bFuncParamCount;
    }

    private String getParamTypesAsString(ParamTypeConstraint[] constraints) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        for (ParamTypeConstraint paramTypeConstraint : constraints) {
            stringJoiner.add(paramTypeConstraint.get().getName());
        }
        return stringJoiner.toString();
    }

    private void throwMethodNotFoundError(JMethodRequest jMethodRequest) throws JInteropException {
        if (jMethodRequest.kind == JMethodKind.CONSTRUCTOR) {
            throw new JInteropException(DiagnosticErrorCode.CONSTRUCTOR_NOT_FOUND, "No such public constructor with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass + "'");
        }
        if (jMethodRequest.bFuncParamCount == 0 || jMethodRequest.bParamTypes[0].tag != 36) {
            throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public static method '" + jMethodRequest.methodName + "' with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass + "'");
        }
        throw new JInteropException(DiagnosticErrorCode.METHOD_NOT_FOUND, "No such public method '" + jMethodRequest.methodName + "' with '" + jMethodRequest.bFuncParamCount + "' parameter(s) found in class '" + jMethodRequest.declaringClass + "'");
    }

    private void throwNoSuchMethodError(String methodName, Class<?> jType, BType bType, Class<?> declaringClass) throws JInteropException {
        throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Incompatible param type for method '" + methodName + "' in class '" + declaringClass.getName() + "': Java type '" + jType.getName() + "' will not be matched to ballerina type '" + (bType.tag == 32 ? bType.tsymbol.name.value : bType) + "'");
    }

    private void throwParamCountMismatchError(JMethodRequest jMethodRequest) throws JInteropException {
        throw new JInteropException(DiagnosticErrorCode.METHOD_SIGNATURE_DOES_NOT_MATCH, "Parameter count does not match with Java method '" + jMethodRequest.methodName + "' found in class '" + jMethodRequest.declaringClass.getName() + "'");
    }
}

