/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JType
extends BType {
    private static final String JBYTE_KIND = "byte";
    private static final String JCHAR_KIND = "char";
    private static final String JSHORT_KIND = "short";
    private static final String JINT_KIND = "int";
    private static final String JLONG_KIND = "long";
    private static final String JFLOAT_KIND = "float";
    private static final String JDOUBLE_KIND = "double";
    private static final String JBOOLEAN_KIND = "boolean";
    private static final String JVOID_KIND = "void";
    private static final String JARRAY_KIND = "array";
    private static final String JREF_KIND = "ref";
    private static final String JNO_KIND = "no";
    static JType jVoid = new JType(11);
    private static JType jByte = new JType(1);
    private static JType jChar = new JType(2);
    private static JType jShort = new JType(3);
    private static JType jInt = new JType(4);
    private static JType jLong = new JType(5);
    private static JType jFloat = new JType(6);
    private static JType jDouble = new JType(7);
    private static JType jBoolean = new JType(8);
    public int jTag;

    JType(int jTag) {
        super(Integer.MAX_VALUE, null);
        this.jTag = jTag;
    }

    static JType getJTypeFromTypeName(String typeName) {
        switch (typeName) {
            case "byte": {
                return jByte;
            }
            case "char": {
                return jChar;
            }
            case "short": {
                return jShort;
            }
            case "int": {
                return jInt;
            }
            case "long": {
                return jLong;
            }
            case "float": {
                return jFloat;
            }
            case "double": {
                return jDouble;
            }
            case "boolean": {
                return jBoolean;
            }
            case "void": {
                return jVoid;
            }
        }
        return new JRefType(typeName.replace('.', '/'));
    }

    static JType getJTypeForPrimitive(String typeName) {
        switch (typeName) {
            case "byte": {
                return jByte;
            }
            case "char": {
                return jChar;
            }
            case "short": {
                return jShort;
            }
            case "int": {
                return jInt;
            }
            case "long": {
                return jLong;
            }
            case "float": {
                return jFloat;
            }
            case "double": {
                return jDouble;
            }
            case "boolean": {
                return jBoolean;
            }
            case "void": {
                return jVoid;
            }
        }
        throw new IllegalArgumentException("The Java " + typeName + " type is not yet supported.");
    }

    static int getJTypeTagForPrimitive(String typeName) {
        switch (typeName) {
            case "byte": {
                return 1;
            }
            case "char": {
                return 2;
            }
            case "short": {
                return 3;
            }
            case "int": {
                return 4;
            }
            case "long": {
                return 5;
            }
            case "float": {
                return 6;
            }
            case "double": {
                return 7;
            }
            case "boolean": {
                return 8;
            }
        }
        throw new IllegalArgumentException("The Java " + typeName + " type is not yet supported.");
    }

    static JArrayType getJArrayTypeFromTypeName(String typeName, byte dimensions) {
        JArrayType arrayType = new JArrayType(JType.getJTypeFromTypeName(typeName));
        for (int i = 1; i < dimensions; ++i) {
            arrayType = new JArrayType(arrayType);
        }
        return arrayType;
    }

    static JType getPrimitiveJTypeForBType(BType type) {
        switch (type.tag) {
            case 1: {
                return jLong;
            }
            case 2: {
                return jInt;
            }
            case 6: {
                return jBoolean;
            }
            case 3: {
                return jFloat;
            }
        }
        return new JType(10);
    }

    public static class JRefType
    extends JType {
        public String typeValue;
        boolean isInterface = false;
        boolean isArray = false;

        public JRefType(String typeValue) {
            super(10);
            this.typeValue = typeValue;
        }
    }

    public static class JArrayType
    extends JType {
        JType elementType;

        JArrayType(JType elementType) {
            super(9);
            this.elementType = elementType;
        }
    }
}

