/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;

public class ConfigMethodGen {
    public void generateConfigInit(List<PackageID> imprtMods, BIRNode.BIRPackage pkg, String moduleInitClass, Map<String, byte[]> jarEntries) {
        String innerClassName = JvmCodeGenUtil.getModuleLevelClassName(pkg.packageID, "$ConfigurationMapper");
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(52, 33, innerClassName, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(2, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "$configureInit", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/util/HashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        mv.visitVarInsn(58, 0);
        for (PackageID id : imprtMods) {
            this.generateInvokeConfiguration(mv, id);
        }
        this.generateInvokeConfiguration(mv, pkg.packageID);
        this.initializeConfigVariables(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.populateConfigDataMethod(cw, moduleInitClass, pkg);
        cw.visitEnd();
        jarEntries.put(innerClassName + ".class", cw.toByteArray());
    }

    private void generateInvokeConfiguration(MethodVisitor mv, PackageID id) {
        String moduleClass = JvmCodeGenUtil.getModuleLevelClassName(id, "$ConfigurationMapper");
        String initClass = JvmCodeGenUtil.getModuleLevelClassName(id, "$_init");
        mv.visitMethodInsn(184, moduleClass, "$populateConfigurationData", String.format("()[L%s;", "io/ballerina/runtime/internal/configurable/VariableKey"), false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(190);
        Label elseLabel = new Label();
        mv.visitJumpInsn(153, elseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, initClass, "$moduleName", String.format("L%s;", "io/ballerina/runtime/api/Module"));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
        mv.visitInsn(87);
        mv.visitLabel(elseLabel);
    }

    private void initializeConfigVariables(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/launch/LaunchUtils", "initConfigurableVariables", "(Ljava/util/Map;)V", false);
    }

    private void populateConfigDataMethod(ClassWriter cw, String moduleClass, BIRNode.BIRPackage module) {
        MethodVisitor mv = cw.visitMethod(9, "$populateConfigurationData", String.format("()[L%s;", "io/ballerina/runtime/internal/configurable/VariableKey"), null, null);
        mv.visitCode();
        mv.visitIntInsn(16, this.calculateConfigArraySize(module.globalVars));
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/configurable/VariableKey");
        mv.visitVarInsn(58, 0);
        int varCount = 0;
        for (BIRNode.BIRGlobalVariableDcl globalVar : module.globalVars) {
            long globalVarFlags = globalVar.flags;
            if (!Symbols.isFlagOn(globalVarFlags, 0x80000000L)) continue;
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/configurable/VariableKey");
            mv.visitInsn(89);
            mv.visitFieldInsn(178, moduleClass, "$moduleName", "Lio/ballerina/runtime/api/Module;");
            mv.visitLdcInsn(globalVar.name.value);
            JvmTypeGen.loadType(mv, globalVar.type);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/configurable/VariableKey", "<init>", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/api/Module", "java/lang/String", "io/ballerina/runtime/api/types/Type"), false);
            mv.visitVarInsn(58, varCount + 1);
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, varCount);
            mv.visitVarInsn(25, varCount + 1);
            mv.visitInsn(83);
            ++varCount;
        }
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private int calculateConfigArraySize(List<BIRNode.BIRGlobalVariableDcl> globalVars) {
        int count = 0;
        for (BIRNode.BIRGlobalVariableDcl globalVar : globalVars) {
            if (!Symbols.isFlagOn(globalVar.flags, 0x80000000L)) continue;
            ++count;
        }
        return count;
    }
}

