/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.FieldVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class FrameClassGen {
    public void generateFrameClasses(BIRNode.BIRPackage pkg, Map<String, byte[]> pkgEntries) {
        pkg.functions.parallelStream().forEach(func -> this.generateFrameClassForFunction(pkg.packageID, (BIRNode.BIRFunction)func, pkgEntries, null));
        for (BIRNode.BIRTypeDefinition typeDef : pkg.typeDefs) {
            List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
            if (attachedFuncs == null || attachedFuncs.size() == 0) continue;
            BType attachedType = typeDef.type.tag == 12 ? null : typeDef.type;
            attachedFuncs.parallelStream().forEach(func -> this.generateFrameClassForFunction(pkg.packageID, (BIRNode.BIRFunction)func, pkgEntries, attachedType));
        }
    }

    private void generateFrameClassForFunction(PackageID packageID, BIRNode.BIRFunction func, Map<String, byte[]> pkgEntries, BType attachedType) {
        String frameClassName = MethodGenUtils.getFrameClassName(JvmCodeGenUtil.getPackageName(packageID), func.name.value, attachedType);
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (func.pos != null && func.pos.lineRange().filePath() != null) {
            cw.visitSource(func.pos.lineRange().filePath(), null);
        }
        cw.visit(52, 33, frameClassName, null, "java/lang/Object", null);
        JvmCodeGenUtil.generateDefaultConstructor(cw, "java/lang/Object");
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        for (int k = 0; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = localVars.get(k);
            BType bType = localVar.type;
            String fieldName = localVar.name.value.replace("%", "_");
            String typeSig = JvmCodeGenUtil.getFieldTypeSignature(bType);
            cw.visitField(1, fieldName, typeSig, null, null).visitEnd();
        }
        FieldVisitor fv = cw.visitField(1, "state", "I", null, null);
        fv.visitEnd();
        cw.visitEnd();
        pkgEntries.put(frameClassName + ".class", cw.toByteArray());
    }
}

