/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.runtime.api.utils.IdentifierUtils;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

public class LambdaGen {
    private final SymbolTable symbolTable;
    private final JvmPackageGen jvmPackageGen;

    public LambdaGen(JvmPackageGen jvmPackageGen) {
        this.jvmPackageGen = jvmPackageGen;
        this.symbolTable = jvmPackageGen.symbolTable;
    }

    public void generateLambdaMethod(BIRInstruction ins, ClassWriter cw, String lambdaName) {
        LambdaDetails lambdaDetails = this.getLambdaDetails(ins);
        MethodVisitor mv = this.getMethodVisitorAndLoadFirst(cw, lambdaName, lambdaDetails, ins);
        ArrayList<BType> paramBTypes = new ArrayList<BType>();
        if (ins.getKind() == InstructionKind.ASYNC_CALL) {
            this.handleAsyncCallLambda((BIRTerminator.AsyncCall)ins, lambdaDetails, mv, paramBTypes);
        } else {
            this.handleFpLambda((BIRNonTerminator.FPLoad)ins, lambdaDetails, mv, paramBTypes);
        }
        MethodGenUtils.visitReturn(mv);
    }

    private void genNonVirtual(LambdaDetails lambdaDetails, MethodVisitor mv, List<BType> paramBTypes) {
        String jvmClass;
        String methodDesc = this.getLambdaMethodDesc(paramBTypes, lambdaDetails.returnType, lambdaDetails.closureMapsCount);
        if (lambdaDetails.functionWrapper != null) {
            jvmClass = lambdaDetails.functionWrapper.fullQualifiedClassName;
        } else {
            String balFileName = lambdaDetails.funcSymbol.source;
            if (balFileName == null || !balFileName.endsWith(".bal")) {
                balFileName = "$_init";
            }
            jvmClass = JvmCodeGenUtil.getModuleLevelClassName(lambdaDetails.packageID, JvmCodeGenUtil.cleanupPathSeparators(balFileName));
        }
        mv.visitMethodInsn(184, jvmClass, lambdaDetails.encodedFuncName, methodDesc, false);
        JvmCastGen.addBoxInsn(mv, lambdaDetails.returnType);
    }

    private void handleAsyncCallLambda(BIRTerminator.AsyncCall ins, LambdaDetails lambdaDetails, MethodVisitor mv, List<BType> paramBTypes) {
        if (ins.isVirtual) {
            this.handleLambdaVirtual(ins, lambdaDetails, mv);
        } else {
            this.handleAsyncNonVirtual(lambdaDetails, mv, paramBTypes);
        }
    }

    private void handleLambdaVirtual(BIRTerminator.AsyncCall ins, LambdaDetails lambdaDetails, MethodVisitor mv) {
        boolean isBuiltinModule = JvmCodeGenUtil.isBallerinaBuiltinModule(lambdaDetails.packageID.orgName.getValue(), lambdaDetails.packageID.name.getValue());
        List paramTypes = ins.args;
        this.genLoadDataForObjectAttachedLambdas(ins, mv, lambdaDetails.closureMapsCount, paramTypes, isBuiltinModule);
        int paramIndex = 2;
        for (int paramTypeIndex = 1; paramTypeIndex < paramTypes.size(); ++paramTypeIndex) {
            this.generateObjectArgs(mv, paramIndex);
            ++paramIndex;
            if (isBuiltinModule) continue;
            this.generateObjectArgs(mv, paramIndex);
            ++paramIndex;
        }
        String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "io/ballerina/runtime/internal/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
        mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "call", methodDesc, true);
    }

    private void genLoadDataForObjectAttachedLambdas(BIRTerminator.AsyncCall ins, MethodVisitor mv, int closureMapsCount, List<BIROperand> paramTypes, boolean isBuiltinModule) {
        mv.visitInsn(87);
        mv.visitVarInsn(25, closureMapsCount);
        mv.visitInsn(4);
        BIROperand ref = (BIROperand)ins.args.get(0);
        mv.visitInsn(50);
        JvmCastGen.addUnboxInsn(mv, ref.variableDcl.type);
        mv.visitVarInsn(25, closureMapsCount);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        mv.visitLdcInsn(JvmCodeGenUtil.rewriteVirtualCallTypeName(ins.name.value));
        int objectArrayLength = paramTypes.size() - 1;
        if (!isBuiltinModule) {
            mv.visitIntInsn(16, objectArrayLength * 2);
        } else {
            mv.visitIntInsn(16, objectArrayLength);
        }
        mv.visitTypeInsn(189, "java/lang/Object");
    }

    private void generateObjectArgs(MethodVisitor mv, int paramIndex) {
        mv.visitInsn(89);
        mv.visitIntInsn(16, paramIndex - 2);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, paramIndex + 1);
        mv.visitInsn(50);
        mv.visitInsn(83);
    }

    private void handleAsyncNonVirtual(LambdaDetails lambdaDetails, MethodVisitor mv, List<BType> paramBTypes) {
        boolean isBuiltinModule = JvmCodeGenUtil.isBallerinaBuiltinModule(lambdaDetails.packageID.orgName.getValue(), lambdaDetails.packageID.name.getValue());
        List<BType> paramTypes = this.getFpParamTypes(lambdaDetails);
        int argIndex = 1;
        int paramIndex = 1;
        for (BType paramType : paramTypes) {
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, argIndex);
            mv.visitInsn(50);
            JvmCastGen.addUnboxInsn(mv, paramType);
            paramBTypes.add(paramIndex - 1, paramType);
            ++paramIndex;
            ++argIndex;
            if (!isBuiltinModule) {
                this.addBooleanTypeToLambdaParamTypes(mv, 0, argIndex);
                paramBTypes.add(paramIndex - 1, this.symbolTable.booleanType);
                ++paramIndex;
            }
            ++argIndex;
        }
        this.genNonVirtual(lambdaDetails, mv, paramBTypes);
    }

    private void addBooleanTypeToLambdaParamTypes(MethodVisitor mv, int arrayIndex, int paramIndex) {
        mv.visitVarInsn(25, arrayIndex);
        mv.visitIntInsn(16, paramIndex);
        mv.visitInsn(50);
        JvmCastGen.addUnboxInsn(mv, this.symbolTable.booleanType);
    }

    private List<BType> getFpParamTypes(LambdaDetails lambdaDetails) {
        List<BType> paramTypes = lambdaDetails.functionWrapper != null ? this.getInitialParamTypes(lambdaDetails.functionWrapper.func.type.paramTypes, lambdaDetails.functionWrapper.func.argsCount) : ((BInvokableType)lambdaDetails.funcSymbol.type).paramTypes;
        return paramTypes;
    }

    private void handleFpLambda(BIRNonTerminator.FPLoad ins, LambdaDetails lambdaDetails, MethodVisitor mv, List<BType> paramBTypes) {
        this.loadClosureMaps(lambdaDetails, mv);
        this.loadAndCastParamValues(ins, lambdaDetails, mv, paramBTypes);
        this.genNonVirtual(lambdaDetails, mv, paramBTypes);
    }

    private void loadAndCastParamValues(BIRNonTerminator.FPLoad ins, LambdaDetails lambdaDetails, MethodVisitor mv, List<BType> paramBTypes) {
        int paramIndex = 1;
        int argIndex = 1;
        for (BIRNode.BIRVariableDcl dcl : ins.params) {
            mv.visitVarInsn(25, lambdaDetails.closureMapsCount);
            mv.visitIntInsn(16, argIndex);
            mv.visitInsn(50);
            JvmCastGen.addUnboxInsn(mv, dcl.type);
            paramBTypes.add(paramIndex - 1, dcl.type);
            ++paramIndex;
            ++argIndex;
            boolean isBuiltinModule = JvmCodeGenUtil.isBallerinaBuiltinModule(lambdaDetails.packageID.orgName.getValue(), lambdaDetails.packageID.name.getValue());
            if (!isBuiltinModule) {
                this.addBooleanTypeToLambdaParamTypes(mv, lambdaDetails.closureMapsCount, argIndex);
                paramBTypes.add(paramIndex - 1, this.symbolTable.booleanType);
                ++paramIndex;
            }
            ++argIndex;
        }
    }

    private void loadClosureMaps(LambdaDetails lambdaDetails, MethodVisitor mv) {
        for (int i = 0; i < lambdaDetails.closureMapsCount; ++i) {
            mv.visitVarInsn(25, i);
            mv.visitInsn(4);
        }
    }

    private MethodVisitor getMethodVisitorAndLoadFirst(ClassWriter cw, String lambdaName, LambdaDetails lambdaDetails, BIRInstruction ins) {
        String closureMapsDesc = this.getMapValueDesc(lambdaDetails.closureMapsCount);
        MethodVisitor mv = cw.visitMethod(9, lambdaName, String.format("(%s[L%s;)L%s;", closureMapsDesc, "java/lang/Object", "java/lang/Object"), null, null);
        mv.visitCode();
        JvmCodeGenUtil.generateDiagnosticPos(((BIRAbstractInstruction)ins).pos, mv);
        mv.visitVarInsn(25, lambdaDetails.closureMapsCount);
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/scheduling/Strand");
        if (lambdaDetails.isExternFunction) {
            this.generateBlockedOnExtern(lambdaDetails.closureMapsCount, mv);
        }
        return mv;
    }

    private String getMapValueDesc(int count) {
        StringBuilder desc = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            desc.append("L").append("io/ballerina/runtime/internal/values/MapValue").append(";");
        }
        return desc.toString();
    }

    private void generateBlockedOnExtern(int closureMapsCount, MethodVisitor mv) {
        Label blockedOnExternLabel = new Label();
        mv.visitInsn(89);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "isBlockedOnExtern", "()Z", false);
        mv.visitJumpInsn(153, blockedOnExternLabel);
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "blockedOnExtern", "Z");
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        Label panicLabel = new Label();
        mv.visitJumpInsn(198, panicLabel);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        mv.visitVarInsn(58, closureMapsCount + 1);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", "panic", String.format("L%s;", "io/ballerina/runtime/api/values/BError"));
        mv.visitVarInsn(25, closureMapsCount + 1);
        mv.visitInsn(191);
        mv.visitLabel(panicLabel);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "returnValue", "Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitLabel(blockedOnExternLabel);
    }

    private LambdaDetails getLambdaDetails(BIRInstruction ins) {
        LambdaDetails lambdaDetails;
        InstructionKind kind = ins.getKind();
        if (kind == InstructionKind.ASYNC_CALL) {
            lambdaDetails = this.populateAsyncLambdaDetails((BIRTerminator.AsyncCall)ins);
        } else if (kind == InstructionKind.FP_LOAD) {
            lambdaDetails = this.populateFpLambdaDetails((BIRNonTerminator.FPLoad)ins);
        } else {
            throw new BLangCompilerException("JVM lambda method generation is not supported for instruction " + String.format("%s", ins));
        }
        lambdaDetails.isExternFunction = this.isExternStaticFunctionCall(ins);
        this.populateLambdaReturnType(ins, lambdaDetails);
        return lambdaDetails;
    }

    private LambdaDetails populateAsyncLambdaDetails(BIRTerminator.AsyncCall asyncIns) {
        LambdaDetails lambdaDetails = new LambdaDetails();
        lambdaDetails.lhsType = asyncIns.lhsOp != null ? asyncIns.lhsOp.variableDcl.type : null;
        lambdaDetails.packageID = asyncIns.calleePkg;
        lambdaDetails.funcName = asyncIns.name.getValue();
        if (!asyncIns.isVirtual) {
            this.populateLambdaFunctionDetails(lambdaDetails);
        }
        return lambdaDetails;
    }

    private LambdaDetails populateFpLambdaDetails(BIRNonTerminator.FPLoad fpIns) {
        LambdaDetails lambdaDetails = new LambdaDetails();
        lambdaDetails.lhsType = fpIns.lhsOp.variableDcl.type;
        lambdaDetails.packageID = fpIns.pkgId;
        lambdaDetails.funcName = fpIns.funcName.getValue();
        lambdaDetails.closureMapsCount = fpIns.closureMaps.size();
        this.populateLambdaFunctionDetails(lambdaDetails);
        return lambdaDetails;
    }

    private void populateLambdaFunctionDetails(LambdaDetails lambdaDetails) {
        lambdaDetails.encodedFuncName = IdentifierUtils.encodeFunctionIdentifier(lambdaDetails.funcName);
        lambdaDetails.lookupKey = JvmCodeGenUtil.getPackageName(lambdaDetails.packageID) + lambdaDetails.encodedFuncName;
        lambdaDetails.functionWrapper = this.jvmPackageGen.lookupBIRFunctionWrapper(lambdaDetails.lookupKey);
        if (lambdaDetails.functionWrapper == null) {
            BPackageSymbol symbol = this.jvmPackageGen.packageCache.getSymbol(lambdaDetails.packageID.orgName + "/" + lambdaDetails.packageID.name);
            lambdaDetails.funcSymbol = (BInvokableSymbol)symbol.scope.lookup((Name)new Name((String)lambdaDetails.funcName)).symbol;
        }
    }

    private boolean isExternStaticFunctionCall(BIRInstruction callIns) {
        PackageID packageID;
        String methodName;
        InstructionKind kind = callIns.getKind();
        switch (kind) {
            case CALL: {
                BIRTerminator.Call call = (BIRTerminator.Call)callIns;
                if (call.isVirtual) {
                    return false;
                }
                methodName = call.name.value;
                packageID = call.calleePkg;
                break;
            }
            case ASYNC_CALL: {
                BIRTerminator.AsyncCall asyncCall = (BIRTerminator.AsyncCall)callIns;
                methodName = asyncCall.name.value;
                packageID = asyncCall.calleePkg;
                break;
            }
            case FP_LOAD: {
                BIRNonTerminator.FPLoad fpLoad = (BIRNonTerminator.FPLoad)callIns;
                methodName = fpLoad.funcName.value;
                packageID = fpLoad.pkgId;
                break;
            }
            default: {
                throw new BLangCompilerException("JVM static function call generation is not supported for instruction " + String.format("%s", callIns));
            }
        }
        String key = JvmCodeGenUtil.getPackageName(packageID) + methodName;
        BIRFunctionWrapper functionWrapper = this.jvmPackageGen.lookupBIRFunctionWrapper(key);
        return functionWrapper != null && JvmCodeGenUtil.isExternFunc(functionWrapper.func);
    }

    private void populateLambdaReturnType(BIRInstruction ins, LambdaDetails lambdaDetails) {
        if (lambdaDetails.lhsType.tag == 31) {
            lambdaDetails.returnType = ((BFutureType)lambdaDetails.lhsType).constraint;
        } else if (ins instanceof BIRNonTerminator.FPLoad) {
            lambdaDetails.returnType = ((BIRNonTerminator.FPLoad)ins).retType;
            if (lambdaDetails.returnType.tag == 16) {
                lambdaDetails.returnType = ((BInvokableType)lambdaDetails.returnType).retType;
            }
        } else {
            throw new BLangCompilerException("JVM generation is not supported for async return type " + String.format("%s", lambdaDetails.lhsType));
        }
    }

    private String getLambdaMethodDesc(List<BType> paramTypes, BType retType, int closureMapsCount) {
        StringBuilder desc = new StringBuilder(JvmCodeGenUtil.INITIAL_METHOD_DESC);
        this.appendClosureMaps(closureMapsCount, desc);
        this.appendParamTypes(paramTypes, desc);
        desc.append(JvmCodeGenUtil.generateReturnType(retType));
        return desc.toString();
    }

    private void appendParamTypes(List<BType> paramTypes, StringBuilder desc) {
        for (BType paramType : paramTypes) {
            desc.append(JvmCodeGenUtil.getArgTypeSignature(paramType));
        }
    }

    private void appendClosureMaps(int closureMapsCount, StringBuilder desc) {
        for (int j = 0; j < closureMapsCount; ++j) {
            desc.append("L").append("io/ballerina/runtime/internal/values/MapValue").append(";").append("Z");
        }
    }

    private List<BType> getInitialParamTypes(List<BType> paramTypes, int argsCount) {
        ArrayList<BType> initialParamTypes = new ArrayList<BType>();
        for (int index = 0; index < argsCount; ++index) {
            initialParamTypes.add(paramTypes.get(index * 2));
        }
        return initialParamTypes;
    }

    private static class LambdaDetails {
        BType lhsType;
        PackageID packageID;
        String funcName;
        boolean isExternFunction;
        String encodedFuncName = null;
        String lookupKey;
        BIRFunctionWrapper functionWrapper = null;
        BInvokableSymbol funcSymbol = null;
        BType returnType;
        int closureMapsCount = 0;

        private LambdaDetails() {
        }
    }
}

