/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.FunctionParamComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class MethodGen {
    private static final String STATE = "state";
    private static final String RESUME_INDEX = "resumeIndex";
    private final JvmPackageGen jvmPackageGen;
    private final SymbolTable symbolTable;

    public MethodGen(JvmPackageGen jvmPackageGen) {
        this.jvmPackageGen = jvmPackageGen;
        this.symbolTable = jvmPackageGen.symbolTable;
    }

    public void generateMethod(BIRNode.BIRFunction birFunc, ClassWriter cw, BIRNode.BIRPackage birModule, BType attachedType, String moduleClassName, AsyncDataCollector asyncDataCollector) {
        if (JvmCodeGenUtil.isExternFunc(birFunc)) {
            ExternalMethodGen.genJMethodForBExternalFunc(birFunc, cw, birModule, attachedType, this, this.jvmPackageGen, moduleClassName, asyncDataCollector);
        } else {
            this.genJMethodForBFunc(birFunc, cw, birModule, moduleClassName, attachedType, asyncDataCollector);
        }
    }

    public void genJMethodForBFunc(BIRNode.BIRFunction func, ClassWriter cw, BIRNode.BIRPackage module, String moduleClassName, BType attachedType, AsyncDataCollector asyncDataCollector) {
        int localVarOffset;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        indexMap.addIfNotExists("strand", this.symbolTable.stringType);
        int access = 1;
        if (attachedType != null) {
            localVarOffset = 1;
            indexMap.addIfNotExists("self", this.symbolTable.anyType);
        } else {
            localVarOffset = 0;
            access += 8;
        }
        String funcName = func.name.value;
        BType retType = this.getReturnType(func);
        String desc = JvmCodeGenUtil.getMethodDesc(func.type.paramTypes, retType);
        MethodVisitor mv = cw.visitMethod(access, funcName, desc, null, null);
        mv.visitCode();
        this.visitModuleStartFunction(module.packageID, funcName, mv);
        Label methodStartLabel = new Label();
        mv.visitLabel(methodStartLabel);
        this.setChannelDetailsToStrand(func, localVarOffset, mv);
        this.checkStrandCancelled(mv, localVarOffset);
        this.genLocalVars(indexMap, mv, func.localVars);
        int returnVarRefIndex = this.getReturnVarRefIndex(func, indexMap, retType, mv);
        int stateVarIndex = this.getStateVarIndex(indexMap, mv);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", RESUME_INDEX, "I");
        LabelGenerator labelGen = new LabelGenerator();
        Label resumeLabel = labelGen.getLabel(funcName + "resume");
        mv.visitJumpInsn(157, resumeLabel);
        Label varinitLabel = labelGen.getLabel(funcName + "varinit");
        mv.visitLabel(varinitLabel);
        ArrayList<Label> labels = new ArrayList<Label>();
        ArrayList<Integer> states = new ArrayList<Integer>();
        this.addCasesForBasicBlocks(func, funcName, labelGen, labels, states);
        JvmInstructionGen instGen = new JvmInstructionGen(mv, indexMap, module.packageID, this.jvmPackageGen);
        JvmErrorGen errorGen = new JvmErrorGen(mv, indexMap, instGen);
        JvmTerminatorGen termGen = new JvmTerminatorGen(mv, indexMap, labelGen, errorGen, module.packageID, instGen, this.jvmPackageGen);
        mv.visitVarInsn(21, stateVarIndex);
        Label yieldLable = labelGen.getLabel(funcName + "yield");
        mv.visitLookupSwitchInsn(yieldLable, this.toIntArray(states), labels.toArray(new Label[0]));
        this.generateBasicBlocks(mv, labelGen, errorGen, instGen, termGen, func, returnVarRefIndex, stateVarIndex, localVarOffset, module, attachedType, moduleClassName, asyncDataCollector);
        mv.visitLabel(resumeLabel);
        String frameName = MethodGenUtils.getFrameClassName(JvmCodeGenUtil.getPackageName(module.packageID), funcName, attachedType);
        this.genGetFrameOnResumeIndex(localVarOffset, mv, frameName);
        this.generateFrameClassFieldLoad(func.localVars, mv, indexMap, frameName);
        mv.visitFieldInsn(180, frameName, STATE, "I");
        mv.visitVarInsn(54, stateVarIndex);
        mv.visitJumpInsn(167, varinitLabel);
        mv.visitLabel(yieldLable);
        mv.visitTypeInsn(187, frameName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, frameName, "<init>", "()V", false);
        this.generateFrameClassFieldUpdate(func.localVars, mv, indexMap, frameName);
        mv.visitInsn(89);
        mv.visitVarInsn(21, stateVarIndex);
        mv.visitFieldInsn(181, frameName, STATE, "I");
        this.generateGetFrame(indexMap, localVarOffset, mv);
        Label methodEndLabel = new Label();
        mv.visitLabel(methodEndLabel);
        termGen.genReturnTerm(returnVarRefIndex, func);
        this.createLocalVariableTable(func, indexMap, localVarOffset, mv, methodStartLabel, labelGen, methodEndLabel);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private BType getReturnType(BIRNode.BIRFunction func) {
        BType retType = func.type.retType;
        if (JvmCodeGenUtil.isExternFunc(func) && Symbols.isFlagOn(retType.flags, 0x4000000L)) {
            retType = JvmCodeGenUtil.TYPE_BUILDER.build(func.type.retType);
        }
        return retType;
    }

    private void visitModuleStartFunction(PackageID packageID, String funcName, MethodVisitor mv) {
        if (!this.isModuleStartFunction(funcName)) {
            return;
        }
        mv.visitInsn(4);
        mv.visitFieldInsn(179, JvmCodeGenUtil.getModuleLevelClassName(packageID, "$_init"), "$moduleStartAttempted", "Z");
    }

    private void setChannelDetailsToStrand(BIRNode.BIRFunction func, int localVarOffset, MethodVisitor mv) {
        if (func.workerChannels.length <= 0) {
            return;
        }
        mv.visitVarInsn(25, localVarOffset);
        JvmCodeGenUtil.loadChannelDetails(mv, Arrays.asList(func.workerChannels));
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Strand", "updateChannelDetails", String.format("([L%s;)V", "io/ballerina/runtime/internal/values/ChannelDetails"), false);
    }

    private void checkStrandCancelled(MethodVisitor mv, int localVarOffset) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "cancel", "Z");
        Label notCancelledLabel = new Label();
        mv.visitJumpInsn(153, notCancelledLabel);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/ErrorUtils", "createCancelledFutureError", String.format("()L%s;", "io/ballerina/runtime/internal/values/ErrorValue"), false);
        mv.visitInsn(191);
        mv.visitLabel(notCancelledLabel);
    }

    private void genLocalVars(BIRVarToJVMIndexMap indexMap, MethodVisitor mv, List<BIRNode.BIRVariableDcl> localVars) {
        localVars.sort(new FunctionParamComparator());
        for (int i = 1; i < localVars.size(); ++i) {
            BIRNode.BIRVariableDcl localVar = localVars.get(i);
            int index = indexMap.addIfNotExists(localVar.name.value, localVar.type);
            if (localVar.kind == VarKind.ARG) continue;
            BType bType = localVar.type;
            this.genDefaultValue(mv, bType, index);
        }
    }

    private int getReturnVarRefIndex(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, BType retType, MethodVisitor mv) {
        BIRNode.BIRVariableDcl varDcl = func.localVars.get(0);
        int returnVarRefIndex = indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
        this.genDefaultValue(mv, retType, returnVarRefIndex);
        return returnVarRefIndex;
    }

    private void genDefaultValue(MethodVisitor mv, BType bType, int index) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitInsn(9);
            mv.visitVarInsn(55, index);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag)) {
            mv.visitInsn(1);
            mv.visitVarInsn(58, index);
            return;
        }
        switch (bType.tag) {
            case 2: 
            case 6: {
                mv.visitInsn(3);
                mv.visitVarInsn(54, index);
                break;
            }
            case 3: {
                mv.visitInsn(14);
                mv.visitVarInsn(57, index);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 49: {
                mv.visitInsn(1);
                mv.visitVarInsn(58, index);
                break;
            }
            case 0x7FFFFFFF: {
                this.genJDefaultValue(mv, (JType)bType, index);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
            }
        }
    }

    private void genJDefaultValue(MethodVisitor mv, JType jType, int index) {
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                mv.visitInsn(3);
                mv.visitVarInsn(54, index);
                break;
            }
            case 5: {
                mv.visitInsn(9);
                mv.visitVarInsn(55, index);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                mv.visitVarInsn(56, index);
                break;
            }
            case 7: {
                mv.visitInsn(14);
                mv.visitVarInsn(57, index);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(1);
                mv.visitVarInsn(58, index);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    private int getStateVarIndex(BIRVarToJVMIndexMap indexMap, MethodVisitor mv) {
        int stateVarIndex = indexMap.addIfNotExists(STATE, this.symbolTable.stringType);
        mv.visitInsn(3);
        mv.visitVarInsn(54, stateVarIndex);
        return stateVarIndex;
    }

    private void addCasesForBasicBlocks(BIRNode.BIRFunction func, String funcName, LabelGenerator labelGen, List<Label> lables, List<Integer> states) {
        int caseIndex = 0;
        for (int i = 0; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock bb = func.basicBlocks.get(i);
            if (i == 0) {
                lables.add(caseIndex, labelGen.getLabel(funcName + bb.id.value));
                states.add(caseIndex, caseIndex);
                ++caseIndex;
            }
            lables.add(caseIndex, labelGen.getLabel(funcName + bb.id.value + "beforeTerm"));
            states.add(caseIndex, caseIndex);
            ++caseIndex;
        }
    }

    private int[] toIntArray(List<Integer> states) {
        int[] ints = new int[states.size()];
        for (int i = 0; i < states.size(); ++i) {
            ints[i] = states.get(i);
        }
        return ints;
    }

    void generateBasicBlocks(MethodVisitor mv, LabelGenerator labelGen, JvmErrorGen errorGen, JvmInstructionGen instGen, JvmTerminatorGen termGen, BIRNode.BIRFunction func, int returnVarRefIndex, int stateVarIndex, int localVarOffset, BIRNode.BIRPackage module, BType attachedType, String moduleClassName, AsyncDataCollector asyncDataCollector) {
        String funcName = func.name.value;
        BirScope lastScope = null;
        HashSet<BirScope> visitedScopesSet = new HashSet<BirScope>();
        int caseIndex = 0;
        for (int i = 0; i < func.basicBlocks.size(); ++i) {
            BIRNode.BIRBasicBlock bb = func.basicBlocks.get(i);
            Label bbLabel = labelGen.getLabel(funcName + bb.id.value);
            mv.visitLabel(bbLabel);
            if (i == 0) {
                this.pushShort(mv, stateVarIndex, caseIndex);
                ++caseIndex;
            }
            lastScope = JvmCodeGenUtil.getLastScopeFromBBInsGen(mv, labelGen, instGen, localVarOffset, asyncDataCollector, funcName, bb, visitedScopesSet, lastScope);
            Label bbEndLabel = labelGen.getLabel(funcName + bb.id.value + "beforeTerm");
            mv.visitLabel(bbEndLabel);
            BIRTerminator terminator = bb.terminator;
            this.pushShort(mv, stateVarIndex, caseIndex);
            ++caseIndex;
            this.processTerminator(mv, func, module, funcName, terminator, localVarOffset);
            termGen.genTerminator(terminator, moduleClassName, func, funcName, localVarOffset, returnVarRefIndex, attachedType, asyncDataCollector);
            errorGen.generateTryCatch(func, funcName, bb, termGen, labelGen);
            BIRNode.BIRBasicBlock thenBB = terminator.thenBB;
            if (thenBB == null) continue;
            JvmCodeGenUtil.genYieldCheck(mv, termGen.getLabelGenerator(), thenBB, funcName, localVarOffset);
        }
    }

    private void pushShort(MethodVisitor mv, int stateVarIndex, int caseIndex) {
        mv.visitIntInsn(17, caseIndex);
        mv.visitVarInsn(54, stateVarIndex);
    }

    private void processTerminator(MethodVisitor mv, BIRNode.BIRFunction func, BIRNode.BIRPackage module, String funcName, BIRTerminator terminator, int localVarOffset) {
        JvmCodeGenUtil.generateDiagnosticPos(terminator.pos, mv);
        if ((MethodGenUtils.isModuleInitFunction(func) || this.isModuleTestInitFunction(func)) && terminator instanceof BIRTerminator.Return) {
            this.generateAnnotLoad(mv, module.typeDefs, JvmCodeGenUtil.getPackageName(module.packageID), localVarOffset);
        }
        if (this.isModuleStartFunction(funcName) && terminator.kind == InstructionKind.RETURN) {
            mv.visitInsn(4);
            mv.visitFieldInsn(179, JvmCodeGenUtil.getModuleLevelClassName(module.packageID, "$_init"), "$moduleStarted", "Z");
        }
    }

    private boolean isModuleTestInitFunction(BIRNode.BIRFunction func) {
        return func.name.value.equals(MethodGenUtils.encodeModuleSpecialFuncName(".<testinit>"));
    }

    private void generateAnnotLoad(MethodVisitor mv, List<BIRNode.BIRTypeDefinition> typeDefs, String pkgName, int localVarOffset) {
        String typePkgName = ".";
        if (!"".equals(pkgName)) {
            typePkgName = pkgName;
        }
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            if (optionalTypeDef.isBuiltin) continue;
            BType bType = optionalTypeDef.type;
            if ((bType.flags & 0x100000000L) == 0x100000000L || bType.tag == 32) continue;
            this.loadAnnots(mv, typePkgName, optionalTypeDef, localVarOffset);
        }
    }

    private void loadAnnots(MethodVisitor mv, String pkgName, BIRNode.BIRTypeDefinition typeDef, int localVarOffset) {
        String pkgClassName = pkgName.equals(".") || pkgName.equals("") ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
        mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
        this.loadLocalType(mv, typeDef);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitMethodInsn(184, String.format("%s", "io/ballerina/runtime/internal/AnnotationUtils"), "processAnnotations", String.format("(L%s;L%s;L%s;)V", "io/ballerina/runtime/internal/values/MapValue", "io/ballerina/runtime/api/types/Type", "io/ballerina/runtime/internal/scheduling/Strand"), false);
    }

    void loadLocalType(MethodVisitor mv, BIRNode.BIRTypeDefinition typeDefinition) {
        JvmTypeGen.loadType(mv, typeDefinition.type);
    }

    private boolean isModuleStartFunction(String functionName) {
        return functionName.equals(MethodGenUtils.encodeModuleSpecialFuncName(".<start>"));
    }

    private void genGetFrameOnResumeIndex(int localVarOffset, MethodVisitor mv, String frameName) {
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "frames", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, localVarOffset);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", RESUME_INDEX, "I");
        mv.visitInsn(4);
        mv.visitInsn(100);
        mv.visitInsn(90);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", RESUME_INDEX, "I");
        mv.visitInsn(50);
        mv.visitTypeInsn(192, frameName);
    }

    private void generateFrameClassFieldLoad(List<BIRNode.BIRVariableDcl> localVars, MethodVisitor mv, BIRVarToJVMIndexMap indexMap, String frameName) {
        for (BIRNode.BIRVariableDcl localVar : localVars) {
            BType bType = localVar.type;
            int index = indexMap.addIfNotExists(localVar.name.value, bType);
            mv.visitInsn(89);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "J");
                mv.visitVarInsn(55, index);
                continue;
            }
            if (TypeTags.isStringTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/api/values/BString"));
                mv.visitVarInsn(58, index);
                continue;
            }
            if (TypeTags.isXMLTypeTag(bType.tag)) {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue"));
                mv.visitVarInsn(58, index);
                continue;
            }
            this.generateFrameClassFieldLoadByTypeTag(mv, frameName, localVar, index, bType);
        }
    }

    private void generateFrameClassFieldLoadByTypeTag(MethodVisitor mv, String frameName, BIRNode.BIRVariableDcl localVar, int index, BType bType) {
        switch (bType.tag) {
            case 2: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
                mv.visitVarInsn(54, index);
                break;
            }
            case 3: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "D");
                mv.visitVarInsn(57, index);
                break;
            }
            case 4: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 6: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "Z");
                mv.visitVarInsn(54, index);
                break;
            }
            case 12: 
            case 15: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 14: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 9: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 19: 
            case 30: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 33: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/api/values/BObject"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 28: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 31: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 16: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 13: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "java/lang/Object"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 36: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue"));
                mv.visitVarInsn(58, index);
                break;
            }
            case 0x7FFFFFFF: {
                this.generateFrameClassJFieldLoad(localVar, mv, index, frameName);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + bType);
            }
        }
    }

    private void generateFrameClassJFieldLoad(BIRNode.BIRVariableDcl localVar, MethodVisitor mv, int index, String frameName) {
        JType jType = (JType)localVar.type;
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "I");
                mv.visitVarInsn(54, index);
                break;
            }
            case 5: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "J");
                mv.visitVarInsn(55, index);
                break;
            }
            case 6: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "F");
                mv.visitVarInsn(56, index);
                break;
            }
            case 7: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "D");
                mv.visitVarInsn(57, index);
                break;
            }
            case 8: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), "Z");
                mv.visitVarInsn(54, index);
                break;
            }
            case 9: 
            case 10: {
                mv.visitFieldInsn(180, frameName, localVar.name.value.replace("%", "_"), InteropMethodGen.getJTypeSignature(jType));
                mv.visitVarInsn(58, index);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    private void generateFrameClassFieldUpdate(List<BIRNode.BIRVariableDcl> localVars, MethodVisitor mv, BIRVarToJVMIndexMap indexMap, String frameName) {
        for (BIRNode.BIRVariableDcl localVar : localVars) {
            BType bType = localVar.type;
            int index = indexMap.addIfNotExists(localVar.name.value, bType);
            mv.visitInsn(89);
            if (TypeTags.isIntegerTypeTag(bType.tag)) {
                mv.visitVarInsn(22, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "J");
                continue;
            }
            if (TypeTags.isStringTypeTag(bType.tag)) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/api/values/BString"));
                continue;
            }
            if (TypeTags.isXMLTypeTag(bType.tag)) {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue"));
                continue;
            }
            this.generateFrameClassFieldUpdateByTypeTag(mv, frameName, localVar, index, bType);
        }
    }

    private void generateFrameClassFieldUpdateByTypeTag(MethodVisitor mv, String frameName, BIRNode.BIRVariableDcl localVar, int index, BType bType) {
        switch (bType.tag) {
            case 2: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "I");
                break;
            }
            case 3: {
                mv.visitVarInsn(24, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "D");
                break;
            }
            case 4: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue"));
                break;
            }
            case 6: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "Z");
                break;
            }
            case 12: 
            case 15: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue"));
                break;
            }
            case 14: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue"));
                break;
            }
            case 9: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl"));
                break;
            }
            case 19: 
            case 30: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue"));
                break;
            }
            case 28: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue"));
                break;
            }
            case 31: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue"));
                break;
            }
            case 13: {
                mv.visitVarInsn(25, index);
                mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/TypedescValue");
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue"));
                break;
            }
            case 33: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/api/values/BObject"));
                break;
            }
            case 16: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue"));
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "java/lang/Object"));
                break;
            }
            case 36: {
                mv.visitVarInsn(25, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue"));
                break;
            }
            case 0x7FFFFFFF: {
                this.generateFrameClassJFieldUpdate(localVar, mv, index, frameName);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
            }
        }
    }

    private void generateFrameClassJFieldUpdate(BIRNode.BIRVariableDcl localVar, MethodVisitor mv, int index, String frameName) {
        JType jType = (JType)localVar.type;
        switch (jType.jTag) {
            case 1: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "B");
                break;
            }
            case 2: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "C");
                break;
            }
            case 3: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "S");
                break;
            }
            case 4: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "I");
                break;
            }
            case 5: {
                mv.visitVarInsn(22, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "J");
                break;
            }
            case 6: {
                mv.visitVarInsn(23, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "F");
                break;
            }
            case 7: {
                mv.visitVarInsn(24, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "D");
                break;
            }
            case 8: {
                mv.visitVarInsn(21, index);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), "Z");
                break;
            }
            case 9: 
            case 10: {
                String classSig = InteropMethodGen.getJTypeSignature(jType);
                String className = InteropMethodGen.getSignatureForJType(jType);
                mv.visitVarInsn(25, index);
                mv.visitTypeInsn(192, className);
                mv.visitFieldInsn(181, frameName, localVar.name.value.replace("%", "_"), classSig);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", jType));
            }
        }
    }

    private void generateGetFrame(BIRVarToJVMIndexMap indexMap, int localVarOffset, MethodVisitor mv) {
        int frameVarIndex = indexMap.addIfNotExists("frame", this.symbolTable.stringType);
        mv.visitVarInsn(58, frameVarIndex);
        mv.visitVarInsn(25, localVarOffset);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "frames", "[Ljava/lang/Object;");
        mv.visitVarInsn(25, localVarOffset);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", RESUME_INDEX, "I");
        mv.visitInsn(90);
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/scheduling/Strand", RESUME_INDEX, "I");
        mv.visitVarInsn(25, frameVarIndex);
        mv.visitInsn(83);
    }

    private void createLocalVariableTable(BIRNode.BIRFunction func, BIRVarToJVMIndexMap indexMap, int localVarOffset, MethodVisitor mv, Label methodStartLabel, LabelGenerator labelGen, Label methodEndLabel) {
        String funcName = func.name.value;
        mv.visitLocalVariable("__strand", String.format("L%s;", "io/ballerina/runtime/internal/scheduling/Strand"), null, methodStartLabel, methodEndLabel, localVarOffset);
        BIRNode.BIRBasicBlock endBB = func.basicBlocks.get(func.basicBlocks.size() - 1);
        for (int i = localVarOffset; i < func.localVars.size(); ++i) {
            String metaVarName;
            BIRNode.BIRVariableDcl localVar = func.localVars.get(i);
            Label startLabel = methodStartLabel;
            Label endLabel = methodEndLabel;
            if (!this.isLocalOrArg(localVar)) continue;
            if (localVar.kind == VarKind.LOCAL) {
                if (localVar.startBB != null) {
                    startLabel = labelGen.getLabel(funcName + "_SCOPE_" + localVar.insScope.id);
                }
                if (localVar.endBB != null) {
                    endLabel = labelGen.getLabel(funcName + endBB.id.value + "beforeTerm");
                }
            }
            if (!this.isCompilerAddedVars(metaVarName = localVar.metaVarName)) continue;
            mv.visitLocalVariable(metaVarName, this.getJVMTypeSign(localVar.type), null, startLabel, endLabel, indexMap.addIfNotExists(localVar.name.value, localVar.type));
        }
    }

    private boolean isLocalOrArg(BIRNode.BIRVariableDcl localVar) {
        boolean synArg = localVar.type.tag == 6 && localVar.name.value.startsWith("%syn");
        return !synArg && (localVar.kind == VarKind.LOCAL || localVar.kind == VarKind.ARG);
    }

    private boolean isCompilerAddedVars(String metaVarName) {
        return !(metaVarName == null || "".equals(metaVarName) || metaVarName.startsWith("$") && metaVarName.endsWith("$") || metaVarName.startsWith("$$") && metaVarName.endsWith("$$") || metaVarName.startsWith("_$$_"));
    }

    private String getJVMTypeSign(BType bType) {
        String jvmType;
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", "java/lang/String");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "io/ballerina/runtime/internal/values/XmlValue");
        }
        switch (bType.tag) {
            case 2: {
                jvmType = "I";
                break;
            }
            case 3: {
                jvmType = "D";
                break;
            }
            case 6: {
                jvmType = "Z";
                break;
            }
            case 4: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/DecimalValue");
                break;
            }
            case 12: 
            case 15: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/MapValue");
                break;
            }
            case 14: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/StreamValue");
                break;
            }
            case 9: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/TableValueImpl");
                break;
            }
            case 19: 
            case 30: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/ArrayValue");
                break;
            }
            case 33: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/api/values/BObject");
                break;
            }
            case 28: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/ErrorValue");
                break;
            }
            case 31: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/FutureValue");
                break;
            }
            case 16: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/FPValue");
                break;
            }
            case 36: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/HandleValue");
                break;
            }
            case 13: {
                jvmType = String.format("L%s;", "io/ballerina/runtime/internal/values/TypedescValue");
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 21: 
            case 32: 
            case 37: 
            case 49: {
                jvmType = String.format("L%s;", "java/lang/Object");
                break;
            }
            case 0x7FFFFFFF: {
                jvmType = InteropMethodGen.getJTypeSignature((JType)bType);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM code generation is not supported for type " + String.format("%s", bType));
            }
        }
        return jvmType;
    }
}

