/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.methodgen;

import io.ballerina.runtime.api.utils.IdentifierUtils;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.ScheduleFunctionInfo;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class MethodGenUtils {
    static final String FRAMES = "frames";
    static final String INIT_FUNCTION_SUFFIX = ".<init>";
    static final String STOP_FUNCTION_SUFFIX = ".<stop>";
    static final String START_FUNCTION_SUFFIX = ".<start>";

    static boolean hasInitFunction(BIRNode.BIRPackage pkg) {
        for (BIRNode.BIRFunction func : pkg.functions) {
            if (func == null || !MethodGenUtils.isModuleInitFunction(func)) continue;
            return true;
        }
        return false;
    }

    static boolean isModuleInitFunction(BIRNode.BIRFunction func) {
        return func.name.value.equals(MethodGenUtils.encodeModuleSpecialFuncName(INIT_FUNCTION_SUFFIX));
    }

    static void submitToScheduler(MethodVisitor mv, String moduleClassName, String workerName, AsyncDataCollector asyncDataCollector) {
        String metaDataVarName = JvmCodeGenUtil.getStrandMetadataVarName("main");
        asyncDataCollector.getStrandMetadata().putIfAbsent(metaDataVarName, new ScheduleFunctionInfo("main"));
        mv.visitLdcInsn(workerName);
        mv.visitFieldInsn(178, moduleClassName, metaDataVarName, String.format("L%s;", "io/ballerina/runtime/api/async/StrandMetadata"));
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "scheduleFunction", String.format("([L%s;L%s;L%s;L%s;L%s;L%s;)L%s;", "java/lang/Object", "io/ballerina/runtime/api/values/BFunctionPointer", "io/ballerina/runtime/internal/scheduling/Strand", "io/ballerina/runtime/api/types/Type", "java/lang/String", "io/ballerina/runtime/api/async/StrandMetadata", "io/ballerina/runtime/internal/values/FutureValue"), false);
    }

    static void visitReturn(MethodVisitor mv) {
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static String encodeModuleSpecialFuncName(String funcSuffix) {
        return IdentifierUtils.encodeFunctionIdentifier(funcSuffix);
    }

    static String calculateLambdaStopFuncName(PackageID id) {
        String orgName = id.orgName.value;
        String moduleName = id.name.value;
        String version = id.version.value;
        String funcSuffix = STOP_FUNCTION_SUFFIX;
        String funcName = moduleName.equals("$0046") ? ".." + funcSuffix : (version.equals("") ? moduleName + "." + funcSuffix : moduleName + ":" + version + "." + funcSuffix);
        if (!orgName.equalsIgnoreCase("$anon")) {
            funcName = orgName + "/" + funcName;
        }
        return "$lambda$" + IdentifierUtils.encodeFunctionIdentifier(funcName);
    }

    private MethodGenUtils() {
    }

    static String getFrameClassName(String pkgName, String funcName, BType attachedType) {
        Object frameClassName = pkgName;
        if (MethodGenUtils.isValidType(attachedType)) {
            frameClassName = (String)frameClassName + JvmCodeGenUtil.toNameString(attachedType) + "_";
        }
        return (String)frameClassName + funcName + "Frame";
    }

    private static boolean isValidType(BType attachedType) {
        return attachedType != null && (attachedType.tag == 33 || attachedType.tag == 12);
    }
}

