/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.model;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;
import org.wso2.ballerinalang.compiler.util.Name;

public abstract class BIRNode {
    public final Location pos;

    protected BIRNode(Location pos) {
        this.pos = pos;
    }

    public abstract void accept(BIRVisitor var1);

    public static class BIRMappingConstructorSpreadFieldEntry
    extends BIRMappingConstructorEntry {
        public BIROperand exprOp;

        public BIRMappingConstructorSpreadFieldEntry(BIROperand exprOp) {
            this.exprOp = exprOp;
        }

        @Override
        public boolean isKeyValuePair() {
            return false;
        }
    }

    public static class BIRMappingConstructorKeyValueEntry
    extends BIRMappingConstructorEntry {
        public BIROperand keyOp;
        public BIROperand valueOp;

        public BIRMappingConstructorKeyValueEntry(BIROperand keyOp, BIROperand valueOp) {
            this.keyOp = keyOp;
            this.valueOp = valueOp;
        }
    }

    public static abstract class BIRMappingConstructorEntry {
        public boolean isKeyValuePair() {
            return true;
        }
    }

    public static class BIRLockDetailsHolder {
        private List<BIRTerminator.Lock> locks = new ArrayList<BIRTerminator.Lock>();

        public boolean isEmpty() {
            return this.locks.isEmpty();
        }

        public void removeLastLock() {
            this.locks.remove(this.size() - 1);
        }

        public BIRTerminator.Lock getLock(int index) {
            return this.locks.get(index);
        }

        public void addLock(BIRTerminator.Lock lock) {
            this.locks.add(lock);
        }

        public int size() {
            return this.locks.size();
        }
    }

    public static abstract class BIRDocumentableNode
    extends BIRNode {
        public MarkdownDocAttachment markdownDocAttachment;

        protected BIRDocumentableNode(Location pos) {
            super(pos);
        }

        public void setMarkdownDocAttachment(MarkdownDocAttachment markdownDocAttachment) {
            this.markdownDocAttachment = markdownDocAttachment;
        }
    }

    public static class TaintTable {
        public int columnCount;
        public int rowCount;
        public Map<Integer, List<Byte>> taintTable = new LinkedHashMap<Integer, List<Byte>>();
    }

    public static class ConstValue {
        public BType type;
        public Object value;

        public ConstValue(Object value, BType type) {
            this.value = value;
            this.type = type;
        }
    }

    public static class BIRAnnotationArrayValue
    extends BIRAnnotationValue {
        public BIRAnnotationValue[] annotArrayValue;

        public BIRAnnotationArrayValue(BType type, BIRAnnotationValue[] annotArrayValue) {
            super(type);
            this.annotArrayValue = annotArrayValue;
        }
    }

    public static class BIRAnnotationRecordValue
    extends BIRAnnotationValue {
        public Map<String, BIRAnnotationValue> annotValueEntryMap;

        public BIRAnnotationRecordValue(BType type, Map<String, BIRAnnotationValue> annotValueEntryMap) {
            super(type);
            this.annotValueEntryMap = annotValueEntryMap;
        }
    }

    public static class BIRAnnotationLiteralValue
    extends BIRAnnotationValue {
        public Object value;

        public BIRAnnotationLiteralValue(BType type, Object value) {
            super(type);
            this.value = value;
        }
    }

    public static abstract class BIRAnnotationValue {
        public BType type;

        protected BIRAnnotationValue(BType type) {
            this.type = type;
        }
    }

    public static class BIRAnnotationAttachment
    extends BIRNode {
        public PackageID packageID;
        public Name annotTagRef;
        public List<BIRAnnotationValue> annotValues;

        public BIRAnnotationAttachment(Location pos, Name annotTagRef) {
            super(pos);
            this.annotTagRef = annotTagRef;
            this.annotValues = new ArrayList<BIRAnnotationValue>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRConstant
    extends BIRDocumentableNode {
        public Name name;
        public long flags;
        public BType type;
        public ConstValue constValue;
        public SymbolOrigin origin;

        public BIRConstant(Location pos, Name name, long flags, BType type, ConstValue constValue, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.type = type;
            this.constValue = constValue;
            this.origin = origin;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRAnnotation
    extends BIRDocumentableNode {
        public Name name;
        public long flags;
        public SymbolOrigin origin;
        public Set<AttachPoint> attachPoints;
        public BType annotationType;

        public BIRAnnotation(Location pos, Name name, long flags, Set<AttachPoint> points, BType annotationType, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.attachPoints = points;
            this.annotationType = annotationType;
            this.origin = origin;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ChannelDetails {
        public String name;
        public boolean channelInSameStrand;
        public boolean send;

        public ChannelDetails(String name, boolean channelInSameStrand, boolean send) {
            this.name = name;
            this.channelInSameStrand = channelInSameStrand;
            this.send = send;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class BIRErrorEntry
    extends BIRNode {
        public BIRBasicBlock trapBB;
        public BIRBasicBlock endBB;
        public BIROperand errorOp;
        public BIRBasicBlock targetBB;

        public BIRErrorEntry(BIRBasicBlock trapBB, BIRBasicBlock endBB, BIROperand errorOp, BIRBasicBlock targetBB) {
            super(null);
            this.trapBB = trapBB;
            this.endBB = endBB;
            this.errorOp = errorOp;
            this.targetBB = targetBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRTypeDefinition
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public List<BIRFunction> attachedFuncs;
        public long flags;
        public BType type;
        public boolean isLabel;
        public boolean isBuiltin;
        public List<BType> referencedTypes;
        public SymbolOrigin origin;
        public int index;

        public BIRTypeDefinition(Location pos, Name name, long flags, boolean isLabel, boolean isBuiltin, BType type, List<BIRFunction> attachedFuncs, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.isLabel = isLabel;
            this.isBuiltin = isBuiltin;
            this.type = type;
            this.attachedFuncs = attachedFuncs;
            this.referencedTypes = new ArrayList<BType>();
            this.origin = origin;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.type + " " + this.name;
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRBasicBlock
    extends BIRNode {
        public Name id;
        public List<BIRNonTerminator> instructions;
        public BIRTerminator terminator;

        public BIRBasicBlock(Name id) {
            super(null);
            this.id = id;
            this.instructions = new ArrayList<BIRNonTerminator>();
            this.terminator = null;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.id.value;
        }
    }

    public static class BIRFunction
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public long flags;
        public SymbolOrigin origin;
        public BInvokableType type;
        public List<BIRParameter> requiredParams;
        public BIRVariableDcl receiver;
        public BIRParameter restParam;
        public int argsCount;
        public List<BIRVariableDcl> localVars;
        public BIRVariableDcl returnVariable;
        public Map<BIRFunctionParameter, List<BIRBasicBlock>> parameters;
        public List<BIRBasicBlock> basicBlocks;
        public List<BIRErrorEntry> errorTable;
        public Name workerName;
        public ChannelDetails[] workerChannels;
        public TaintTable taintTable;
        public List<BIRAnnotationAttachment> annotAttachments;
        public Set<BIRGlobalVariableDcl> dependentGlobalVars = new TreeSet<BIRGlobalVariableDcl>();

        public BIRFunction(Location pos, Name name, long flags, BInvokableType type, Name workerName, int sendInsCount, TaintTable taintTable, SymbolOrigin origin) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.type = type;
            this.localVars = new ArrayList<BIRVariableDcl>();
            this.parameters = new LinkedHashMap<BIRFunctionParameter, List<BIRBasicBlock>>();
            this.requiredParams = new ArrayList<BIRParameter>();
            this.basicBlocks = new ArrayList<BIRBasicBlock>();
            this.errorTable = new ArrayList<BIRErrorEntry>();
            this.workerName = workerName;
            this.workerChannels = new ChannelDetails[sendInsCount];
            this.taintTable = taintTable;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
            this.origin = origin;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public BIRFunction duplicate() {
            BIRFunction f = new BIRFunction(this.pos, this.name, this.flags, this.type, this.workerName, 0, this.taintTable, this.origin);
            f.localVars = this.localVars;
            f.parameters = this.parameters;
            f.requiredParams = this.requiredParams;
            f.basicBlocks = this.basicBlocks;
            f.errorTable = this.errorTable;
            f.workerChannels = this.workerChannels;
            f.annotAttachments = this.annotAttachments;
            return f;
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRFunctionParameter
    extends BIRVariableDcl {
        public final boolean hasDefaultExpr;

        public BIRFunctionParameter(Location pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName, boolean hasDefaultExpr) {
            super(pos, type, name, scope, kind, metaVarName);
            this.hasDefaultExpr = hasDefaultExpr;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRGlobalVariableDcl
    extends BIRVariableDcl {
        public long flags;
        public PackageID pkgId;
        public SymbolOrigin origin;

        public BIRGlobalVariableDcl(Location pos, long flags, BType type, PackageID pkgId, Name name, VarScope scope, VarKind kind, String metaVarName, SymbolOrigin origin) {
            super(pos, type, name, scope, kind, metaVarName);
            this.flags = flags;
            this.pkgId = pkgId;
            this.origin = origin;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRParameter
    extends BIRNode {
        public Name name;
        public long flags;

        public BIRParameter(Location pos, Name name, long flags) {
            super(pos);
            this.name = name;
            this.flags = flags;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRVariableDcl
    extends BIRDocumentableNode {
        public BType type;
        public Name name;
        public String metaVarName;
        public VarKind kind;
        public VarScope scope;
        public boolean ignoreVariable;
        public BIRBasicBlock endBB;
        public BIRBasicBlock startBB;
        public int insOffset;
        public BirScope insScope;

        public BIRVariableDcl(Location pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName) {
            super(pos);
            this.type = type;
            this.name = name;
            this.scope = scope;
            this.kind = kind;
            this.metaVarName = metaVarName;
        }

        public BIRVariableDcl(BType type, Name name, VarScope scope, VarKind kind) {
            this(null, type, name, scope, kind, null);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BIRVariableDcl)) {
                return false;
            }
            BIRVariableDcl otherVarDecl = (BIRVariableDcl)other;
            return this.name.equals(otherVarDecl.name);
        }

        public int hashCode() {
            return this.name.value.hashCode();
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static class BIRImportModule
    extends BIRNode {
        public final PackageID packageID;

        public BIRImportModule(Location pos, Name org, Name name, Name version) {
            super(pos);
            this.packageID = new PackageID(org, name, version);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRPackage
    extends BIRNode {
        public final PackageID packageID;
        public final List<BIRImportModule> importModules;
        public final List<BIRTypeDefinition> typeDefs;
        public final List<BIRGlobalVariableDcl> globalVars;
        public final List<BIRFunction> functions;
        public final List<BIRAnnotation> annotations;
        public final List<BIRConstant> constants;

        public BIRPackage(Location pos, Name org, Name name, Name version, Name sourceFileName) {
            super(pos);
            this.packageID = new PackageID(org, name, version, sourceFileName);
            this.importModules = new ArrayList<BIRImportModule>();
            this.typeDefs = new ArrayList<BIRTypeDefinition>();
            this.globalVars = new ArrayList<BIRGlobalVariableDcl>();
            this.functions = new ArrayList<BIRFunction>();
            this.annotations = new ArrayList<BIRAnnotation>();
            this.constants = new ArrayList<BIRConstant>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }
}

