/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.model;

import io.ballerina.tools.diagnostics.Location;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRAssignInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.util.Name;

public abstract class BIRTerminator
extends BIRAbstractInstruction
implements BIRInstruction {
    public BIRNode.BIRBasicBlock thenBB;

    public BIRTerminator(Location pos, InstructionKind kind) {
        super(pos, kind);
        this.kind = kind;
    }

    @Override
    public InstructionKind getKind() {
        return this.kind;
    }

    public abstract BIRNode.BIRBasicBlock[] getNextBasicBlocks();

    public static class WaitAll
    extends BIRTerminator {
        public List<String> keys;
        public List<BIROperand> valueExprs;

        public WaitAll(Location pos, BIROperand lhsOp, List<String> keys, List<BIROperand> valueExprs, BIRNode.BIRBasicBlock thenBB) {
            super(pos, InstructionKind.WAIT_ALL);
            this.lhsOp = lhsOp;
            this.keys = keys;
            this.valueExprs = valueExprs;
            this.thenBB = thenBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return this.valueExprs.toArray(new BIROperand[0]);
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class WorkerSend
    extends BIRTerminator {
        public Name channel;
        public BIROperand data;
        public boolean isSameStrand;
        public boolean isSync;

        public WorkerSend(Location location, Name workerName, BIROperand data, boolean isSameStrand, boolean isSync, BIROperand lhsOp, BIRNode.BIRBasicBlock thenBB) {
            super(location, InstructionKind.WK_SEND);
            this.channel = workerName;
            this.data = data;
            this.thenBB = thenBB;
            this.lhsOp = lhsOp;
            this.isSameStrand = isSameStrand;
            this.isSync = isSync;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[]{this.data};
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class WorkerReceive
    extends BIRTerminator {
        public Name workerName;
        public boolean isSameStrand;

        public WorkerReceive(Location pos, Name workerName, BIROperand lhsOp, boolean isSameStrand, BIRNode.BIRBasicBlock thenBB) {
            super(pos, InstructionKind.WK_RECEIVE);
            this.workerName = workerName;
            this.thenBB = thenBB;
            this.isSameStrand = isSameStrand;
            this.lhsOp = lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class Flush
    extends BIRTerminator {
        public BIRNode.ChannelDetails[] channels;

        public Flush(Location pos, BIRNode.ChannelDetails[] channels, BIROperand lhsOp, BIRNode.BIRBasicBlock thenBB) {
            super(pos, InstructionKind.FLUSH);
            this.channels = channels;
            this.lhsOp = lhsOp;
            this.thenBB = thenBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class Wait
    extends BIRTerminator {
        public List<BIROperand> exprList;

        public Wait(Location pos, List<BIROperand> exprList, BIROperand lhsOp, BIRNode.BIRBasicBlock thenBB) {
            super(pos, InstructionKind.WAIT);
            this.exprList = exprList;
            this.lhsOp = lhsOp;
            this.thenBB = thenBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return this.exprList.toArray(new BIROperand[0]);
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class Panic
    extends BIRTerminator {
        public BIROperand errorOp;

        public Panic(Location pos, BIROperand errorOp) {
            super(pos, InstructionKind.PANIC);
            this.errorOp = errorOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[]{this.errorOp};
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[0];
        }
    }

    public static class Unlock
    extends BIRTerminator {
        public final BIRNode.BIRBasicBlock unlockBB;
        public Lock relatedLock;

        public Unlock(Location pos, BIRNode.BIRBasicBlock unlockBB) {
            super(pos, InstructionKind.UNLOCK);
            this.unlockBB = unlockBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.unlockBB};
        }
    }

    public static class FieldLock
    extends BIRTerminator {
        public BIROperand localVar;
        public String field;
        public final BIRNode.BIRBasicBlock lockedBB;

        public FieldLock(Location pos, BIROperand localVar, String field, BIRNode.BIRBasicBlock lockedBB) {
            super(pos, InstructionKind.FIELD_LOCK);
            this.localVar = localVar;
            this.field = field;
            this.lockedBB = lockedBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[]{this.localVar};
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.lockedBB};
        }
    }

    public static class Lock
    extends BIRTerminator {
        public final BIRNode.BIRBasicBlock lockedBB;
        public Set<BIRNode.BIRGlobalVariableDcl> lockVariables = new HashSet<BIRNode.BIRGlobalVariableDcl>();
        public Integer lockId = -1;

        public Lock(Location pos, BIRNode.BIRBasicBlock lockedBB) {
            super(pos, InstructionKind.LOCK);
            this.lockedBB = lockedBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.lockedBB};
        }
    }

    public static class Branch
    extends BIRTerminator {
        public BIROperand op;
        public BIRNode.BIRBasicBlock trueBB;
        public BIRNode.BIRBasicBlock falseBB;

        public Branch(Location pos, BIROperand op, BIRNode.BIRBasicBlock trueBB, BIRNode.BIRBasicBlock falseBB) {
            super(pos, InstructionKind.BRANCH);
            this.op = op;
            this.trueBB = trueBB;
            this.falseBB = falseBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[]{this.op};
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.trueBB, this.falseBB};
        }
    }

    public static class Return
    extends BIRTerminator {
        public Return(Location pos) {
            super(pos, InstructionKind.RETURN);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[0];
        }
    }

    public static class FPCall
    extends BIRTerminator {
        public BIROperand fp;
        public List<BIROperand> args;
        public boolean isAsync;

        public FPCall(Location pos, InstructionKind kind, BIROperand fp, List<BIROperand> args, BIROperand lhsOp, boolean isAsync, BIRNode.BIRBasicBlock thenBB) {
            super(pos, kind);
            this.fp = fp;
            this.lhsOp = lhsOp;
            this.args = args;
            this.isAsync = isAsync;
            this.thenBB = thenBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            BIROperand[] operands = new BIROperand[this.args.size() + 1];
            operands[0] = this.fp;
            int i = 1;
            for (BIROperand operand : this.args) {
                operands[i++] = operand;
            }
            return operands;
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class AsyncCall
    extends Call {
        public List<BIRNode.BIRAnnotationAttachment> annotAttachments;

        public AsyncCall(Location pos, InstructionKind kind, boolean isVirtual, PackageID calleePkg, Name name, List<BIROperand> args, BIROperand lhsOp, BIRNode.BIRBasicBlock thenBB, List<BIRNode.BIRAnnotationAttachment> annotAttachments, List<BIRNode.BIRAnnotationAttachment> calleeAnnotAttachments, Set<Flag> calleeFlags) {
            super(pos, kind, isVirtual, calleePkg, name, args, lhsOp, thenBB, calleeAnnotAttachments, calleeFlags);
            this.annotAttachments = annotAttachments;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Call
    extends BIRTerminator
    implements BIRAssignInstruction {
        public boolean isVirtual;
        public List<BIROperand> args;
        public Name name;
        public PackageID calleePkg;
        public List<BIRNode.BIRAnnotationAttachment> calleeAnnotAttachments;
        public Set<Flag> calleeFlags;

        public Call(Location pos, InstructionKind kind, boolean isVirtual, PackageID calleePkg, Name name, List<BIROperand> args, BIROperand lhsOp, BIRNode.BIRBasicBlock thenBB, List<BIRNode.BIRAnnotationAttachment> calleeAnnotAttachments, Set<Flag> calleeFlags) {
            super(pos, kind);
            this.lhsOp = lhsOp;
            this.isVirtual = isVirtual;
            this.args = args;
            this.thenBB = thenBB;
            this.name = name;
            this.calleePkg = calleePkg;
            this.calleeAnnotAttachments = calleeAnnotAttachments;
            this.calleeFlags = calleeFlags;
        }

        @Override
        public BIROperand getLhsOperand() {
            return this.lhsOp;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return this.args.toArray(new BIROperand[0]);
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.thenBB};
        }
    }

    public static class GOTO
    extends BIRTerminator {
        public BIRNode.BIRBasicBlock targetBB;

        public GOTO(Location pos, BIRNode.BIRBasicBlock targetBB) {
            super(pos, InstructionKind.GOTO);
            this.targetBB = targetBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public BIROperand[] getRhsOperands() {
            return new BIROperand[0];
        }

        @Override
        public BIRNode.BIRBasicBlock[] getNextBasicBlocks() {
            return new BIRNode.BIRBasicBlock[]{this.targetBB};
        }
    }
}

