/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.optimizer.ControlFlowGraph;

public class LivenessAnalyzer {
    private final Map<ControlFlowGraph.Node, Set<BIRNode.BIRVariableDcl>> liveIns = new HashMap<ControlFlowGraph.Node, Set<BIRNode.BIRVariableDcl>>();
    private final Map<ControlFlowGraph.Node, Set<BIRNode.BIRVariableDcl>> liveOuts = new HashMap<ControlFlowGraph.Node, Set<BIRNode.BIRVariableDcl>>();
    private final List<ControlFlowGraph.Node> nodes;

    public LivenessAnalyzer(List<ControlFlowGraph.Node> nodes) {
        this.nodes = nodes;
        this.init();
    }

    private void init() {
        this.nodes.forEach(node -> {
            this.liveIns.put((ControlFlowGraph.Node)node, new HashSet());
            this.liveOuts.put((ControlFlowGraph.Node)node, new HashSet());
        });
        this.analyze();
    }

    private void analyze() {
        if (this.nodes.isEmpty()) {
            return;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                ControlFlowGraph.Node node = this.nodes.get(i);
                changed |= this.updateLiveIns(node);
                changed |= this.updateLiveOuts(node);
            }
        }
    }

    private boolean updateLiveIns(ControlFlowGraph.Node node) {
        boolean changed = false;
        Set<BIRNode.BIRVariableDcl> in = this.liveIns.get(node);
        Set<BIRNode.BIRVariableDcl> out = this.liveOuts.get(node);
        for (BIROperand use : node.instruction.getRhsOperands()) {
            changed |= in.add(use.variableDcl);
        }
        BIRNode.BIRVariableDcl def = this.getDef(node);
        boolean removed = out.remove(def);
        changed |= in.addAll(out);
        if (removed) {
            out.add(def);
        }
        return changed;
    }

    private BIRNode.BIRVariableDcl getDef(ControlFlowGraph.Node node) {
        BIRNode.BIRVariableDcl def = null;
        if (node.instruction.lhsOp != null) {
            BIRNode.BIRVariableDcl variableDcl = node.instruction.lhsOp.variableDcl;
            if (variableDcl.kind != VarKind.GLOBAL) {
                def = variableDcl;
            }
        }
        return def;
    }

    private boolean updateLiveOuts(ControlFlowGraph.Node node) {
        boolean changed = false;
        for (ControlFlowGraph.Node successor : node.successors) {
            changed |= this.liveOuts.get(node).addAll((Collection<BIRNode.BIRVariableDcl>)this.liveIns.get(successor));
        }
        return changed;
    }

    public Map<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> getInstructionLiveOuts() {
        HashMap<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>> map = new HashMap<BIRAbstractInstruction, Set<BIRNode.BIRVariableDcl>>();
        this.liveOuts.forEach((node, var) -> map.put(node.instruction, (Set<BIRNode.BIRVariableDcl>)var));
        return map;
    }
}

