/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRInstructionWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRTypeWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRWriterUtils;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class BIRBinaryWriter {
    private final ConstantPool cp = new ConstantPool();
    private final BIRNode.BIRPackage birPackage;

    public BIRBinaryWriter(BIRNode.BIRPackage birPackage) {
        this.birPackage = birPackage;
    }

    public byte[] serialize() {
        byte[] byArray;
        ByteBuf birbuf = Unpooled.buffer();
        BIRTypeWriter typeWriter = new BIRTypeWriter(birbuf, this.cp);
        birbuf.writeInt(BIRWriterUtils.addPkgCPEntry(this.birPackage.packageID, this.cp));
        this.writeImportModuleDecls(birbuf, this.birPackage.importModules);
        this.writeConstants(birbuf, this.birPackage.constants);
        this.writeTypeDefs(birbuf, typeWriter, this.birPackage.typeDefs);
        this.writeGlobalVars(birbuf, typeWriter, this.birPackage.globalVars);
        this.writeTypeDefBodies(birbuf, typeWriter, this.birPackage.typeDefs);
        this.writeFunctions(birbuf, typeWriter, this.birPackage.functions);
        this.writeAnnotations(birbuf, typeWriter, this.birPackage.annotations);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(baos);
        try {
            dataOut.write(this.cp.serialize());
            dataOut.write(birbuf.nioBuffer().array(), 0, birbuf.nioBuffer().limit());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BLangCompilerException("failed to serialize the bir", e);
            }
        }
        dataOut.close();
        return byArray;
    }

    private void writeImportModuleDecls(ByteBuf buf, List<BIRNode.BIRImportModule> birImpModList) {
        buf.writeInt(birImpModList.size());
        birImpModList.forEach(impMod -> {
            PackageID packageID = impMod.packageID;
            buf.writeInt(this.addStringCPEntry(packageID.orgName.getValue()));
            buf.writeInt(this.addStringCPEntry(packageID.name.getValue()));
            buf.writeInt(this.addStringCPEntry(packageID.version.getValue()));
        });
    }

    private void writeTypeDefs(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        buf.writeInt(birTypeDefList.size());
        birTypeDefList.forEach(typeDef -> this.writeType(buf, typeWriter, (BIRNode.BIRTypeDefinition)typeDef));
    }

    private void writeTypeDefBodies(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        List<BIRNode.BIRTypeDefinition> filtered = birTypeDefList.stream().filter(t -> t.type.tag == 33 || t.type.tag == 12).collect(Collectors.toList());
        buf.writeInt(filtered.size());
        filtered.forEach(typeDef -> {
            this.writeFunctions(buf, typeWriter, typeDef.attachedFuncs);
            this.writeReferencedTypes(buf, typeDef.referencedTypes);
        });
    }

    private void writeReferencedTypes(ByteBuf buf, List<BType> referencedTypes) {
        buf.writeInt(referencedTypes.size());
        referencedTypes.forEach(type -> this.writeType(buf, (BType)type));
    }

    private void writeGlobalVars(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRGlobalVariableDcl> birGlobalVars) {
        buf.writeInt(birGlobalVars.size());
        for (BIRNode.BIRGlobalVariableDcl birGlobalVar : birGlobalVars) {
            buf.writeByte(birGlobalVar.kind.getValue());
            buf.writeInt(this.addStringCPEntry(birGlobalVar.name.value));
            buf.writeLong(birGlobalVar.flags);
            buf.writeByte(birGlobalVar.origin.value());
            typeWriter.writeMarkdownDocAttachment(buf, birGlobalVar.markdownDocAttachment);
            this.writeType(buf, birGlobalVar.type);
        }
    }

    private void writeType(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRTypeDefinition typeDef) {
        this.writePosition(buf, typeDef.pos);
        buf.writeInt(this.addStringCPEntry(typeDef.name.value));
        buf.writeLong(typeDef.flags);
        buf.writeByte(typeDef.isLabel ? 1 : 0);
        buf.writeByte(typeDef.origin.value());
        typeWriter.writeMarkdownDocAttachment(buf, typeDef.markdownDocAttachment);
        this.writeType(buf, typeDef.type);
    }

    private void writeFunctions(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRFunction> birFunctionList) {
        buf.writeInt(birFunctionList.size());
        birFunctionList.forEach(func -> this.writeFunction(buf, typeWriter, (BIRNode.BIRFunction)func));
    }

    private void writeFunction(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRFunction birFunction) {
        this.writePosition(buf, birFunction.pos);
        buf.writeInt(this.addStringCPEntry(birFunction.name.value));
        buf.writeInt(this.addStringCPEntry(birFunction.workerName.value));
        buf.writeLong(birFunction.flags);
        buf.writeByte(birFunction.origin.value());
        this.writeType(buf, birFunction.type);
        this.writeAnnotAttachments(buf, birFunction.annotAttachments);
        buf.writeInt(birFunction.requiredParams.size());
        for (BIRNode.BIRParameter parameter : birFunction.requiredParams) {
            buf.writeInt(this.addStringCPEntry(parameter.name.value));
            buf.writeLong(parameter.flags);
        }
        boolean restParamExist = birFunction.restParam != null;
        buf.writeBoolean(restParamExist);
        if (restParamExist) {
            buf.writeInt(this.addStringCPEntry(birFunction.restParam.name.value));
        }
        boolean hasReceiverType = birFunction.receiver != null;
        buf.writeBoolean(hasReceiverType);
        if (hasReceiverType) {
            buf.writeByte(birFunction.receiver.kind.getValue());
            this.writeType(buf, birFunction.receiver.type);
            buf.writeInt(this.addStringCPEntry(birFunction.receiver.name.value));
        }
        this.writeTaintTable(buf, birFunction.taintTable);
        typeWriter.writeMarkdownDocAttachment(buf, birFunction.markdownDocAttachment);
        this.writeFunctionsGlobalVarDependency(buf, birFunction);
        ByteBuf birbuf = Unpooled.buffer();
        ByteBuf scopebuf = Unpooled.buffer();
        BIRInstructionWriter funcInsWriter = new BIRInstructionWriter(birbuf, scopebuf, this.cp, this);
        birbuf.writeInt(birFunction.argsCount);
        birbuf.writeBoolean(birFunction.returnVariable != null);
        if (birFunction.returnVariable != null) {
            birbuf.writeByte(birFunction.returnVariable.kind.getValue());
            this.writeType(birbuf, birFunction.returnVariable.type);
            birbuf.writeInt(this.addStringCPEntry(birFunction.returnVariable.name.value));
        }
        birbuf.writeInt(birFunction.parameters.size());
        for (BIRNode.BIRFunctionParameter param : birFunction.parameters.keySet()) {
            birbuf.writeByte(param.kind.getValue());
            this.writeType(birbuf, param.type);
            birbuf.writeInt(this.addStringCPEntry(param.name.value));
            if (param.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(param.metaVarName != null ? param.metaVarName : ""));
            }
            birbuf.writeBoolean(param.hasDefaultExpr);
        }
        birbuf.writeInt(birFunction.localVars.size());
        for (BIRNode.BIRVariableDcl localVar : birFunction.localVars) {
            birbuf.writeByte(localVar.kind.getValue());
            this.writeType(birbuf, localVar.type);
            birbuf.writeInt(this.addStringCPEntry(localVar.name.value));
            if (localVar.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(localVar.metaVarName != null ? localVar.metaVarName : ""));
            }
            if (!localVar.kind.equals((Object)VarKind.LOCAL)) continue;
            birbuf.writeInt(this.addStringCPEntry(localVar.metaVarName != null ? localVar.metaVarName : ""));
            birbuf.writeInt(this.addStringCPEntry(localVar.endBB != null ? localVar.endBB.id.value : ""));
            birbuf.writeInt(this.addStringCPEntry(localVar.startBB != null ? localVar.startBB.id.value : ""));
            birbuf.writeInt(localVar.insOffset);
        }
        birFunction.parameters.values().forEach(funcInsWriter::writeBBs);
        funcInsWriter.writeBBs(birFunction.basicBlocks);
        funcInsWriter.writeErrorTable(birFunction.errorTable);
        birbuf.writeInt(birFunction.workerChannels.length);
        for (Iterator<BIRNode.BIRVariableDcl> iterator : birFunction.workerChannels) {
            birbuf.writeInt(this.addStringCPEntry(((BIRNode.ChannelDetails)((Object)iterator)).name));
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).channelInSameStrand);
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).send);
        }
        this.writeScopes(buf, scopebuf, funcInsWriter.getScopeCount());
        int length = birbuf.nioBuffer().limit();
        buf.writeLong(length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeFunctionsGlobalVarDependency(ByteBuf buf, BIRNode.BIRFunction birFunction) {
        buf.writeInt(birFunction.dependentGlobalVars.size());
        for (BIRNode.BIRVariableDcl bIRVariableDcl : birFunction.dependentGlobalVars) {
            buf.writeInt(this.addStringCPEntry(bIRVariableDcl.name.value));
        }
    }

    private void writeScopes(ByteBuf buf, ByteBuf scopebuf, int scopeCount) {
        int length = scopebuf.nioBuffer().limit();
        buf.writeLong(length + 4);
        buf.writeInt(scopeCount);
        buf.writeBytes(scopebuf.nioBuffer().array(), 0, length);
    }

    private void writeTaintTable(ByteBuf buf, BIRNode.TaintTable taintTable) {
        ByteBuf birbuf = Unpooled.buffer();
        birbuf.writeShort(taintTable.rowCount);
        birbuf.writeShort(taintTable.columnCount);
        birbuf.writeInt(taintTable.taintTable.size());
        for (Integer paramIndex : taintTable.taintTable.keySet()) {
            birbuf.writeShort(paramIndex);
            List<Byte> taintRecord = taintTable.taintTable.get(paramIndex);
            birbuf.writeInt(taintRecord.size());
            for (Byte taintStatus : taintRecord) {
                birbuf.writeByte(taintStatus.byteValue());
            }
        }
        int length = birbuf.nioBuffer().limit();
        buf.writeLong(length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeAnnotations(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRAnnotation> birAnnotationList) {
        buf.writeInt(birAnnotationList.size());
        birAnnotationList.forEach(annotation -> this.writeAnnotation(buf, typeWriter, (BIRNode.BIRAnnotation)annotation));
    }

    private void writeAnnotation(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRAnnotation birAnnotation) {
        buf.writeInt(this.addStringCPEntry(birAnnotation.name.value));
        buf.writeLong(birAnnotation.flags);
        buf.writeByte(birAnnotation.origin.value());
        this.writePosition(buf, birAnnotation.pos);
        buf.writeInt(birAnnotation.attachPoints.size());
        for (AttachPoint attachPoint : birAnnotation.attachPoints) {
            buf.writeInt(this.addStringCPEntry(attachPoint.point.getValue()));
            buf.writeBoolean(attachPoint.source);
        }
        this.writeType(buf, birAnnotation.annotationType);
        typeWriter.writeMarkdownDocAttachment(buf, birAnnotation.markdownDocAttachment);
    }

    private void writeConstants(ByteBuf buf, List<BIRNode.BIRConstant> birConstList) {
        BIRTypeWriter constTypeWriter = new BIRTypeWriter(buf, this.cp);
        buf.writeInt(birConstList.size());
        birConstList.forEach(constant -> this.writeConstant(buf, constTypeWriter, (BIRNode.BIRConstant)constant));
    }

    private void writeConstant(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRConstant birConstant) {
        buf.writeInt(this.addStringCPEntry(birConstant.name.value));
        buf.writeLong(birConstant.flags);
        buf.writeByte(birConstant.origin.value());
        this.writePosition(buf, birConstant.pos);
        typeWriter.writeMarkdownDocAttachment(buf, birConstant.markdownDocAttachment);
        this.writeType(buf, birConstant.type);
        ByteBuf birbuf = Unpooled.buffer();
        this.writeConstValue(birbuf, birConstant.constValue);
        int length = birbuf.nioBuffer().limit();
        buf.writeLong(length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeConstValue(ByteBuf buf, BIRNode.ConstValue constValue) {
        this.writeType(buf, constValue.type);
        switch (constValue.type.tag) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                buf.writeInt(this.addIntCPEntry((Long)constValue.value));
                break;
            }
            case 2: {
                int byteValue = ((Number)constValue.value).intValue();
                buf.writeInt(this.addByteCPEntry(byteValue));
                break;
            }
            case 3: {
                double doubleVal = constValue.value instanceof String ? Double.parseDouble((String)constValue.value) : (Double)constValue.value;
                buf.writeInt(this.addFloatCPEntry(doubleVal));
                break;
            }
            case 4: 
            case 5: 
            case 44: {
                buf.writeInt(this.addStringCPEntry((String)constValue.value));
                break;
            }
            case 6: {
                buf.writeBoolean((Boolean)constValue.value);
                break;
            }
            case 10: {
                break;
            }
            case 15: {
                Map mapConstVal = (Map)constValue.value;
                buf.writeInt(mapConstVal.size());
                mapConstVal.forEach((key, value) -> {
                    buf.writeInt(this.addStringCPEntry((String)key));
                    this.writeConstValue(buf, (BIRNode.ConstValue)value);
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + constValue.type);
            }
        }
    }

    private int addIntCPEntry(long value) {
        return this.cp.addCPEntry(new CPEntry.IntegerCPEntry(value));
    }

    private int addFloatCPEntry(double value) {
        return this.cp.addCPEntry(new CPEntry.FloatCPEntry(value));
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private int addByteCPEntry(int value) {
        return this.cp.addCPEntry(new CPEntry.ByteCPEntry(value));
    }

    private void writeType(ByteBuf buf, BType type) {
        buf.writeInt(this.cp.addShapeCPEntry(type));
    }

    void writeAnnotAttachments(ByteBuf buff, List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ByteBuf annotBuf = Unpooled.buffer();
        annotBuf.writeInt(annotAttachments.size());
        for (BIRNode.BIRAnnotationAttachment annotAttachment : annotAttachments) {
            this.writeAnnotAttachment(annotBuf, annotAttachment);
        }
        int length = annotBuf.nioBuffer().limit();
        buff.writeLong(length);
        buff.writeBytes(annotBuf.nioBuffer().array(), 0, length);
    }

    private void writeAnnotAttachment(ByteBuf annotBuf, BIRNode.BIRAnnotationAttachment annotAttachment) {
        annotBuf.writeInt(BIRWriterUtils.addPkgCPEntry(annotAttachment.packageID, this.cp));
        this.writePosition(annotBuf, annotAttachment.pos);
        annotBuf.writeInt(this.addStringCPEntry(annotAttachment.annotTagRef.value));
        this.writeAnnotAttachValues(annotBuf, annotAttachment.annotValues);
    }

    private void writeAnnotAttachValues(ByteBuf annotBuf, List<BIRNode.BIRAnnotationValue> annotValues) {
        annotBuf.writeInt(annotValues.size());
        for (BIRNode.BIRAnnotationValue annotValue : annotValues) {
            this.writeAnnotAttachValue(annotBuf, annotValue);
        }
    }

    private void writeAnnotAttachValue(ByteBuf annotBuf, BIRNode.BIRAnnotationValue annotValue) {
        if (annotValue.type.tag == 19) {
            this.writeType(annotBuf, annotValue.type);
            BIRNode.BIRAnnotationArrayValue annotArrayValue = (BIRNode.BIRAnnotationArrayValue)annotValue;
            annotBuf.writeInt(annotArrayValue.annotArrayValue.length);
            for (BIRNode.BIRAnnotationValue annotValueEntry : annotArrayValue.annotArrayValue) {
                this.writeAnnotAttachValue(annotBuf, annotValueEntry);
            }
        } else if (annotValue.type.tag == 12 || annotValue.type.tag == 15) {
            this.writeType(annotBuf, annotValue.type);
            BIRNode.BIRAnnotationRecordValue annotRecValue = (BIRNode.BIRAnnotationRecordValue)annotValue;
            annotBuf.writeInt(annotRecValue.annotValueEntryMap.size());
            for (Map.Entry<String, BIRNode.BIRAnnotationValue> annotValueEntry : annotRecValue.annotValueEntryMap.entrySet()) {
                annotBuf.writeInt(this.addStringCPEntry(annotValueEntry.getKey()));
                this.writeAnnotAttachValue(annotBuf, annotValueEntry.getValue());
            }
        } else {
            BIRNode.BIRAnnotationLiteralValue annotLiteralValue = (BIRNode.BIRAnnotationLiteralValue)annotValue;
            this.writeConstValue(annotBuf, new BIRNode.ConstValue(annotLiteralValue.value, annotLiteralValue.type));
        }
    }

    private void writePosition(ByteBuf buf, Location pos) {
        BIRWriterUtils.writePosition(pos, buf, this.cp);
    }
}

