/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.netty.buffer.ByteBuf;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;

public class BIRWriterUtils {
    public static void writePosition(Location pos, ByteBuf buf, ConstantPool cp) {
        int sLine = Integer.MIN_VALUE;
        int eLine = Integer.MIN_VALUE;
        int sCol = Integer.MIN_VALUE;
        int eCol = Integer.MIN_VALUE;
        String sourceFileName = "";
        if (pos != null) {
            sLine = pos.lineRange().startLine().line();
            eLine = pos.lineRange().endLine().line();
            sCol = pos.lineRange().startLine().offset();
            eCol = pos.lineRange().endLine().offset();
            if (pos.lineRange().filePath() != null) {
                sourceFileName = pos.lineRange().filePath();
            }
        }
        buf.writeInt(BIRWriterUtils.addStringCPEntry(sourceFileName, cp));
        buf.writeInt(sLine);
        buf.writeInt(sCol);
        buf.writeInt(eLine);
        buf.writeInt(eCol);
    }

    public static int addStringCPEntry(String value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    public static int addPkgCPEntry(PackageID packageID, ConstantPool cp) {
        int orgCPIndex = BIRWriterUtils.addStringCPEntry(packageID.orgName.getValue(), cp);
        int nameCPIndex = BIRWriterUtils.addStringCPEntry(packageID.name.getValue(), cp);
        int versionCPIndex = BIRWriterUtils.addStringCPEntry(packageID.version.getValue(), cp);
        return cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
    }
}

