/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class AnnotationDesugar {
    public static final String ANNOTATION_DATA = "$annotation_data";
    private static final String ANNOT_FUNC = "$annot_func$";
    public static final String BUILTIN_PKG_KEY = "ballerina/builtin";
    public static final String DEFAULTABLE_ANN = "DefaultableArgs";
    public static final String DEFAULTABLE_REC = "ArgsData";
    public static final String ARG_NAMES = "args";
    private static final String DOT = ".";
    private static final String FIELD = "$field$";
    private static final String PARAM = "$param$";
    private static final String RETURNS = "$returns$";
    private BLangSimpleVariable annotationMap;
    private int annotFuncCount = 0;
    private static final CompilerContext.Key<AnnotationDesugar> ANNOTATION_DESUGAR_KEY = new CompilerContext.Key();
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final Types types;
    private final Names names;
    private SymbolResolver symResolver;

    public static AnnotationDesugar getInstance(CompilerContext context) {
        AnnotationDesugar annotationDesugar = context.get(ANNOTATION_DESUGAR_KEY);
        if (annotationDesugar == null) {
            annotationDesugar = new AnnotationDesugar(context);
        }
        return annotationDesugar;
    }

    private AnnotationDesugar(CompilerContext context) {
        context.put(ANNOTATION_DESUGAR_KEY, this);
        this.desugar = Desugar.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
    }

    void initializeAnnotationMap(BLangPackage pkgNode) {
        this.annotationMap = this.createGlobalAnnotationMapVar(pkgNode);
    }

    void rewritePackageAnnotations(BLangPackage pkgNode, SymbolEnv env) {
        BLangFunction initFunction = pkgNode.initFunction;
        this.defineTypeAnnotations(pkgNode, env, initFunction);
        this.defineClassAnnotations(pkgNode, env, initFunction);
        this.defineFunctionAnnotations(pkgNode, env, initFunction);
    }

    private void defineClassAnnotations(BLangPackage pkgNode, SymbolEnv env, BLangFunction initFunction) {
        List<TopLevelNode> topLevelNodes = pkgNode.topLevelNodes;
        int topLevelNodesSize = topLevelNodes.size();
        for (int i = 0; i < topLevelNodesSize; ++i) {
            TopLevelNode topLevelNode = topLevelNodes.get(i);
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            BLangClassDefinition classDefinition = (BLangClassDefinition)topLevelNode;
            PackageID pkgID = classDefinition.symbol.pkgID;
            BSymbol owner = classDefinition.symbol.owner;
            SymbolEnv classEnv = SymbolEnv.createClassEnv(classDefinition, initFunction.symbol.scope, env);
            BLangLambdaFunction lambdaFunction = this.defineAnnotations(classDefinition, pkgNode, classEnv, pkgID, owner);
            if (lambdaFunction == null) continue;
            BType type = classDefinition.type;
            if (Symbols.isService(type.tsymbol) || Symbols.isFlagOn(type.flags, 0x100000000L)) {
                BLangBlockStmt target = (BLangBlockStmt)TreeBuilder.createBlockNode();
                BLangBlockFunctionBody initBody = (BLangBlockFunctionBody)initFunction.body;
                target.pos = initBody.pos;
                this.addLambdaToGlobalAnnotMap(classDefinition.name.value, lambdaFunction, target);
                int index = this.calculateIndex(initBody.stmts, type.tsymbol);
                for (BLangStatement stmt : target.stmts) {
                    initBody.stmts.add(index++, stmt);
                }
                continue;
            }
            this.addInvocationToGlobalAnnotMap(classDefinition.name.value, lambdaFunction, initFunction.body);
        }
    }

    private BLangLambdaFunction defineAnnotations(BLangClassDefinition classDefinition, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        if (!classDefinition.annAttachments.isEmpty()) {
            function = this.defineFunction(classDefinition.pos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(classDefinition.annAttachments, mapLiteral, function, env);
        }
        for (BLangSimpleVariable field : classDefinition.fields) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(field.annAttachments, field.pos, pkgNode, env, pkgID, owner);
            if (paramAnnotLambda == null) continue;
            if (function == null) {
                function = this.defineFunction(classDefinition.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            }
            String fieldName = "$field$." + field.name.value;
            this.addInvocationToLiteral(mapLiteral, fieldName, ((BLangAnnotationAttachment)field.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (function != null && !mapLiteral.fields.isEmpty()) {
            return this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return null;
    }

    void defineStatementAnnotations(List<BLangAnnotationAttachment> attachments, Location location, PackageID pkgID, BSymbol owner, SymbolEnv env) {
        BLangFunction function = this.defineFunction(location, pkgID, owner);
        BLangRecordLiteral mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
        this.addAnnotsToLiteral(attachments, mapLiteral, function, env);
    }

    private void defineTypeAnnotations(BLangPackage pkgNode, SymbolEnv env, BLangFunction initFunction) {
        for (BLangTypeDefinition typeDef : pkgNode.typeDefinitions) {
            if (typeDef.isBuiltinTypeDef) continue;
            PackageID pkgID = typeDef.symbol.pkgID;
            BSymbol owner = typeDef.symbol.owner;
            BLangType typeNode = typeDef.typeNode;
            SymbolEnv typeEnv = SymbolEnv.createTypeEnv(typeNode, initFunction.symbol.scope, env);
            BLangLambdaFunction lambdaFunction = typeNode.getKind() == NodeKind.RECORD_TYPE || typeNode.getKind() == NodeKind.OBJECT_TYPE ? this.defineAnnotations(typeDef, pkgNode, typeEnv, pkgID, owner) : this.defineAnnotations(typeDef, typeDef.pos, pkgNode, typeEnv, pkgID, owner);
            if (lambdaFunction == null) continue;
            this.addInvocationToGlobalAnnotMap(typeDef.name.value, lambdaFunction, initFunction.body);
        }
    }

    private void defineFunctionAnnotations(BLangPackage pkgNode, SymbolEnv env, BLangFunction initFunction) {
        BLangFunction[] functions;
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)initFunction.body;
        for (BLangFunction function : functions = pkgNode.functions.toArray(new BLangFunction[pkgNode.functions.size()])) {
            int index;
            String identifier;
            BLangLambdaFunction lambdaFunction;
            PackageID pkgID = function.symbol.pkgID;
            BSymbol owner = function.symbol.owner;
            if (function.symbol.name.getValue().equals("main")) {
                this.addVarArgsAnnotation(function);
            }
            if (function.flagSet.contains((Object)Flag.WORKER)) {
                this.attachSchedulerPolicy(function);
            }
            if ((lambdaFunction = this.defineAnnotations(function, pkgNode, env, pkgID, owner)) == null) continue;
            BLangBlockStmt target = (BLangBlockStmt)TreeBuilder.createBlockNode();
            target.pos = initFnBody.pos;
            String string = identifier = function.attachedFunction ? function.symbol.name.value : function.name.value;
            if (function.attachedFunction && (function.receiver.type.flags & 0x40000L) == 262144L) {
                this.addLambdaToGlobalAnnotMap(identifier, lambdaFunction, target);
                index = this.calculateIndex(initFnBody.stmts, function.receiver.type.tsymbol);
            } else {
                this.addInvocationToGlobalAnnotMap(identifier, lambdaFunction, target);
                index = initFnBody.stmts.size();
            }
            for (BLangStatement stmt : target.stmts) {
                initFnBody.stmts.add(index++, stmt);
            }
        }
    }

    private void attachSchedulerPolicy(BLangFunction function) {
        for (BLangAnnotationAttachment annotation : function.annAttachments) {
            if (!annotation.annotationName.value.equals("strand")) continue;
            List<RecordLiteralNode.RecordField> fields = ((BLangRecordLiteral)annotation.expr).fields;
            for (RecordLiteralNode.RecordField field : fields) {
                Object value;
                if (field.getKind() != NodeKind.RECORD_LITERAL_KEY_VALUE) continue;
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangExpression expr = keyValue.key.expr;
                if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
                BLangIdentifier variableName = ((BLangSimpleVarRef)expr).variableName;
                if (variableName.value.equals("name")) {
                    if (keyValue.valueExpr.getKind() != NodeKind.LITERAL) continue;
                    function.symbol.strandName = ((BLangLiteral)keyValue.valueExpr).value.toString();
                    continue;
                }
                if (!variableName.value.equals("thread") || keyValue.valueExpr.getKind() != NodeKind.LITERAL || !"any".equals(value = ((BLangLiteral)keyValue.valueExpr).value)) continue;
                function.symbol.schedulerPolicy = SchedulerPolicy.ANY;
            }
        }
    }

    private BLangLambdaFunction defineAnnotations(AnnotatableNode node, Location location, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        return this.defineAnnotations(this.getAnnotationList(node), location, pkgNode, env, pkgID, owner);
    }

    private List<BLangAnnotationAttachment> getAnnotationList(AnnotatableNode node) {
        return node.getAnnotationAttachments().stream().map(annotAttachment -> (BLangAnnotationAttachment)annotAttachment).collect(Collectors.toList());
    }

    private BLangLambdaFunction defineAnnotations(List<BLangAnnotationAttachment> annAttachments, Location location, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        if (annAttachments.isEmpty()) {
            return null;
        }
        BLangFunction function = this.defineFunction(location, pkgID, owner);
        BLangRecordLiteral mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
        this.addAnnotsToLiteral(annAttachments, mapLiteral, function, env);
        if (mapLiteral.fields.isEmpty()) {
            return null;
        }
        return this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
    }

    private BLangLambdaFunction defineAnnotations(BLangTypeDefinition typeDef, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        BLangLambdaFunction lambdaFunction = null;
        boolean annotFunctionDefined = false;
        if (!typeDef.annAttachments.isEmpty()) {
            function = this.defineFunction(typeDef.pos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(typeDef.annAttachments, mapLiteral, function, env);
            annotFunctionDefined = true;
        }
        for (BLangSimpleVariable field : ((BLangStructureTypeNode)typeDef.typeNode).fields) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(field.annAttachments, field.pos, pkgNode, env, pkgID, owner);
            if (paramAnnotLambda == null) continue;
            if (!annotFunctionDefined) {
                function = this.defineFunction(typeDef.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            this.addInvocationToLiteral(mapLiteral, "$field$." + field.name.value, ((BLangAnnotationAttachment)field.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (annotFunctionDefined) {
            if (mapLiteral.fields.isEmpty()) {
                return null;
            }
            lambdaFunction = this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return lambdaFunction;
    }

    private BLangLambdaFunction defineAnnotations(BLangFunction bLangFunction, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        BLangLambdaFunction lambdaFunction = null;
        boolean annotFunctionDefined = false;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(bLangFunction, bLangFunction.symbol.scope, env);
        if (!bLangFunction.annAttachments.isEmpty()) {
            function = this.defineFunction(bLangFunction.pos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(bLangFunction.annAttachments, mapLiteral, function, funcEnv);
            annotFunctionDefined = true;
        }
        for (BLangSimpleVariable param : this.getParams(bLangFunction)) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(param.annAttachments, param.pos, pkgNode, funcEnv, pkgID, owner);
            if (paramAnnotLambda == null) continue;
            if (!annotFunctionDefined) {
                function = this.defineFunction(bLangFunction.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            this.addInvocationToLiteral(mapLiteral, "$param$." + param.name.value, ((BLangAnnotationAttachment)param.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (!bLangFunction.returnTypeAnnAttachments.isEmpty()) {
            if (!annotFunctionDefined) {
                function = this.defineFunction(bLangFunction.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            BLangFunction retFunction = this.defineFunction(bLangFunction.pos, pkgID, owner);
            BLangRecordLiteral retMapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(bLangFunction.returnTypeAnnAttachments, retMapLiteral, retFunction, funcEnv);
            BLangLambdaFunction returnAnnotLambda = this.addReturnAndDefineLambda(retFunction, retMapLiteral, pkgNode, env, pkgID, owner);
            this.addInvocationToLiteral(mapLiteral, RETURNS, ((BLangAnnotationAttachment)bLangFunction.returnTypeAnnAttachments.get((int)0)).pos, returnAnnotLambda);
        }
        if (annotFunctionDefined) {
            if (mapLiteral.fields.isEmpty()) {
                return null;
            }
            lambdaFunction = this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return lambdaFunction;
    }

    private void addVarArgsAnnotation(BLangFunction mainFunc) {
        BLangIdentifier identifierNode;
        if (mainFunc.symbol.getParameters().isEmpty() && mainFunc.symbol.restParam == null) {
            return;
        }
        Location pos = mainFunc.pos;
        BLangAnnotationAttachment annoAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        mainFunc.addAnnotationAttachment(annoAttachment);
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(mainFunc.symbol.getEnclosingSymbol());
        BSymbol annSymbol = this.symResolver.lookupSymbolInAnnotationSpace(pkgEnv, this.names.fromString(DEFAULTABLE_ANN));
        if (annSymbol instanceof BAnnotationSymbol) {
            annoAttachment.annotationSymbol = (BAnnotationSymbol)annSymbol;
        }
        annoAttachment.annotationName = identifierNode = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annoAttachment.annotationName.value = DEFAULTABLE_ANN;
        annoAttachment.pos = pos;
        annoAttachment.annotationName.pos = pos;
        BLangRecordLiteral literalNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annoAttachment.expr = literalNode;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue(BUILTIN_PKG_KEY);
        annoAttachment.pkgAlias = pkgAlias;
        annoAttachment.attachPoints.add(AttachPoint.Point.FUNCTION);
        literalNode.pos = pos;
        BStructureTypeSymbol bStructSymbol = null;
        BSymbol annTypeSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, this.names.fromString(DEFAULTABLE_REC));
        if (annTypeSymbol instanceof BStructureTypeSymbol) {
            bStructSymbol = (BStructureTypeSymbol)annTypeSymbol;
            literalNode.type = bStructSymbol.type;
        }
        BLangRecordLiteral.BLangRecordKeyValueField descriptorKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(descriptorKeyValue);
        BLangLiteral keyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        keyLiteral.value = ARG_NAMES;
        keyLiteral.type = this.symTable.stringType;
        BLangListConstructorExpr.BLangArrayLiteral valueLiteral = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        valueLiteral.type = new BArrayType(this.symTable.stringType);
        valueLiteral.pos = pos;
        for (BVarSymbol varSymbol : mainFunc.symbol.getParameters()) {
            BLangLiteral str = (BLangLiteral)TreeBuilder.createLiteralExpression();
            str.value = varSymbol.name.value;
            str.type = this.symTable.stringType;
            valueLiteral.exprs.add(str);
        }
        if (mainFunc.symbol.restParam != null) {
            BLangLiteral str = (BLangLiteral)TreeBuilder.createLiteralExpression();
            str.value = mainFunc.symbol.restParam.name.value;
            str.type = this.symTable.stringType;
            valueLiteral.exprs.add(str);
        }
        descriptorKeyValue.key = new BLangRecordLiteral.BLangRecordKey(keyLiteral);
        BSymbol fieldSymbol = this.symResolver.resolveStructField(mainFunc.pos, pkgEnv, this.names.fromString(ARG_NAMES), bStructSymbol);
        if (fieldSymbol instanceof BVarSymbol) {
            descriptorKeyValue.key.fieldSymbol = (BVarSymbol)fieldSymbol;
        }
        if (valueLiteral != null) {
            descriptorKeyValue.valueExpr = valueLiteral;
        }
    }

    private BLangFunction defineFunction(Location pos, PackageID pkgID, BSymbol owner) {
        String funcName = "$annot_func$_" + this.annotFuncCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, funcName);
        function.type = new BInvokableType(Collections.emptyList(), this.symTable.mapType, null);
        BLangBuiltInRefTypeNode anyMapType = (BLangBuiltInRefTypeNode)TreeBuilder.createBuiltInReferenceTypeNode();
        anyMapType.typeKind = TypeKind.MAP;
        anyMapType.pos = pos;
        BLangValueType anyType = new BLangValueType();
        anyType.typeKind = TypeKind.ANY;
        BLangConstrainedType constrainedType = (BLangConstrainedType)TreeBuilder.createConstrainedTypeNode();
        constrainedType.type = anyMapType;
        constrainedType.constraint = anyType;
        constrainedType.pos = pos;
        function.returnTypeNode = anyMapType;
        function.returnTypeNode.type = this.symTable.mapType;
        function.body = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        BInvokableSymbol functionSymbol = new BInvokableSymbol(256, Flags.asMask(function.flagSet), new Name(funcName), pkgID, function.type, owner, function.name.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.bodyExist = true;
        functionSymbol.kind = SymbolKind.FUNCTION;
        functionSymbol.retType = function.returnTypeNode.type;
        functionSymbol.scope = new Scope(functionSymbol);
        function.symbol = functionSymbol;
        return function;
    }

    private BLangLambdaFunction addReturnAndDefineLambda(BLangFunction function, BLangRecordLiteral mapLiteral, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(function.pos, (BLangBlockFunctionBody)function.body);
        returnStmt.expr = mapLiteral;
        BInvokableSymbol lambdaFunctionSymbol = this.createInvokableSymbol(function, pkgID, owner);
        BLangLambdaFunction lambdaFunction = this.desugar.createLambdaFunction(function, lambdaFunctionSymbol);
        lambdaFunction.capturedClosureEnv = env.createClone();
        pkgNode.functions.add(function);
        pkgNode.topLevelNodes.add(function);
        pkgNode.lambdaFunctions.add(lambdaFunction);
        return lambdaFunction;
    }

    private void addAnnotsToLiteral(List<BLangAnnotationAttachment> nodeAttachments, BLangRecordLiteral mapLiteral, BLangFunction function, SymbolEnv env) {
        HashMap<BAnnotationSymbol, 1> attachments = new HashMap<BAnnotationSymbol, 1>();
        for (AnnotationAttachmentNode annotationAttachmentNode : nodeAttachments) {
            final BLangAnnotationAttachment annotationAttachment = (BLangAnnotationAttachment)annotationAttachmentNode;
            this.desugar.rewrite(annotationAttachment, env);
            BAnnotationSymbol annotationSymbol = annotationAttachment.annotationSymbol;
            if (attachments.containsKey(annotationSymbol)) {
                ((List)attachments.get(annotationSymbol)).add(annotationAttachment);
                continue;
            }
            AttachPoint attachPoint = null;
            for (AttachPoint.Point point : annotationAttachment.attachPoints) {
                Optional<AttachPoint> attachPointOptional = annotationSymbol.points.stream().filter(annotAttachPoint -> annotAttachPoint.point == point).findAny();
                if (!attachPointOptional.isPresent()) continue;
                attachPoint = attachPointOptional.get();
                break;
            }
            if (attachPoint == null || attachPoint.source) continue;
            attachments.put(annotationSymbol, new ArrayList<BLangAnnotationAttachment>(){
                {
                    this.add(annotationAttachment);
                }
            });
        }
        if (attachments.isEmpty()) {
            return;
        }
        for (BAnnotationSymbol bAnnotationSymbol : attachments.keySet()) {
            BTypeSymbol attachedTypeSymbol = bAnnotationSymbol.attachedType;
            if (attachedTypeSymbol == null || this.types.isAssignable(attachedTypeSymbol.type, this.symTable.trueType)) {
                this.addTrueAnnot((BLangAnnotationAttachment)((List)attachments.get(bAnnotationSymbol)).get(0), mapLiteral);
                continue;
            }
            if (attachedTypeSymbol.type.tag != 19) {
                this.addSingleAnnot((BLangAnnotationAttachment)((List)attachments.get(bAnnotationSymbol)).get(0), mapLiteral);
                continue;
            }
            this.addAnnotArray(function.pos, bAnnotationSymbol.bvmAlias(), attachedTypeSymbol.type, (List)attachments.get(bAnnotationSymbol), mapLiteral);
        }
    }

    private BInvokableSymbol createInvokableSymbol(BLangFunction function, PackageID pkgID, BSymbol owner) {
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), pkgID, function.type, owner, true, function.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.retType = function.returnTypeNode.type;
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).collect(Collectors.toList());
        functionSymbol.scope = new Scope(functionSymbol);
        functionSymbol.restParam = function.restParam != null ? function.restParam.symbol : null;
        functionSymbol.type = new BInvokableType(Collections.emptyList(), function.restParam != null ? function.restParam.type : null, new BMapType(15, this.symTable.anyType, null), null);
        function.symbol = functionSymbol;
        return functionSymbol;
    }

    private BLangSimpleVariable createGlobalAnnotationMapVar(BLangPackage pkgNode) {
        BLangSimpleVariable annotationMap = ASTBuilderUtil.createVariable(pkgNode.pos, ANNOTATION_DATA, this.symTable.mapType, ASTBuilderUtil.createEmptyRecordLiteral(pkgNode.pos, this.symTable.mapType), null);
        ASTBuilderUtil.defineVariable(annotationMap, pkgNode.symbol, this.names);
        pkgNode.globalVars.add(0, annotationMap);
        pkgNode.topLevelNodes.add(0, annotationMap);
        return annotationMap;
    }

    private void addTrueAnnot(BLangAnnotationAttachment attachment, BLangRecordLiteral recordLiteral) {
        BLangExpression expression = ASTBuilderUtil.wrapToConversionExpr(this.symTable.trueType, ASTBuilderUtil.createLiteral(attachment.pos, this.symTable.booleanType, Boolean.TRUE), this.symTable, this.types);
        this.addAnnotValueToLiteral(recordLiteral, attachment.annotationSymbol.bvmAlias(), expression, attachment.pos);
    }

    private void addSingleAnnot(BLangAnnotationAttachment attachment, BLangRecordLiteral recordLiteral) {
        this.addAnnotValueToLiteral(recordLiteral, attachment.annotationSymbol.bvmAlias(), attachment.expr, attachment.pos);
    }

    private void addAnnotArray(Location pos, String name, BType annotType, List<BLangAnnotationAttachment> attachments, BLangRecordLiteral recordLiteral) {
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = ASTBuilderUtil.createEmptyArrayLiteral(pos, (BArrayType)annotType);
        attachments.forEach(attachment -> arrayLiteral.exprs.add(attachment.expr));
        this.addAnnotValueToLiteral(recordLiteral, name, arrayLiteral, pos);
    }

    private void addInvocationToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangBlockStmt target) {
        this.addAnnotValueAssignmentToMap(this.annotationMap, identifier, target, (BLangExpression)this.getInvocation(lambdaFunction));
    }

    private void addInvocationToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangFunctionBody target) {
        this.addAnnotValueAssignmentToMap(this.annotationMap, identifier, (BLangBlockFunctionBody)target, (BLangExpression)this.getInvocation(lambdaFunction));
    }

    private void addLambdaToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangBlockStmt target) {
        this.addAnnotValueAssignmentToMap(this.annotationMap, identifier, target, (BLangExpression)ASTBuilderUtil.createVariableRef(lambdaFunction.pos, lambdaFunction.function.symbol));
    }

    private void addInvocationToLiteral(BLangRecordLiteral recordLiteral, String identifier, Location pos, BLangLambdaFunction lambdaFunction) {
        BLangInvocation annotFuncInvocation = this.getInvocation(lambdaFunction);
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), annotFuncInvocation));
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BlockNode target, Location targetPos, BLangExpression expression) {
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(targetPos, target);
        assignmentStmt.expr = expression;
        BLangIndexBasedAccess indexAccessNode = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
        indexAccessNode.pos = targetPos;
        indexAccessNode.indexExpr = ASTBuilderUtil.createLiteral(targetPos, this.symTable.stringType, StringEscapeUtils.unescapeJava(identifier));
        indexAccessNode.expr = ASTBuilderUtil.createVariableRef(targetPos, mapVar.symbol);
        indexAccessNode.type = ((BMapType)mapVar.type).constraint;
        assignmentStmt.varRef = indexAccessNode;
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BLangBlockFunctionBody target, BLangExpression expression) {
        this.addAnnotValueAssignmentToMap(mapVar, identifier, target, target.pos, expression);
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BLangBlockStmt target, BLangExpression expression) {
        this.addAnnotValueAssignmentToMap(mapVar, identifier, target, target.pos, expression);
    }

    private void addAnnotValueToLiteral(BLangRecordLiteral recordLiteral, String identifier, BLangExpression expression, Location pos) {
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), expression));
    }

    private BLangInvocation getInvocation(BLangLambdaFunction lambdaFunction) {
        BLangInvocation funcInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        funcInvocation.type = this.symTable.mapType;
        funcInvocation.expr = null;
        BInvokableSymbol lambdaSymbol = lambdaFunction.function.symbol;
        funcInvocation.symbol = lambdaSymbol;
        funcInvocation.name = ASTBuilderUtil.createIdentifier(lambdaFunction.pos, lambdaSymbol.name.value);
        return funcInvocation;
    }

    private int calculateIndex(List<BLangStatement> statements, BLangService service) {
        for (int i = 0; i < statements.size(); ++i) {
            BLangStatement stmt = statements.get(i);
            if (stmt.getKind() != NodeKind.ASSIGNMENT || ((BLangAssignment)stmt).expr.getKind() != NodeKind.SERVICE_CONSTRUCTOR || ((BLangServiceConstructorExpr)((BLangAssignment)stmt).expr).serviceNode != service) continue;
            return i;
        }
        return statements.size();
    }

    private int calculateIndex(List<BLangStatement> statements, BTypeSymbol symbol) {
        for (int i = 0; i < statements.size(); ++i) {
            BLangExpression expr;
            NodeKind kind;
            BLangStatement stmt = statements.get(i);
            if (stmt.getKind() != NodeKind.ASSIGNMENT || (kind = (expr = ((BLangAssignment)stmt).expr).getKind()) != NodeKind.TYPE_INIT_EXPR && kind != NodeKind.OBJECT_CTOR_EXPRESSION || expr.type.tsymbol != symbol) continue;
            return i;
        }
        return statements.size();
    }

    private List<BLangSimpleVariable> getParams(BLangFunction function) {
        ArrayList<BLangSimpleVariable> params = new ArrayList<BLangSimpleVariable>(function.getParameters());
        if (function.restParam != null) {
            params.add(function.restParam);
        }
        return params;
    }
}

