/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ClosureDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ClosureDesugar> CLOSURE_DESUGAR_KEY = new CompilerContext.Key();
    private static final String BLOCK_MAP_SYM_NAME = "$map$block$";
    private static final String FUNCTION_MAP_SYM_NAME = "$map$func$";
    private static final String PARAMETER_MAP_NAME = "$paramMap$";
    private static final BVarSymbol CLOSURE_MAP_NOT_FOUND = new BVarSymbol(0L, new Name("$not$found"), null, null, null, null, SymbolOrigin.VIRTUAL);
    private SymbolTable symTable;
    private SymbolEnv env;
    private BLangNode result;
    private Types types;
    private Desugar desugar;
    private Names names;
    private int funClosureMapCount = 1;
    private int blockClosureMapCount = 1;

    public static ClosureDesugar getInstance(CompilerContext context) {
        ClosureDesugar desugar = context.get(CLOSURE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ClosureDesugar(context);
        }
        return desugar;
    }

    private ClosureDesugar(CompilerContext context) {
        context.put(CLOSURE_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.names = Names.getInstance(context);
        ClosureDesugar.CLOSURE_MAP_NOT_FOUND.pos = this.symTable.builtinPos;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        pkgNode.topLevelNodes.stream().filter(pkgLevelNode -> pkgLevelNode.getKind() != NodeKind.FUNCTION || !((BLangFunction)pkgLevelNode).flagSet.contains((Object)Flag.LAMBDA)).forEach(topLevelNode -> this.rewrite((BLangNode)((Object)topLevelNode), pkgEnv));
        ArrayList<BLangLambdaFunction> lambdasCollected = new ArrayList<BLangLambdaFunction>(pkgNode.lambdaFunctions);
        Collections.reverse(lambdasCollected);
        pkgNode.lambdaFunctions = new LinkedList<BLangLambdaFunction>(lambdasCollected);
        while (pkgNode.lambdaFunctions.peek() != null) {
            BLangLambdaFunction lambdaFunction = pkgNode.lambdaFunctions.poll();
            lambdaFunction.function = this.rewrite(lambdaFunction.function, lambdaFunction.capturedClosureEnv);
        }
        pkgNode.functions.forEach(this::updateFunctionParams);
        pkgNode.typeDefinitions.stream().filter(typeDef -> typeDef.typeNode.getKind() == NodeKind.RECORD_TYPE).forEach(this::updateRecordInitFunction);
        this.result = pkgNode;
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        BLangSimpleVariable receiver;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.originalFuncSymbol.scope, this.env);
        ++this.funClosureMapCount;
        Optional<BVarSymbol> paramsExposed = funcNode.symbol.params.stream().filter(bVarSymbol -> bVarSymbol.closure).findAny();
        int position = 1;
        if (paramsExposed.isPresent()) {
            this.createFunctionMap(funcNode, funcEnv);
            for (BVarSymbol paramSymbol : funcNode.symbol.params) {
                if (!paramSymbol.closure) continue;
                this.addToFunctionMap(funcNode, funcEnv, position, paramSymbol, paramSymbol.type);
                ++position;
            }
        }
        if (funcNode.symbol.restParam != null && funcNode.symbol.restParam.closure) {
            if (funcNode.mapSymbol == null) {
                this.createFunctionMap(funcNode, funcEnv);
            }
            this.addToFunctionMap(funcNode, funcEnv, position, funcNode.symbol.restParam, funcNode.symbol.restParam.type);
            ++position;
        }
        if ((receiver = funcNode.receiver) != null && receiver.symbol.closure && funcNode.flagSet.contains((Object)Flag.ATTACHED)) {
            if (funcNode.mapSymbol == null) {
                this.createFunctionMap(funcNode, funcEnv);
            }
            this.addToFunctionMap(funcNode, funcEnv, position, receiver.symbol, receiver.type);
        }
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        this.result = funcNode;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        ++this.blockClosureMapCount;
        body.stmts = this.rewriteStmt(body.stmts, blockEnv);
        if (body.mapSymbol != null) {
            this.addClosureMap(body.stmts, body.pos, body.mapSymbol, blockEnv);
        }
        this.result = body;
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.result = body;
    }

    private void createFunctionMap(BLangFunction funcNode, SymbolEnv funcEnv) {
        funcNode.mapSymbol = this.createMapSymbol("$map$func$_" + this.funClosureMapCount, funcEnv);
        BLangRecordLiteral emptyRecord = ASTBuilderUtil.createEmptyRecordLiteral(funcNode.pos, this.symTable.mapType);
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(funcNode.pos, funcNode.mapSymbol.name.value, funcNode.mapSymbol.type, emptyRecord, funcNode.mapSymbol);
        mapVar.typeNode = ASTBuilderUtil.createTypeNode(funcNode.mapSymbol.type);
        BLangSimpleVariableDef mapVarDef = ASTBuilderUtil.createVariableDef(funcNode.pos, mapVar);
        mapVarDef = this.desugar.rewrite(mapVarDef, funcEnv);
        if (funcNode.body == null) {
            funcNode.body = ASTBuilderUtil.createBlockFunctionBody(funcNode.pos);
        }
        ((BLangBlockFunctionBody)funcNode.body).stmts.add(0, mapVarDef);
    }

    private void updateFunctionParams(BLangFunction funcNode) {
        BInvokableSymbol dupFuncSymbol;
        funcNode.symbol = dupFuncSymbol = ASTBuilderUtil.duplicateInvokableSymbol(funcNode.symbol);
        BInvokableType dupFuncType = (BInvokableType)dupFuncSymbol.type;
        int i = 0;
        for (Map.Entry<Integer, BVarSymbol> entry : funcNode.paramClosureMap.entrySet()) {
            BVarSymbol mapSymbol = entry.getValue();
            dupFuncSymbol.params.add(i, mapSymbol);
            dupFuncType.paramTypes.add(i, mapSymbol.type);
            ++i;
        }
    }

    private void updateRecordInitFunction(BLangTypeDefinition typeDef) {
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)typeDef.typeNode;
        BInvokableSymbol initFnSym = recordTypeNode.initFunction.symbol;
        BRecordTypeSymbol recordTypeSymbol = (BRecordTypeSymbol)typeDef.symbol;
        recordTypeSymbol.initializerFunc.symbol = initFnSym;
        recordTypeSymbol.initializerFunc.type = (BInvokableType)initFnSym.type;
    }

    private void addToFunctionMap(BLangFunction funcNode, SymbolEnv symbolEnv, int position, BVarSymbol paramSymbol, BType type) {
        BLangSimpleVarRef.BLangLocalVarRef localVarRef = new BLangSimpleVarRef.BLangLocalVarRef(paramSymbol);
        localVarRef.closureDesugared = true;
        localVarRef.type = type;
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(funcNode.pos, type, funcNode.mapSymbol, ASTBuilderUtil.createLiteral(funcNode.pos, this.symTable.stringType, paramSymbol.name.value));
        accessExpr.type = ((BMapType)funcNode.mapSymbol.type).constraint;
        accessExpr.lhsVar = true;
        BLangAssignment stmt = this.desugar.rewrite(ASTBuilderUtil.createAssignmentStmt(funcNode.pos, accessExpr, localVarRef), symbolEnv);
        ((BLangBlockFunctionBody)funcNode.body).stmts.add(position, stmt);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        ++this.blockClosureMapCount;
        blockNode.stmts = this.rewriteStmt(blockNode.stmts, blockEnv);
        if (blockNode.mapSymbol != null) {
            this.addClosureMap(blockNode.stmts, blockNode.pos, blockNode.mapSymbol, blockEnv);
        }
        this.result = blockNode;
    }

    private void addClosureMap(List<BLangStatement> stmts, Location pos, BVarSymbol mapSymbol, SymbolEnv blockEnv) {
        BLangRecordLiteral emptyRecord = ASTBuilderUtil.createEmptyRecordLiteral(this.symTable.builtinPos, mapSymbol.type);
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.type, emptyRecord, mapSymbol);
        mapVar.typeNode = ASTBuilderUtil.createTypeNode(mapSymbol.type);
        BLangSimpleVariableDef mapVarDef = ASTBuilderUtil.createVariableDef(this.symTable.builtinPos, mapVar);
        mapVarDef = this.desugar.rewrite(mapVarDef, blockEnv);
        stmts.add(0, mapVarDef);
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        if (!varDefNode.var.symbol.closure) {
            varDefNode.var = this.rewrite(varDefNode.var, this.env);
            this.result = varDefNode;
            return;
        }
        if (varDefNode.var.expr != null) {
            BLangAssignment stmt = this.createAssignment(varDefNode);
            this.result = this.rewrite(stmt, this.env);
        } else {
            this.createMapSymbolIfAbsent(this.env.node, this.blockClosureMapCount);
            this.result = varDefNode;
        }
    }

    private BLangAssignment createAssignment(BLangSimpleVariableDef varDefNode) {
        BVarSymbol mapSymbol = this.createMapSymbolIfAbsent(this.env.node, this.blockClosureMapCount);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(varDefNode.pos, varDefNode.type, mapSymbol, ASTBuilderUtil.createLiteral(varDefNode.pos, this.symTable.stringType, varDefNode.var.name.value));
        accessExpr.type = ((BMapType)mapSymbol.type).constraint;
        accessExpr.lhsVar = true;
        return ASTBuilderUtil.createAssignmentStmt(varDefNode.pos, accessExpr, varDefNode.var.expr);
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangNode node, int closureMapCount) {
        if (node.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
            return this.createMapSymbolIfAbsent((BLangBlockFunctionBody)node, closureMapCount);
        }
        if (node.getKind() == NodeKind.BLOCK) {
            return this.createMapSymbolIfAbsent((BLangBlockStmt)node, closureMapCount);
        }
        if (node.getKind() == NodeKind.FUNCTION) {
            return this.createMapSymbolIfAbsent((BLangFunction)node, closureMapCount);
        }
        return null;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockFunctionBody body, int closureMapCount) {
        if (body.mapSymbol == null) {
            body.mapSymbol = this.createMapSymbol("$map$block$_" + closureMapCount, this.env);
        }
        return body.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockStmt blockStmt, int closureMapCount) {
        if (blockStmt.mapSymbol == null) {
            blockStmt.mapSymbol = this.createMapSymbol("$map$block$_" + closureMapCount, this.env);
        }
        return blockStmt.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangFunction function, int closureMapCount) {
        if (function.mapSymbol == null) {
            function.mapSymbol = this.createMapSymbol("$map$func$_" + closureMapCount, this.env);
        }
        return function.mapSymbol;
    }

    private BVarSymbol getMapSymbol(BLangNode node) {
        if (node.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
            return ((BLangBlockFunctionBody)node).mapSymbol;
        }
        if (node.getKind() == NodeKind.BLOCK) {
            return ((BLangBlockStmt)node).mapSymbol;
        }
        if (node.getKind() == NodeKind.FUNCTION) {
            return ((BLangFunction)node).mapSymbol;
        }
        return CLOSURE_MAP_NOT_FOUND;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
        iExpr.expr = this.rewriteExpr(iExpr.expr);
        if (iExpr.requiredArgs.size() > 0) {
            iExpr.requiredArgs.set(0, iExpr.expr);
        }
        iExpr.requiredArgs = this.rewriteExprs(iExpr.requiredArgs);
        iExpr.restArgs = this.rewriteExprs(iExpr.restArgs);
        this.result = iExpr;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        this.result = importPkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        if (typeDef.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDef.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        }
        this.result = typeDef;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        this.result = classDefinition;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.result = recordTypeNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        varDefNode.errorVariable = this.rewrite(varDefNode.errorVariable, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        if (assignNode.expr.impConversionExpr != null) {
            this.types.setImplicitCastExpr(assignNode.expr.impConversionExpr, assignNode.expr.impConversionExpr.type, assignNode.varRef.type);
        } else {
            this.types.setImplicitCastExpr(assignNode.expr, assignNode.expr.type, assignNode.varRef.type);
        }
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        this.result = tupleDestructure;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.result = recordDestructure;
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.result = errorDestructure;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody = this.rewrite(retryNode.retryBody, this.env);
        this.result = retryNode;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        retryTransaction.transaction = this.rewrite(retryTransaction.transaction, this.env);
        this.result = retryTransaction;
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body = this.rewrite(doNode.body, this.env);
        this.result = doNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (failNode.exprStmt != null) {
            failNode.exprStmt = this.rewrite(failNode.exprStmt, this.env);
        }
        this.result = failNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body, this.env);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangMatch matchStmt) {
        this.result = matchStmt;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.result = foreach;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewriteExpr(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body, this.env);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body = this.rewrite(lockNode.body, this.env);
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockNode) {
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.result = unLockNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody = this.rewrite(transactionNode.transactionBody, this.env);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        rollbackNode.expr = this.rewriteExpr(rollbackNode.expr);
        this.result = rollbackNode;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.result = transactionalExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.exprs = this.rewriteExprs(listConstructorExpr.exprs);
        this.result = listConstructorExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewriteExprs(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        jsonArrayLiteral.exprs = this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        tupleLiteral.exprs = this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        arrayLiteral.exprs = this.rewriteExprs(arrayLiteral.exprs);
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        recordLiteral.fields.forEach(field -> {
            BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            keyValue.key.expr = this.rewriteExpr(keyValue.key.expr);
            keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
        });
        this.result = recordLiteral;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.result = this.desugar.rewriteExpr(indexAccessExpr);
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        iExpr.expr = this.rewriteExpr(iExpr.expr);
        iExpr.requiredArgs = this.rewriteExprs(iExpr.requiredArgs);
        iExpr.restArgs = this.rewriteExprs(iExpr.restArgs);
        this.result = iExpr;
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        ArrayList<BLangExpression> exprList = new ArrayList<BLangExpression>();
        tableMultiKeyExpr.multiKeyIndexExprs.forEach(expression -> exprList.add(this.rewriteExpr(expression)));
        tableMultiKeyExpr.multiKeyIndexExprs = exprList;
        this.result = tableMultiKeyExpr;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.initInvocation = this.rewriteExpr(typeInitExpr.initInvocation);
        this.result = typeInitExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewriteExpr(ternaryExpr.expr);
        ternaryExpr.thenExpr = this.rewriteExpr(ternaryExpr.thenExpr);
        ternaryExpr.elseExpr = this.rewriteExpr(ternaryExpr.elseExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        ArrayList<BLangExpression> exprList = new ArrayList<BLangExpression>();
        waitExpr.exprList.forEach(expression -> exprList.add(this.rewriteExpr(expression)));
        waitExpr.exprList = exprList;
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression = this.rewriteExpr(groupExpr.expression);
        this.result = groupExpr;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (conversionExpr.expr.impConversionExpr != null) {
            this.result = conversionExpr;
            return;
        }
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        SymbolEnv symbolEnv;
        bLangLambdaFunction.capturedClosureEnv = symbolEnv = this.env.createClone();
        BLangFunction enclInvokable = (BLangFunction)symbolEnv.enclInvokable;
        bLangLambdaFunction.paramMapSymbolsOfEnclInvokable = enclInvokable.paramClosureMap;
        boolean isWorker = bLangLambdaFunction.function.flagSet.contains((Object)Flag.WORKER);
        bLangLambdaFunction.enclMapSymbols = this.collectClosureMapSymbols(symbolEnv, enclInvokable, isWorker);
        this.result = bLangLambdaFunction;
    }

    private TreeMap<Integer, BVarSymbol> collectClosureMapSymbols(SymbolEnv symbolEnv, BLangInvokableNode enclInvokable, boolean isWorker) {
        TreeMap<Integer, BVarSymbol> enclMapSymbols = new TreeMap<Integer, BVarSymbol>();
        while (symbolEnv != null && symbolEnv.enclInvokable == enclInvokable) {
            BVarSymbol mapSym = this.getMapSymbol(symbolEnv.node);
            if (mapSym == CLOSURE_MAP_NOT_FOUND) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            if (mapSym != null) {
                enclMapSymbols.putIfAbsent(symbolEnv.envCount, mapSym);
            } else if (isWorker) {
                mapSym = this.createMapSymbolIfAbsent(this.env.node, this.blockClosureMapCount);
                enclMapSymbols.putIfAbsent(symbolEnv.envCount, mapSym);
            }
            symbolEnv = symbolEnv.enclEnv;
        }
        return enclMapSymbols;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        xmlElementLiteral.modifiedChildren = this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        xmlElementLiteral.attributes = this.rewriteExprs(xmlElementLiteral.attributes);
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.textFragments.forEach(this::rewriteExpr);
        xmlTextLiteral.concatExpr = this.rewriteExpr(xmlTextLiteral.concatExpr);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.textFragments.forEach(this::rewriteExpr);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataFragments.forEach(this::rewriteExpr);
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.textFragments.forEach(this::rewriteExpr);
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::rewriteExpr);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        workerSendNode.expr = this.rewriteExpr(workerSendNode.expr);
        this.result = workerSendNode;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.rewriteExpr(syncSendExpr.expr);
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        xmlAttributeAccessExpr.indexExpr = this.rewriteExpr(xmlAttributeAccessExpr.indexExpr);
        xmlAttributeAccessExpr.expr = this.rewriteExpr(xmlAttributeAccessExpr.expr);
        this.result = xmlAttributeAccessExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        if (!localVarRef.symbol.closure || localVarRef.closureDesugared) {
            this.result = localVarRef;
            return;
        }
        int selfRelativeCount = this.env.relativeEnvCount;
        int selfAbsoluteLevel = this.env.envCount;
        int absoluteLevel = this.findResolvedLevel(this.env, (BVarSymbol)localVarRef.varSymbol);
        if (selfRelativeCount >= selfAbsoluteLevel - absoluteLevel) {
            SymbolEnv symbolEnv = this.env;
            NodeKind nodeKind = symbolEnv.node.getKind();
            while (symbolEnv != null && nodeKind != NodeKind.PACKAGE) {
                BVarSymbol mapSym;
                if (symbolEnv.envCount == absoluteLevel && (mapSym = this.createMapSymbolIfAbsent(symbolEnv.node, symbolEnv.envCount)) != null) {
                    this.updateClosureVars(localVarRef, mapSym);
                    return;
                }
                symbolEnv = symbolEnv.enclEnv;
                nodeKind = symbolEnv.node.getKind();
            }
        } else {
            ((BLangFunction)this.env.enclInvokable).paramClosureMap.putIfAbsent(absoluteLevel, this.createMapSymbol("$paramMap$_" + absoluteLevel, this.env));
            this.updateClosureVars(localVarRef, ((BLangFunction)this.env.enclInvokable).paramClosureMap.get(absoluteLevel));
        }
        this.updatePrecedingFunc(this.env, absoluteLevel);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    private int findResolvedLevel(SymbolEnv symbolEnv, BVarSymbol varSymbol) {
        while (symbolEnv != null && symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            Scope.ScopeEntry entry = symbolEnv.scope.lookup(varSymbol.name);
            if (entry != Scope.NOT_FOUND_ENTRY && varSymbol == entry.symbol && varSymbol.owner == symbolEnv.scope.owner) {
                return symbolEnv.envCount;
            }
            symbolEnv = symbolEnv.enclEnv;
        }
        return 0;
    }

    private void updatePrecedingFunc(SymbolEnv symbolEnv, int resolvedLevel) {
        while (symbolEnv != null && symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            if (symbolEnv.envCount == resolvedLevel) {
                return;
            }
            if (symbolEnv.node.getKind() != NodeKind.FUNCTION) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            BLangFunction bLangFunction = (BLangFunction)symbolEnv.node;
            if (symbolEnv.enclInvokable == this.env.enclInvokable) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            if (bLangFunction.paramClosureMap.containsKey(resolvedLevel)) {
                return;
            }
            bLangFunction.paramClosureMap.put(resolvedLevel, this.createMapSymbol("$paramMap$_" + resolvedLevel, symbolEnv));
            symbolEnv = symbolEnv.enclEnv;
        }
    }

    private BVarSymbol createMapSymbol(String mapName, SymbolEnv symbolEnv) {
        return new BVarSymbol(0L, this.names.fromString(mapName), symbolEnv.scope.owner.pkgID, this.symTable.mapAllType, symbolEnv.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    private void updateClosureVars(BLangSimpleVarRef varRefExpr, BVarSymbol mapSymbol) {
        BLangLiteral indexExpr = ASTBuilderUtil.createLiteral(varRefExpr.pos, this.symTable.stringType, varRefExpr.varSymbol.name.value);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(varRefExpr.pos, varRefExpr.type, mapSymbol, indexExpr);
        this.result = this.rewriteExpr(accessExpr);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        fieldAccessExpr.indexExpr = this.rewriteExpr(fieldAccessExpr.indexExpr);
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        functionVarRef.expr = this.rewriteExpr(functionVarRef.expr);
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        mapKeyAccessExpr.indexExpr = this.rewriteExpr(mapKeyAccessExpr.indexExpr);
        mapKeyAccessExpr.expr = this.rewriteExpr(mapKeyAccessExpr.expr);
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        tableKeyAccessExpr.indexExpr = this.rewriteExpr(tableKeyAccessExpr.indexExpr);
        tableKeyAccessExpr.expr = this.rewriteExpr(tableKeyAccessExpr.expr);
        this.result = tableKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlIndexAccessExpr) {
        xmlIndexAccessExpr.indexExpr = this.rewriteExpr(xmlIndexAccessExpr.indexExpr);
        xmlIndexAccessExpr.expr = this.rewriteExpr(xmlIndexAccessExpr.expr);
        this.result = xmlIndexAccessExpr;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        xmlNavigation.childIndex = this.rewriteExpr(xmlNavigation.childIndex);
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        jsonAccessExpr.indexExpr = this.rewriteExpr(jsonAccessExpr.indexExpr);
        jsonAccessExpr.expr = this.rewriteExpr(jsonAccessExpr.expr);
        this.result = jsonAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        stringAccessExpr.indexExpr = this.rewriteExpr(stringAccessExpr.indexExpr);
        stringAccessExpr.expr = this.rewriteExpr(stringAccessExpr.expr);
        this.result = stringAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        SymbolEnv symbolEnv = this.env.createClone();
        BLangFunction enclInvokable = (BLangFunction)symbolEnv.enclInvokable;
        structLiteral.enclMapSymbols = this.collectClosureMapSymbols(symbolEnv, enclInvokable, false);
        for (RecordLiteralNode.RecordField field : structLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        waitLiteral.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation fpInvocation) {
        fpInvocation.expr = this.rewriteExpr(fpInvocation.expr);
        fpInvocation.requiredArgs = this.rewriteExprs(fpInvocation.requiredArgs);
        fpInvocation.restArgs = this.rewriteExprs(fpInvocation.restArgs);
        this.result = fpInvocation;
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        intRangeExpression.startExpr = this.rewriteExpr(intRangeExpression.startExpr);
        intRangeExpression.endExpr = this.rewriteExpr(intRangeExpression.endExpr);
        this.result = intRangeExpression;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression.expr;
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        this.result = bLangMatchExpression;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr = this.rewriteExpr(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr = this.rewriteExpr(annotAccessExpr.expr);
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        if (bLangStatementExpression.stmt.getKind() == NodeKind.BLOCK) {
            BLangBlockStmt bLangBlockStmt = (BLangBlockStmt)bLangStatementExpression.stmt;
            for (int i = 0; i < bLangBlockStmt.stmts.size(); ++i) {
                BLangStatement stmt = bLangBlockStmt.stmts.remove(i);
                bLangBlockStmt.stmts.add(i, this.rewrite(stmt, this.env));
            }
        } else {
            bLangStatementExpression.stmt = this.rewrite(bLangStatementExpression.stmt, this.env);
        }
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation aIExpr) {
        aIExpr.expr = this.rewriteExpr(aIExpr.expr);
        aIExpr.requiredArgs = this.rewriteExprs(aIExpr.requiredArgs);
        aIExpr.restArgs = this.rewriteExprs(aIExpr.restArgs);
        this.result = aIExpr;
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        this.result = constant;
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause patternClauseNode) {
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangMatchExpression.BLangMatchExprPatternClause bLangMatchExprPatternClause) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        this.result = typeLoad;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangChannelLiteral channelLiteral) {
        channelLiteral.fields.forEach(field -> {
            BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            keyValue.key.expr = this.rewriteExpr(keyValue.key.expr);
            keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
        });
        this.result = channelLiteral;
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        this.result = bLangXMLSequenceLiteral;
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause langMatchStaticBindingPatternClause) {
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause matchStructuredBindingPatternClause) {
    }

    private <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        this.env = previousEnv;
        return (E)resultNode;
    }

    private <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        return (E)((BLangExpression)resultNode);
    }

    private <E extends BLangStatement> List<E> rewriteStmt(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangStatement)nodeList.get(i), env));
        }
        return nodeList;
    }

    private <E extends BLangExpression> List<E> rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
        return nodeList;
    }
}

