/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class TransactionDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<TransactionDesugar> TRANSACTION_DESUGAR_KEY = new CompilerContext.Key();
    private static final String SHOULD_CLEANUP_SYMBOL = "$shouldCleanUp$";
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final PackageCache packageCache;
    private BSymbol transactionError;
    private BLangExpression retryStmt;
    private SymbolEnv env;
    private BLangBlockStmt result;
    private BLangSimpleVarRef prevAttemptInfoRef;
    private BLangSimpleVarRef shouldCleanUpVariableRef;
    private BLangExpression transactionID;
    private String uniqueId;
    private BLangLiteral trxBlockId;
    private boolean transactionInternalModuleIncluded = false;
    private boolean trxCoordinatorServiceStarted = false;
    private int trxResourceCount;

    private TransactionDesugar(CompilerContext context) {
        context.put(TRANSACTION_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
    }

    public static TransactionDesugar getInstance(CompilerContext context) {
        TransactionDesugar desugar = context.get(TRANSACTION_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new TransactionDesugar(context);
        }
        return desugar;
    }

    public BLangBlockStmt rewrite(BLangNode node, BLangLiteral trxBlockIdDef, SymbolEnv env, String uniqueId) {
        BLangLiteral currentTrxBlockIdDef = this.trxBlockId;
        this.trxBlockId = trxBlockIdDef;
        String id = this.uniqueId;
        this.uniqueId = uniqueId;
        BLangExpression trxId = this.transactionID;
        BLangSimpleVarRef attemptVarRef = this.prevAttemptInfoRef;
        BLangSimpleVarRef prevShouldCleanUp = this.shouldCleanUpVariableRef;
        SymbolEnv symbolEnv = this.env;
        this.env = env;
        node.accept(this);
        this.uniqueId = id;
        this.transactionID = trxId;
        this.prevAttemptInfoRef = attemptVarRef;
        this.shouldCleanUpVariableRef = prevShouldCleanUp;
        this.env = symbolEnv;
        this.trxBlockId = currentTrxBlockIdDef;
        return this.result;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.result = this.desugarTransactionBody(transactionNode, this.env, transactionNode.pos);
    }

    private BLangBlockStmt desugarTransactionBody(BLangTransaction transactionNode, SymbolEnv env, Location pos) {
        BLangBlockStmt transactionBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        transactionBlockStmt.scope = transactionNode.transactionBody.scope;
        BVarSymbol shouldCleanUpSymbol = new BVarSymbol(0L, new Name("$shouldCleanUp$_" + this.uniqueId), env.scope.owner.pkgID, this.symTable.booleanType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable shouldCleanUpVariable = ASTBuilderUtil.createVariable(pos, "$shouldCleanUp$_" + this.uniqueId, this.symTable.booleanType, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, false), shouldCleanUpSymbol);
        shouldCleanUpVariable.symbol.closure = true;
        BLangSimpleVariableDef shouldCleanUpVariableDef = ASTBuilderUtil.createVariableDef(pos, shouldCleanUpVariable);
        transactionBlockStmt.stmts.add(shouldCleanUpVariableDef);
        this.shouldCleanUpVariableRef = ASTBuilderUtil.createVariableRef(pos, shouldCleanUpVariable.symbol);
        if (transactionNode.prevAttemptInfo == null) {
            BLangSimpleVariableDef prevAttemptVarDef = this.createPrevAttemptInfoVarDef(env, pos);
            transactionBlockStmt.stmts.add(prevAttemptVarDef);
            transactionBlockStmt.scope.define(prevAttemptVarDef.var.symbol.name, prevAttemptVarDef.var.symbol);
            this.prevAttemptInfoRef = ASTBuilderUtil.createVariableRef(pos, prevAttemptVarDef.var.symbol);
        } else {
            this.prevAttemptInfoRef = (BLangSimpleVarRef)transactionNode.prevAttemptInfo;
        }
        BType transactionIDType = this.symTable.stringType;
        BVarSymbol transactionIDVarSymbol = new BVarSymbol(0L, new Name("transactionId" + this.uniqueId), env.scope.owner.pkgID, transactionIDType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable transactionIDVariable = ASTBuilderUtil.createVariable(pos, "transactionId" + this.uniqueId, transactionIDType, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, ""), transactionIDVarSymbol);
        BLangSimpleVariableDef transactionIDVariableDef = ASTBuilderUtil.createVariableDef(pos, transactionIDVariable);
        transactionBlockStmt.stmts.add(transactionIDVariableDef);
        this.transactionID = ASTBuilderUtil.createVariableRef(pos, transactionIDVariable.symbol);
        transactionIDVariable.symbol.closure = true;
        transactionBlockStmt.scope.define(transactionIDVarSymbol.name, transactionIDVarSymbol);
        transactionBlockStmt.scope.define(shouldCleanUpVariable.symbol.name, shouldCleanUpVariable.symbol);
        BUnionType transactionReturnType = this.symTable.errorOrNilType;
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BLangStatementExpression statementExpression = ASTBuilderUtil.createStatementExpression(transactionNode.transactionBody, nilLiteral);
        statementExpression.type = this.symTable.nilType;
        BLangTrapExpr trapExpr = (BLangTrapExpr)TreeBuilder.createTrapExpressionNode();
        trapExpr.type = transactionReturnType;
        trapExpr.expr = statementExpression;
        BVarSymbol nillableErrorVarSymbol = new BVarSymbol(0L, this.names.fromString("$trapResult"), this.env.scope.owner.pkgID, transactionReturnType, this.env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable trapResultVariable = ASTBuilderUtil.createVariable(pos, "$trapResult", transactionReturnType, trapExpr, nillableErrorVarSymbol);
        BLangSimpleVariableDef trapResultVariableDef = ASTBuilderUtil.createVariableDef(pos, trapResultVariable);
        transactionBlockStmt.addStatement(trapResultVariableDef);
        BLangSimpleVarRef trapResultRef = ASTBuilderUtil.createVariableRef(pos, nillableErrorVarSymbol);
        BLangFail failStmt = (BLangFail)TreeBuilder.createFailNode();
        failStmt.pos = pos;
        failStmt.expr = this.desugar.addConversionExprIfRequired(trapResultRef, this.symTable.errorType);
        BLangPanic panicNode = (BLangPanic)TreeBuilder.createPanicNode();
        panicNode.pos = pos;
        panicNode.expr = failStmt.expr;
        failStmt.exprStmt = panicNode;
        BLangBlockStmt ifErrorBlock = ASTBuilderUtil.createBlockStmt(pos);
        ifErrorBlock.addStatement(failStmt);
        BLangTypeTestExpr isErrorTest = ASTBuilderUtil.createTypeTestExpr(pos, trapResultRef, this.desugar.getErrorTypeNode());
        isErrorTest.type = this.symTable.booleanType;
        BLangIf ifTrapResIsError = ASTBuilderUtil.createIfElseStmt(pos, isErrorTest, ifErrorBlock, null);
        transactionBlockStmt.addStatement(ifTrapResIsError);
        BLangInvocation startTransactionInvocation = this.createStartTransactionInvocation(pos, ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, this.uniqueId), this.prevAttemptInfoRef);
        BLangAssignment startTrxAssignment = ASTBuilderUtil.createAssignmentStmt(pos, ASTBuilderUtil.createVariableRef(pos, transactionIDVarSymbol), startTransactionInvocation);
        BLangAssignment infoAssignment = this.createPrevAttemptInfoInvocation(pos);
        transactionNode.transactionBody.stmts.add(0, startTrxAssignment);
        transactionNode.transactionBody.stmts.add(1, infoAssignment);
        BLangIf cleanValidationIf = ASTBuilderUtil.createIfStmt(pos, transactionBlockStmt);
        BLangGroupExpr cleanValidationGroupExpr = new BLangGroupExpr();
        cleanValidationGroupExpr.expression = ASTBuilderUtil.createVariableRef(pos, shouldCleanUpVariable.symbol);
        cleanValidationIf.expr = cleanValidationGroupExpr;
        cleanValidationIf.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangExpressionStmt stmt = ASTBuilderUtil.createExpressionStmt(pos, cleanValidationIf.body);
        stmt.expr = this.createCleanupTrxStmt(pos, this.trxBlockId);
        return this.desugar.rewrite(transactionBlockStmt, env);
    }

    private BLangAssignment createPrevAttemptInfoInvocation(Location pos) {
        BInvokableSymbol transactionInfoInvokableSymbol = (BInvokableSymbol)this.getTransactionLibInvokableSymbol(Names.CURRENT_TRANSACTION_INFO);
        BLangInvocation infoInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, transactionInfoInvokableSymbol, new ArrayList<BLangExpression>(), this.symResolver);
        infoInvocation.argExprs = infoInvocation.requiredArgs;
        return ASTBuilderUtil.createAssignmentStmt(pos, this.prevAttemptInfoRef, infoInvocation);
    }

    private BLangInvocation createStartTransactionInvocation(Location location, BLangLiteral transactionBlockIDLiteral, BLangSimpleVarRef prevAttempt) {
        BInvokableSymbol startTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.START_TRANSACTION);
        if (!this.transactionInternalModuleIncluded) {
            this.desugar.addTransactionInternalModuleImport();
            this.transactionInternalModuleIncluded = true;
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(transactionBlockIDLiteral);
        args.add(prevAttempt);
        BLangInvocation startTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(location, startTransactionInvokableSymbol, args, this.symResolver);
        startTransactionInvocation.argExprs = args;
        return startTransactionInvocation;
    }

    public BLangInvocation createBeginParticipantInvocation(Location pos) {
        BInvokableSymbol beginParticipantInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.BEGIN_REMOTE_PARTICIPANT);
        if (!this.transactionInternalModuleIncluded) {
            this.desugar.addTransactionInternalModuleImport();
            this.transactionInternalModuleIncluded = true;
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, String.valueOf(++this.trxResourceCount)));
        BLangInvocation startTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, beginParticipantInvokableSymbol, args, this.symResolver);
        startTransactionInvocation.argExprs = args;
        return startTransactionInvocation;
    }

    private BLangInvocation createStartTransactionCoordinatorInvocation(Location pos) {
        BInvokableSymbol startTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.START_TRANSACTION_COORDINATOR);
        if (!this.transactionInternalModuleIncluded) {
            this.desugar.addTransactionInternalModuleImport();
            this.transactionInternalModuleIncluded = true;
        }
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        BLangInvocation startTransactionCoordinatorInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, startTransactionInvokableSymbol, args, this.symResolver);
        startTransactionCoordinatorInvocation.argExprs = args;
        return startTransactionCoordinatorInvocation;
    }

    private BLangSimpleVariableDef createVarDefForCoordinator(SymbolEnv env, Location pos) {
        BLangInvocation invocation = this.createStartTransactionCoordinatorInvocation(pos);
        BVarSymbol outputVarSymbol = new BVarSymbol(0L, new Name("$trxCoordinatorErr$"), env.scope.owner.pkgID, this.symTable.errorOrNilType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable outputVariable = ASTBuilderUtil.createVariable(pos, "$trxCoordinatorErr$", this.symTable.errorOrNilType, invocation, outputVarSymbol);
        return ASTBuilderUtil.createVariableDef(pos, outputVariable);
    }

    public void startTransactionCoordinatorOnce(SymbolEnv env, Location pos) {
        if (!this.trxCoordinatorServiceStarted) {
            BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)env.enclPkg.initFunction.body;
            funcBody.stmts.add(0, this.createVarDefForCoordinator(env, pos));
            this.trxCoordinatorServiceStarted = true;
        }
    }

    BLangSimpleVariableDef createPrevAttemptInfoVarDef(SymbolEnv env, Location pos) {
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BLangSimpleVariable prevAttemptVariable = this.createPrevAttemptVariable(env, pos);
        prevAttemptVariable.expr = nilLiteral;
        return ASTBuilderUtil.createVariableDef(pos, prevAttemptVariable);
    }

    private BLangSimpleVariable createPrevAttemptVariable(SymbolEnv env, Location pos) {
        BSymbol infoRecordSymbol = this.symResolver.lookupSymbolInMainSpace(this.symTable.pkgEnvMap.get(this.symTable.langTransactionModuleSymbol), Names.TRANSACTION_INFO_RECORD);
        BUnionType infoRecordType = BUnionType.create(null, infoRecordSymbol.type, this.symTable.nilType);
        BVarSymbol prevAttemptVarSymbol = new BVarSymbol(0L, new Name("prevAttempt" + this.uniqueId), env.scope.owner.pkgID, infoRecordType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        prevAttemptVarSymbol.closure = true;
        return ASTBuilderUtil.createVariable(pos, "prevAttempt" + this.uniqueId, infoRecordType, null, prevAttemptVarSymbol);
    }

    BLangBlockStmt desugar(BLangRollback rollbackNode, BLangLiteral transactionBlockID) {
        BLangBlockStmt rollbackBlockStmt = ASTBuilderUtil.createBlockStmt(rollbackNode.pos);
        BLangStatementExpression rollbackExpr = this.invokeRollbackFunc(rollbackNode.pos, rollbackNode.expr, transactionBlockID);
        BLangExpressionStmt rollbackStmt = ASTBuilderUtil.createExpressionStmt(rollbackNode.pos, rollbackBlockStmt);
        rollbackStmt.expr = rollbackExpr;
        return rollbackBlockStmt;
    }

    void createRollbackIfFailed(Location pos, BLangBlockStmt onFailBodyBlock, BSymbol trxFuncResultSymbol, BLangLiteral trxBlockId) {
        BLangIf rollbackCheck = (BLangIf)TreeBuilder.createIfElseStatementNode();
        rollbackCheck.pos = pos;
        int stmtIndex = onFailBodyBlock.stmts.isEmpty() ? 0 : 1;
        onFailBodyBlock.stmts.add(stmtIndex, rollbackCheck);
        BConstructorSymbol transactionErrorSymbol = (BConstructorSymbol)this.symTable.langTransactionModuleSymbol.scope.lookup((Name)this.names.fromString((String)"TransactionError")).symbol;
        BType errorType = transactionErrorSymbol.type;
        BLangErrorType trxErrorTypeNode = (BLangErrorType)TreeBuilder.createErrorTypeNode();
        trxErrorTypeNode.type = errorType;
        BLangSimpleVarRef trxResultRef = ASTBuilderUtil.createVariableRef(pos, trxFuncResultSymbol);
        BLangTypeTestExpr testExpr = ASTBuilderUtil.createTypeTestExpr(pos, trxResultRef, trxErrorTypeNode);
        testExpr.type = this.symTable.booleanType;
        BLangGroupExpr transactionErrorCheckGroupExpr = new BLangGroupExpr();
        transactionErrorCheckGroupExpr.type = this.symTable.booleanType;
        transactionErrorCheckGroupExpr.expression = this.desugar.createNotBinaryExpression(pos, testExpr);
        BLangTypeTestExpr errorCheck = this.desugar.createTypeCheckExpr(pos, trxResultRef, this.desugar.getErrorOrNillTypeNode());
        BLangBinaryExpr isErrorCheck = ASTBuilderUtil.createBinaryExpr(pos, errorCheck, transactionErrorCheckGroupExpr, this.symTable.booleanType, OperatorKind.AND, null);
        BLangTransactionalExpr isTransactionalCheck = TreeBuilder.createTransactionalExpressionNode();
        isTransactionalCheck.pos = pos;
        rollbackCheck.expr = ASTBuilderUtil.createBinaryExpr(pos, isErrorCheck, isTransactionalCheck, this.symTable.booleanType, OperatorKind.AND, null);
        rollbackCheck.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangStatementExpression rollbackInvocation = this.invokeRollbackFunc(pos, this.desugar.addConversionExprIfRequired(trxResultRef, this.symTable.errorOrNilType), trxBlockId);
        BLangCheckPanickedExpr checkedExpr = ASTBuilderUtil.createCheckPanickedExpr(pos, rollbackInvocation, this.symTable.nilType);
        checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
        BLangExpressionStmt transactionExprStmt = (BLangExpressionStmt)TreeBuilder.createExpressionStatementNode();
        transactionExprStmt.pos = pos;
        transactionExprStmt.expr = checkedExpr;
        transactionExprStmt.type = this.symTable.nilType;
        rollbackCheck.body.stmts.add(transactionExprStmt);
    }

    private BLangInvocation createCleanupTrxStmt(Location pos, BLangLiteral trxBlockId) {
        BInvokableSymbol cleanupTrxInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.CLEAN_UP_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(trxBlockId);
        BLangInvocation cleanupTrxInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, cleanupTrxInvokableSymbol, args, this.symResolver);
        cleanupTrxInvocation.argExprs = args;
        return cleanupTrxInvocation;
    }

    BLangStatementExpression invokeRollbackFunc(Location pos, BLangExpression rollbackExpr, BLangLiteral trxBlockId) {
        BLangBlockStmt rollbackBlockStmt = ASTBuilderUtil.createBlockStmt(pos);
        BInvokableSymbol rollbackTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.ROLLBACK_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(trxBlockId);
        if (rollbackExpr != null) {
            args.add(rollbackExpr);
        }
        BLangInvocation rollbackTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, rollbackTransactionInvokableSymbol, args, this.symResolver);
        rollbackTransactionInvocation.argExprs = args;
        BLangExpressionStmt rollbackStmt = ASTBuilderUtil.createExpressionStmt(pos, rollbackBlockStmt);
        rollbackStmt.expr = rollbackTransactionInvocation;
        BLangExpressionStmt cleanUpTrx = ASTBuilderUtil.createExpressionStmt(pos, rollbackBlockStmt);
        cleanUpTrx.expr = this.createCleanupTrxStmt(pos, trxBlockId);
        BLangStatementExpression rollbackStmtExpr = ASTBuilderUtil.createStatementExpression(rollbackBlockStmt, ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE));
        rollbackStmtExpr.type = this.symTable.nilType;
        return rollbackStmtExpr;
    }

    BLangStatementExpression desugar(BLangCommitExpr commitExpr, SymbolEnv env) {
        Location pos = commitExpr.pos;
        BLangBlockStmt commitBlockStatement = ASTBuilderUtil.createBlockStmt(pos);
        BLangSimpleVariableDef outputVariableDef = this.createCommitResultVarDef(env, pos);
        BLangSimpleVarRef outputVarRef = ASTBuilderUtil.createVariableRef(pos, outputVariableDef.var.symbol);
        commitBlockStatement.addStatement(outputVariableDef);
        BInvokableSymbol transactionCleanerInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.GET_AND_CLEAR_FAILURE_TRANSACTION);
        BLangInvocation transactionCleanerInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, transactionCleanerInvokableSymbol, new ArrayList<BLangExpression>(), this.symResolver);
        transactionCleanerInvocation.argExprs = new ArrayList<BLangExpression>();
        BVarSymbol isTransactionFailedVarSymbol = new BVarSymbol(0L, new Name("isFailed"), env.scope.owner.pkgID, this.symTable.booleanType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable isTransactionFailedVariable = ASTBuilderUtil.createVariable(pos, "isFailed", this.symTable.booleanType, transactionCleanerInvocation, isTransactionFailedVarSymbol);
        BLangSimpleVariableDef isTransactionFailedVariableDef = ASTBuilderUtil.createVariableDef(pos, isTransactionFailedVariable);
        commitBlockStatement.addStatement(isTransactionFailedVariableDef);
        BLangBlockStmt failureHandlerBlockStatement = ASTBuilderUtil.createBlockStmt(pos);
        BInvokableSymbol commitTransactionInvokableSymbol = (BInvokableSymbol)this.getInternalTransactionModuleInvokableSymbol(Names.END_TRANSACTION);
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
        args.add(this.transactionID);
        args.add(this.trxBlockId);
        BLangInvocation commitTransactionInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, commitTransactionInvokableSymbol, args, this.symResolver);
        commitTransactionInvocation.argExprs = args;
        BUnionType commitReturnType = BUnionType.create(null, this.symTable.stringType, this.symTable.errorType);
        BVarSymbol commitTransactionVarSymbol = new BVarSymbol(0L, new Name("commitResult"), env.scope.owner.pkgID, commitReturnType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable commitResultVariable = ASTBuilderUtil.createVariable(pos, "commitResult", commitReturnType, commitTransactionInvocation, commitTransactionVarSymbol);
        BLangSimpleVariableDef commitResultVariableDef = ASTBuilderUtil.createVariableDef(pos, commitResultVariable);
        BLangSimpleVarRef commitResultVarRef = ASTBuilderUtil.createVariableRef(pos, commitResultVariable.symbol);
        failureHandlerBlockStatement.addStatement(commitResultVariableDef);
        BLangIf commitResultValidationIf = ASTBuilderUtil.createIfStmt(pos, failureHandlerBlockStatement);
        BLangGroupExpr commitResultValidationGroupExpr = new BLangGroupExpr();
        commitResultValidationGroupExpr.type = this.symTable.booleanType;
        BLangValueType stringType = (BLangValueType)TreeBuilder.createValueTypeNode();
        stringType.type = this.symTable.stringType;
        stringType.typeKind = TypeKind.STRING;
        commitResultValidationGroupExpr.expression = ASTBuilderUtil.createTypeTestExpr(pos, commitResultVarRef, stringType);
        commitResultValidationIf.expr = commitResultValidationGroupExpr;
        commitResultValidationIf.body = ASTBuilderUtil.createBlockStmt(pos);
        BLangAssignment shouldCleanUpStmt = ASTBuilderUtil.createAssignmentStmt(pos, this.shouldCleanUpVariableRef, ASTBuilderUtil.createLiteral(pos, this.symTable.booleanType, true));
        commitResultValidationIf.body.addStatement(shouldCleanUpStmt);
        commitResultValidationIf.elseStmt = ASTBuilderUtil.createAssignmentStmt(pos, outputVarRef, commitResultVarRef);
        BLangIf failureValidationIf = ASTBuilderUtil.createIfStmt(pos, commitBlockStatement);
        BLangGroupExpr failureValidationGroupExpr = new BLangGroupExpr();
        failureValidationGroupExpr.type = this.symTable.booleanType;
        BLangSimpleVarRef failureValidationExprVarRef = ASTBuilderUtil.createVariableRef(pos, isTransactionFailedVariable.symbol);
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        paramTypes.add(this.symTable.booleanType);
        BInvokableType type = new BInvokableType(paramTypes, this.symTable.booleanType, null);
        BOperatorSymbol notOperatorSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.NOT.value()), this.symTable.rootPkgSymbol.pkgID, type, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        failureValidationGroupExpr.expression = ASTBuilderUtil.createUnaryExpr(pos, failureValidationExprVarRef, this.symTable.booleanType, OperatorKind.NOT, notOperatorSymbol);
        failureValidationIf.expr = failureValidationGroupExpr;
        failureValidationIf.body = failureHandlerBlockStatement;
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(commitBlockStatement, outputVarRef);
        stmtExpr.type = this.symTable.errorOrNilType;
        return stmtExpr;
    }

    private BLangSimpleVariableDef createCommitResultVarDef(SymbolEnv env, Location pos) {
        BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BVarSymbol outputVarSymbol = new BVarSymbol(0L, new Name("$outputVar$"), env.scope.owner.pkgID, this.symTable.errorOrNilType, env.scope.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable outputVariable = ASTBuilderUtil.createVariable(pos, "$outputVar$", this.symTable.errorOrNilType, nilLiteral, outputVarSymbol);
        return ASTBuilderUtil.createVariableDef(pos, outputVariable);
    }

    public BSymbol getTransactionLibInvokableSymbol(Name name) {
        return this.symTable.langTransactionModuleSymbol.scope.lookup((Name)name).symbol;
    }

    public BSymbol getInternalTransactionModuleInvokableSymbol(Name name) {
        if (this.symTable.internalTransactionModuleSymbol == null) {
            this.symTable.internalTransactionModuleSymbol = this.packageCache.getSymbol(PackageID.TRANSACTION_INTERNAL);
        }
        return this.symTable.internalTransactionModuleSymbol.scope.lookup((Name)name).symbol;
    }
}

