/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.wso2.ballerinalang.compiler.packaging.RepoHierarchy;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;

public class RepoHierarchyBuilder {
    public static RepoHierarchy build(RepoNode root) {
        List<RepoNode> ordered = RepoHierarchyBuilder.genBreathFirstOrder(root);
        RepoHierarchyBuilder.clearVisitedFlag(ordered);
        return RepoHierarchyBuilder.newHierarchyFromOrderedNodes(ordered);
    }

    private static List<RepoNode> genBreathFirstOrder(RepoNode root) {
        ArrayList<RepoNode> ordered = new ArrayList<RepoNode>();
        LinkedList<RepoNode> queue = new LinkedList<RepoNode>();
        queue.add(root);
        ordered.add(root);
        root.visited = true;
        while (!queue.isEmpty()) {
            RepoNode node = (RepoNode)queue.remove();
            for (RepoNode child : node.children) {
                if (child == null || child.visited) continue;
                child.visited = true;
                ordered.add(child);
                queue.add(child);
            }
        }
        return ordered;
    }

    private static RepoHierarchy newHierarchyFromOrderedNodes(List<RepoNode> ordered) {
        int totalNodes = ordered.size();
        Repo[] orderedRepos = new Repo[totalNodes];
        RepoHierarchy[] orderedDAGs = new RepoHierarchy[totalNodes - 1];
        for (int i = 0; i < totalNodes; ++i) {
            RepoNode repoNode = ordered.get(i);
            orderedRepos[i] = repoNode.repo;
            if (i == 0) continue;
            orderedDAGs[i - 1] = RepoHierarchyBuilder.build(repoNode);
        }
        return new RepoHierarchy(orderedRepos, orderedDAGs);
    }

    private static void clearVisitedFlag(List<RepoNode> ordered) {
        for (RepoNode repoNode : ordered) {
            repoNode.visited = false;
        }
    }

    public static RepoNode node(Repo r, RepoNode ... n) {
        return new RepoNode(r, n);
    }

    public static class RepoNode {
        public final RepoNode[] children;
        public final Repo repo;
        private boolean visited;

        RepoNode(Repo repo, RepoNode[] children) {
            this.children = children;
            this.repo = repo;
        }
    }
}

