/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Path;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.PathConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.NonSysRepo;

public class ProjectSourceRepo
extends NonSysRepo<Path> {
    private final boolean testEnabled;
    private final Manifest manifest;

    public ProjectSourceRepo(Converter<Path> converter, Manifest manifest, boolean testEnabled) {
        super(converter);
        this.testEnabled = testEnabled;
        this.manifest = manifest;
    }

    public ProjectSourceRepo(Path projectRoot, Manifest manifest, boolean testEnabled) {
        this(new PathConverter(projectRoot), manifest, testEnabled);
    }

    @Override
    public Patten calculateNonSysPkg(PackageID moduleID) {
        if (null != this.manifest && !moduleID.orgName.value.equals(this.manifest.getProject().getOrgName())) {
            return Patten.NULL;
        }
        if (this.testEnabled) {
            return new Patten(Patten.path("src"), Patten.path(moduleID.getName().value), Patten.WILDCARD_SOURCE_WITH_TEST);
        }
        return new Patten(Patten.path("src"), Patten.path(moduleID.getName().value), Patten.WILDCARD_SOURCE);
    }
}

