/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.URIConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.NonSysRepo;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;

public class RemoteRepo
extends NonSysRepo<URI> {
    private Path systemBirRepoPath;

    public RemoteRepo(Converter<URI> converter, Path ballerinaHome) {
        super(converter);
        this.systemBirRepoPath = ballerinaHome.resolve("bir-cache");
    }

    public RemoteRepo(URI base, Map<PackageID, Manifest> dependencyManifests, Path ballerinaHome) {
        this(new URIConverter(base, dependencyManifests), ballerinaHome);
    }

    public RemoteRepo(URI base, Map<PackageID, Manifest> dependencyManifests, boolean isBuild, Path ballerinaHome) {
        this(new URIConverter(base, dependencyManifests, isBuild), ballerinaHome);
    }

    @Override
    public Patten calculateNonSysPkg(PackageID pkg) {
        if (pkg.getOrgName().equals(Names.ANON_ORG)) {
            return Patten.NULL;
        }
        String orgName = pkg.getOrgName().value;
        String pkgName = pkg.getName().value;
        String pkgVersion = pkg.getPackageVersion().value;
        if (pkgVersion.isEmpty()) {
            pkgVersion = "*";
        }
        return new Patten(Patten.path(orgName, pkgName, pkgVersion));
    }

    @Override
    public Patten calculate(PackageID pkgId) {
        if (!RepoUtils.COMPILE_BALLERINA_ORG && this.systemBirRepoPath.resolve(pkgId.orgName.value).resolve(pkgId.name.value).toFile().exists()) {
            return Patten.NULL;
        }
        return this.calculateNonSysPkg(pkgId);
    }
}

