/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.ActionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.expressions.XMLNavigationAccess;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableMultiKeyExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangThrow;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class CodeAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<CodeAnalyzer> CODE_ANALYZER_KEY = new CompilerContext.Key();
    private static final String NULL_LITERAL = "null";
    private final SymbolResolver symResolver;
    private int loopCount;
    private int transactionCount;
    private boolean statementReturns;
    private boolean failureHandled;
    private boolean matchClauseReturns;
    private boolean lastStatement;
    private boolean errorThrown;
    private boolean failVisited;
    private boolean hasLastPatternInClause;
    private boolean withinLockBlock;
    private SymbolTable symTable;
    private Types types;
    private BLangDiagnosticLog dlog;
    private TypeChecker typeChecker;
    private Stack<WorkerActionSystem> workerActionSystemStack = new Stack();
    private Stack<Boolean> loopWithinTransactionCheckStack = new Stack();
    private Stack<Boolean> returnWithinTransactionCheckStack = new Stack();
    private Stack<Boolean> doneWithinTransactionCheckStack = new Stack();
    private Stack<Boolean> transactionalFuncCheckStack = new Stack();
    private Stack<Boolean> returnWithinLambdaWrappingCheckStack = new Stack();
    private BLangNode parent;
    private Names names;
    private SymbolEnv env;
    private final Stack<LinkedHashSet<BType>> returnTypes = new Stack();
    private final Stack<LinkedHashSet<BType>> errorTypes = new Stack();
    private boolean isJSONContext;
    private boolean enableExperimentalFeatures;
    private int commitCount;
    private int rollbackCount;
    private boolean withinTransactionScope;
    private boolean commitRollbackAllowed;
    private int commitCountWithinBlock;
    private int rollbackCountWithinBlock;
    private boolean queryToTableWithKey;
    private BType matchExprType;

    public static CodeAnalyzer getInstance(CompilerContext context) {
        CodeAnalyzer codeGenerator = context.get(CODE_ANALYZER_KEY);
        if (codeGenerator == null) {
            codeGenerator = new CodeAnalyzer(context);
        }
        return codeGenerator;
    }

    public CodeAnalyzer(CompilerContext context) {
        context.put(CODE_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeChecker = TypeChecker.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.enableExperimentalFeatures = Boolean.parseBoolean(CompilerOptions.getInstance(context).get(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED));
    }

    private void resetFunction() {
        this.resetStatementReturns();
        this.resetErrorThrown();
    }

    private void resetStatementReturns() {
        this.statementReturns = false;
    }

    private void resetLastStatement() {
        this.lastStatement = false;
    }

    private void resetErrorThrown() {
        this.errorThrown = false;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.CODE_ANALYZE)) {
            return;
        }
        this.parent = pkgNode;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeTopLevelNodes(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
    }

    private void analyzeTopLevelNodes(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        pkgNode.topLevelNodes.forEach(topLevelNode -> this.analyzeNode((BLangNode)((Object)topLevelNode), pkgEnv));
        pkgNode.completedPhases.add(CompilerPhase.CODE_ANALYZE);
        this.parent = null;
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.parent = myParent;
        this.env = prevEnv;
    }

    private void analyzeTypeNode(BLangType node, SymbolEnv env) {
        if (node == null) {
            return;
        }
        this.analyzeNode(node, env);
    }

    @Override
    public void visit(BLangCompilationUnit compUnitNode) {
        compUnitNode.topLevelNodes.forEach(e -> this.analyzeNode((BLangNode)((Object)e), this.env));
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.analyzeTypeNode(typeDefinition.typeNode, this.env);
        typeDefinition.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        SymbolEnv objectEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, this.env);
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.analyzeNode(field, objectEnv);
        }
        ArrayList<BLangFunction> bLangFunctionList = new ArrayList<BLangFunction>(classDefinition.functions);
        if (classDefinition.initFunction != null) {
            bLangFunctionList.add(classDefinition.initFunction);
        }
        bLangFunctionList.sort(Comparator.comparingInt(function -> function.pos.lineRange().startLine().line()));
        for (BLangFunction function2 : bLangFunctionList) {
            this.analyzeNode(function2, objectEnv);
        }
        classDefinition.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.visit(objectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.analyzeNode(bLangTupleVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.analyzeNode(bLangRecordVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.analyzeNode(bLangErrorVariableDef.errorVariable, this.env);
    }

    @Override
    public void visit(BLangResourceFunction funcNode) {
        this.visit((BLangFunction)funcNode);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean isLambda = funcNode.flagSet.contains((Object)Flag.LAMBDA);
        if (isLambda) {
            return;
        }
        this.validateParams(funcNode);
        if (Symbols.isPublic(funcNode.symbol)) {
            funcNode.symbol.params.forEach(symbol -> this.analyzeExportableTypeRef(funcNode.symbol, symbol.type.tsymbol, true, funcNode.pos));
            if (funcNode.symbol.restParam != null) {
                this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.restParam.type.tsymbol, true, funcNode.restParam.pos);
            }
            this.analyzeExportableTypeRef(funcNode.symbol, funcNode.symbol.retType.tsymbol, true, funcNode.returnTypeNode.pos);
        }
        this.validateMainFunction(funcNode);
        this.validateModuleInitFunction(funcNode);
        try {
            this.initNewWorkerActionSystem();
            this.workerActionSystemStack.peek().startWorkerActionStateMachine("default", funcNode.pos, funcNode);
            this.visitFunction(funcNode);
            this.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
        finally {
            this.finalizeCurrentWorkerActionSystem();
        }
        funcNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private void validateParams(BLangFunction funcNode) {
        for (BLangSimpleVariable parameter : funcNode.requiredParams) {
            this.analyzeNode(parameter, this.env);
        }
        if (funcNode.restParam != null) {
            this.analyzeNode(funcNode.restParam, this.env);
        }
    }

    private void visitFunction(BLangFunction funcNode) {
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        this.returnWithinTransactionCheckStack.push(true);
        this.doneWithinTransactionCheckStack.push(true);
        this.returnTypes.push(new LinkedHashSet());
        this.transactionalFuncCheckStack.push(funcNode.flagSet.contains((Object)Flag.TRANSACTIONAL));
        this.resetFunction();
        if (Symbols.isNative(funcNode.symbol)) {
            return;
        }
        if (this.isPublicInvokableNode(funcNode)) {
            this.analyzeNode(funcNode.returnTypeNode, invokableEnv);
        }
        if (funcNode.body != null) {
            boolean isNeverOrNilableReturn;
            this.analyzeNode(funcNode.body, invokableEnv);
            boolean bl = isNeverOrNilableReturn = funcNode.symbol.type.getReturnType().tag == 49 || funcNode.symbol.type.getReturnType().isNullable();
            if (!isNeverOrNilableReturn && !this.statementReturns) {
                this.dlog.error(funcNode.pos, DiagnosticErrorCode.INVOKABLE_MUST_RETURN, funcNode.getKind().toString().toLowerCase());
            }
        }
        this.returnTypes.pop();
        this.returnWithinTransactionCheckStack.pop();
        this.doneWithinTransactionCheckStack.pop();
        this.transactionalFuncCheckStack.pop();
    }

    private boolean isPublicInvokableNode(BLangInvokableNode invNode) {
        return Symbols.isPublic(invNode.symbol) && (SymbolKind.PACKAGE.equals((Object)invNode.symbol.owner.getKind()) || Symbols.isPublic(invNode.symbol.owner));
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        boolean prevWithinTxScope = this.withinTransactionScope;
        if (!this.transactionalFuncCheckStack.empty() && !this.withinTransactionScope) {
            this.withinTransactionScope = this.transactionalFuncCheckStack.peek();
        }
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement e : body.stmts) {
            this.analyzeNode(e, blockEnv);
        }
        this.resetLastStatement();
        if (!this.transactionalFuncCheckStack.empty() && this.transactionalFuncCheckStack.peek().booleanValue()) {
            this.withinTransactionScope = prevWithinTxScope;
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        this.analyzeExpr(body.expr);
        this.statementReturns = true;
        this.resetLastStatement();
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        if (forkJoin.workers.isEmpty()) {
            this.dlog.error(forkJoin.pos, DiagnosticErrorCode.INVALID_FOR_JOIN_SYNTAX_EMPTY_FORK, new Object[0]);
        }
    }

    @Override
    public void visit(BLangWorker worker) {
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.checkStatementExecutionValidity(transactionNode);
        if (!this.transactionalFuncCheckStack.empty() && this.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(transactionNode.pos, DiagnosticErrorCode.TRANSACTION_CANNOT_BE_USED_WITHIN_TRANSACTIONAL_SCOPE, new Object[0]);
            return;
        }
        this.errorTypes.push(new LinkedHashSet());
        boolean failureHandled = this.failureHandled;
        boolean previousWithinTxScope = this.withinTransactionScope;
        int previousCommitCount = this.commitCount;
        int previousRollbackCount = this.rollbackCount;
        boolean prevCommitRollbackAllowed = this.commitRollbackAllowed;
        this.commitRollbackAllowed = true;
        this.commitCount = 0;
        this.rollbackCount = 0;
        this.withinTransactionScope = true;
        this.loopWithinTransactionCheckStack.push(false);
        this.returnWithinTransactionCheckStack.push(false);
        this.doneWithinTransactionCheckStack.push(false);
        ++this.transactionCount;
        if (!this.failureHandled) {
            this.failureHandled = transactionNode.onFailClause != null;
        }
        this.analyzeNode(transactionNode.transactionBody, this.env);
        this.failureHandled = failureHandled;
        if (this.commitCount < 1) {
            this.dlog.error(transactionNode.pos, DiagnosticErrorCode.INVALID_COMMIT_COUNT, new Object[0]);
        }
        --this.transactionCount;
        this.withinTransactionScope = previousWithinTxScope;
        this.commitCount = previousCommitCount;
        this.rollbackCount = previousRollbackCount;
        this.commitRollbackAllowed = prevCommitRollbackAllowed;
        this.returnWithinTransactionCheckStack.pop();
        this.loopWithinTransactionCheckStack.pop();
        this.doneWithinTransactionCheckStack.pop();
        this.analyzeOnFailClause(transactionNode.onFailClause);
        this.errorTypes.pop();
    }

    private void analyzeOnFailClause(BLangOnFailClause onFailClause) {
        if (onFailClause != null) {
            boolean currentStatementReturns = this.statementReturns;
            this.resetStatementReturns();
            this.resetLastStatement();
            this.analyzeNode(onFailClause, this.env);
            this.statementReturns = currentStatementReturns;
        }
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        ++this.commitCount;
        ++this.commitCountWithinBlock;
        if (this.transactionCount == 0) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        if (!this.transactionalFuncCheckStack.empty() && this.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_CANNOT_BE_WITHIN_TRANSACTIONAL_FUNCTION, new Object[0]);
            return;
        }
        if (!this.withinTransactionScope || !this.commitRollbackAllowed || !this.loopWithinTransactionCheckStack.empty() && this.loopWithinTransactionCheckStack.peek().booleanValue()) {
            this.dlog.error(commitExpr.pos, DiagnosticErrorCode.COMMIT_NOT_ALLOWED, new Object[0]);
            return;
        }
        this.withinTransactionScope = false;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        ++this.rollbackCount;
        ++this.rollbackCountWithinBlock;
        if (this.transactionCount == 0 && !this.withinTransactionScope) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_CANNOT_BE_OUTSIDE_TRANSACTION_BLOCK, new Object[0]);
            return;
        }
        if (!this.transactionalFuncCheckStack.empty() && this.transactionalFuncCheckStack.peek().booleanValue()) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_CANNOT_BE_WITHIN_TRANSACTIONAL_FUNCTION, new Object[0]);
            return;
        }
        if (!this.withinTransactionScope || !this.commitRollbackAllowed || !this.loopWithinTransactionCheckStack.empty() && this.loopWithinTransactionCheckStack.peek().booleanValue()) {
            this.dlog.error(rollbackNode.pos, DiagnosticErrorCode.ROLLBACK_NOT_ALLOWED, new Object[0]);
            return;
        }
        this.withinTransactionScope = false;
        this.analyzeExpr(rollbackNode.expr);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.errorTypes.push(new LinkedHashSet());
        boolean failureHandled = this.failureHandled;
        this.checkStatementExecutionValidity(retryNode);
        if (!this.failureHandled) {
            this.failureHandled = retryNode.onFailClause != null;
        }
        retryNode.retrySpec.accept(this);
        retryNode.retryBody.accept(this);
        this.failureHandled = failureHandled;
        this.resetLastStatement();
        this.resetErrorThrown();
        retryNode.retryBody.isBreakable = retryNode.onFailClause != null;
        this.analyzeOnFailClause(retryNode.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        if (retrySpec.retryManagerType != null) {
            BObjectTypeSymbol retryManagerTypeSymbol = (BObjectTypeSymbol)this.symTable.langObjectModuleSymbol.scope.lookup((Name)this.names.fromString((String)"RetryManager")).symbol;
            BType abstractRetryManagerType = retryManagerTypeSymbol.type;
            if (!this.types.isAssignable(retrySpec.retryManagerType.type, abstractRetryManagerType)) {
                this.dlog.error(retrySpec.pos, DiagnosticErrorCode.INVALID_INTERFACE_ON_NON_ABSTRACT_OBJECT, "shouldRetry", retrySpec.retryManagerType.type);
            }
        }
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.analyzeNode(retryTransaction.retrySpec, this.env);
        this.analyzeNode(retryTransaction.transaction, this.env);
    }

    private void checkUnreachableCode(BLangStatement stmt) {
        if (this.statementReturns) {
            this.dlog.error(stmt.pos, DiagnosticErrorCode.UNREACHABLE_CODE, new Object[0]);
            this.resetStatementReturns();
        } else if (this.errorThrown) {
            this.dlog.error(stmt.pos, DiagnosticErrorCode.UNREACHABLE_CODE, new Object[0]);
            this.resetErrorThrown();
        }
        if (this.lastStatement) {
            this.dlog.error(stmt.pos, DiagnosticErrorCode.UNREACHABLE_CODE, new Object[0]);
            this.resetLastStatement();
        }
    }

    private void checkStatementExecutionValidity(BLangStatement stmt) {
        this.checkUnreachableCode(stmt);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        int prevCommitCount = this.commitCountWithinBlock;
        int prevRollbackCount = this.rollbackCountWithinBlock;
        this.commitCountWithinBlock = 0;
        this.rollbackCountWithinBlock = 0;
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts.forEach(e -> this.analyzeNode((BLangNode)e, blockEnv));
        if (this.commitCountWithinBlock > 1 || this.rollbackCountWithinBlock > 1) {
            this.dlog.error(blockNode.pos, DiagnosticErrorCode.MAX_ONE_COMMIT_ROLLBACK_ALLOWED_WITHIN_A_BRANCH, new Object[0]);
        }
        this.commitCountWithinBlock = prevCommitCount;
        this.rollbackCountWithinBlock = prevRollbackCount;
        this.resetLastStatement();
    }

    @Override
    public void visit(BLangReturn returnStmt) {
        this.checkStatementExecutionValidity(returnStmt);
        if (this.checkReturnValidityInTransaction()) {
            this.dlog.error(returnStmt.pos, DiagnosticErrorCode.RETURN_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        if (!this.returnWithinLambdaWrappingCheckStack.empty()) {
            this.returnWithinLambdaWrappingCheckStack.pop();
            this.returnWithinLambdaWrappingCheckStack.push(true);
        }
        if (returnStmt.parent != null && returnStmt.parent.parent.getKind() == NodeKind.MATCH_CLAUSE) {
            this.matchClauseReturns = true;
        } else {
            this.statementReturns = true;
        }
        this.analyzeExpr(returnStmt.expr);
        this.returnTypes.peek().add(returnStmt.expr.type);
    }

    @Override
    public void visit(BLangIf ifStmt) {
        boolean independentBlocks = false;
        int prevCommitCount = this.commitCount;
        int prevRollbackCount = this.rollbackCount;
        this.checkStatementExecutionValidity(ifStmt);
        if (this.withinTransactionScope && ifStmt.elseStmt != null && ifStmt.elseStmt.getKind() != NodeKind.IF) {
            independentBlocks = true;
            this.commitRollbackAllowed = true;
        }
        boolean prevTxMode = this.withinTransactionScope;
        if (ifStmt.expr.getKind() == NodeKind.TRANSACTIONAL_EXPRESSION) {
            this.withinTransactionScope = true;
        }
        this.analyzeNode(ifStmt.body, this.env);
        if (ifStmt.expr.getKind() == NodeKind.TRANSACTIONAL_EXPRESSION) {
            this.withinTransactionScope = prevTxMode;
        }
        boolean ifStmtReturns = this.statementReturns;
        boolean currentErrorThrown = this.errorThrown;
        this.resetStatementReturns();
        this.resetErrorThrown();
        if (ifStmt.elseStmt != null) {
            if (independentBlocks) {
                this.commitRollbackAllowed = true;
                this.withinTransactionScope = true;
            }
            this.analyzeNode(ifStmt.elseStmt, this.env);
            if (prevCommitCount != this.commitCount || prevRollbackCount != this.rollbackCount) {
                this.commitRollbackAllowed = false;
            }
            this.statementReturns = ifStmtReturns && this.statementReturns;
            this.errorThrown = currentErrorThrown && this.errorThrown;
        }
        this.analyzeExpr(ifStmt.expr);
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        this.errorTypes.push(new LinkedHashSet());
        this.analyzeExpr(matchStatement.expr);
        if (!this.failureHandled) {
            this.failureHandled = matchStatement.onFailClause != null;
        }
        this.matchExprType = matchStatement.expr.type;
        boolean currentErrorThrown = this.errorThrown;
        this.hasLastPatternInClause = false;
        boolean containsLastPatternInStatement = false;
        boolean allClausesReturns = true;
        List<BLangMatchClause> matchClauses = matchStatement.matchClauses;
        for (int i = 0; i < matchClauses.size(); ++i) {
            this.matchClauseReturns = false;
            BLangMatchClause matchClause = matchClauses.get(i);
            for (int j = i; j > 0; --j) {
                if (!this.checkSimilarMatchGuard(matchClause.matchGuard, matchClauses.get((int)(j - 1)).matchGuard)) continue;
                this.checkSimilarMatchPatternsBetweenClauses(matchClauses.get(j - 1), matchClause);
            }
            this.resetErrorThrown();
            this.analyzeNode(matchClause, this.env);
            allClausesReturns = allClausesReturns && this.matchClauseReturns;
            containsLastPatternInStatement = containsLastPatternInStatement || matchClause.matchGuard == null && this.hasLastPatternInClause;
        }
        this.statementReturns = allClausesReturns && containsLastPatternInStatement;
        this.errorThrown = currentErrorThrown;
        this.analyzeOnFailClause(matchStatement.onFailClause);
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        HashMap<String, BVarSymbol> variablesInMatchPattern = new HashMap<String, BVarSymbol>();
        boolean patternListContainsSameVars = true;
        List<BLangMatchPattern> matchPatterns = matchClause.matchPatterns;
        for (int i = 0; i < matchPatterns.size(); ++i) {
            BLangMatchPattern matchPattern = matchPatterns.get(i);
            if (this.hasLastPatternInClause && matchClause.matchGuard == null) {
                this.dlog.error(matchPattern.pos, DiagnosticErrorCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
            if (matchPattern.type == this.symTable.noType) {
                this.dlog.error(matchPattern.pos, DiagnosticErrorCode.MATCH_STMT_UNMATCHED_PATTERN, new Object[0]);
            }
            if (patternListContainsSameVars) {
                patternListContainsSameVars = this.compareVariables(variablesInMatchPattern, matchPattern);
            }
            for (int j = i; j > 0; --j) {
                if (!this.checkSimilarMatchPatterns(matchPatterns.get(j - 1), matchPattern)) continue;
                this.dlog.error(matchPattern.pos, DiagnosticErrorCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
            this.isJSONContext = this.types.isJSONContext(this.matchExprType);
            this.analyzeNode(matchPattern, this.env);
            matchPattern.isLastPattern = this.hasLastPatternInClause;
        }
        if (!patternListContainsSameVars) {
            this.dlog.error(matchClause.pos, DiagnosticErrorCode.MATCH_PATTERNS_SHOULD_CONTAIN_SAME_SET_OF_VARIABLES, new Object[0]);
        }
        matchClause.declaredVars.putAll(matchClause.matchPatterns.get((int)0).declaredVars);
        this.analyzeNode(matchClause.blockStmt, this.env);
        this.resetStatementReturns();
    }

    private void checkSimilarMatchPatternsBetweenClauses(BLangMatchClause firstClause, BLangMatchClause secondClause) {
        for (BLangMatchPattern firstMatchPattern : firstClause.matchPatterns) {
            for (BLangMatchPattern secondMatchPattern : secondClause.matchPatterns) {
                if (!this.checkSimilarMatchPatterns(firstMatchPattern, secondMatchPattern)) continue;
                this.dlog.error(secondMatchPattern.pos, DiagnosticErrorCode.MATCH_STMT_PATTERN_UNREACHABLE, new Object[0]);
            }
        }
    }

    private boolean checkSimilarMatchPatterns(BLangMatchPattern firstPattern, BLangMatchPattern secondPattern) {
        NodeKind secondPatternKind;
        NodeKind firstPatternKind = firstPattern.getKind();
        if (firstPatternKind != (secondPatternKind = secondPattern.getKind())) {
            return false;
        }
        switch (firstPatternKind) {
            case CONST_MATCH_PATTERN: {
                return this.checkSimilarConstMatchPattern((BLangConstPattern)firstPattern, (BLangConstPattern)secondPattern);
            }
            case VAR_BINDING_PATTERN_MATCH_PATTERN: {
                return this.checkSimilarBindingPatterns(((BLangVarBindingPatternMatchPattern)firstPattern).getBindingPattern(), ((BLangVarBindingPatternMatchPattern)secondPattern).getBindingPattern());
            }
            case LIST_MATCH_PATTERN: {
                return this.checkSimilarListMatchPattern((BLangListMatchPattern)firstPattern, (BLangListMatchPattern)secondPattern);
            }
            case REST_MATCH_PATTERN: {
                return true;
            }
        }
        return false;
    }

    private boolean checkSimilarConstMatchPattern(BLangConstPattern firstConstMatchPattern, BLangConstPattern secondConstMatchPattern) {
        NodeKind secondConstPatternExprKind;
        NodeKind firstConstPatternExprKind = firstConstMatchPattern.expr.getKind();
        if (firstConstPatternExprKind != (secondConstPatternExprKind = secondConstMatchPattern.expr.getKind())) {
            return false;
        }
        switch (firstConstPatternExprKind) {
            case NUMERIC_LITERAL: {
                return ((BLangNumericLiteral)firstConstMatchPattern.expr).value.equals(((BLangNumericLiteral)secondConstMatchPattern.expr).value);
            }
            case LITERAL: {
                return ((BLangLiteral)firstConstMatchPattern.expr).value.equals(((BLangLiteral)secondConstMatchPattern.expr).value);
            }
            case SIMPLE_VARIABLE_REF: {
                return ((BLangSimpleVarRef)secondConstMatchPattern.expr).variableName.equals(((BLangSimpleVarRef)firstConstMatchPattern.expr).variableName);
            }
        }
        return false;
    }

    private boolean checkSimilarListMatchPattern(BLangListMatchPattern firstListMatchPattern, BLangListMatchPattern secondListMatchPattern) {
        if (firstListMatchPattern.restMatchPattern != null && secondListMatchPattern.restMatchPattern == null) {
            return false;
        }
        if (firstListMatchPattern.restMatchPattern == null && secondListMatchPattern.restMatchPattern != null) {
            return false;
        }
        List<BLangMatchPattern> firstListMatchPatterns = firstListMatchPattern.matchPatterns;
        List<BLangMatchPattern> secondListMatchPatterns = secondListMatchPattern.matchPatterns;
        if (firstListMatchPattern.restMatchPattern == null) {
            if (firstListMatchPatterns.size() != secondListMatchPatterns.size()) {
                return false;
            }
            return this.checkSimilarListMemberPatterns(firstListMatchPatterns, secondListMatchPatterns);
        }
        if (firstListMatchPatterns.size() > secondListMatchPatterns.size()) {
            return false;
        }
        if (firstListMatchPatterns.size() == secondListMatchPatterns.size()) {
            return this.checkSimilarListMemberPatterns(firstListMatchPatterns, secondListMatchPatterns);
        }
        return this.checkSimilarMatchPatterns(firstListMatchPattern.restMatchPattern, secondListMatchPattern.restMatchPattern);
    }

    private boolean checkSimilarListMemberPatterns(List<BLangMatchPattern> firstListMatchPatterns, List<BLangMatchPattern> secondListMatchPatterns) {
        for (int i = 0; i < firstListMatchPatterns.size(); ++i) {
            if (this.checkSimilarMatchPatterns(firstListMatchPatterns.get(i), secondListMatchPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimilarBindingPatterns(BLangBindingPattern firstBidingPattern, BLangBindingPattern secondBindingPattern) {
        NodeKind secondBindingPatternKind;
        NodeKind firstBindingPatternKind = firstBidingPattern.getKind();
        if (firstBindingPatternKind != (secondBindingPatternKind = secondBindingPattern.getKind())) {
            return false;
        }
        switch (firstBindingPatternKind) {
            case CAPTURE_BINDING_PATTERN: {
                return true;
            }
        }
        return false;
    }

    private boolean checkSimilarMatchGuard(BLangMatchGuard firstMatchGuard, BLangMatchGuard secondMatchGuard) {
        if (firstMatchGuard == null && secondMatchGuard == null) {
            return true;
        }
        if (firstMatchGuard == null || secondMatchGuard == null) {
            return false;
        }
        if (firstMatchGuard.expr.getKind() == NodeKind.TYPE_TEST_EXPR && secondMatchGuard.expr.getKind() == NodeKind.TYPE_TEST_EXPR && ((BLangTypeTestExpr)firstMatchGuard.expr).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangTypeTestExpr)secondMatchGuard.expr).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangTypeTestExpr firstTypeTest = (BLangTypeTestExpr)firstMatchGuard.expr;
            BLangTypeTestExpr secondTypeTest = (BLangTypeTestExpr)secondMatchGuard.expr;
            return ((BLangSimpleVarRef)firstTypeTest.expr).variableName.toString().equals(((BLangSimpleVarRef)secondTypeTest.expr).variableName.toString()) && firstTypeTest.typeNode.type.tag == secondTypeTest.typeNode.type.tag;
        }
        return false;
    }

    private boolean compareVariables(Map<String, BVarSymbol> varsInPreviousMatchPattern, BLangMatchPattern matchPattern) {
        Map<String, BVarSymbol> varsInCurrentMatchPattern = matchPattern.declaredVars;
        if (varsInPreviousMatchPattern.size() == 0) {
            varsInPreviousMatchPattern.putAll(varsInCurrentMatchPattern);
            return true;
        }
        if (varsInPreviousMatchPattern.size() != varsInCurrentMatchPattern.size()) {
            return false;
        }
        for (String identifier : varsInPreviousMatchPattern.keySet()) {
            if (varsInCurrentMatchPattern.containsKey(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        this.analyzeNode(constMatchPattern.expr, this.env);
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern) {
        wildCardMatchPattern.matchesAll = wildCardMatchPattern.matchExpr != null && this.types.isAssignable(wildCardMatchPattern.matchExpr.type, this.symTable.anyType);
        this.hasLastPatternInClause = wildCardMatchPattern.matchesAll;
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        BLangBindingPattern bindingPattern = varBindingPattern.getBindingPattern();
        this.analyzeNode(bindingPattern, this.env);
        this.hasLastPatternInClause = varBindingPattern.matchExpr != null && this.hasLastPatternInClause && !varBindingPattern.matchGuardIsAvailable;
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        if (listMatchPattern.matchExpr == null) {
            return;
        }
        this.hasLastPatternInClause = this.types.isSameType(listMatchPattern.type, listMatchPattern.matchExpr.type) && !this.isConstMatchPatternExist(listMatchPattern);
    }

    private boolean isConstMatchPatternExist(BLangMatchPattern matchPattern) {
        if (matchPattern.getKind() != NodeKind.LIST_MATCH_PATTERN) {
            return matchPattern.getKind() == NodeKind.CONST_MATCH_PATTERN;
        }
        for (BLangMatchPattern memberMatchPattern : ((BLangListMatchPattern)matchPattern).matchPatterns) {
            if (!this.isConstMatchPatternExist(memberMatchPattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern) {
        this.hasLastPatternInClause = true;
    }

    @Override
    public void visit(BLangMatch matchStmt) {
        this.errorTypes.push(new LinkedHashSet());
        if (!this.failureHandled) {
            this.failureHandled = matchStmt.onFailClause != null;
        }
        this.analyzeExpr(matchStmt.expr);
        boolean staticLastPattern = false;
        if (!matchStmt.getStaticPatternClauses().isEmpty()) {
            staticLastPattern = this.analyzeStaticMatchPatterns(matchStmt);
        }
        boolean structuredLastPattern = false;
        if (!matchStmt.getStructuredPatternClauses().isEmpty()) {
            structuredLastPattern = this.analyzeStructuredMatchPatterns(matchStmt);
        }
        if (!matchStmt.getPatternClauses().isEmpty()) {
            this.analyzeEmptyMatchPatterns(matchStmt);
            this.analyzeMatchedPatterns(matchStmt, staticLastPattern, structuredLastPattern);
        }
        this.analyzeOnFailClause(matchStmt.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause patternClause) {
        this.analyzeNode(patternClause.matchExpr, this.env);
        this.analyzeNode(patternClause.body, this.env);
        this.resetStatementReturns();
        this.resetErrorThrown();
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause patternClause) {
        this.analyzeNode(patternClause.matchExpr, this.env);
        this.analyzeNode(patternClause.body, this.env);
        this.resetStatementReturns();
        this.resetErrorThrown();
    }

    private void analyzeMatchedPatterns(BLangMatch matchStmt, boolean staticLastPattern, boolean structuredLastPattern) {
        if (staticLastPattern && structuredLastPattern) {
            this.dlog.error(matchStmt.pos, DiagnosticErrorCode.MATCH_STMT_CONTAINS_TWO_DEFAULT_PATTERNS, new Object[0]);
        }
        if (staticLastPattern && !this.hasErrorType(matchStmt.exprTypes) || structuredLastPattern) {
            if (matchStmt.getPatternClauses().size() == 1) {
                this.dlog.error(matchStmt.getPatternClauses().get((int)0).pos, DiagnosticErrorCode.MATCH_STMT_PATTERN_ALWAYS_MATCHES, new Object[0]);
            }
            this.checkStatementExecutionValidity(matchStmt);
            boolean matchStmtReturns = true;
            for (BLangMatch.BLangMatchBindingPatternClause patternClause : matchStmt.getPatternClauses()) {
                this.analyzeNode(patternClause.body, this.env);
                matchStmtReturns = matchStmtReturns && this.statementReturns;
                this.resetStatementReturns();
                this.resetErrorThrown();
            }
            this.statementReturns = matchStmtReturns;
        }
    }

    private boolean hasErrorType(List<BType> typeList) {
        return typeList.stream().anyMatch(t -> this.types.isAssignable((BType)t, this.symTable.errorType));
    }

    private boolean analyzeStructuredMatchPatterns(BLangMatch matchStmt) {
        if (matchStmt.exprTypes.isEmpty()) {
            return false;
        }
        for (BLangMatch.BLangMatchStructuredBindingPatternClause patternClause : matchStmt.getStructuredPatternClauses()) {
            this.analyzeNode(patternClause, this.env);
        }
        return this.analyseStructuredBindingPatterns(matchStmt.getStructuredPatternClauses(), this.hasErrorType(matchStmt.exprTypes));
    }

    private void analyzeEmptyMatchPatterns(BLangMatch matchStmt) {
        ArrayList<BLangMatch.BLangMatchBindingPatternClause> emptyLists = new ArrayList<BLangMatch.BLangMatchBindingPatternClause>();
        ArrayList<BLangMatch.BLangMatchBindingPatternClause> emptyRecords = new ArrayList<BLangMatch.BLangMatchBindingPatternClause>();
        for (BLangMatch.BLangMatchBindingPatternClause pattern : matchStmt.patternClauses) {
            if (pattern.getKind() == NodeKind.MATCH_STATIC_PATTERN_CLAUSE) {
                BLangMatch.BLangMatchStaticBindingPatternClause staticPattern = (BLangMatch.BLangMatchStaticBindingPatternClause)pattern;
                if (staticPattern.literal.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
                    BLangListConstructorExpr listLiteral = (BLangListConstructorExpr)staticPattern.literal;
                    if (!listLiteral.exprs.isEmpty()) continue;
                    emptyLists.add(pattern);
                    continue;
                }
                if (staticPattern.literal.getKind() != NodeKind.RECORD_LITERAL_EXPR) continue;
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)staticPattern.literal;
                if (!recordLiteral.fields.isEmpty()) continue;
                emptyRecords.add(pattern);
                continue;
            }
            if (pattern.getKind() != NodeKind.MATCH_STRUCTURED_PATTERN_CLAUSE) continue;
            BLangMatch.BLangMatchStructuredBindingPatternClause structuredPattern = (BLangMatch.BLangMatchStructuredBindingPatternClause)pattern;
            if (structuredPattern.bindingPatternVariable.getKind() == NodeKind.TUPLE_VARIABLE) {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)structuredPattern.bindingPatternVariable;
                if (!tupleVariable.memberVariables.isEmpty() || tupleVariable.restVariable != null) continue;
                emptyLists.add(pattern);
                continue;
            }
            if (structuredPattern.bindingPatternVariable.getKind() != NodeKind.RECORD_VARIABLE) continue;
            BLangRecordVariable recordVariable = (BLangRecordVariable)structuredPattern.bindingPatternVariable;
            if (!recordVariable.variableList.isEmpty() || recordVariable.restParam != null) continue;
            emptyRecords.add(pattern);
        }
        if (emptyLists.size() > 1) {
            for (int i = 1; i < emptyLists.size(); ++i) {
                this.dlog.error(((BLangMatch.BLangMatchBindingPatternClause)emptyLists.get((int)i)).pos, DiagnosticErrorCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
            }
        }
        if (emptyRecords.size() > 1) {
            for (int i = 1; i < emptyRecords.size(); ++i) {
                this.dlog.error(((BLangMatch.BLangMatchBindingPatternClause)emptyRecords.get((int)i)).pos, DiagnosticErrorCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
            }
        }
    }

    private boolean analyzeStaticMatchPatterns(BLangMatch matchStmt) {
        if (matchStmt.exprTypes.isEmpty()) {
            return false;
        }
        ArrayList<BLangMatch.BLangMatchStaticBindingPatternClause> matchedPatterns = new ArrayList<BLangMatch.BLangMatchStaticBindingPatternClause>();
        for (BLangMatch.BLangMatchStaticBindingPatternClause patternClause : matchStmt.getStaticPatternClauses()) {
            this.analyzeNode(patternClause, this.env);
            ArrayList<BType> matchedExpTypes = new ArrayList<BType>();
            for (BType exprType : matchStmt.exprTypes) {
                if (!this.isValidStaticMatchPattern(exprType, patternClause.literal)) continue;
                matchedExpTypes.add(exprType);
            }
            if (matchedExpTypes.isEmpty()) {
                this.dlog.error(patternClause.pos, DiagnosticErrorCode.MATCH_STMT_UNMATCHED_PATTERN, new Object[0]);
                continue;
            }
            this.isJSONContext = this.types.isJSONContext(matchStmt.expr.type);
            this.analyzeNode(patternClause.literal, this.env);
            matchedPatterns.add(patternClause);
        }
        if (matchedPatterns.isEmpty()) {
            return false;
        }
        return this.analyzeStaticPatterns(matchedPatterns, this.hasErrorType(matchStmt.exprTypes));
    }

    private boolean analyzeStaticPatterns(List<BLangMatch.BLangMatchStaticBindingPatternClause> matchedPatterns, boolean errorTypeInMatchExpr) {
        BLangMatch.BLangMatchStaticBindingPatternClause finalPattern = matchedPatterns.get(matchedPatterns.size() - 1);
        if (finalPattern.literal.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)finalPattern.literal).variableName.value.equals(Names.IGNORE.value) && !errorTypeInMatchExpr) {
            finalPattern.isLastPattern = true;
        }
        for (int i = 0; i < matchedPatterns.size() - 1; ++i) {
            BLangExpression precedingPattern = matchedPatterns.get((int)i).literal;
            for (int j = i + 1; j < matchedPatterns.size(); ++j) {
                BLangExpression pattern = matchedPatterns.get((int)j).literal;
                if (!this.checkLiteralSimilarity(precedingPattern, pattern)) continue;
                this.dlog.error(pattern.pos, DiagnosticErrorCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
                matchedPatterns.remove(j--);
            }
        }
        return finalPattern.isLastPattern;
    }

    private boolean analyseStructuredBindingPatterns(List<BLangMatch.BLangMatchStructuredBindingPatternClause> clauses, boolean errorTypeInMatchExpr) {
        BLangMatch.BLangMatchStructuredBindingPatternClause finalPattern = clauses.get(clauses.size() - 1);
        if (!(finalPattern.bindingPatternVariable.getKind() != NodeKind.VARIABLE || finalPattern.typeGuardExpr != null || errorTypeInMatchExpr && this.isWildcardMatchPattern(finalPattern))) {
            finalPattern.isLastPattern = true;
        }
        for (int i = 0; i < clauses.size(); ++i) {
            BLangMatch.BLangMatchStructuredBindingPatternClause precedingPattern = clauses.get(i);
            if (precedingPattern.typeGuardExpr != null) {
                this.analyzeExpr(precedingPattern.typeGuardExpr);
            }
            for (int j = i + 1; j < clauses.size(); ++j) {
                BLangMatch.BLangMatchStructuredBindingPatternClause currentPattern = clauses.get(j);
                BLangVariable precedingVar = precedingPattern.bindingPatternVariable;
                BLangVariable currentVar = currentPattern.bindingPatternVariable;
                if (!this.checkStructuredPatternSimilarity(precedingVar, currentVar, errorTypeInMatchExpr) || !this.checkTypeGuardSimilarity(precedingPattern.typeGuardExpr, currentPattern.typeGuardExpr)) continue;
                this.dlog.error(currentVar.pos, DiagnosticErrorCode.MATCH_STMT_UNREACHABLE_PATTERN, new Object[0]);
                clauses.remove(j--);
            }
        }
        return finalPattern.isLastPattern;
    }

    private boolean isWildcardMatchPattern(BLangMatch.BLangMatchStructuredBindingPatternClause finalPattern) {
        return ((BLangSimpleVariable)finalPattern.bindingPatternVariable).name.value.equals(Names.IGNORE.value);
    }

    private boolean checkLiteralSimilarity(BLangExpression precedingPattern, BLangExpression pattern) {
        if (precedingPattern.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr precedingBinaryExpr = (BLangBinaryExpr)precedingPattern;
            BLangExpression precedingLhsExpr = precedingBinaryExpr.lhsExpr;
            BLangExpression precedingRhsExpr = precedingBinaryExpr.rhsExpr;
            return this.checkLiteralSimilarity(precedingLhsExpr, pattern) || this.checkLiteralSimilarity(precedingRhsExpr, pattern);
        }
        if (pattern.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr binaryExpr = (BLangBinaryExpr)pattern;
            BLangExpression lhsExpr = binaryExpr.lhsExpr;
            BLangExpression rhsExpr = binaryExpr.rhsExpr;
            return this.checkLiteralSimilarity(precedingPattern, lhsExpr) || this.checkLiteralSimilarity(precedingPattern, rhsExpr);
        }
        switch (precedingPattern.type.tag) {
            case 15: {
                if (pattern.type.tag == 15) {
                    BLangRecordLiteral precedingRecordLiteral = (BLangRecordLiteral)precedingPattern;
                    Map<String, BLangExpression> recordLiteral = ((BLangRecordLiteral)pattern).fields.stream().map(field -> (BLangRecordLiteral.BLangRecordKeyValueField)field).collect(Collectors.toMap(keyValuePair -> ((BLangSimpleVarRef)keyValuePair.key.expr).variableName.value, BLangRecordLiteral.BLangRecordKeyValueField::getValue));
                    for (int i2 = 0; i2 < precedingRecordLiteral.fields.size(); ++i2) {
                        BLangRecordLiteral.BLangRecordKeyValueField bLangRecordKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)precedingRecordLiteral.fields.get(i2);
                        String key = ((BLangSimpleVarRef)bLangRecordKeyValue.key.expr).variableName.value;
                        if (!recordLiteral.containsKey(key)) {
                            return false;
                        }
                        if (this.checkLiteralSimilarity(bLangRecordKeyValue.valueExpr, recordLiteral.get(key))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case 30: {
                if (pattern.type.tag == 30) {
                    BLangListConstructorExpr precedingTupleLiteral = (BLangListConstructorExpr)precedingPattern;
                    BLangListConstructorExpr tupleLiteral = (BLangListConstructorExpr)pattern;
                    if (precedingTupleLiteral.exprs.size() != tupleLiteral.exprs.size()) {
                        return false;
                    }
                    return IntStream.range(0, precedingTupleLiteral.exprs.size()).allMatch(i -> this.checkLiteralSimilarity(precedingTupleLiteral.exprs.get(i), tupleLiteral.exprs.get(i)));
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (precedingPattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                    BConstantSymbol precedingPatternSym = (BConstantSymbol)((BLangSimpleVarRef)precedingPattern).symbol;
                    if (pattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        if (!((BLangSimpleVarRef)pattern).variableName.value.equals(Names.IGNORE.value)) {
                            BConstantSymbol patternSym = (BConstantSymbol)((BLangSimpleVarRef)pattern).symbol;
                            return precedingPatternSym.value.equals(patternSym.value);
                        }
                        return false;
                    }
                    BLangLiteral literal = pattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)pattern).expression : (BLangLiteral)pattern;
                    return precedingPatternSym.value.equals(literal.value);
                }
                if (this.types.isValueType(pattern.type)) {
                    BLangLiteral precedingLiteral;
                    BLangLiteral bLangLiteral = precedingLiteral = precedingPattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)precedingPattern).expression : (BLangLiteral)precedingPattern;
                    if (pattern.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                        if (pattern.type.tag != 23) {
                            BConstantSymbol patternSym = (BConstantSymbol)((BLangSimpleVarRef)pattern).symbol;
                            return patternSym.value.equals(precedingLiteral.value);
                        }
                        return false;
                    }
                    BLangLiteral literal = pattern.getKind() == NodeKind.GROUP_EXPR ? (BLangLiteral)((BLangGroupExpr)pattern).expression : (BLangLiteral)pattern;
                    return precedingLiteral.value.equals(literal.value);
                }
                return false;
            }
            case 17: {
                return pattern.type.tag != 28;
            }
        }
        return false;
    }

    private boolean checkTypeGuardSimilarity(BLangExpression precedingGuard, BLangExpression currentGuard) {
        if (precedingGuard != null && currentGuard != null) {
            if (precedingGuard.getKind() == NodeKind.TYPE_TEST_EXPR && currentGuard.getKind() == NodeKind.TYPE_TEST_EXPR && ((BLangTypeTestExpr)precedingGuard).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangTypeTestExpr)currentGuard).expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangTypeTestExpr precedingTypeTest = (BLangTypeTestExpr)precedingGuard;
                BLangTypeTestExpr currentTypeTest = (BLangTypeTestExpr)currentGuard;
                return ((BLangSimpleVarRef)precedingTypeTest.expr).variableName.toString().equals(((BLangSimpleVarRef)currentTypeTest.expr).variableName.toString()) && precedingTypeTest.typeNode.type.tag == currentTypeTest.typeNode.type.tag;
            }
            return false;
        }
        return currentGuard != null || precedingGuard == null;
    }

    private boolean checkStructuredPatternSimilarity(BLangVariable precedingVar, BLangVariable var, boolean errorTypeInMatchExpr) {
        if (precedingVar.type.tag == 27 || var.type.tag == 27) {
            return false;
        }
        if (precedingVar.getKind() == NodeKind.RECORD_VARIABLE && var.getKind() == NodeKind.RECORD_VARIABLE) {
            BLangRecordVariable precedingRecVar = (BLangRecordVariable)precedingVar;
            BLangRecordVariable recVar = (BLangRecordVariable)var;
            Map<String, BLangVariable> recVarAsMap = recVar.variableList.stream().collect(Collectors.toMap(keyValue -> keyValue.key.value, keyValue -> keyValue.valueBindingPattern));
            if (precedingRecVar.variableList.size() > recVar.variableList.size()) {
                return false;
            }
            for (int i = 0; i < precedingRecVar.variableList.size(); ++i) {
                BLangRecordVariable.BLangRecordVariableKeyValue precedingKeyValue = precedingRecVar.variableList.get(i);
                if (!recVarAsMap.containsKey(precedingKeyValue.key.value)) {
                    return false;
                }
                if (this.checkStructuredPatternSimilarity(precedingKeyValue.valueBindingPattern, recVarAsMap.get(precedingKeyValue.key.value), errorTypeInMatchExpr)) continue;
                return false;
            }
            if (precedingRecVar.hasRestParam() && recVar.hasRestParam()) {
                return true;
            }
            return precedingRecVar.hasRestParam() || !recVar.hasRestParam();
        }
        if (precedingVar.getKind() == NodeKind.TUPLE_VARIABLE && var.getKind() == NodeKind.TUPLE_VARIABLE) {
            List<BLangVariable> precedingMemberVars = ((BLangTupleVariable)precedingVar).memberVariables;
            BLangVariable precedingRestVar = ((BLangTupleVariable)precedingVar).restVariable;
            List<BLangVariable> memberVars = ((BLangTupleVariable)var).memberVariables;
            BLangVariable memberRestVar = ((BLangTupleVariable)var).restVariable;
            if (precedingRestVar != null && memberRestVar != null) {
                return true;
            }
            if (precedingRestVar == null && memberRestVar == null && precedingMemberVars.size() != memberVars.size()) {
                return false;
            }
            if (precedingRestVar != null && precedingMemberVars.size() > memberVars.size()) {
                return false;
            }
            if (memberRestVar != null) {
                return false;
            }
            for (int i = 0; i < memberVars.size(); ++i) {
                if (this.checkStructuredPatternSimilarity(precedingMemberVars.get(i), memberVars.get(i), errorTypeInMatchExpr)) continue;
                return false;
            }
            return true;
        }
        if (precedingVar.getKind() == NodeKind.ERROR_VARIABLE && var.getKind() == NodeKind.ERROR_VARIABLE) {
            BLangErrorVariable precedingErrVar = (BLangErrorVariable)precedingVar;
            BLangErrorVariable errVar = (BLangErrorVariable)var;
            if (precedingErrVar.restDetail != null && this.isDirectErrorBindingPattern(precedingErrVar)) {
                return true;
            }
            if (errVar.restDetail != null) {
                return false;
            }
            if (precedingErrVar.detail != null && errVar.detail != null) {
                Map<String, BLangVariable> preDetails = precedingErrVar.detail.stream().collect(Collectors.toMap(entry -> entry.key.value, entry -> entry.valueBindingPattern));
                for (BLangErrorVariable.BLangErrorDetailEntry detailEntry : errVar.detail) {
                    BLangVariable correspondingCurDetail = preDetails.get(detailEntry.key.value);
                    if (correspondingCurDetail == null) {
                        return false;
                    }
                    boolean similar = this.checkStructuredPatternSimilarity(detailEntry.valueBindingPattern, correspondingCurDetail, errorTypeInMatchExpr);
                    if (similar) continue;
                    return false;
                }
            }
            return true;
        }
        if (precedingVar.getKind() == NodeKind.VARIABLE && ((BLangSimpleVariable)precedingVar).name.value.equals(Names.IGNORE.value) && var.getKind() == NodeKind.ERROR_VARIABLE) {
            return false;
        }
        return precedingVar.getKind() == NodeKind.VARIABLE;
    }

    private boolean isDirectErrorBindingPattern(BLangErrorVariable precedingErrVar) {
        return precedingErrVar.typeNode == null;
    }

    private boolean isValidStaticMatchPattern(BType matchType, BLangExpression literal) {
        if (literal.type.tag == 23) {
            return true;
        }
        if (this.types.isSameType(literal.type, matchType)) {
            return true;
        }
        if (17 == literal.type.tag) {
            return true;
        }
        switch (matchType.tag) {
            case 7: 
            case 11: 
            case 17: {
                return true;
            }
            case 20: {
                BUnionType unionMatchType = (BUnionType)matchType;
                return unionMatchType.getMemberTypes().stream().anyMatch(memberMatchType -> this.isValidStaticMatchPattern((BType)memberMatchType, literal));
            }
            case 30: {
                if (literal.type.tag != 30) break;
                BLangListConstructorExpr tupleLiteral = (BLangListConstructorExpr)literal;
                BTupleType literalTupleType = (BTupleType)literal.type;
                BTupleType matchTupleType = (BTupleType)matchType;
                if (literalTupleType.tupleTypes.size() != matchTupleType.tupleTypes.size()) {
                    return false;
                }
                return IntStream.range(0, literalTupleType.tupleTypes.size()).allMatch(i -> this.isValidStaticMatchPattern(matchTupleType.tupleTypes.get(i), tupleLiteral.exprs.get(i)));
            }
            case 15: {
                if (literal.type.tag != 15) break;
                BLangRecordLiteral mapLiteral = (BLangRecordLiteral)literal;
                return IntStream.range(0, mapLiteral.fields.size()).allMatch(i -> this.isValidStaticMatchPattern(((BMapType)matchType).constraint, ((BLangRecordLiteral.BLangRecordKeyValueField)mapLiteral.fields.get((int)i)).valueExpr));
            }
            case 12: {
                if (literal.type.tag != 15) break;
                BLangRecordLiteral mapLiteral = (BLangRecordLiteral)literal;
                BRecordType recordMatchType = (BRecordType)matchType;
                LinkedHashMap recordFields = recordMatchType.fields;
                for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
                    String literalKeyName;
                    BLangRecordLiteral.BLangRecordKeyValueField literalKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                    NodeKind nodeKind = literalKeyValue.key.expr.getKind();
                    if (nodeKind == NodeKind.SIMPLE_VARIABLE_REF) {
                        literalKeyName = ((BLangSimpleVarRef)literalKeyValue.key.expr).variableName.value;
                    } else if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
                        literalKeyName = ((BLangLiteral)literalKeyValue.key.expr).value.toString();
                    } else {
                        return false;
                    }
                    if (!(recordFields.containsKey(literalKeyName) ? !this.isValidStaticMatchPattern(((BField)recordFields.get((Object)literalKeyName)).type, literalKeyValue.valueExpr) : recordMatchType.sealed || !this.isValidStaticMatchPattern(recordMatchType.restFieldType, literalKeyValue.valueExpr))) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (literal.type.tag != 1) break;
                return true;
            }
            case 32: {
                if (literal.getKind() == NodeKind.LITERAL || literal.getKind() == NodeKind.NUMERIC_LITERAL) {
                    return this.types.isAssignableToFiniteType(matchType, (BLangLiteral)literal);
                }
                if (literal.getKind() != NodeKind.SIMPLE_VARIABLE_REF || ((BLangSimpleVarRef)literal).symbol.getKind() != SymbolKind.CONSTANT) break;
                BConstantSymbol constSymbol = (BConstantSymbol)((BLangSimpleVarRef)literal).symbol;
                return this.types.isAssignableToFiniteType(matchType, (BLangLiteral)((BFiniteType)constSymbol.type).getValueSpace().iterator().next());
            }
        }
        return false;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.loopWithinTransactionCheckStack.push(true);
        this.errorTypes.push(new LinkedHashSet());
        boolean statementReturns = this.statementReturns;
        boolean failureHandled = this.failureHandled;
        this.checkStatementExecutionValidity(foreach);
        if (!this.failureHandled) {
            this.failureHandled = foreach.onFailClause != null;
        }
        ++this.loopCount;
        this.analyzeNode(foreach.body, this.env);
        --this.loopCount;
        this.statementReturns = statementReturns;
        this.failureHandled = failureHandled;
        this.resetLastStatement();
        this.loopWithinTransactionCheckStack.pop();
        this.analyzeExpr(foreach.collection);
        foreach.body.isBreakable = foreach.onFailClause != null;
        this.analyzeOnFailClause(foreach.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.loopWithinTransactionCheckStack.push(true);
        this.errorTypes.push(new LinkedHashSet());
        boolean statementReturns = this.statementReturns;
        boolean failureHandled = this.failureHandled;
        this.checkStatementExecutionValidity(whileNode);
        if (!this.failureHandled) {
            this.failureHandled = whileNode.onFailClause != null;
        }
        ++this.loopCount;
        this.analyzeNode(whileNode.body, this.env);
        --this.loopCount;
        this.statementReturns = statementReturns;
        this.failureHandled = failureHandled;
        this.resetLastStatement();
        this.loopWithinTransactionCheckStack.pop();
        this.analyzeExpr(whileNode.expr);
        this.analyzeOnFailClause(whileNode.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangDo doNode) {
        this.errorTypes.push(new LinkedHashSet());
        boolean failureHandled = this.failureHandled;
        this.checkStatementExecutionValidity(doNode);
        if (!this.failureHandled) {
            this.failureHandled = doNode.onFailClause != null;
        }
        this.analyzeNode(doNode.body, this.env);
        this.failureHandled = failureHandled;
        doNode.body.isBreakable = doNode.onFailClause != null;
        this.analyzeOnFailClause(doNode.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangFail failNode) {
        this.checkStatementExecutionValidity(failNode);
        this.failVisited = true;
        this.errorThrown = true;
        this.analyzeExpr(failNode.expr);
        if (this.env.scope.owner.getKind() == SymbolKind.PACKAGE) {
            return;
        }
        this.typeChecker.checkExpr(failNode.expr, this.env);
        if (!this.errorTypes.empty()) {
            this.errorTypes.peek().add(this.getErrorTypes(failNode.expr.type));
        }
        if (!this.failureHandled) {
            this.statementReturns = true;
            BType exprType = this.env.enclInvokable.getReturnTypeNode().type;
            this.returnTypes.peek().add(exprType);
            if (!this.types.isAssignable(this.getErrorTypes(failNode.expr.type), exprType)) {
                this.dlog.error(failNode.pos, DiagnosticErrorCode.FAIL_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE, new Object[0]);
            }
        }
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.errorTypes.push(new LinkedHashSet());
        boolean failureHandled = this.failureHandled;
        this.checkStatementExecutionValidity(lockNode);
        if (!this.failureHandled) {
            this.failureHandled = lockNode.onFailClause != null;
        }
        boolean previousWithinLockBlock = this.withinLockBlock;
        this.withinLockBlock = true;
        lockNode.body.stmts.forEach(e -> this.analyzeNode((BLangNode)e, this.env));
        this.withinLockBlock = previousWithinLockBlock;
        this.failureHandled = failureHandled;
        lockNode.body.isBreakable = lockNode.onFailClause != null;
        this.analyzeOnFailClause(lockNode.onFailClause);
        this.errorTypes.pop();
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.checkStatementExecutionValidity(continueNode);
        if (this.loopCount == 0) {
            this.dlog.error(continueNode.pos, DiagnosticErrorCode.CONTINUE_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction()) {
            this.dlog.error(continueNode.pos, DiagnosticErrorCode.CONTINUE_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        BPackageSymbol pkgSymbol = importPkgNode.symbol;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgSymbol);
        if (pkgEnv == null) {
            return;
        }
        this.analyzeNode(pkgEnv.node, this.env);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangResource resourceNode) {
        throw new RuntimeException("Deprecated lang feature");
    }

    private void analyzeExportableTypeRef(BSymbol owner, BTypeSymbol symbol, boolean inFuncSignature, Location pos) {
        if (!inFuncSignature && Symbols.isFlagOn(owner.flags, 2048L)) {
            return;
        }
        if (Symbols.isPublic(owner)) {
            this.checkForExportableType(symbol, pos);
        }
    }

    private void checkForExportableType(BTypeSymbol symbol, Location pos) {
        if (symbol == null || symbol.type == null || Symbols.isFlagOn(symbol.flags, 0x200000L)) {
            return;
        }
        switch (symbol.type.tag) {
            case 19: {
                this.checkForExportableType(((BArrayType)symbol.type).eType.tsymbol, pos);
                return;
            }
            case 30: {
                BTupleType tupleType = (BTupleType)symbol.type;
                tupleType.tupleTypes.forEach(t -> this.checkForExportableType(t.tsymbol, pos));
                if (tupleType.restType != null) {
                    this.checkForExportableType(tupleType.restType.tsymbol, pos);
                }
                return;
            }
            case 15: {
                this.checkForExportableType(((BMapType)symbol.type).constraint.tsymbol, pos);
                return;
            }
            case 12: {
                if (!Symbols.isFlagOn(symbol.flags, 2048L)) break;
                BRecordType recordType = (BRecordType)symbol.type;
                recordType.fields.values().forEach(f -> this.checkForExportableType(f.type.tsymbol, pos));
                if (recordType.restFieldType != null) {
                    this.checkForExportableType(recordType.restFieldType.tsymbol, pos);
                }
                return;
            }
            case 9: {
                BTableType tableType = (BTableType)symbol.type;
                if (tableType.constraint != null) {
                    this.checkForExportableType(tableType.constraint.tsymbol, pos);
                }
                return;
            }
            case 14: {
                BStreamType streamType = (BStreamType)symbol.type;
                if (streamType.constraint != null) {
                    this.checkForExportableType(streamType.constraint.tsymbol, pos);
                }
                return;
            }
            case 16: {
                BInvokableType invokableType = (BInvokableType)symbol.type;
                if (invokableType.paramTypes != null) {
                    for (BType paramType : invokableType.paramTypes) {
                        this.checkForExportableType(paramType.tsymbol, pos);
                    }
                }
                if (invokableType.restType != null) {
                    this.checkForExportableType(invokableType.restType.tsymbol, pos);
                }
                this.checkForExportableType(invokableType.retType.tsymbol, pos);
                return;
            }
            case 51: {
                BTypeSymbol parameterizedType = ((BParameterizedType)symbol.type).paramValueType.tsymbol;
                this.checkForExportableType(parameterizedType, pos);
                return;
            }
        }
        if (!Symbols.isPublic(symbol)) {
            this.dlog.error(pos, DiagnosticErrorCode.ATTEMPT_EXPOSE_NON_PUBLIC_SYMBOL, symbol.name);
        }
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        int ownerSymTag = this.env.scope.owner.tag;
        if ((ownerSymTag & 0x5005C) == 327772) {
            this.dlog.error(letExpression.pos, DiagnosticErrorCode.LET_EXPRESSION_NOT_YET_SUPPORTED_RECORD_FIELD, new Object[0]);
        } else if ((ownerSymTag & 0x3005C) == 196700) {
            this.dlog.error(letExpression.pos, DiagnosticErrorCode.LET_EXPRESSION_NOT_YET_SUPPORTED_OBJECT_FIELD, new Object[0]);
        }
        boolean returnStateBefore = this.statementReturns;
        this.statementReturns = false;
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode), letExpression.env);
        }
        this.statementReturns = returnStateBefore;
        this.analyzeExpr(letExpression.expr, letExpression.env);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        this.analyzeTypeNode(varNode.typeNode, this.env);
        this.analyzeExpr(varNode.expr);
        if (Objects.isNull(varNode.symbol)) {
            return;
        }
        if (!Symbols.isPublic(varNode.symbol)) {
            return;
        }
        int ownerSymTag = this.env.scope.owner.tag;
        if ((ownerSymTag & 0x5005C) == 327772 || (ownerSymTag & 0x3005C) == 196700) {
            this.analyzeExportableTypeRef(this.env.scope.owner, varNode.type.tsymbol, false, varNode.pos);
        } else if ((ownerSymTag & 0x100) != 256) {
            this.analyzeExportableTypeRef(varNode.symbol, varNode.type.tsymbol, false, varNode.pos);
        }
        varNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private void checkWorkerPeerWorkerUsageInsideWorker(Location pos, BSymbol symbol, SymbolEnv env) {
        if ((symbol.flags & 0x800000L) == 0x800000L && this.isCurrentPositionInWorker(env) && env.scope.lookup((Name)symbol.name).symbol == null) {
            if (this.referingForkedWorkerOutOfFork(symbol, env)) {
                return;
            }
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_WORKER_REFERRENCE, symbol.name);
        }
    }

    private boolean isCurrentPositionInWorker(SymbolEnv env) {
        if (env.enclInvokable != null && env.enclInvokable.flagSet.contains((Object)Flag.WORKER)) {
            return true;
        }
        if (env.enclEnv != null && env.enclEnv.node.getKind() != NodeKind.PACKAGE && env.enclEnv.node.getKind() != NodeKind.OBJECT_TYPE) {
            return this.isCurrentPositionInWorker(env.enclEnv);
        }
        return false;
    }

    private boolean referingForkedWorkerOutOfFork(BSymbol symbol, SymbolEnv env) {
        return (symbol.flags & 0x1000000L) == 0x1000000L && env.enclInvokable.getKind() == NodeKind.FUNCTION && ((BLangFunction)env.enclInvokable).anonForkName == null;
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        if (bLangTupleVariable.typeNode != null) {
            this.analyzeNode(bLangTupleVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangTupleVariable.expr);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        if (bLangRecordVariable.typeNode != null) {
            this.analyzeNode(bLangRecordVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangRecordVariable.expr);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        if (bLangErrorVariable.typeNode != null) {
            this.analyzeNode(bLangErrorVariable.typeNode, this.env);
        }
        this.analyzeExpr(bLangErrorVariable.expr);
    }

    private BType getNilableType(BType type) {
        if (type.isNullable()) {
            return type;
        }
        BUnionType unionType = BUnionType.create(null, new BType[0]);
        if (type.tag == 20) {
            LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>(((BUnionType)type).getMemberTypes());
            unionType.addAll(memTypes);
        }
        unionType.add(type);
        unionType.add(this.symTable.nilType);
        return unionType;
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        this.analyzeExpr(annAttachmentNode.expr);
        BAnnotationSymbol annotationSymbol = annAttachmentNode.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16L)) {
            this.dlog.warning(annAttachmentNode.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, annotationSymbol);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.checkStatementExecutionValidity(varDefNode);
        this.analyzeNode(varDefNode.var, this.env);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        this.checkStatementExecutionValidity(compoundAssignment);
        this.analyzeExpr(compoundAssignment.varRef);
        this.analyzeExpr(compoundAssignment.expr);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.checkStatementExecutionValidity(assignNode);
        this.analyzeExpr(assignNode.varRef);
        this.analyzeExpr(assignNode.expr);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.checkDuplicateVarRefs(this.getVarRefs(stmt.varRef));
        this.checkStatementExecutionValidity(stmt);
        this.analyzeExpr(stmt.varRef);
        this.analyzeExpr(stmt.expr);
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs) {
        this.checkDuplicateVarRefs(varRefs, new HashSet<BSymbol>());
    }

    private void checkDuplicateVarRefs(List<BLangExpression> varRefs, Set<BSymbol> symbols) {
        for (BLangExpression varRef : varRefs) {
            if (varRef == null || varRef.getKind() != NodeKind.SIMPLE_VARIABLE_REF && varRef.getKind() != NodeKind.RECORD_VARIABLE_REF && varRef.getKind() != NodeKind.ERROR_VARIABLE_REF && varRef.getKind() != NodeKind.TUPLE_VARIABLE_REF || varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && this.names.fromIdNode(((BLangSimpleVarRef)varRef).variableName) == Names.IGNORE) continue;
            if (varRef.getKind() == NodeKind.TUPLE_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangTupleVarRef)varRef), symbols);
            }
            if (varRef.getKind() == NodeKind.RECORD_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangRecordVarRef)varRef), symbols);
            }
            if (varRef.getKind() == NodeKind.ERROR_VARIABLE_REF) {
                this.checkDuplicateVarRefs(this.getVarRefs((BLangErrorVarRef)varRef), symbols);
            }
            BLangVariableReference varRefExpr = (BLangVariableReference)varRef;
            if (varRefExpr.symbol == null || symbols.add(varRefExpr.symbol)) continue;
            this.dlog.error(varRef.pos, DiagnosticErrorCode.DUPLICATE_VARIABLE_IN_BINDING_PATTERN, varRefExpr.symbol);
        }
    }

    private List<BLangExpression> getVarRefs(BLangRecordVarRef varRef) {
        List<BLangExpression> varRefs = varRef.recordRefFields.stream().map(e -> e.variableReference).collect(Collectors.toList());
        varRefs.add((BLangExpression)varRef.restParam);
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangErrorVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>();
        if (varRef.message != null) {
            varRefs.add(varRef.message);
        }
        if (varRef.cause != null) {
            varRefs.add(varRef.cause);
        }
        varRefs.addAll(varRef.detail.stream().map(e -> e.expr).collect(Collectors.toList()));
        varRefs.add(varRef.restVar);
        return varRefs;
    }

    private List<BLangExpression> getVarRefs(BLangTupleVarRef varRef) {
        ArrayList<BLangExpression> varRefs = new ArrayList<BLangExpression>(varRef.expressions);
        varRefs.add((BLangExpression)varRef.restParam);
        return varRefs;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.checkStatementExecutionValidity(breakNode);
        if (this.loopCount == 0) {
            this.dlog.error(breakNode.pos, DiagnosticErrorCode.BREAK_CANNOT_BE_OUTSIDE_LOOP, new Object[0]);
            return;
        }
        if (this.checkNextBreakValidityInTransaction()) {
            this.dlog.error(breakNode.pos, DiagnosticErrorCode.BREAK_CANNOT_BE_USED_TO_EXIT_TRANSACTION, new Object[0]);
            return;
        }
        this.lastStatement = true;
    }

    @Override
    public void visit(BLangThrow throwNode) {
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.checkStatementExecutionValidity(panicNode);
        this.statementReturns = true;
        this.analyzeExpr(panicNode.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.checkStatementExecutionValidity(xmlnsStmtNode);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.checkStatementExecutionValidity(exprStmtNode);
        this.analyzeExpr(exprStmtNode.expr);
        this.validateExprStatementExpression(exprStmtNode);
    }

    private void validateExprStatementExpression(BLangExpressionStmt exprStmtNode) {
        BLangExpression expr = exprStmtNode.expr;
        if (expr.getKind() == NodeKind.WORKER_SYNC_SEND) {
            return;
        }
        while (expr.getKind() == NodeKind.MATCH_EXPRESSION || expr.getKind() == NodeKind.CHECK_EXPR || expr.getKind() == NodeKind.CHECK_PANIC_EXPR) {
            if (expr.getKind() == NodeKind.MATCH_EXPRESSION) {
                expr = ((BLangMatchExpression)expr).expr;
                continue;
            }
            if (expr.getKind() == NodeKind.CHECK_EXPR) {
                expr = ((BLangCheckedExpr)expr).expr;
                continue;
            }
            if (expr.getKind() != NodeKind.CHECK_PANIC_EXPR) continue;
            expr = ((BLangCheckPanickedExpr)expr).expr;
        }
        if (expr.getKind() == NodeKind.INVOCATION || expr.getKind() == NodeKind.WAIT_EXPR) {
            return;
        }
        if (expr.type == this.symTable.nilType) {
            this.dlog.error(exprStmtNode.pos, DiagnosticErrorCode.INVALID_EXPR_STATEMENT, new Object[0]);
        }
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
    }

    @Override
    public void visit(BLangCatch catchNode) {
    }

    private boolean isTopLevel() {
        SymbolEnv env = this.env;
        return env.enclInvokable.body == env.node;
    }

    private boolean isInWorker() {
        return this.env.enclInvokable.flagSet.contains((Object)Flag.WORKER);
    }

    private boolean isCommunicationAllowedLocation(String workerIdentifier) {
        return this.isDefaultWorkerCommunication(workerIdentifier) && this.isInWorker() || this.isTopLevel();
    }

    private boolean isDefaultWorkerCommunication(String workerIdentifier) {
        return workerIdentifier.equals("default");
    }

    private boolean workerExists(BType type, String workerName) {
        if (this.isDefaultWorkerCommunication(workerName) && this.isInWorker()) {
            return true;
        }
        if (type == this.symTable.semanticError) {
            return false;
        }
        return type.tag == 31 && ((BFutureType)type).workerDerivative;
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerSendNode.workerIdentifier));
        if ((receiver.tag & 0x34) != 52) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(workerSendNode.pos, receiver, workerSendNode.workerIdentifier.value);
        this.checkStatementExecutionValidity(workerSendNode);
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        BType type = workerSendNode.expr.type;
        if (type == this.symTable.semanticError) {
            was.hasErrors = true;
        } else if (workerSendNode.expr instanceof ActionNode) {
            this.dlog.error(workerSendNode.expr.pos, DiagnosticErrorCode.INVALID_SEND_EXPR, new Object[0]);
        } else if (!type.isAnydata()) {
            this.dlog.error(workerSendNode.pos, DiagnosticErrorCode.INVALID_TYPE_FOR_SEND, type);
        }
        String workerName = workerSendNode.workerIdentifier.getValue();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(workerSendNode.pos, DiagnosticErrorCode.INVALID_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(workerSendNode.type, workerName)) {
            this.dlog.error(workerSendNode.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        workerSendNode.type = this.createAccumulatedErrorTypeForMatchingRecive(workerSendNode.pos, workerSendNode.expr.type);
        was.addWorkerAction(workerSendNode);
        this.analyzeExpr(workerSendNode.expr);
        this.validateActionParentNode(workerSendNode.pos, workerSendNode.expr);
    }

    private BType createAccumulatedErrorTypeForMatchingRecive(Location pos, BType exprType) {
        Set returnTypesUpToNow = this.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>(){
            {
                Comparator.comparing(BType::toString);
            }
        };
        for (BType returnType : returnTypesUpToNow) {
            if (returnType.tag == 28) {
                returnTypeAndSendType.add(returnType);
                continue;
            }
            this.dlog.error(pos, DiagnosticErrorCode.WORKER_SEND_AFTER_RETURN, new Object[0]);
        }
        returnTypeAndSendType.add(exprType);
        if (returnTypeAndSendType.size() > 1) {
            return BUnionType.create(null, returnTypeAndSendType);
        }
        return exprType;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        BSymbol receiver = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(syncSendExpr.workerIdentifier));
        if ((receiver.tag & 0x34) != 52) {
            receiver = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(syncSendExpr.pos, receiver, syncSendExpr.workerIdentifier.value);
        this.validateActionParentNode(syncSendExpr.pos, syncSendExpr);
        String workerName = syncSendExpr.workerIdentifier.getValue();
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.INVALID_WORKER_SEND_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(syncSendExpr.workerType, workerName)) {
            this.dlog.error(syncSendExpr.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        syncSendExpr.type = this.createAccumulatedErrorTypeForMatchingRecive(syncSendExpr.pos, syncSendExpr.expr.type);
        was.addWorkerAction(syncSendExpr);
        this.analyzeExpr(syncSendExpr.expr);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.validateActionParentNode(workerReceiveNode.pos, workerReceiveNode);
        BSymbol sender = this.symResolver.lookupSymbolInMainSpace(this.env, this.names.fromIdNode(workerReceiveNode.workerIdentifier));
        if ((sender.tag & 0x34) != 52) {
            sender = this.symTable.notFoundSymbol;
        }
        this.verifyPeerCommunication(workerReceiveNode.pos, sender, workerReceiveNode.workerIdentifier.value);
        WorkerActionSystem was = this.workerActionSystemStack.peek();
        String workerName = workerReceiveNode.workerIdentifier.getValue();
        boolean allowedLocation = this.isCommunicationAllowedLocation(workerName);
        if (!allowedLocation) {
            this.dlog.error(workerReceiveNode.pos, DiagnosticErrorCode.INVALID_WORKER_RECEIVE_POSITION, new Object[0]);
            was.hasErrors = true;
        }
        if (!this.workerExists(workerReceiveNode.workerType, workerName)) {
            this.dlog.error(workerReceiveNode.pos, DiagnosticErrorCode.UNDEFINED_WORKER, workerName);
            was.hasErrors = true;
        }
        workerReceiveNode.matchingSendsError = this.createAccumulatedErrorTypeForMatchingSyncSend(workerReceiveNode);
        was.addWorkerAction(workerReceiveNode);
    }

    private void verifyPeerCommunication(Location pos, BSymbol otherWorker, String otherWorkerName) {
        if (this.env.enclEnv.node.getKind() != NodeKind.FUNCTION) {
            return;
        }
        BLangFunction funcNode = (BLangFunction)this.env.enclEnv.node;
        Set flagSet = funcNode.flagSet;
        Name workerDerivedName = this.names.fromString("0" + otherWorker.name.value);
        if (flagSet.contains((Object)Flag.WORKER)) {
            if (otherWorkerName.equals("default")) {
                if (flagSet.contains((Object)Flag.FORKED)) {
                    this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
                }
                return;
            }
            Scope enclFunctionScope = this.env.enclEnv.enclEnv.scope;
            BInvokableSymbol wLambda = (BInvokableSymbol)enclFunctionScope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && funcNode.anonForkName != null && !funcNode.anonForkName.equals(wLambda.enclForkName)) {
                this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        } else {
            BInvokableSymbol wLambda = (BInvokableSymbol)this.env.scope.lookup((Name)workerDerivedName).symbol;
            if (wLambda != null && wLambda.enclForkName != null) {
                this.dlog.error(pos, DiagnosticErrorCode.WORKER_INTERACTIONS_ONLY_ALLOWED_BETWEEN_PEERS, new Object[0]);
            }
        }
    }

    public BType createAccumulatedErrorTypeForMatchingSyncSend(BLangWorkerReceive workerReceiveNode) {
        Set returnTypesUpToNow = this.returnTypes.peek();
        LinkedHashSet<BType> returnTypeAndSendType = new LinkedHashSet<BType>();
        for (BType returnType : returnTypesUpToNow) {
            if (returnType.tag == 28) {
                returnTypeAndSendType.add(returnType);
                continue;
            }
            this.dlog.error(workerReceiveNode.pos, DiagnosticErrorCode.WORKER_RECEIVE_AFTER_RETURN, new Object[0]);
        }
        returnTypeAndSendType.add(this.symTable.nilType);
        if (returnTypeAndSendType.size() > 1) {
            return BUnionType.create(null, returnTypeAndSendType);
        }
        return this.symTable.nilType;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        if (literalExpr.type.tag == 10 && NULL_LITERAL.equals(literalExpr.originalValue) && !literalExpr.isJSONContext && !this.isJSONContext) {
            this.dlog.error(literalExpr.pos, DiagnosticErrorCode.INVALID_USE_OF_NULL_LITERAL, new Object[0]);
        }
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.analyzeExprs(listConstructorExpr.exprs);
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.analyzeExprs(tableConstructorExpr.recordLiteralList);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        List<RecordLiteralNode.RecordField> fields = recordLiteral.fields;
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                this.analyzeExpr(((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeExpr((BLangRecordLiteral.BLangRecordVarNameField)field);
                continue;
            }
            this.analyzeExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
        }
        HashSet<Object> names = new HashSet<Object>();
        HashSet<String> neverTypedKeys = new HashSet<String>();
        BType type = recordLiteral.type;
        boolean isRecord = type.tag == 12;
        boolean isOpenRecord = isRecord && !((BRecordType)type).sealed;
        boolean isInferredRecordForMapCET = isRecord && recordLiteral.expectedType != null && recordLiteral.expectedType.tag == 15;
        BLangRecordLiteral.BLangRecordSpreadOperatorField inclusiveTypeSpreadField = null;
        for (RecordLiteralNode.RecordField field : fields) {
            Object name;
            BLangExpression keyExpr;
            if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
                BLangExpression spreadOpExpr = spreadOpField.expr;
                this.analyzeExpr(spreadOpExpr);
                BType spreadOpExprType = spreadOpExpr.type;
                int spreadFieldTypeTag = spreadOpExprType.tag;
                if (spreadFieldTypeTag == 15) {
                    if (inclusiveTypeSpreadField != null) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.MULTIPLE_INCLUSIVE_TYPES, new Object[0]);
                        continue;
                    }
                    inclusiveTypeSpreadField = spreadOpField;
                    if (fields.size() > 1) {
                        if (names.size() <= 0) continue;
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.SPREAD_FIELD_MAY_DULPICATE_ALREADY_SPECIFIED_KEYS, spreadOpExpr);
                        continue;
                    }
                }
                if (spreadFieldTypeTag != 12) continue;
                BRecordType spreadExprRecordType = (BRecordType)spreadOpExprType;
                boolean isSpreadExprRecordTypeSealed = spreadExprRecordType.sealed;
                if (!isSpreadExprRecordTypeSealed) {
                    if (inclusiveTypeSpreadField != null) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.MULTIPLE_INCLUSIVE_TYPES, new Object[0]);
                    } else {
                        inclusiveTypeSpreadField = spreadOpField;
                    }
                }
                LinkedHashMap fieldsInRecordType = spreadExprRecordType.fields;
                for (Object e : names) {
                    if (fieldsInRecordType.containsKey(e) || isSpreadExprRecordTypeSealed) continue;
                    this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.SPREAD_FIELD_MAY_DULPICATE_ALREADY_SPECIFIED_KEYS, spreadOpExpr);
                    break;
                }
                for (BField bField : fieldsInRecordType.values()) {
                    String name2 = bField.name.value;
                    if (names.contains(name2)) {
                        if (bField.type.tag == 49) continue;
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_RECORD_LITERAL_SPREAD_OP, recordLiteral.type.getKind().typeName(), name2, spreadOpField);
                        continue;
                    }
                    if (bField.type.tag == 49) {
                        neverTypedKeys.add(name2);
                        continue;
                    }
                    if (!neverTypedKeys.remove(name2) && inclusiveTypeSpreadField != null && isSpreadExprRecordTypeSealed) {
                        this.dlog.error(spreadOpExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, recordLiteral.expectedType.getKind().typeName(), name2, spreadOpField);
                    }
                    names.add(name2);
                }
                continue;
            }
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKey key = ((BLangRecordLiteral.BLangRecordKeyValueField)field).key;
                keyExpr = key.expr;
                if (key.computedKey) {
                    this.analyzeExpr(keyExpr);
                    continue;
                }
            } else {
                keyExpr = (BLangRecordLiteral.BLangRecordVarNameField)field;
            }
            if (keyExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                name = ((BLangSimpleVarRef)keyExpr).variableName.value;
                if (names.contains(name)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_RECORD_LITERAL, recordLiteral.expectedType.getKind().typeName(), name);
                } else if (inclusiveTypeSpreadField != null && !neverTypedKeys.contains(name)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, name, inclusiveTypeSpreadField);
                }
                if (!isInferredRecordForMapCET && isOpenRecord && !((BRecordType)type).fields.containsKey(name)) {
                    this.dlog.error(keyExpr.pos, DiagnosticErrorCode.INVALID_RECORD_LITERAL_IDENTIFIER_KEY, name);
                }
                names.add(name);
                continue;
            }
            if (keyExpr.getKind() != NodeKind.LITERAL && keyExpr.getKind() != NodeKind.NUMERIC_LITERAL) continue;
            name = ((BLangLiteral)keyExpr).value;
            if (names.contains(name)) {
                this.dlog.error(keyExpr.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_RECORD_LITERAL, recordLiteral.parent.type.getKind().typeName(), name);
            } else if (inclusiveTypeSpreadField != null && !neverTypedKeys.contains(name)) {
                this.dlog.error(keyExpr.pos, DiagnosticErrorCode.POSSIBLE_DUPLICATE_OF_FIELD_SPECIFIED_VIA_SPREAD_OP, name, inclusiveTypeSpreadField);
            }
            names.add(name);
        }
        if (isInferredRecordForMapCET) {
            recordLiteral.expectedType = type;
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        switch (varRefExpr.parent.getKind()) {
            case WORKER_RECEIVE: 
            case WORKER_SEND: 
            case WORKER_SYNC_SEND: {
                return;
            }
        }
        if (varRefExpr.type != null && varRefExpr.type.tag == 31) {
            this.checkWorkerPeerWorkerUsageInsideWorker(varRefExpr.pos, varRefExpr.symbol, this.env);
        }
        if (varRefExpr.symbol != null && Symbols.isFlagOn(varRefExpr.symbol.flags, 16L)) {
            this.dlog.warning(varRefExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, varRefExpr);
        }
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.analyzeExpr(fieldAccessExpr.expr);
        BSymbol symbol = fieldAccessExpr.symbol;
        if (symbol != null && Symbols.isFlagOn(fieldAccessExpr.symbol.flags, 16L)) {
            this.dlog.warning(fieldAccessExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, fieldAccessExpr);
        }
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeExpr(indexAccessExpr.indexExpr);
        this.analyzeExpr(indexAccessExpr.expr);
    }

    @Override
    public void visit(BLangTableMultiKeyExpr tableMultiKeyExpr) {
        this.analyzeExprs(tableMultiKeyExpr.multiKeyIndexExprs);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeExpr(invocationExpr.expr);
        this.analyzeExprs(invocationExpr.requiredArgs);
        this.analyzeExprs(invocationExpr.restArgs);
        if (invocationExpr.symbol != null && invocationExpr.symbol.kind == SymbolKind.FUNCTION) {
            BSymbol funcSymbol = invocationExpr.symbol;
            if (Symbols.isFlagOn(funcSymbol.flags, 0x2000000L) && !this.withinTransactionScope) {
                this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, invocationExpr);
                return;
            }
            if (Symbols.isFlagOn(funcSymbol.flags, 16L)) {
                this.dlog.warning(invocationExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, invocationExpr);
            }
            if (((BInvokableSymbol)funcSymbol).getReturnType().tag == 49 && invocationExpr.parent.getKind() != NodeKind.EXPRESSION_STATEMENT) {
                this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NEVER_RETURN_TYPED_FUNCTION_INVOCATION, funcSymbol.name);
            }
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation) {
        if (!actionInvocation.async && !this.withinTransactionScope && Symbols.isFlagOn(actionInvocation.symbol.flags, 0x2000000L)) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, actionInvocation);
            return;
        }
        if (actionInvocation.async && this.withinTransactionScope && !Symbols.isFlagOn(actionInvocation.symbol.flags, 0x2000000L)) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.USAGE_OF_START_WITHIN_TRANSACTION_IS_PROHIBITED, new Object[0]);
            return;
        }
        this.analyzeExpr(actionInvocation.expr);
        this.analyzeExprs(actionInvocation.requiredArgs);
        this.analyzeExprs(actionInvocation.restArgs);
        if (actionInvocation.symbol.kind == SymbolKind.FUNCTION && Symbols.isFlagOn(actionInvocation.symbol.flags, 16L)) {
            this.dlog.warning(actionInvocation.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, actionInvocation);
        }
        if (actionInvocation.flagSet.contains((Object)Flag.TRANSACTIONAL) && !this.withinTransactionScope) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.TRANSACTIONAL_FUNC_INVOKE_PROHIBITED, new Object[0]);
            return;
        }
        if (actionInvocation.async && this.withinLockBlock) {
            this.dlog.error(actionInvocation.pos, actionInvocation.functionPointerInvocation ? DiagnosticErrorCode.USAGE_OF_WORKER_WITHIN_LOCK_IS_PROHIBITED : DiagnosticErrorCode.USAGE_OF_START_WITHIN_LOCK_IS_PROHIBITED, new Object[0]);
            return;
        }
        if ((actionInvocation.symbol.tag & 0x8000100) == 0x8000100) {
            this.dlog.error(actionInvocation.pos, DiagnosticErrorCode.INVALID_FUNCTIONAL_CONSTRUCTOR_INVOCATION, actionInvocation.symbol.name);
            return;
        }
        this.validateActionInvocation(actionInvocation.pos, actionInvocation);
        if (!actionInvocation.async && this.withinTransactionScope) {
            actionInvocation.invokedInsideTransaction = true;
        }
    }

    private void validateActionInvocation(Location pos, BLangInvocation iExpr) {
        if (iExpr.expr != null) {
            NodeKind clientNodeKind = iExpr.expr.getKind();
            if (clientNodeKind != NodeKind.SIMPLE_VARIABLE_REF && clientNodeKind != NodeKind.FIELD_BASED_ACCESS_EXPR) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
            } else if (clientNodeKind == NodeKind.FIELD_BASED_ACCESS_EXPR) {
                BLangFieldBasedAccess fieldBasedAccess = (BLangFieldBasedAccess)iExpr.expr;
                if (fieldBasedAccess.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
                    this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                } else {
                    BLangSimpleVarRef selfName = (BLangSimpleVarRef)fieldBasedAccess.expr;
                    if (!Names.SELF.equals(selfName.symbol.name)) {
                        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
                    }
                }
            }
        }
        this.validateActionParentNode(pos, iExpr);
    }

    private void validateActionParentNode(Location pos, BLangNode node) {
        BLangNode parent = node.parent;
        while (parent != null) {
            NodeKind kind = parent.getKind();
            if (parent instanceof StatementNode) {
                return;
            }
            if (!(parent instanceof ActionNode) && !(parent instanceof BLangVariable) && kind != NodeKind.CHECK_EXPR && kind != NodeKind.CHECK_PANIC_EXPR && kind != NodeKind.TRAP_EXPR && kind != NodeKind.GROUP_EXPR && kind != NodeKind.TYPE_CONVERSION_EXPR || parent instanceof BLangInvocation.BLangActionInvocation) break;
            parent = parent.parent;
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_ACTION_INVOCATION_AS_EXPR, new Object[0]);
    }

    @Override
    public void visit(BLangTypeInit cIExpr) {
        this.analyzeExprs(cIExpr.argsExpr);
        this.analyzeExpr(cIExpr.initInvocation);
        BType type = cIExpr.type;
        if (cIExpr.userDefinedType != null && Symbols.isFlagOn(type.tsymbol.flags, 16L)) {
            this.dlog.warning(cIExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, type);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        boolean isJSONCtx;
        this.analyzeExpr(ternaryExpr.expr);
        this.isJSONContext = isJSONCtx = this.getIsJSONContext(ternaryExpr.type);
        this.analyzeExpr(ternaryExpr.thenExpr);
        this.isJSONContext = isJSONCtx;
        this.analyzeExpr(ternaryExpr.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr awaitExpr) {
        BLangExpression expr = awaitExpr.getExpression();
        this.validateWaitFutureExpr(expr);
        this.analyzeExpr(expr);
        this.validateActionParentNode(awaitExpr.pos, awaitExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : waitForAllExpr.keyValuePairs) {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            this.validateWaitFutureExpr(expr);
            this.analyzeExpr(expr);
        }
        this.validateActionParentNode(waitForAllExpr.pos, waitForAllExpr);
    }

    private void validateWaitFutureExpr(BLangExpression expr) {
        if (expr.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_WAIT_MAPPING_CONSTRUCTORS, new Object[0]);
        }
        if (expr instanceof ActionNode) {
            this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_WAIT_ACTIONS, new Object[0]);
        }
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.analyzeExpr(xmlElementAccess.expr);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.analyzeExpr(xmlNavigation.expr);
        if (xmlNavigation.childIndex != null) {
            if (xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.DESCENDANTS || xmlNavigation.navAccessType == XMLNavigationAccess.NavAccessType.CHILDREN) {
                this.dlog.error(xmlNavigation.pos, DiagnosticErrorCode.UNSUPPORTED_INDEX_IN_XML_NAVIGATION, new Object[0]);
            }
            this.analyzeExpr(xmlNavigation.childIndex);
        }
        this.validateMethodInvocationsInXMLNavigationExpression(xmlNavigation);
    }

    private void validateMethodInvocationsInXMLNavigationExpression(BLangXMLNavigationAccess expression) {
        if (!expression.methodInvocationAnalyzed && expression.parent.getKind() == NodeKind.INVOCATION) {
            BLangInvocation invocation = (BLangInvocation)expression.parent;
            if (invocation.argExprs.contains(expression) && (invocation.symbol.flags & 0x400000L) != 0x400000L) {
                return;
            }
            this.dlog.error(invocation.pos, DiagnosticErrorCode.UNSUPPORTED_METHOD_INVOCATION_XML_NAV, new Object[0]);
        }
        expression.methodInvocationAnalyzed = true;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        BLangIdentifier flushWrkIdentifier = workerFlushExpr.workerIdentifier;
        Stack<WorkerActionSystem> workerActionSystems = this.workerActionSystemStack;
        WorkerActionSystem currentWrkerAction = workerActionSystems.peek();
        List<BLangWorkerSend> sendStmts = this.getAsyncSendStmtsOfWorker(currentWrkerAction);
        if (flushWrkIdentifier != null) {
            List sendsToGivenWrkr = sendStmts.stream().filter(bLangNode -> bLangNode.workerIdentifier.equals(flushWrkIdentifier)).collect(Collectors.toList());
            if (sendsToGivenWrkr.size() == 0) {
                this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.INVALID_WORKER_FLUSH_FOR_WORKER, flushWrkIdentifier, currentWrkerAction.currentWorkerId());
                return;
            }
            sendStmts = sendsToGivenWrkr;
        } else if (sendStmts.size() == 0) {
            this.dlog.error(workerFlushExpr.pos, DiagnosticErrorCode.INVALID_WORKER_FLUSH, currentWrkerAction.currentWorkerId());
            return;
        }
        workerFlushExpr.cachedWorkerSendStmts = sendStmts;
        this.validateActionParentNode(workerFlushExpr.pos, workerFlushExpr);
    }

    private List<BLangWorkerSend> getAsyncSendStmtsOfWorker(WorkerActionSystem currentWorkerAction) {
        List<BLangNode> actions = currentWorkerAction.workerActionStateMachines.peek().actions;
        return actions.stream().filter(CodeAnalyzer::isWorkerSend).map(bLangNode -> (BLangWorkerSend)bLangNode).collect(Collectors.toList());
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeExpr(trapExpr.expr);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        if (this.validateBinaryExpr(binaryExpr)) {
            boolean isJSONCtx;
            this.isJSONContext = isJSONCtx = this.getIsJSONContext(binaryExpr.lhsExpr.type, binaryExpr.rhsExpr.type);
            this.analyzeExpr(binaryExpr.lhsExpr);
            this.isJSONContext = isJSONCtx;
            this.analyzeExpr(binaryExpr.rhsExpr);
        }
    }

    private boolean validateBinaryExpr(BLangBinaryExpr binaryExpr) {
        if (binaryExpr.lhsExpr.type.tag != 31 && binaryExpr.rhsExpr.type.tag != 31) {
            return true;
        }
        BLangNode parentNode = binaryExpr.parent;
        if (binaryExpr.lhsExpr.type.tag == 31 || binaryExpr.rhsExpr.type.tag == 31) {
            if (parentNode == null) {
                return false;
            }
            if (parentNode.getKind() == NodeKind.WAIT_EXPR) {
                return true;
            }
        }
        if (parentNode.getKind() != NodeKind.BINARY_EXPR && binaryExpr.opKind == OperatorKind.BITWISE_OR) {
            this.dlog.error(binaryExpr.pos, DiagnosticErrorCode.OPERATOR_NOT_SUPPORTED, new Object[]{OperatorKind.BITWISE_OR, this.symTable.futureType});
            return false;
        }
        if (parentNode.getKind() == NodeKind.BINARY_EXPR) {
            return this.validateBinaryExpr((BLangBinaryExpr)parentNode);
        }
        return true;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeExpr(elvisExpr.lhsExpr);
        this.analyzeExpr(elvisExpr.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeExpr(groupExpr.expression);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeExpr(unaryExpr.expr);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeExpr(conversionExpr.expr);
        conversionExpr.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeExpr(xmlAttribute.name);
        this.analyzeExpr(xmlAttribute.value);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        this.analyzeExpr(xmlElementLiteral.startTagName);
        this.analyzeExpr(xmlElementLiteral.endTagName);
        this.analyzeExprs(xmlElementLiteral.attributes);
        this.analyzeExprs(xmlElementLiteral.children);
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        this.analyzeExprs(xmlTextLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        this.analyzeExprs(xmlCommentLiteral.textFragments);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        this.analyzeExprs(xmlProcInsLiteral.dataFragments);
        this.analyzeExpr(xmlProcInsLiteral.target);
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        this.analyzeExprs(xmlQuotedString.textFragments);
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        this.analyzeExprs(stringTemplateLiteral.exprs);
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.analyzeExprs(rawTemplateLiteral.strings);
        this.analyzeExprs(rawTemplateLiteral.insertions);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        String workerVarName;
        boolean isWorker = false;
        if (bLangLambdaFunction.function.flagSet.contains((Object)Flag.TRANSACTIONAL) && bLangLambdaFunction.function.flagSet.contains((Object)Flag.WORKER) && !this.withinTransactionScope) {
            this.dlog.error(bLangLambdaFunction.pos, DiagnosticErrorCode.TRANSACTIONAL_WORKER_OUT_OF_TRANSACTIONAL_SCOPE, bLangLambdaFunction);
            return;
        }
        if (bLangLambdaFunction.parent.getKind() == NodeKind.VARIABLE && (workerVarName = ((BLangSimpleVariable)bLangLambdaFunction.parent).name.value).startsWith("0")) {
            String workerName = workerVarName.substring(1);
            isWorker = true;
            this.workerActionSystemStack.peek().startWorkerActionStateMachine(workerName, bLangLambdaFunction.function.pos, bLangLambdaFunction.function);
        }
        boolean statementReturn = this.statementReturns;
        this.visitFunction(bLangLambdaFunction.function);
        this.statementReturns = statementReturn;
        if (isWorker) {
            this.workerActionSystemStack.peek().endWorkerActionStateMachine();
        }
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.analyzeExpr(bLangArrowFunction.body.expr);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        this.analyzeExpr(xmlAttributeAccessExpr.expr);
        this.analyzeExpr(xmlAttributeAccessExpr.indexExpr);
    }

    @Override
    public void visit(BLangIntRangeExpression intRangeExpression) {
        this.analyzeExpr(intRangeExpression.startExpr);
        this.analyzeExpr(intRangeExpression.endExpr);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv recordEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            this.analyzeNode(field, recordEnv);
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.analyzeNode(field, objectEnv);
        }
        ArrayList<BLangFunction> bLangFunctionList = new ArrayList<BLangFunction>(objectTypeNode.functions);
        if (objectTypeNode.initFunction != null) {
            bLangFunctionList.add(objectTypeNode.initFunction);
        }
        bLangFunctionList.sort(Comparator.comparingInt(function -> function.pos.lineRange().startLine().line()));
        for (BLangFunction function2 : bLangFunctionList) {
            this.analyzeNode(function2, objectEnv);
        }
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeTypeNode(arrayType.elemtype, this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeTypeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeTypeNode(streamType.constraint, this.env);
        this.analyzeTypeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.analyzeTypeNode(tableType.constraint, this.env);
        if (tableType.tableKeyTypeConstraint != null) {
            this.analyzeTypeNode(tableType.tableKeyTypeConstraint.keyType, this.env);
        }
    }

    @Override
    public void visit(BLangErrorType errorType) {
        this.analyzeTypeNode(errorType.detailType, this.env);
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        BTypeSymbol typeSymbol = userDefinedType.type.tsymbol;
        if (typeSymbol != null && Symbols.isFlagOn(typeSymbol.flags, 16L)) {
            this.dlog.warning(userDefinedType.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, userDefinedType);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        tupleTypeNode.memberTypeNodes.forEach(memberType -> this.analyzeTypeNode((BLangType)memberType, this.env));
        this.analyzeTypeNode(tupleTypeNode.restParamType, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        unionTypeNode.memberTypeNodes.forEach(memberType -> this.analyzeTypeNode((BLangType)memberType, this.env));
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeTypeNode(constituentTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        functionTypeNode.params.forEach(node -> this.analyzeNode((BLangNode)node, this.env));
        this.analyzeTypeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeExpr(bLangNamedArgsExpression.expr);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.failVisited = true;
        this.analyzeExpr(checkedExpr.expr);
        if (this.env.scope.owner.getKind() == SymbolKind.PACKAGE) {
            return;
        }
        BType exprType = this.env.enclInvokable.getReturnTypeNode().type;
        if (!this.failureHandled && !this.types.isAssignable(this.getErrorTypes(checkedExpr.expr.type), exprType)) {
            this.dlog.error(checkedExpr.pos, DiagnosticErrorCode.CHECKED_EXPR_NO_MATCHING_ERROR_RETURN_IN_ENCL_INVOKABLE, new Object[0]);
        }
        if (!this.errorTypes.empty()) {
            this.errorTypes.peek().add(this.getErrorTypes(checkedExpr.expr.type));
        }
        this.returnTypes.peek().add(exprType);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr) {
        this.analyzeExpr(checkPanicExpr.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        this.queryToTableWithKey = queryExpr.isTable() && !queryExpr.fieldNameIdentifierList.isEmpty();
        int fromCount = 0;
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            if (clause.getKind() == NodeKind.FROM) {
                BLangFromClause fromClause = (BLangFromClause)clause;
                BLangExpression collection = (BLangExpression)fromClause.getCollection();
                if (++fromCount > 1 && 14 == collection.type.tag) {
                    this.dlog.error(collection.pos, DiagnosticErrorCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
                }
            }
            this.analyzeNode(clause, this.env);
        }
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        int fromCount = 0;
        for (BLangNode clause : queryAction.getQueryClauses()) {
            if (clause.getKind() == NodeKind.FROM) {
                BLangFromClause fromClause = (BLangFromClause)clause;
                BLangExpression collection = (BLangExpression)fromClause.getCollection();
                if (++fromCount > 1 && 14 == collection.type.tag) {
                    this.dlog.error(collection.pos, DiagnosticErrorCode.NOT_ALLOWED_STREAM_USAGE_WITH_FROM, new Object[0]);
                }
            }
            this.analyzeNode(clause, this.env);
        }
        this.validateActionParentNode(queryAction.pos, queryAction);
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        this.analyzeExpr(fromClause.collection);
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.analyzeExpr(joinClause.collection);
        if (joinClause.onClause != null) {
            this.analyzeNode((BLangNode)((Object)joinClause.onClause), this.env);
        }
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode), this.env);
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeExpr(whereClause.expression);
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.analyzeExpr(onClause.lhsExpr);
        this.analyzeExpr(onClause.rhsExpr);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        orderByClause.orderByKeyList.forEach(value -> this.analyzeExpr((BLangExpression)value.getOrderKey()));
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeExpr(selectClause.expression);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.analyzeExpr(onConflictClause.expression);
        if (!this.queryToTableWithKey) {
            this.dlog.error(onConflictClause.pos, DiagnosticErrorCode.ON_CONFLICT_ONLY_WORKS_WITH_TABLES_WITH_KEY_SPECIFIER, new Object[0]);
        }
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, this.env);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        boolean currentFailVisited = this.failVisited;
        this.failVisited = false;
        this.resetLastStatement();
        this.resetErrorThrown();
        this.returnWithinLambdaWrappingCheckStack.push(false);
        BLangVariable onFailVarNode = (BLangVariable)onFailClause.variableDefinitionNode.getVariable();
        for (BType errorType : this.errorTypes.peek()) {
            if (this.types.isAssignable(errorType, onFailVarNode.type)) continue;
            this.dlog.error(onFailVarNode.pos, DiagnosticErrorCode.INCOMPATIBLE_ON_FAIL_ERROR_DEFINITION, errorType, onFailVarNode.type);
        }
        this.analyzeNode(onFailClause.body, this.env);
        onFailClause.bodyContainsFail = this.failVisited;
        onFailClause.statementBlockReturns = this.returnWithinLambdaWrappingCheckStack.peek();
        this.returnWithinLambdaWrappingCheckStack.pop();
        this.resetErrorThrown();
        this.failVisited = currentFailVisited;
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.analyzeExpr(limitClause.expression);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        if (typeTestExpr.typeNode.type == this.symTable.semanticError || typeTestExpr.expr.type == this.symTable.semanticError) {
            return;
        }
        if (this.types.isAssignable(typeTestExpr.expr.type, typeTestExpr.typeNode.type)) {
            this.dlog.error(typeTestExpr.pos, DiagnosticErrorCode.UNNECESSARY_CONDITION, new Object[0]);
            return;
        }
        if (!this.types.isAssignable(typeTestExpr.typeNode.type, typeTestExpr.expr.type) && !this.indirectIntersectionExists(typeTestExpr.expr, typeTestExpr.typeNode.type)) {
            this.dlog.error(typeTestExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_CHECK, typeTestExpr.expr.type, typeTestExpr.typeNode.type);
        }
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.analyzeExpr(annotAccessExpr.expr);
        BAnnotationSymbol annotationSymbol = annotAccessExpr.annotationSymbol;
        if (annotationSymbol != null && Symbols.isFlagOn(annotationSymbol.flags, 16L)) {
            this.dlog.warning(annotAccessExpr.pos, DiagnosticWarningCode.USAGE_OF_DEPRECATED_CONSTRUCT, annotationSymbol);
        }
    }

    private boolean indirectIntersectionExists(BLangExpression expression, BType testType) {
        BType expressionType = expression.type;
        switch (expressionType.tag) {
            case 20: {
                if (this.types.getTypeForUnionTypeMembersAssignableToType((BUnionType)expressionType, testType) == this.symTable.semanticError) break;
                return true;
            }
            case 32: {
                if (this.types.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)expressionType, testType) == this.symTable.semanticError) break;
                return true;
            }
        }
        switch (testType.tag) {
            case 20: {
                return this.types.getTypeForUnionTypeMembersAssignableToType((BUnionType)testType, expressionType) != this.symTable.semanticError;
            }
            case 32: {
                return this.types.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)testType, expressionType) != this.symTable.semanticError;
            }
        }
        return false;
    }

    private <E extends BLangExpression> void analyzeExpr(E node) {
        if (node == null) {
            return;
        }
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.isJSONContext = false;
        this.parent = myParent;
        this.checkAccess(node);
    }

    private <E extends BLangExpression> void analyzeExpr(E node, SymbolEnv env) {
        if (node == null) {
            return;
        }
        SymbolEnv prevEnv = this.env;
        this.env = env;
        BLangNode myParent = this.parent;
        node.parent = this.parent;
        this.parent = node;
        node.accept(this);
        this.isJSONContext = false;
        this.parent = myParent;
        this.checkAccess(node);
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangConstant constant) {
        this.analyzeTypeNode(constant.typeNode, this.env);
        this.analyzeNode(constant.expr, this.env);
        this.analyzeExportableTypeRef(constant.symbol, constant.symbol.type.tsymbol, false, constant.pos);
        constant.annAttachments.forEach(annotationAttachment -> this.analyzeNode((BLangNode)annotationAttachment, this.env));
    }

    private <E extends BLangExpression> void checkAccess(E node) {
        if (node.type != null) {
            this.checkAccessSymbol(node.type.tsymbol, node.pos);
        }
        if (node.getKind() == NodeKind.INVOCATION) {
            BLangInvocation bLangInvocation = (BLangInvocation)node;
            this.checkAccessSymbol(bLangInvocation.symbol, bLangInvocation.pos);
        }
    }

    private void checkAccessSymbol(BSymbol symbol, Location position) {
        if (symbol == null) {
            return;
        }
        if (this.env.enclPkg.symbol.pkgID != symbol.pkgID && !Symbols.isPublic(symbol)) {
            this.dlog.error(position, DiagnosticErrorCode.ATTEMPT_REFER_NON_ACCESSIBLE_SYMBOL, symbol.name);
        }
    }

    private <E extends BLangExpression> void analyzeExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            this.analyzeExpr((BLangExpression)nodeList.get(i));
        }
    }

    private void initNewWorkerActionSystem() {
        this.workerActionSystemStack.push(new WorkerActionSystem());
    }

    private void finalizeCurrentWorkerActionSystem() {
        WorkerActionSystem was = this.workerActionSystemStack.pop();
        if (!was.hasErrors) {
            this.validateWorkerInteractions(was);
        }
    }

    private static boolean isWorkerSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_SEND;
    }

    private static boolean isWorkerSyncSend(BLangNode action) {
        return action.getKind() == NodeKind.WORKER_SYNC_SEND;
    }

    private String extractWorkerId(BLangNode action) {
        if (CodeAnalyzer.isWorkerSend(action)) {
            return ((BLangWorkerSend)action).workerIdentifier.value;
        }
        if (CodeAnalyzer.isWorkerSyncSend(action)) {
            return ((BLangWorkerSyncSendExpr)action).workerIdentifier.value;
        }
        return ((BLangWorkerReceive)action).workerIdentifier.value;
    }

    private void validateWorkerInteractions(WorkerActionSystem workerActionSystem) {
        boolean systemRunning;
        do {
            systemRunning = false;
            for (WorkerActionStateMachine worker : workerActionSystem.finshedWorkers) {
                WorkerActionStateMachine otherSM;
                BLangNode currentAction;
                if (worker.done() || !CodeAnalyzer.isWorkerSend(currentAction = worker.currentAction()) && !CodeAnalyzer.isWorkerSyncSend(currentAction) || (otherSM = workerActionSystem.find(this.extractWorkerId(currentAction))) == null || !otherSM.currentIsReceive(worker.workerId)) continue;
                BLangWorkerReceive receive = (BLangWorkerReceive)otherSM.currentAction();
                if (CodeAnalyzer.isWorkerSyncSend(currentAction)) {
                    this.validateWorkerActionParameters((BLangWorkerSyncSendExpr)currentAction, receive);
                } else {
                    this.validateWorkerActionParameters((BLangWorkerSend)currentAction, receive);
                }
                otherSM.next();
                worker.next();
                systemRunning = true;
                String channelName = CodeAnalyzer.generateChannelName(worker.workerId, otherSM.workerId);
                otherSM.node.sendsToThis.add(channelName);
                worker.node.sendsToThis.add(channelName);
            }
        } while (systemRunning);
        if (!workerActionSystem.everyoneDone()) {
            this.reportInvalidWorkerInteractionDiagnostics(workerActionSystem);
        }
    }

    private void reportInvalidWorkerInteractionDiagnostics(WorkerActionSystem workerActionSystem) {
        this.dlog.error(workerActionSystem.getRootPosition(), DiagnosticErrorCode.INVALID_WORKER_INTERACTION, workerActionSystem.toString());
    }

    private void validateWorkerActionParameters(BLangWorkerSend send, BLangWorkerReceive receive) {
        this.types.checkType(receive, send.type, receive.type);
        this.addImplicitCast(send.type, receive);
        NodeKind kind = receive.parent.getKind();
        if (kind == NodeKind.TRAP_EXPR || kind == NodeKind.CHECK_EXPR || kind == NodeKind.CHECK_PANIC_EXPR || kind == NodeKind.FAIL) {
            this.typeChecker.checkExpr((BLangExpression)receive.parent, receive.env);
        }
        receive.sendExpression = send.expr;
    }

    private void validateWorkerActionParameters(BLangWorkerSyncSendExpr send, BLangWorkerReceive receive) {
        send.receive = receive;
        NodeKind parentNodeKind = send.parent.getKind();
        if (parentNodeKind == NodeKind.VARIABLE) {
            BLangSimpleVariable variable = (BLangSimpleVariable)send.parent;
            if (variable.isDeclaredWithVar) {
                variable.symbol.type = send.expectedType = receive.matchingSendsError;
                variable.type = send.expectedType;
            }
        } else if (parentNodeKind == NodeKind.ASSIGNMENT) {
            BSymbol varSymbol;
            BLangAssignment assignment = (BLangAssignment)send.parent;
            if (assignment.varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF && (varSymbol = ((BLangSimpleVarRef)assignment.varRef).symbol) != null) {
                send.expectedType = varSymbol.type;
            }
        }
        if (receive.matchingSendsError != this.symTable.nilType && parentNodeKind == NodeKind.EXPRESSION_STATEMENT) {
            this.dlog.error(send.pos, DiagnosticErrorCode.ASSIGNMENT_REQUIRED, new Object[0]);
        } else {
            this.types.checkType(send.pos, receive.matchingSendsError, send.expectedType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        }
        this.types.checkType(receive, send.type, receive.type);
        this.addImplicitCast(send.type, receive);
        NodeKind kind = receive.parent.getKind();
        if (kind == NodeKind.TRAP_EXPR || kind == NodeKind.CHECK_EXPR || kind == NodeKind.CHECK_PANIC_EXPR) {
            this.typeChecker.checkExpr((BLangExpression)receive.parent, receive.env);
        }
        receive.sendExpression = send;
    }

    private void addImplicitCast(BType actualType, BLangWorkerReceive receive) {
        if (receive.type != null && receive.type != this.symTable.semanticError) {
            this.types.setImplicitCastExpr(receive, actualType, receive.type);
            receive.type = actualType;
        }
    }

    private boolean checkNextBreakValidityInTransaction() {
        return this.loopWithinTransactionCheckStack.peek() == false && this.transactionCount > 0 && this.withinTransactionScope;
    }

    private boolean checkReturnValidityInTransaction() {
        return (this.returnWithinTransactionCheckStack.empty() || this.returnWithinTransactionCheckStack.peek() == false) && this.transactionCount > 0 && this.withinTransactionScope;
    }

    private void validateMainFunction(BLangFunction funcNode) {
        if (!"main".equals(funcNode.name.value)) {
            return;
        }
        if (!Symbols.isPublic(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.MAIN_SHOULD_BE_PUBLIC, new Object[0]);
        }
        funcNode.requiredParams.forEach(param -> {
            if (!param.type.isAnydata()) {
                this.dlog.error(param.pos, DiagnosticErrorCode.MAIN_PARAMS_SHOULD_BE_ANYDATA, param.type);
            }
        });
        if (funcNode.restParam != null && !funcNode.restParam.type.isAnydata()) {
            this.dlog.error(funcNode.restParam.pos, DiagnosticErrorCode.MAIN_PARAMS_SHOULD_BE_ANYDATA, funcNode.restParam.type);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.MAIN_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private void validateModuleInitFunction(BLangFunction funcNode) {
        if (funcNode.attachedFunction || !Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcNode.name.value)) {
            return;
        }
        if (Symbols.isPublic(funcNode.symbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.MODULE_INIT_CANNOT_BE_PUBLIC, new Object[0]);
        }
        if (!funcNode.requiredParams.isEmpty() || funcNode.restParam != null) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.MODULE_INIT_CANNOT_HAVE_PARAMS, new Object[0]);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.MODULE_INIT_RETURN_SHOULD_BE_ERROR_OR_NIL);
    }

    private boolean getIsJSONContext(BType ... arg) {
        if (this.isJSONContext) {
            return true;
        }
        for (BType type : arg) {
            if (!this.types.isJSONContext(type)) continue;
            return true;
        }
        return false;
    }

    private BType getErrorTypes(BType bType) {
        BType errorType = this.symTable.semanticError;
        int tag = bType.tag;
        if (tag == 28) {
            errorType = bType;
        } else if (tag == 20) {
            LinkedHashSet<BType> errTypes = new LinkedHashSet<BType>();
            Set<BType> memTypes = ((BUnionType)bType).getMemberTypes();
            for (BType memType : memTypes) {
                if (memType.tag != 28) continue;
                errTypes.add(memType);
            }
            errorType = errTypes.size() == 1 ? (BType)errTypes.iterator().next() : BUnionType.create(null, errTypes);
        }
        return errorType;
    }

    private void checkExperimentalFeatureValidity(ExperimentalFeatures constructName, Location pos) {
        if (this.enableExperimentalFeatures) {
            return;
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_USE_OF_EXPERIMENTAL_FEATURE, constructName.value);
    }

    public static String generateChannelName(String source, String target) {
        return source + "->" + target;
    }

    private static enum ExperimentalFeatures {
        LOCK("lock"),
        XML_ACCESS("xml access expression"),
        XML_ATTRIBUTES_ACCESS("xml attribute expression");

        private String value;

        private ExperimentalFeatures(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class WorkerActionStateMachine {
        private static final String WORKER_SM_FINISHED = "FINISHED";
        public int currentState;
        public List<BLangNode> actions = new ArrayList<BLangNode>();
        public Location pos;
        public String workerId;
        public BLangFunction node;

        public WorkerActionStateMachine(Location pos, String workerId, BLangFunction node) {
            this.pos = pos;
            this.workerId = workerId;
            this.node = node;
        }

        public boolean done() {
            return this.actions.size() == this.currentState;
        }

        public BLangNode currentAction() {
            return this.actions.get(this.currentState);
        }

        public boolean currentIsReceive(String sourceWorkerId) {
            if (this.done()) {
                return false;
            }
            BLangNode action = this.currentAction();
            return !CodeAnalyzer.isWorkerSend(action) && !CodeAnalyzer.isWorkerSyncSend(action) && ((BLangWorkerReceive)action).workerIdentifier.value.equals(sourceWorkerId);
        }

        public void next() {
            ++this.currentState;
        }

        public String toString() {
            if (this.done()) {
                return WORKER_SM_FINISHED;
            }
            BLangNode action = this.currentAction();
            if (CodeAnalyzer.isWorkerSend(action)) {
                return ((BLangWorkerSend)action).toActionString();
            }
            if (CodeAnalyzer.isWorkerSyncSend(action)) {
                return ((BLangWorkerSyncSendExpr)action).toActionString();
            }
            return ((BLangWorkerReceive)action).toActionString();
        }
    }

    private static class WorkerActionSystem {
        public List<WorkerActionStateMachine> finshedWorkers = new ArrayList<WorkerActionStateMachine>();
        private Stack<WorkerActionStateMachine> workerActionStateMachines = new Stack();
        private boolean hasErrors = false;

        private WorkerActionSystem() {
        }

        public void startWorkerActionStateMachine(String workerId, Location pos, BLangFunction node) {
            this.workerActionStateMachines.push(new WorkerActionStateMachine(pos, workerId, node));
        }

        public void endWorkerActionStateMachine() {
            this.finshedWorkers.add(this.workerActionStateMachines.pop());
        }

        public void addWorkerAction(BLangNode action) {
            this.workerActionStateMachines.peek().actions.add(action);
        }

        public WorkerActionStateMachine find(String workerId) {
            for (WorkerActionStateMachine worker : this.finshedWorkers) {
                if (!worker.workerId.equals(workerId)) continue;
                return worker;
            }
            throw new AssertionError((Object)("Reference to non existing worker " + workerId));
        }

        public boolean everyoneDone() {
            return this.finshedWorkers.stream().allMatch(WorkerActionStateMachine::done);
        }

        public Location getRootPosition() {
            return this.finshedWorkers.iterator().next().pos;
        }

        public String toString() {
            return this.finshedWorkers.toString();
        }

        public String currentWorkerId() {
            return this.workerActionStateMachines.peek().workerId;
        }
    }
}

