/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ConstantValueResolver
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ConstantValueResolver> CONSTANT_VALUE_RESOLVER_KEY = new CompilerContext.Key();
    private BConstantSymbol currentConstSymbol;
    private BLangConstantValue result;
    private BLangDiagnosticLog dlog;
    private Location currentPos;
    private Map<BConstantSymbol, BLangConstant> unresolvedConstants = new HashMap<BConstantSymbol, BLangConstant>();

    private ConstantValueResolver(CompilerContext context) {
        context.put(CONSTANT_VALUE_RESOLVER_KEY, this);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public static ConstantValueResolver getInstance(CompilerContext context) {
        ConstantValueResolver constantValueResolver = context.get(CONSTANT_VALUE_RESOLVER_KEY);
        if (constantValueResolver == null) {
            constantValueResolver = new ConstantValueResolver(context);
        }
        return constantValueResolver;
    }

    public void resolve(List<BLangConstant> constants, PackageID packageID) {
        this.dlog.setCurrentPackageId(packageID);
        constants.forEach(constant -> this.unresolvedConstants.put(constant.symbol, (BLangConstant)constant));
        constants.forEach(constant -> constant.accept(this));
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol tempCurrentConstSymbol = this.currentConstSymbol;
        this.currentConstSymbol = constant.symbol;
        this.currentConstSymbol.value = this.visitExpr(constant.expr);
        this.unresolvedConstants.remove(this.currentConstSymbol);
        this.currentConstSymbol = tempCurrentConstSymbol;
    }

    @Override
    public void visit(BLangLiteral literal) {
        this.result = new BLangConstantValue(literal.value, literal.type);
    }

    @Override
    public void visit(BLangNumericLiteral literal) {
        this.result = new BLangConstantValue(literal.value, literal.type);
    }

    @Override
    public void visit(BLangSimpleVarRef varRef) {
        if (varRef.symbol == null || (varRef.symbol.tag & 0x200001C) != 33554460) {
            this.result = null;
            return;
        }
        BConstantSymbol constSymbol = (BConstantSymbol)varRef.symbol;
        BLangConstantValue constVal = constSymbol.value;
        if (constVal != null) {
            this.result = constVal;
            return;
        }
        this.unresolvedConstants.get(varRef.symbol).accept(this);
        this.result = constSymbol.value;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        HashMap<String, BLangConstantValue> mapConstVal = new HashMap<String, BLangConstantValue>();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            BLangConstantValue value;
            String key;
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                NodeKind nodeKind = keyValuePair.key.expr.getKind();
                if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
                    key = (String)((BLangLiteral)keyValuePair.key.expr).value;
                } else {
                    if (nodeKind != NodeKind.SIMPLE_VARIABLE_REF) continue;
                    key = ((BLangSimpleVarRef)keyValuePair.key.expr).variableName.value;
                }
                value = this.visitExpr(keyValuePair.valueExpr);
            } else if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangRecordLiteral.BLangRecordVarNameField varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                key = varNameField.variableName.value;
                value = this.visitExpr(varNameField);
            } else {
                BLangConstantValue spreadOpConstValue = this.visitExpr(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr);
                if (spreadOpConstValue == null) continue;
                mapConstVal.putAll((Map)spreadOpConstValue.value);
                continue;
            }
            mapConstVal.put(key, value);
        }
        this.result = new BLangConstantValue(mapConstVal, recordLiteral.type);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        BLangConstantValue lhs = this.visitExpr(binaryExpr.lhsExpr);
        BLangConstantValue rhs = this.visitExpr(binaryExpr.rhsExpr);
        this.result = this.calculateConstValue(lhs, rhs, binaryExpr.opKind);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.result = this.visitExpr(groupExpr.expression);
    }

    private BLangConstantValue calculateConstValue(BLangConstantValue lhs, BLangConstantValue rhs, OperatorKind kind) {
        if (lhs == null || rhs == null || lhs.value == null || rhs.value == null) {
            return new BLangConstantValue(null, this.currentConstSymbol.type);
        }
        try {
            switch (kind) {
                case ADD: {
                    return this.calculateAddition(lhs, rhs);
                }
                case SUB: {
                    return this.calculateSubtract(lhs, rhs);
                }
                case MUL: {
                    return this.calculateMultiplication(lhs, rhs);
                }
                case DIV: {
                    return this.calculateDivision(lhs, rhs);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArithmeticException ae) {
            this.dlog.error(this.currentPos, DiagnosticErrorCode.INVALID_CONST_EXPRESSION, ae.getMessage());
        }
        return new BLangConstantValue(null, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateAddition(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (this.currentConstSymbol.type.tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value + (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) + Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.add(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
                break;
            }
            case 5: {
                result = String.valueOf(lhs.value) + String.valueOf(rhs.value);
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateSubtract(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (this.currentConstSymbol.type.tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value - (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) - Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.subtract(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateMultiplication(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (this.currentConstSymbol.type.tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value * (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) * Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.multiply(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateDivision(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (this.currentConstSymbol.type.tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value / (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) / Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.divide(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue calculateMod(BLangConstantValue lhs, BLangConstantValue rhs) {
        Object result = null;
        switch (this.currentConstSymbol.type.tag) {
            case 1: 
            case 2: {
                result = (Long)lhs.value % (Long)rhs.value;
                break;
            }
            case 3: {
                result = String.valueOf(Double.parseDouble(String.valueOf(lhs.value)) % Double.parseDouble(String.valueOf(rhs.value)));
                break;
            }
            case 4: {
                BigDecimal lhsDecimal = new BigDecimal(String.valueOf(lhs.value), MathContext.DECIMAL128);
                BigDecimal rhsDecimal = new BigDecimal(String.valueOf(rhs.value), MathContext.DECIMAL128);
                BigDecimal resultDecimal = lhsDecimal.remainder(rhsDecimal, MathContext.DECIMAL128);
                result = resultDecimal.toPlainString();
            }
        }
        return new BLangConstantValue(result, this.currentConstSymbol.type);
    }

    private BLangConstantValue visitExpr(BLangExpression node) {
        if (!node.typeChecked) {
            return null;
        }
        switch (node.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: 
            case RECORD_LITERAL_EXPR: 
            case SIMPLE_VARIABLE_REF: 
            case BINARY_EXPR: 
            case GROUP_EXPR: {
                BLangConstantValue prevResult = this.result;
                Location prevPos = this.currentPos;
                this.currentPos = node.pos;
                this.result = null;
                node.accept(this);
                BLangConstantValue newResult = this.result;
                this.result = prevResult;
                this.currentPos = prevPos;
                return newResult;
            }
        }
        return null;
    }
}

