/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OrderedNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.TypeDefinition;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.BLangMissingNodesHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLAttributeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class SymbolEnter
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SymbolEnter> SYMBOL_ENTER_KEY = new CompilerContext.Key();
    private final PackageLoader pkgLoader;
    private final SymbolTable symTable;
    private final Names names;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private final SourceDirectory sourceDirectory;
    private List<BLangNode> unresolvedTypes;
    private List<BLangClassDefinition> unresolvedClasses;
    private HashSet<LocationData> unknownTypeRefs;
    private List<PackageID> importedPackages;
    private int typePrecedence;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private BLangAnonymousModelHelper anonymousModelHelper;
    private BLangMissingNodesHelper missingNodesHelper;
    private PackageCache packageCache;
    private SymbolEnv env;
    private final boolean projectAPIInitiatedCompilation;
    private static final String DEPRECATION_ANNOTATION = "deprecated";

    public static SymbolEnter getInstance(CompilerContext context) {
        SymbolEnter symbolEnter = context.get(SYMBOL_ENTER_KEY);
        if (symbolEnter == null) {
            symbolEnter = new SymbolEnter(context);
        }
        return symbolEnter;
    }

    public SymbolEnter(CompilerContext context) {
        context.put(SYMBOL_ENTER_KEY, this);
        this.pkgLoader = PackageLoader.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.sourceDirectory = context.get(SourceDirectory.class);
        this.importedPackages = new ArrayList<PackageID>();
        this.unknownTypeRefs = new HashSet();
        this.missingNodesHelper = BLangMissingNodesHelper.getInstance(context);
        this.packageCache = PackageCache.getInstance(context);
        CompilerOptions options = CompilerOptions.getInstance(context);
        this.projectAPIInitiatedCompilation = Boolean.parseBoolean(options.get(CompilerOptionName.PROJECT_API_INITIATED_COMPILATION));
    }

    public BLangPackage definePackage(BLangPackage pkgNode) {
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        this.populatePackageNode(pkgNode);
        this.defineNode(pkgNode, this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol));
        return pkgNode;
    }

    public void defineNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        node.accept(this);
        this.env = prevEnv;
    }

    public BLangPackage defineTestablePackage(BLangTestablePackage pkgNode, SymbolEnv env) {
        this.populatePackageNode(pkgNode);
        this.defineNode(pkgNode, env);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DEFINE)) {
            return;
        }
        BPackageSymbol pkgSymbol = Symbols.isFlagOn(Flags.asMask(pkgNode.flagSet), 8192L) ? Symbols.createPackageSymbol(pkgNode.packageID, this.symTable, Flags.asMask(pkgNode.flagSet), SymbolOrigin.SOURCE) : Symbols.createPackageSymbol(pkgNode.packageID, this.symTable, SymbolOrigin.SOURCE);
        if (PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            this.populateLangLibInSymTable(pkgSymbol);
        }
        pkgNode.symbol = pkgSymbol;
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(pkgNode, pkgSymbol.scope, this.env);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        this.importedPackages.add(pkgNode.packageID);
        this.defineConstructs(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.defineTestablePackage((BLangTestablePackage)testablePackage, pkgEnv));
        pkgNode.completedPhases.add(CompilerPhase.DEFINE);
        this.importedPackages.remove(pkgNode.packageID);
    }

    private void defineConstructs(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        HashMap importPkgHolder = new HashMap();
        pkgNode.imports.forEach(importNode -> {
            String qualifiedName = importNode.getQualifiedPackageName();
            if (importPkgHolder.containsKey(qualifiedName)) {
                ((ImportResolveHolder)importPkgHolder.get((Object)qualifiedName)).unresolved.add((BLangImportPackage)importNode);
                return;
            }
            this.defineNode((BLangNode)importNode, pkgEnv);
            if (importNode.symbol != null) {
                importPkgHolder.put(qualifiedName, new ImportResolveHolder((BLangImportPackage)importNode));
            }
        });
        for (ImportResolveHolder importHolder : importPkgHolder.values()) {
            BPackageSymbol pkgSymbol = importHolder.resolved.symbol;
            for (BLangImportPackage unresolvedPkg : importHolder.unresolved) {
                BPackageSymbol importSymbol = importHolder.resolved.symbol;
                Name resolvedPkgAlias = this.names.fromIdNode(importHolder.resolved.alias);
                Name unresolvedPkgAlias = this.names.fromIdNode(unresolvedPkg.alias);
                if (!Names.IGNORE.equals(unresolvedPkgAlias) && unresolvedPkgAlias.equals(resolvedPkgAlias) && importSymbol.compUnit.equals(this.names.fromIdNode(unresolvedPkg.compUnit))) {
                    if (this.isSameImport(unresolvedPkg, importSymbol)) {
                        this.dlog.error(unresolvedPkg.pos, DiagnosticErrorCode.REDECLARED_IMPORT_MODULE, unresolvedPkg.getQualifiedPackageName());
                        continue;
                    }
                    this.dlog.error(unresolvedPkg.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, unresolvedPkgAlias);
                    continue;
                }
                unresolvedPkg.symbol = pkgSymbol;
                BPackageSymbol symbol = this.dupPackageSymbolAndSetCompUnit(pkgSymbol, this.names.fromIdNode(unresolvedPkg.compUnit));
                symbol.scope = pkgSymbol.scope;
                unresolvedPkg.symbol = symbol;
                pkgEnv.scope.define(unresolvedPkgAlias, symbol);
            }
        }
        this.initPredeclaredModules(this.symTable.predeclaredModules, pkgNode.compUnits, pkgEnv);
        this.typePrecedence = 0;
        ArrayList<BLangNode> typeAndClassDefs = new ArrayList<BLangNode>();
        pkgNode.constants.forEach(constant -> typeAndClassDefs.add((BLangNode)constant));
        pkgNode.typeDefinitions.forEach(typDef -> typeAndClassDefs.add((BLangNode)typDef));
        List<BLangClassDefinition> classDefinitions = this.getClassDefinitions(pkgNode.topLevelNodes);
        classDefinitions.forEach(classDefn -> typeAndClassDefs.add((BLangNode)classDefn));
        this.defineTypeNodes(typeAndClassDefs, pkgEnv);
        for (BLangSimpleVariable variable : pkgNode.globalVars) {
            if (variable.expr == null || variable.expr.getKind() != NodeKind.LAMBDA || !variable.isDeclaredWithVar) continue;
            this.resolveAndSetFunctionTypeFromRHSLambda(variable, pkgEnv);
        }
        pkgEnv.logErrors = true;
        pkgNode.typeDefinitions.sort(this.getTypePrecedenceComparator());
        typeAndClassDefs.sort(this.getTypePrecedenceComparator());
        this.defineErrorDetails(pkgNode.typeDefinitions, pkgEnv);
        this.defineFields(typeAndClassDefs, pkgEnv);
        this.defineMembers(typeAndClassDefs, pkgEnv);
        this.defineDistinctClassAndObjectDefinitions(typeAndClassDefs);
        this.validateReadOnlyIntersectionTypeDefinitions(pkgNode.typeDefinitions);
        this.defineUndefinedReadOnlyTypes(pkgNode.typeDefinitions, typeAndClassDefs, pkgEnv);
        pkgNode.services.forEach(service -> this.defineNode((BLangNode)service, pkgEnv));
        pkgNode.functions.forEach(func -> this.defineNode((BLangNode)func, pkgEnv));
        pkgNode.annotations.forEach(annot -> this.defineNode((BLangNode)annot, pkgEnv));
        pkgNode.globalVars.forEach(var -> this.defineNode((BLangNode)var, pkgEnv));
        pkgNode.globalVars.stream().filter(var -> var.symbol.type.tsymbol != null && Symbols.isFlagOn(var.symbol.type.tsymbol.flags, 65536L)).map(varNode -> varNode.symbol).forEach(varSymbol -> {
            varSymbol.tag = 32820;
        });
    }

    private void defineDistinctClassAndObjectDefinitions(List<BLangNode> typDefs) {
        for (BLangNode node : typDefs) {
            if (node.getKind() == NodeKind.CLASS_DEFN) {
                this.populateDistinctTypeIdsFromIncludedTypeReferences((BLangClassDefinition)node);
                continue;
            }
            if (node.getKind() != NodeKind.TYPE_DEFINITION) continue;
            this.populateDistinctTypeIdsFromIncludedTypeReferences((BLangTypeDefinition)node);
        }
    }

    private void populateDistinctTypeIdsFromIncludedTypeReferences(BLangTypeDefinition typeDefinition) {
        if (typeDefinition.typeNode.getKind() != NodeKind.OBJECT_TYPE) {
            return;
        }
        BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)typeDefinition.typeNode;
        BTypeIdSet typeIdSet = ((BObjectType)objectTypeNode.type).typeIdSet;
        for (BLangType typeRef : objectTypeNode.typeRefs) {
            if (typeRef.type.tag != 33) continue;
            BObjectType refType = (BObjectType)typeRef.type;
            if (!refType.typeIdSet.primary.isEmpty()) {
                typeIdSet.primary.addAll(refType.typeIdSet.primary);
            }
            if (refType.typeIdSet.secondary.isEmpty()) continue;
            typeIdSet.secondary.addAll(refType.typeIdSet.secondary);
        }
    }

    private void populateDistinctTypeIdsFromIncludedTypeReferences(BLangClassDefinition typeDef) {
        BLangClassDefinition classDefinition = typeDef;
        BTypeIdSet typeIdSet = ((BObjectType)classDefinition.type).typeIdSet;
        for (BLangType typeRef : classDefinition.typeRefs) {
            if (typeRef.type.tag != 33) continue;
            BObjectType refType = (BObjectType)typeRef.type;
            if (!refType.typeIdSet.primary.isEmpty()) {
                typeIdSet.primary.addAll(refType.typeIdSet.primary);
            }
            if (refType.typeIdSet.secondary.isEmpty()) continue;
            typeIdSet.secondary.addAll(refType.typeIdSet.secondary);
        }
    }

    private Comparator<BLangNode> getTypePrecedenceComparator() {
        return new Comparator<BLangNode>(){

            @Override
            public int compare(BLangNode l, BLangNode r) {
                if (l instanceof OrderedNode && r instanceof OrderedNode) {
                    return ((OrderedNode)((Object)l)).getPrecedence() - ((OrderedNode)((Object)r)).getPrecedence();
                }
                return 0;
            }
        };
    }

    private void defineMembersOfClassDef(SymbolEnv pkgEnv, BLangClassDefinition classDefinition) {
        BObjectType objectType = (BObjectType)classDefinition.symbol.type;
        if (objectType.mutableType != null) {
            return;
        }
        SymbolEnv objMethodsEnv = SymbolEnv.createClassMethodsEnv(classDefinition, (BObjectTypeSymbol)classDefinition.symbol, pkgEnv);
        this.defineClassInitFunction(classDefinition, objMethodsEnv);
        classDefinition.functions.forEach(f -> {
            f.flagSet.add(Flag.FINAL);
            f.setReceiver(ASTBuilderUtil.createReceiver(classDefinition.pos, objectType));
            this.defineNode((BLangNode)f, objMethodsEnv);
        });
        HashSet<String> includedFunctionNames = new HashSet<String>();
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType type = typeRef.type;
            if (type == null || type == this.symTable.semanticError) {
                return;
            }
            List functions = ((BObjectTypeSymbol)type.tsymbol).attachedFuncs;
            for (BAttachedFunction function : functions) {
                this.defineReferencedFunction(classDefinition.pos, classDefinition.flagSet, objMethodsEnv, typeRef, function, includedFunctionNames, classDefinition.symbol, classDefinition.functions, classDefinition.internal);
            }
        }
    }

    private void defineReferencedClassFields(BLangClassDefinition classDefinition, SymbolEnv typeDefEnv, BObjectType objType) {
        HashSet referencedTypes = new HashSet();
        ArrayList invalidTypeRefs = new ArrayList();
        HashMap<String, BLangSimpleVariable> fieldNames = new HashMap<String, BLangSimpleVariable>();
        for (BLangSimpleVariable fieldVariable : classDefinition.fields) {
            fieldNames.put(fieldVariable.name.value, fieldVariable);
        }
        classDefinition.referencedFields = classDefinition.typeRefs.stream().flatMap(typeRef -> {
            BType referredType = this.symResolver.resolveTypeNode((BLangType)typeRef, typeDefEnv);
            if (referredType == this.symTable.semanticError) {
                return Stream.empty();
            }
            if (!referencedTypes.add(referredType.tsymbol)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_TYPE_REFERENCE, typeRef);
                return Stream.empty();
            }
            if (classDefinition.type.tag == 33) {
                if (referredType.tag != 33) {
                    this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE, typeRef);
                    invalidTypeRefs.add(typeRef);
                    return Stream.empty();
                }
                BObjectType objectType = (BObjectType)referredType;
                if (classDefinition.type.tsymbol.owner != referredType.tsymbol.owner) {
                    for (BField field2 : objectType.fields.values()) {
                        if (Symbols.isPublic(field2.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                    for (BAttachedFunction func : ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs) {
                        if (Symbols.isPublic(func.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                }
            }
            return ((BStructureType)referredType).fields.values().stream().filter(f -> {
                if (fieldNames.containsKey(f.name.value)) {
                    BLangSimpleVariable existingVariable = (BLangSimpleVariable)fieldNames.get(f.name.value);
                    return !this.types.isAssignable(existingVariable.type, f.type);
                }
                return true;
            }).map(field -> {
                BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.type);
                var.flagSet = field.symbol.getFlags();
                return var;
            });
        }).collect(Collectors.toList());
        classDefinition.typeRefs.removeAll(invalidTypeRefs);
        for (BLangSimpleVariable field : classDefinition.referencedFields) {
            this.defineNode(field, typeDefEnv);
            if (field.symbol.type == this.symTable.semanticError) continue;
            objType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
    }

    private List<BLangClassDefinition> getClassDefinitions(List<TopLevelNode> topLevelNodes) {
        ArrayList<BLangClassDefinition> classDefinitions = new ArrayList<BLangClassDefinition>();
        for (TopLevelNode topLevelNode : topLevelNodes) {
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            classDefinitions.add((BLangClassDefinition)topLevelNode);
        }
        return classDefinitions;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        EnumSet<Flag> flags = EnumSet.copyOf(classDefinition.flagSet);
        boolean isPublicType = flags.contains((Object)Flag.PUBLIC);
        Name className = this.names.fromIdNode(classDefinition.name);
        BClassSymbol tSymbol = Symbols.createClassSymbol(Flags.asMask(flags), className, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, classDefinition.name.pos, this.getOrigin(className, flags), classDefinition.isServiceDecl);
        tSymbol.scope = new Scope(tSymbol);
        tSymbol.markdownDocumentation = this.getMarkdownDocAttachment(classDefinition.markdownDocumentationAttachment);
        long typeFlags = 0L;
        if (flags.contains((Object)Flag.READONLY)) {
            typeFlags |= 0x20L;
        }
        if (flags.contains((Object)Flag.ISOLATED)) {
            typeFlags |= 0x20000000L;
        }
        if (flags.contains((Object)Flag.SERVICE)) {
            typeFlags |= 0x40000L;
        }
        if (flags.contains((Object)Flag.OBJECT_CTOR)) {
            typeFlags |= 0x100000000L;
        }
        BObjectType objectType = new BObjectType(tSymbol, typeFlags);
        if (flags.contains((Object)Flag.DISTINCT)) {
            objectType.typeIdSet = BTypeIdSet.from(this.env.enclPkg.symbol.pkgID, classDefinition.name.value, isPublicType);
        }
        if (flags.contains((Object)Flag.CLIENT)) {
            objectType.flags |= 0x10000L;
        }
        tSymbol.type = objectType;
        classDefinition.type = objectType;
        classDefinition.symbol = tSymbol;
        if (this.isDeprecated(classDefinition.annAttachments)) {
            tSymbol.flags |= 0x10L;
        }
        for (BLangType typeRef : classDefinition.typeRefs) {
            BType referencedType = this.symResolver.resolveTypeNode(typeRef, this.env);
            if (referencedType != this.symTable.noType || this.unresolvedTypes.contains(classDefinition)) continue;
            this.unresolvedTypes.add(classDefinition);
            return;
        }
        classDefinition.setPrecedence(this.typePrecedence++);
        if (this.symResolver.checkForUniqueSymbol(classDefinition.pos, this.env, tSymbol)) {
            this.env.scope.define(tSymbol.name, tSymbol);
        }
        this.env.scope.define(tSymbol.name, tSymbol);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        Name annotName = this.names.fromIdNode(annotationNode.name);
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(Flags.asMask(annotationNode.flagSet), annotationNode.getAttachPoints(), annotName, this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, annotationNode.pos, this.getOrigin(annotName));
        annotationSymbol.markdownDocumentation = this.getMarkdownDocAttachment(annotationNode.markdownDocumentationAttachment);
        if (this.isDeprecated(annotationNode.annAttachments)) {
            annotationSymbol.flags |= 0x10L;
        }
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        annotationNode.symbol = annotationSymbol;
        this.defineSymbol(annotationNode.name.pos, annotationSymbol);
        SymbolEnv annotationEnv = SymbolEnv.createAnnotationEnv(annotationNode, annotationSymbol.scope, this.env);
        BLangType annotTypeNode = annotationNode.typeNode;
        if (annotTypeNode != null) {
            BType type = this.symResolver.resolveTypeNode(annotTypeNode, annotationEnv);
            annotationSymbol.attachedType = type.tsymbol;
            if (!this.isValidAnnotationType(type)) {
                this.dlog.error(annotTypeNode.pos, DiagnosticErrorCode.ANNOTATION_INVALID_TYPE, type);
            }
            if (annotationNode.flagSet.contains((Object)Flag.CONSTANT) && !type.isAnydata()) {
                this.dlog.error(annotTypeNode.pos, DiagnosticErrorCode.ANNOTATION_INVALID_CONST_TYPE, type);
            }
        }
        if (!annotationNode.flagSet.contains((Object)Flag.CONSTANT) && annotationNode.getAttachPoints().stream().anyMatch(attachPoint -> attachPoint.source)) {
            this.dlog.error(annotationNode.pos, DiagnosticErrorCode.ANNOTATION_REQUIRES_CONST, new Object[0]);
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        Name version;
        Name orgName;
        BSymbol importSymbol;
        Name pkgAlias = this.names.fromIdNode(importPkgNode.alias);
        if (!Names.IGNORE.equals(pkgAlias) && (importSymbol = this.symResolver.resolvePrefixSymbol(this.env, pkgAlias, this.names.fromIdNode(importPkgNode.compUnit))) != this.symTable.notFoundSymbol) {
            if (this.isSameImport(importPkgNode, (BPackageSymbol)importSymbol)) {
                this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.REDECLARED_IMPORT_MODULE, importPkgNode.getQualifiedPackageName());
            } else {
                this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, pkgAlias);
            }
            return;
        }
        PackageID enclPackageID = this.env.enclPkg.packageID;
        if (!this.isNullOrEmpty(importPkgNode.orgName.value)) {
            orgName = this.names.fromIdNode(importPkgNode.orgName);
            if (!this.isNullOrEmpty(importPkgNode.version.value)) {
                version = this.names.fromIdNode(importPkgNode.version);
            } else if (this.projectAPIInitiatedCompilation) {
                version = Names.EMPTY;
            } else {
                String pkgName = importPkgNode.getPackageName().stream().map(id -> id.value).collect(Collectors.joining("."));
                version = this.sourceDirectory.getSourcePackageNames().contains(pkgName) && orgName.value.equals(enclPackageID.orgName.value) ? enclPackageID.version : Names.EMPTY;
            }
        } else {
            orgName = enclPackageID.orgName;
            version = Names.DEFAULT_VERSION.equals(enclPackageID.version) ? Names.EMPTY : enclPackageID.version;
        }
        List<Name> nameComps = importPkgNode.pkgNameComps.stream().map(identifier -> this.names.fromIdNode((BLangIdentifier)identifier)).collect(Collectors.toList());
        PackageID pkgId = new PackageID(orgName, nameComps, version);
        if (!(!pkgId.equals(PackageID.ANNOTATIONS) && !pkgId.equals(PackageID.INTERNAL) && !pkgId.equals(PackageID.QUERY) || enclPackageID.orgName.equals(Names.BALLERINA_ORG) && enclPackageID.name.value.startsWith(Names.LANG.value))) {
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        if (this.importedPackages.contains(pkgId)) {
            int index = this.importedPackages.indexOf(pkgId);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = index; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        boolean samePkg = false;
        PackageID entryPackage = this.importedPackages.get(0);
        if (entryPackage.isUnnamed == pkgId.isUnnamed) {
            boolean bl = samePkg = !entryPackage.isUnnamed || entryPackage.sourceFileName.equals(pkgId.sourceFileName);
        }
        if (samePkg && entryPackage.orgName.equals(pkgId.orgName) && entryPackage.name.equals(pkgId.name)) {
            StringBuilder stringBuilder = new StringBuilder();
            String entryPackageString = this.importedPackages.get(0).toString();
            int packageIndex = entryPackageString.indexOf(":");
            if (packageIndex != -1) {
                entryPackageString = entryPackageString.substring(0, packageIndex);
            }
            stringBuilder.append(entryPackageString).append(" -> ");
            for (int i = 1; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        BPackageSymbol pkgSymbol = this.projectAPIInitiatedCompilation ? this.packageCache.getSymbol(pkgId) : this.pkgLoader.loadPackageSymbol(pkgId, enclPackageID, this.env.enclPkg.repos);
        if (pkgSymbol == null) {
            this.dlog.error(importPkgNode.pos, DiagnosticErrorCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        List<BPackageSymbol> imports = ((BPackageSymbol)this.env.scope.owner).imports;
        if (!imports.contains(pkgSymbol)) {
            imports.add(pkgSymbol);
        }
        BPackageSymbol symbol = this.dupPackageSymbolAndSetCompUnit(pkgSymbol, this.names.fromIdNode(importPkgNode.compUnit));
        symbol.scope = pkgSymbol.scope;
        importPkgNode.symbol = symbol;
        this.env.scope.define(pkgAlias, symbol);
    }

    public void initPredeclaredModules(Map<Name, BPackageSymbol> predeclaredModules, List<BLangCompilationUnit> compUnits, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        for (Name alias : predeclaredModules.keySet()) {
            int index = 0;
            Scope.ScopeEntry entry = this.env.scope.lookup(alias);
            if (entry == Scope.NOT_FOUND_ENTRY && !compUnits.isEmpty()) {
                this.env.scope.define(alias, this.dupPackageSymbolAndSetCompUnit(predeclaredModules.get(alias), new Name(compUnits.get((int)index++).name)));
                entry = this.env.scope.lookup(alias);
            }
            for (int i = index; i < compUnits.size(); ++i) {
                boolean isUndefinedModule = true;
                String compUnitName = compUnits.get((int)i).name;
                if (((BPackageSymbol)entry.symbol).compUnit.value.equals(compUnitName)) {
                    isUndefinedModule = false;
                }
                while (entry.next != Scope.NOT_FOUND_ENTRY) {
                    if (((BPackageSymbol)entry.next.symbol).compUnit.value.equals(compUnitName)) {
                        isUndefinedModule = false;
                        break;
                    }
                    entry = entry.next;
                }
                if (!isUndefinedModule) continue;
                entry.next = new Scope.ScopeEntry(this.dupPackageSymbolAndSetCompUnit(predeclaredModules.get(alias), new Name(compUnitName)), Scope.NOT_FOUND_ENTRY);
            }
        }
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        String nsURI;
        if (xmlnsNode.namespaceURI.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef varRef = (BLangSimpleVarRef)xmlnsNode.namespaceURI;
            nsURI = this.missingNodesHelper.isMissingNode(varRef.variableName.value) ? "" : "";
        } else {
            nsURI = (String)((BLangLiteral)xmlnsNode.namespaceURI).value;
            if (!this.nullOrEmpty(xmlnsNode.prefix.value) && nsURI.isEmpty()) {
                this.dlog.error(xmlnsNode.pos, DiagnosticErrorCode.INVALID_NAMESPACE_DECLARATION, xmlnsNode.prefix);
            }
        }
        if (xmlnsNode.prefix.value == null) {
            xmlnsNode.prefix.value = "";
        }
        Name prefix = this.names.fromIdNode(xmlnsNode.prefix);
        BXMLNSSymbol xmlnsSymbol = Symbols.createXMLNSSymbol(prefix, nsURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner, xmlnsNode.pos, this.getOrigin(prefix));
        xmlnsNode.symbol = xmlnsSymbol;
        BSymbol foundSym = this.symResolver.lookupSymbolInPrefixSpace(this.env, xmlnsSymbol.name);
        if ((foundSym.tag & 0x1001) != 4097) {
            foundSym = this.symTable.notFoundSymbol;
        }
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(xmlnsNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, xmlnsSymbol.name);
            return;
        }
        this.defineSymbol(xmlnsNode.prefix.pos, xmlnsSymbol);
    }

    private boolean nullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.defineNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    private void defineTypeNodes(List<BLangNode> typeDefs, SymbolEnv env) {
        if (typeDefs.isEmpty()) {
            return;
        }
        this.unresolvedTypes = new ArrayList<BLangNode>();
        for (BLangNode typeDef : typeDefs) {
            this.defineNode(typeDef, env);
        }
        if (typeDefs.size() <= this.unresolvedTypes.size()) {
            for (BLangNode unresolvedType : this.unresolvedTypes) {
                Stack<String> references = new Stack<String>();
                if (unresolvedType.getKind() == NodeKind.TYPE_DEFINITION || unresolvedType.getKind() == NodeKind.CONSTANT) {
                    TypeDefinition def = (TypeDefinition)((Object)unresolvedType);
                    references.push(def.getName().getValue());
                    this.checkErrors(unresolvedType, (BLangNode)((Object)def.getTypeNode()), references);
                    continue;
                }
                if (unresolvedType.getKind() != NodeKind.CLASS_DEFN) continue;
                BLangClassDefinition classDefinition = (BLangClassDefinition)unresolvedType;
                references.push(classDefinition.getName().getValue());
                this.checkErrors(unresolvedType, classDefinition, references);
            }
            this.unresolvedTypes.forEach(type -> this.defineNode((BLangNode)type, env));
            return;
        }
        this.defineTypeNodes(this.unresolvedTypes, env);
    }

    private void checkErrors(BLangNode unresolvedType, BLangNode currentTypeOrClassNode, Stack<String> visitedNodes) {
        switch (currentTypeOrClassNode.getKind()) {
            case ARRAY_TYPE: {
                this.checkErrors(unresolvedType, ((BLangArrayType)currentTypeOrClassNode).elemtype, visitedNodes);
                break;
            }
            case UNION_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangUnionTypeNode)currentTypeOrClassNode).memberTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(unresolvedType, memberTypeNode, visitedNodes);
                }
                break;
            }
            case INTERSECTION_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangIntersectionTypeNode)currentTypeOrClassNode).constituentTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(unresolvedType, memberTypeNode, visitedNodes);
                }
                break;
            }
            case TUPLE_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangTupleTypeNode)currentTypeOrClassNode).memberTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(unresolvedType, memberTypeNode, visitedNodes);
                }
                break;
            }
            case CONSTRAINED_TYPE: {
                this.checkErrors(unresolvedType, ((BLangConstrainedType)currentTypeOrClassNode).constraint, visitedNodes);
                break;
            }
            case TABLE_TYPE: {
                this.checkErrors(unresolvedType, ((BLangTableTypeNode)currentTypeOrClassNode).constraint, visitedNodes);
                break;
            }
            case USER_DEFINED_TYPE: {
                this.checkErrorsOfUserDefinedType(unresolvedType, (BLangUserDefinedType)currentTypeOrClassNode, visitedNodes);
                break;
            }
            case BUILT_IN_REF_TYPE: 
            case FINITE_TYPE_NODE: 
            case VALUE_TYPE: 
            case ERROR_TYPE: {
                break;
            }
            case FUNCTION_TYPE: {
                BLangFunctionTypeNode functionTypeNode = (BLangFunctionTypeNode)currentTypeOrClassNode;
                functionTypeNode.params.forEach(p -> this.checkErrors(unresolvedType, p.typeNode, visitedNodes));
                if (functionTypeNode.restParam != null) {
                    this.checkErrors(unresolvedType, functionTypeNode.restParam.typeNode, visitedNodes);
                }
                if (functionTypeNode.returnTypeNode == null) break;
                this.checkErrors(unresolvedType, functionTypeNode.returnTypeNode, visitedNodes);
                break;
            }
            case RECORD_TYPE: {
                for (TypeNode typeNode : ((BLangRecordTypeNode)currentTypeOrClassNode).getTypeReferences()) {
                    this.checkErrors(unresolvedType, (BLangType)typeNode, visitedNodes);
                }
                break;
            }
            case OBJECT_TYPE: {
                for (TypeNode typeNode : ((BLangObjectTypeNode)currentTypeOrClassNode).getTypeReferences()) {
                    this.checkErrors(unresolvedType, (BLangType)typeNode, visitedNodes);
                }
                break;
            }
            case CLASS_DEFN: {
                for (TypeNode typeNode : ((BLangClassDefinition)currentTypeOrClassNode).typeRefs) {
                    this.checkErrors(unresolvedType, (BLangType)typeNode, visitedNodes);
                }
                break;
            }
            default: {
                throw new RuntimeException("unhandled type kind: " + currentTypeOrClassNode.getKind());
            }
        }
    }

    private void checkErrorsOfUserDefinedType(BLangNode unresolvedType, BLangUserDefinedType currentTypeOrClassNode, Stack<String> visitedNodes) {
        String currentTypeNodeName = currentTypeOrClassNode.typeName.value;
        if (currentTypeNodeName.startsWith("$")) {
            return;
        }
        String unresolvedTypeNodeName = this.getTypeOrClassName(unresolvedType);
        if (unresolvedTypeNodeName.equals(currentTypeNodeName)) {
            visitedNodes.push(currentTypeNodeName);
            this.dlog.error(unresolvedType.getPosition(), DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, visitedNodes);
            visitedNodes.pop();
        } else if (visitedNodes.contains(currentTypeNodeName)) {
            int i;
            ArrayList<String> dependencyList = new ArrayList<String>(visitedNodes.size() - i);
            for (i = visitedNodes.indexOf(currentTypeNodeName); i < visitedNodes.size(); ++i) {
                dependencyList.add((String)visitedNodes.get(i));
            }
            dependencyList.add(currentTypeNodeName);
            this.dlog.error(unresolvedType.getPosition(), DiagnosticErrorCode.CYCLIC_TYPE_REFERENCE, dependencyList);
        } else {
            List typeDefinitions = this.unresolvedTypes.stream().filter(node -> this.getTypeOrClassName((BLangNode)node).equals(currentTypeNodeName)).collect(Collectors.toList());
            if (typeDefinitions.isEmpty()) {
                LocationData locationData = new LocationData(currentTypeNodeName, currentTypeOrClassNode.pos.lineRange().startLine().line(), currentTypeOrClassNode.pos.lineRange().startLine().offset());
                if (this.unknownTypeRefs.add(locationData)) {
                    this.dlog.error(currentTypeOrClassNode.pos, DiagnosticErrorCode.UNKNOWN_TYPE, currentTypeNodeName);
                }
            } else {
                for (BLangNode typeDefinition : typeDefinitions) {
                    if (typeDefinition.getKind() == NodeKind.TYPE_DEFINITION) {
                        BLangTypeDefinition typeDef = (BLangTypeDefinition)typeDefinition;
                        String typeName = typeDef.getName().getValue();
                        visitedNodes.push(typeName);
                        this.checkErrors(unresolvedType, typeDef.getTypeNode(), visitedNodes);
                        visitedNodes.pop();
                        continue;
                    }
                    BLangClassDefinition classDefinition = (BLangClassDefinition)typeDefinition;
                    visitedNodes.push(classDefinition.getName().getValue());
                    this.checkErrors(unresolvedType, classDefinition, visitedNodes);
                    visitedNodes.pop();
                }
            }
        }
    }

    private String getTypeOrClassName(BLangNode node) {
        if (node.getKind() == NodeKind.TYPE_DEFINITION || node.getKind() == NodeKind.CONSTANT) {
            return ((TypeDefinition)((Object)node)).getName().getValue();
        }
        return ((BLangClassDefinition)node).getName().getValue();
    }

    public boolean isUnknownTypeRef(BLangUserDefinedType bLangUserDefinedType) {
        LocationData locationData = new LocationData(bLangUserDefinedType.typeName.value, bLangUserDefinedType.pos.lineRange().startLine().line(), bLangUserDefinedType.pos.lineRange().startLine().offset());
        return this.unknownTypeRefs.contains(locationData);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        BType definedType = this.symResolver.resolveTypeNode(typeDefinition.typeNode, this.env);
        if (definedType == this.symTable.semanticError) {
            return;
        }
        if (definedType == this.symTable.noType) {
            if (!this.unresolvedTypes.contains(typeDefinition)) {
                this.unresolvedTypes.add(typeDefinition);
            }
            return;
        }
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDefinition.typeNode;
            for (BLangType typeRef : structureTypeNode.typeRefs) {
                BType referencedType = this.symResolver.resolveTypeNode(typeRef, this.env);
                if (referencedType != this.symTable.noType || this.unresolvedTypes.contains(typeDefinition)) continue;
                this.unresolvedTypes.add(typeDefinition);
                return;
            }
        }
        if (typeDefinition.typeNode.getKind() == NodeKind.FUNCTION_TYPE && definedType.tsymbol == null) {
            definedType.tsymbol = Symbols.createTypeSymbol(67108892, Flags.asMask(typeDefinition.flagSet), Names.EMPTY, this.env.enclPkg.symbol.pkgID, definedType, this.env.scope.owner, typeDefinition.pos, SymbolOrigin.SOURCE);
        }
        if (typeDefinition.flagSet.contains((Object)Flag.ENUM)) {
            definedType.tsymbol = this.createEnumSymbol(typeDefinition, definedType);
        }
        typeDefinition.setPrecedence(this.typePrecedence++);
        BTypeSymbol typeDefSymbol = definedType.tsymbol.name != Names.EMPTY ? definedType.tsymbol.createLabelSymbol() : definedType.tsymbol;
        typeDefSymbol.markdownDocumentation = this.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        typeDefSymbol.name = this.names.fromIdNode(typeDefinition.getName());
        typeDefSymbol.pkgID = this.env.enclPkg.packageID;
        typeDefSymbol.pos = typeDefinition.name.pos;
        typeDefSymbol.origin = this.getOrigin(typeDefSymbol.name);
        boolean distinctFlagPresent = this.isDistinctFlagPresent(typeDefinition);
        if (distinctFlagPresent) {
            BType distinctType;
            if (definedType.getKind() == TypeKind.ERROR) {
                distinctType = this.getDistinctErrorType(typeDefinition, (BErrorType)definedType, typeDefSymbol);
                typeDefinition.typeNode.type = distinctType;
                definedType = distinctType;
            } else if (definedType.getKind() == TypeKind.OBJECT) {
                distinctType = this.getDistinctObjectType(typeDefinition, (BObjectType)definedType, typeDefSymbol);
                typeDefinition.typeNode.type = distinctType;
                definedType = distinctType;
            } else if (definedType.getKind() == TypeKind.UNION) {
                this.validateUnionForDistinctType((BUnionType)definedType, typeDefinition.pos);
            } else {
                this.dlog.error(typeDefinition.pos, DiagnosticErrorCode.DISTINCT_TYPING_ONLY_SUPPORT_OBJECTS_AND_ERRORS, new Object[0]);
            }
        }
        typeDefSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        typeDefSymbol.flags &= this.getPublicFlagResetingMask(typeDefinition.flagSet, typeDefinition.typeNode);
        if (this.isDeprecated(typeDefinition.annAttachments)) {
            typeDefSymbol.flags |= 0x10L;
        }
        if (Symbols.isFlagOn(typeDefSymbol.flags, 2048L)) {
            typeDefSymbol.origin = SymbolOrigin.VIRTUAL;
        }
        if (typeDefinition.annAttachments.stream().anyMatch(attachment -> attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value))) {
            if (PackageID.isLangLibPackageID(this.env.enclPkg.packageID)) {
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol.type, typeDefSymbol.name);
                typeDefSymbol.flags |= 0x200000L;
                if (typeDefinition.typeNode.getKind() == NodeKind.ERROR_TYPE) {
                    typeDefSymbol.isLabel = false;
                }
            } else {
                this.dlog.error(typeDefinition.pos, DiagnosticErrorCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
            }
        }
        definedType.flags |= typeDefSymbol.flags;
        typeDefinition.symbol = typeDefSymbol;
        boolean isLanglibModule = PackageID.isLangLibPackageID(this.env.enclPkg.packageID);
        if (isLanglibModule) {
            this.handleLangLibTypes(typeDefinition);
            return;
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefSymbol);
        if (typeDefinition.typeNode.type.tag == 28) {
            this.defineErrorConstructorSymbol(typeDefinition.name.pos, typeDefSymbol);
        }
    }

    private BEnumSymbol createEnumSymbol(BLangTypeDefinition typeDefinition, BType definedType) {
        ArrayList<BConstantSymbol> enumMembers = new ArrayList<BConstantSymbol>();
        List<BLangType> members = ((BLangUnionTypeNode)typeDefinition.typeNode).memberTypeNodes;
        for (BLangType member : members) {
            enumMembers.add((BConstantSymbol)((BLangUserDefinedType)member).symbol);
        }
        return new BEnumSymbol(enumMembers, Flags.asMask(typeDefinition.flagSet), Names.EMPTY, this.env.enclPkg.symbol.pkgID, definedType, this.env.scope.owner, typeDefinition.pos, SymbolOrigin.SOURCE);
    }

    private BObjectType getDistinctObjectType(BLangTypeDefinition typeDefinition, BObjectType definedType, BTypeSymbol typeDefSymbol) {
        BObjectType definedObjType = definedType;
        if (definedObjType.tsymbol != typeDefSymbol) {
            BObjectType objType = new BObjectType(typeDefSymbol);
            typeDefSymbol.type = objType;
            definedObjType = objType;
        }
        boolean isPublicType = typeDefinition.flagSet.contains((Object)Flag.PUBLIC);
        definedObjType.typeIdSet = this.calculateTypeIdSet(typeDefinition, isPublicType, definedType.typeIdSet);
        return definedObjType;
    }

    private void validateUnionForDistinctType(BUnionType definedType, Location pos) {
        Set<BType> memberTypes = definedType.getMemberTypes();
        TypeKind firstTypeKind = null;
        for (BType type : memberTypes) {
            TypeKind typeKind = type.getKind();
            if (firstTypeKind == null && (typeKind == TypeKind.ERROR || typeKind == TypeKind.OBJECT)) {
                firstTypeKind = typeKind;
            }
            if (typeKind == firstTypeKind) continue;
            this.dlog.error(pos, DiagnosticErrorCode.DISTINCT_TYPING_ONLY_SUPPORT_OBJECTS_AND_ERRORS, new Object[0]);
        }
    }

    private BErrorType getDistinctErrorType(BLangTypeDefinition typeDefinition, BErrorType definedType, BTypeSymbol typeDefSymbol) {
        BErrorType definedErrorType = definedType;
        if (definedErrorType.tsymbol != typeDefSymbol) {
            BErrorType bErrorType = new BErrorType(typeDefSymbol);
            bErrorType.detailType = definedErrorType.detailType;
            typeDefSymbol.type = bErrorType;
            definedErrorType = bErrorType;
        }
        boolean isPublicType = typeDefinition.flagSet.contains((Object)Flag.PUBLIC);
        definedErrorType.typeIdSet = this.calculateTypeIdSet(typeDefinition, isPublicType, definedType.typeIdSet);
        return definedErrorType;
    }

    private BTypeIdSet calculateTypeIdSet(BLangTypeDefinition typeDefinition, boolean isPublicType, BTypeIdSet secondary) {
        String name = typeDefinition.flagSet.contains((Object)Flag.ANONYMOUS) ? this.anonymousModelHelper.getNextDistinctErrorId(this.env.enclPkg.packageID) : typeDefinition.getName().value;
        return BTypeIdSet.from(this.env.enclPkg.packageID, name, isPublicType, secondary);
    }

    private boolean isDistinctFlagPresent(BLangTypeDefinition typeDefinition) {
        return typeDefinition.typeNode.flagSet.contains((Object)Flag.DISTINCT);
    }

    private void handleLangLibTypes(BLangTypeDefinition typeDefinition) {
        Iterator<BLangAnnotationAttachment> iterator = typeDefinition.annAttachments.iterator();
        if (iterator.hasNext()) {
            BLangAnnotationAttachment attachment = iterator.next();
            if (attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
                BTypeSymbol typeDefSymbol = typeDefinition.symbol;
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol.type, typeDefSymbol.name);
                typeDefSymbol.flags |= 0x200000L;
            } else if (attachment.annotationName.value.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) {
                BType type = this.symTable.getLangLibSubType(typeDefinition.name.value);
                typeDefinition.symbol = type.tsymbol;
                typeDefinition.type = type;
                typeDefinition.typeNode.type = type;
                typeDefinition.isBuiltinTypeDef = true;
            } else {
                throw new IllegalStateException("Not supported annotation attachment at:" + attachment.pos);
            }
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol);
        if (typeDefinition.typeNode.type.tag == 28) {
            this.defineErrorConstructorSymbol(typeDefinition.name.pos, typeDefinition.symbol);
        }
    }

    private long getPublicFlagResetingMask(Set<Flag> flagSet, BLangType typeNode) {
        boolean isAnonType;
        boolean bl = isAnonType = typeNode instanceof BLangStructureTypeNode && ((BLangStructureTypeNode)typeNode).isAnonymous;
        if (flagSet.contains((Object)Flag.PUBLIC) || isAnonType) {
            return Long.MAX_VALUE;
        }
        return -2L;
    }

    private void defineErrorConstructorSymbol(Location pos, BTypeSymbol typeDefSymbol) {
        BErrorType errorType = (BErrorType)typeDefSymbol.type;
        BConstructorSymbol symbol = new BConstructorSymbol(typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, errorType, typeDefSymbol.owner, pos, this.getOrigin(typeDefSymbol.name));
        symbol.kind = SymbolKind.ERROR_CONSTRUCTOR;
        symbol.scope = new Scope(symbol);
        symbol.retType = errorType;
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
        ((BErrorTypeSymbol)typeDefSymbol).ctorSymbol = symbol;
    }

    @Override
    public void visit(BLangWorker workerNode) {
        BInvokableSymbol workerSymbol = Symbols.createWorkerSymbol(Flags.asMask(workerNode.flagSet), this.names.fromIdNode(workerNode.name), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, workerNode.pos, SymbolOrigin.SOURCE);
        workerSymbol.markdownDocumentation = this.getMarkdownDocAttachment(workerNode.markdownDocumentationAttachment);
        workerNode.symbol = workerSymbol;
        this.defineSymbolWithCurrentEnvOwner(workerNode.pos, workerSymbol);
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.defineNode(serviceNode.serviceVariable, this.env);
    }

    @Override
    public void visit(BLangResourceFunction funcNode) {
        boolean validAttachedFunc = this.validateFuncReceiver(funcNode);
        if (PackageID.isLangLibPackageID(this.env.enclPkg.symbol.pkgID)) {
            funcNode.flagSet.add(Flag.LANG_LIB);
        }
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.getFuncSymbolName(funcNode), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, funcNode.hasBody(), funcNode.name.pos, SymbolOrigin.SOURCE);
        funcSymbol.source = funcNode.pos.lineRange().filePath();
        funcSymbol.markdownDocumentation = this.getMarkdownDocAttachment(funcNode.markdownDocumentationAttachment);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        funcNode.type = funcSymbol.type;
        if (this.isDeprecated(funcNode.annAttachments)) {
            funcSymbol.flags |= 0x10L;
        }
        if (funcNode.receiver != null) {
            this.defineAttachedFunctions(funcNode, funcSymbol, invokableEnv, validAttachedFunc);
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean validAttachedFunc = this.validateFuncReceiver(funcNode);
        boolean remoteFlagSetOnNode = Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 32768L);
        if (!funcNode.attachedFunction && Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 1024L)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.PRIVATE_FUNCTION_VISIBILITY, funcNode.name);
        }
        if (funcNode.receiver == null && !funcNode.attachedFunction && remoteFlagSetOnNode) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.REMOTE_IN_NON_OBJECT_FUNCTION, funcNode.name.value);
        }
        if (PackageID.isLangLibPackageID(this.env.enclPkg.symbol.pkgID)) {
            funcNode.flagSet.add(Flag.LANG_LIB);
        }
        Location symbolPos = funcNode.flagSet.contains((Object)Flag.LAMBDA) ? this.symTable.builtinPos : funcNode.name.pos;
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.getFuncSymbolName(funcNode), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, funcNode.hasBody(), symbolPos, this.getOrigin(funcNode.name.value));
        funcSymbol.source = funcNode.pos.lineRange().filePath();
        funcSymbol.markdownDocumentation = this.getMarkdownDocAttachment(funcNode.markdownDocumentationAttachment);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        funcNode.type = funcSymbol.type;
        if (Symbols.isFlagOn(funcSymbol.flags, 0x100000L)) {
            funcSymbol.origin = SymbolOrigin.VIRTUAL;
        }
        if (this.isDeprecated(funcNode.annAttachments)) {
            funcSymbol.flags |= 0x10L;
        }
        if (funcNode.receiver != null) {
            this.defineAttachedFunctions(funcNode, funcSymbol, invokableEnv, validAttachedFunc);
        }
    }

    private boolean isDeprecated(List<BLangAnnotationAttachment> annAttachments) {
        for (BLangAnnotationAttachment annotationAttachment : annAttachments) {
            if (!annotationAttachment.annotationName.getValue().equals(DEPRECATION_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol constantSymbol;
        BType staticType;
        if (constant.typeNode != null) {
            staticType = this.symResolver.resolveTypeNode(constant.typeNode, this.env);
            if (staticType == this.symTable.noType) {
                constant.symbol = this.getConstantSymbol(constant);
                if (!this.unresolvedTypes.contains(constant)) {
                    this.unresolvedTypes.add(constant);
                }
                return;
            }
        } else {
            staticType = this.symTable.semanticError;
        }
        constant.symbol = constantSymbol = this.getConstantSymbol(constant);
        NodeKind nodeKind = constant.expr.getKind();
        if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
            if (constant.typeNode != null) {
                if (this.types.isValidLiteral((BLangLiteral)constant.expr, staticType)) {
                    BLangFiniteTypeNode finiteType = (BLangFiniteTypeNode)constant.associatedTypeDefinition.typeNode;
                    BLangExpression valueSpaceExpr = finiteType.valueSpace.iterator().next();
                    valueSpaceExpr.type = staticType;
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                    constantSymbol.literalType = staticType;
                } else {
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = staticType;
                    constantSymbol.literalType = constant.expr.type;
                }
            } else {
                this.defineNode(constant.associatedTypeDefinition, this.env);
                constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                constantSymbol.literalType = constant.expr.type;
            }
        } else if (constant.typeNode != null) {
            constantSymbol.type = constantSymbol.literalType = staticType;
        }
        constantSymbol.markdownDocumentation = this.getMarkdownDocAttachment(constant.markdownDocumentationAttachment);
        if (this.isDeprecated(constant.annAttachments)) {
            constantSymbol.flags |= 0x10L;
        }
        if (!this.symResolver.checkForUniqueSymbol(constant.name.pos, this.env, constantSymbol)) {
            return;
        }
        if (constant.symbol.name == Names.IGNORE) {
            return;
        }
        this.env.scope.define(constantSymbol.name, constantSymbol);
    }

    private BConstantSymbol getConstantSymbol(BLangConstant constant) {
        Name name = this.names.fromIdNode(constant.name);
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        return new BConstantSymbol(Flags.asMask(constant.flagSet), name, pkgID, this.symTable.semanticError, this.symTable.noType, this.env.scope.owner, constant.name.pos, this.getOrigin(name));
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        Name varName;
        if (varNode.type == null) {
            varNode.type = varNode.typeNode != null ? this.symResolver.resolveTypeNode(varNode.typeNode, this.env) : this.symTable.noType;
        }
        if ((varName = this.names.fromIdNode(varNode.name)) == Names.EMPTY || varName == Names.IGNORE) {
            return;
        }
        BVarSymbol varSymbol = this.defineVarSymbol(varNode.name.pos, varNode.flagSet, varNode.type, varName, this.env, varNode.internal);
        if (this.isDeprecated(varNode.annAttachments)) {
            varSymbol.flags |= 0x10L;
        }
        varSymbol.markdownDocumentation = this.getMarkdownDocAttachment(varNode.markdownDocumentationAttachment);
        varNode.symbol = varSymbol;
        if (varNode.symbol.type.tsymbol != null && Symbols.isFlagOn(varNode.symbol.type.tsymbol.flags, 65536L)) {
            varSymbol.tag = 32820;
        }
        if (varSymbol.type.tag == 31 && ((BFutureType)varSymbol.type).workerDerivative) {
            Iterator lambdaFunctions = this.env.enclPkg.lambdaFunctions.iterator();
            while (lambdaFunctions.hasNext()) {
                BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)lambdaFunctions.next();
                BLangInvokableNode enclInvokable = lambdaFunction.capturedClosureEnv.enclInvokable;
                if (!lambdaFunctions.hasNext() || enclInvokable == null || varSymbol.owner != enclInvokable.symbol) continue;
                lambdaFunction.capturedClosureEnv.scope.define(varSymbol.name, varSymbol);
            }
        }
        if (varSymbol.type.tag == 16) {
            BInvokableSymbol symbol = (BInvokableSymbol)varSymbol;
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)symbol.type.tsymbol;
            symbol.params = tsymbol.params;
            symbol.restParam = tsymbol.restParam;
            symbol.retType = tsymbol.returnType;
        }
        if (varSymbol.type.tag == 49 && (this.env.scope.owner.tag & 0x5005C) != 327772) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.NEVER_TYPED_VAR_DEF_NOT_ALLOWED, varSymbol.name);
        }
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute) {
        Name prefix;
        BXMLNSSymbol xmlnsSymbol;
        String symbolName;
        if (bLangXMLAttribute.name.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        BLangXMLQName qname = (BLangXMLQName)bLangXMLAttribute.name;
        if (!bLangXMLAttribute.isNamespaceDeclr) {
            BXMLAttributeSymbol attrSymbol = new BXMLAttributeSymbol(qname.localname.value, qname.namespaceURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner, bLangXMLAttribute.pos, SymbolOrigin.SOURCE);
            if (this.missingNodesHelper.isMissingNode(qname.localname.value) || qname.namespaceURI != null && this.missingNodesHelper.isMissingNode(qname.namespaceURI)) {
                attrSymbol.origin = SymbolOrigin.VIRTUAL;
            }
            if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, attrSymbol)) {
                this.env.scope.define(attrSymbol.name, attrSymbol);
                bLangXMLAttribute.symbol = attrSymbol;
            }
            return;
        }
        List<BLangExpression> exprs = bLangXMLAttribute.value.textFragments;
        String nsURI = null;
        NodeKind nodeKind = exprs.get(0).getKind();
        if (exprs.size() == 1 && (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL)) {
            nsURI = (String)((BLangLiteral)exprs.get((int)0)).value;
        }
        if ((symbolName = qname.localname.value).equals("xmlns")) {
            symbolName = "";
        }
        if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, xmlnsSymbol = new BXMLNSSymbol(prefix = this.names.fromString(symbolName), nsURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner, qname.localname.pos, this.getOrigin(prefix)))) {
            this.env.scope.define(xmlnsSymbol.name, xmlnsSymbol);
            bLangXMLAttribute.symbol = xmlnsSymbol;
        }
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        this.defineRecordTypeNode(recordTypeNode, typeDefEnv);
    }

    private void defineRecordTypeNode(BLangRecordTypeNode recordTypeNode, SymbolEnv env) {
        BRecordType recordType = (BRecordType)recordTypeNode.symbol.type;
        recordTypeNode.type = recordType;
        this.resolveFields(recordType, recordTypeNode, env);
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticErrorCode.REST_FIELD_NOT_ALLOWED_IN_SEALED_RECORDS, new Object[0]);
            return;
        }
        ArrayList<BType> fieldTypes = new ArrayList<BType>(recordType.fields.size());
        for (BField field : recordType.fields.values()) {
            BType type = field.type;
            fieldTypes.add(type);
        }
        if (recordTypeNode.restFieldType == null) {
            this.symResolver.markParameterizedType((BType)recordType, fieldTypes);
            if (recordTypeNode.sealed) {
                recordType.restFieldType = this.symTable.noType;
                return;
            }
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, env);
        fieldTypes.add(recordType.restFieldType);
        this.symResolver.markParameterizedType((BType)recordType, fieldTypes);
    }

    private Collector<BField, ?, LinkedHashMap<String, BField>> getFieldCollector() {
        BinaryOperator mergeFunc = (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
        return Collectors.toMap(field -> field.name.value, Function.identity(), mergeFunc, LinkedHashMap::new);
    }

    private void populateLangLibInSymTable(BPackageSymbol packageSymbol) {
        PackageID langLib = packageSymbol.pkgID;
        if (langLib.equals(PackageID.ARRAY)) {
            this.symTable.langArrayModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.DECIMAL)) {
            this.symTable.langDecimalModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.ERROR)) {
            this.symTable.langErrorModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FLOAT)) {
            this.symTable.langFloatModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FUTURE)) {
            this.symTable.langFutureModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.INT)) {
            this.symTable.langIntModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.MAP)) {
            this.symTable.langMapModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.OBJECT)) {
            this.symTable.langObjectModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STREAM)) {
            this.symTable.langStreamModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STRING)) {
            this.symTable.langStringModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TABLE)) {
            this.symTable.langTableModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TYPEDESC)) {
            this.symTable.langTypedescModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.VALUE)) {
            this.symTable.langValueModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.XML)) {
            this.symTable.langXmlModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.BOOLEAN)) {
            this.symTable.langBooleanModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.QUERY)) {
            this.symTable.langQueryModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TRANSACTION)) {
            this.symTable.langTransactionModuleSymbol = packageSymbol;
            return;
        }
    }

    private boolean isValidAnnotationType(BType type) {
        if (type == this.symTable.semanticError) {
            return false;
        }
        switch (type.tag) {
            case 15: {
                BType constraintType = ((BMapType)type).constraint;
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(constraintType);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    if (this.isAnyDataOrReadOnlyTypeSkippingObjectType(field.type)) continue;
                    return false;
                }
                BType recordRestType = recordType.restFieldType;
                if (recordRestType == null || recordRestType == this.symTable.noType) {
                    return true;
                }
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(recordRestType);
            }
            case 19: {
                BType elementType = ((BArrayType)type).eType;
                if (elementType.tag == 15 || elementType.tag == 12) {
                    return this.isValidAnnotationType(elementType);
                }
                return false;
            }
        }
        return this.types.isAssignable(type, this.symTable.trueType);
    }

    private boolean isAnyDataOrReadOnlyTypeSkippingObjectType(BType type) {
        if (type == this.symTable.semanticError) {
            return false;
        }
        switch (type.tag) {
            case 33: {
                return true;
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    if (this.isAnyDataOrReadOnlyTypeSkippingObjectType(field.type)) continue;
                    return false;
                }
                BType recordRestType = recordType.restFieldType;
                if (recordRestType == null || recordRestType == this.symTable.noType) {
                    return true;
                }
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(recordRestType);
            }
            case 15: {
                BType constraintType = ((BMapType)type).constraint;
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(constraintType);
            }
            case 20: {
                for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                    if (this.isAnyDataOrReadOnlyTypeSkippingObjectType(memberType)) continue;
                    return false;
                }
                return true;
            }
            case 30: {
                BTupleType tupleType = (BTupleType)type;
                for (BType tupMemType : tupleType.getTupleTypes()) {
                    if (this.isAnyDataOrReadOnlyTypeSkippingObjectType(tupMemType)) continue;
                    return false;
                }
                BType tupRestType = tupleType.restType;
                if (tupRestType == null) {
                    return true;
                }
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(tupRestType);
            }
            case 9: {
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(((BTableType)type).constraint);
            }
            case 19: {
                return this.isAnyDataOrReadOnlyTypeSkippingObjectType(((BArrayType)type).getElementType());
            }
        }
        return this.types.isAssignable(type, this.symTable.anydataOrReadOnlyType);
    }

    private void populatePackageNode(BLangPackage pkgNode) {
        List<BLangCompilationUnit> compUnits = pkgNode.getCompilationUnits();
        compUnits.forEach(compUnit -> this.populateCompilationUnit(pkgNode, (BLangCompilationUnit)compUnit));
    }

    private void populateCompilationUnit(BLangPackage pkgNode, BLangCompilationUnit compUnit) {
        compUnit.getTopLevelNodes().forEach(node -> this.addTopLevelNode(pkgNode, (TopLevelNode)node));
    }

    private void addTopLevelNode(BLangPackage pkgNode, TopLevelNode node) {
        NodeKind kind = node.getKind();
        if (kind != NodeKind.PACKAGE_DECLARATION && kind != NodeKind.IMPORT) {
            pkgNode.topLevelNodes.add(node);
        }
        switch (kind) {
            case IMPORT: {
                pkgNode.imports.add((BLangImportPackage)node);
                break;
            }
            case FUNCTION: {
                pkgNode.functions.add((BLangFunction)node);
                break;
            }
            case TYPE_DEFINITION: {
                pkgNode.typeDefinitions.add((BLangTypeDefinition)node);
                break;
            }
            case SERVICE: {
                pkgNode.services.add((BLangService)node);
                break;
            }
            case VARIABLE: {
                pkgNode.globalVars.add((BLangSimpleVariable)node);
                break;
            }
            case ANNOTATION: {
                pkgNode.annotations.add((BLangAnnotation)node);
                break;
            }
            case XMLNS: {
                pkgNode.xmlnsList.add((BLangXMLNS)node);
                break;
            }
            case CONSTANT: {
                pkgNode.constants.add((BLangConstant)node);
                break;
            }
            case CLASS_DEFN: {
                pkgNode.classDefinitions.add((BLangClassDefinition)node);
            }
        }
    }

    private void defineErrorDetails(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            SymbolEnv typeDefEnv;
            BLangType typeNode = typeDef.typeNode;
            if (typeNode.getKind() == NodeKind.ERROR_TYPE) {
                BType detailType;
                typeDefEnv = SymbolEnv.createTypeEnv(typeNode, typeDef.symbol.scope, pkgEnv);
                BLangErrorType errorTypeNode = (BLangErrorType)typeNode;
                ((BErrorType)typeDef.symbol.type).detailType = detailType = Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.symResolver.resolveTypeNode((BLangType)bLangType, typeDefEnv)).orElse(this.symTable.detailType);
                continue;
            }
            if (typeNode.type == null || typeNode.type.tag != 28) continue;
            typeDefEnv = SymbolEnv.createTypeEnv(typeNode, typeDef.symbol.scope, pkgEnv);
            BType detailType = ((BErrorType)typeNode.type).detailType;
            if (detailType != this.symTable.noType) continue;
            BErrorType type = (BErrorType)this.symResolver.resolveTypeNode(typeNode, typeDefEnv);
            ((BErrorType)typeDef.symbol.type).detailType = type.detailType;
        }
    }

    private void defineFields(List<BLangNode> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangNode typeDef : typeDefNodes) {
            if (typeDef.getKind() == NodeKind.CLASS_DEFN) {
                this.defineFieldsOfClassDef((BLangClassDefinition)typeDef, pkgEnv);
                continue;
            }
            if (typeDef.getKind() != NodeKind.TYPE_DEFINITION) continue;
            this.defineFieldsOfObjectOrRecordTypeDef((BLangTypeDefinition)typeDef, pkgEnv);
        }
    }

    private void defineFieldsOfClassDef(BLangClassDefinition classDefinition, SymbolEnv env) {
        SymbolEnv typeDefEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, env);
        BObjectTypeSymbol tSymbol = (BObjectTypeSymbol)classDefinition.symbol;
        BObjectType objType = (BObjectType)tSymbol.type;
        for (BLangSimpleVariable field : classDefinition.fields) {
            this.defineNode(field, typeDefEnv);
            if (field.symbol.type == this.symTable.semanticError) continue;
            objType.fields.put(field.name.value, new BField(this.names.fromIdNode(field.name), field.pos, field.symbol));
        }
        this.defineReferencedClassFields(classDefinition, typeDefEnv, objType);
    }

    private void defineFieldsOfObjectOrRecordTypeDef(BLangTypeDefinition typeDef, SymbolEnv pkgEnv) {
        NodeKind nodeKind = typeDef.typeNode.getKind();
        if (nodeKind != NodeKind.OBJECT_TYPE && nodeKind != NodeKind.RECORD_TYPE) {
            return;
        }
        BStructureType structureType = (BStructureType)typeDef.symbol.type;
        BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDef.typeNode;
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(structureTypeNode, typeDef.symbol.scope, pkgEnv);
        this.resolveFields(structureType, structureTypeNode, typeDefEnv);
        if (typeDef.symbol.kind != SymbolKind.RECORD) {
            return;
        }
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)structureTypeNode;
        BRecordType recordType = (BRecordType)structureType;
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticErrorCode.REST_FIELD_NOT_ALLOWED_IN_SEALED_RECORDS, new Object[0]);
            return;
        }
        if (recordTypeNode.restFieldType == null) {
            if (recordTypeNode.sealed) {
                recordType.restFieldType = this.symTable.noType;
                return;
            }
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, typeDefEnv);
    }

    private void resolveFields(BStructureType structureType, BLangStructureTypeNode structureTypeNode, SymbolEnv typeDefEnv) {
        structureType.fields = structureTypeNode.fields.stream().peek(field -> this.defineNode((BLangNode)field, typeDefEnv)).filter(field -> field.symbol.type != this.symTable.semanticError).map(field -> new BField(this.names.fromIdNode(field.name), field.pos, field.symbol)).collect(this.getFieldCollector());
        ArrayList<BType> list = new ArrayList<BType>();
        for (BLangType tRef : structureTypeNode.typeRefs) {
            BType type = tRef.type;
            list.add(type);
        }
        structureType.typeInclusions = list;
        this.resolveReferencedFields(structureTypeNode, typeDefEnv);
        for (BLangSimpleVariable field2 : structureTypeNode.referencedFields) {
            this.defineNode(field2, typeDefEnv);
            if (field2.symbol.type == this.symTable.semanticError) continue;
            structureType.fields.put(field2.name.value, new BField(this.names.fromIdNode(field2.name), field2.pos, field2.symbol));
        }
    }

    private void updateServiceResourceFieldVisibilityRegion(BField value, boolean isService) {
        if (isService && value.symbol != null && Symbols.isResource(value.symbol)) {
            value.symbol.flags |= 1L;
        }
    }

    private void defineMembers(List<BLangNode> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangNode node : typeDefNodes) {
            if (node.getKind() == NodeKind.CLASS_DEFN) {
                this.defineMembersOfClassDef(pkgEnv, (BLangClassDefinition)node);
                continue;
            }
            if (node.getKind() != NodeKind.TYPE_DEFINITION) continue;
            this.defineMemberOfObjectTypeDef(pkgEnv, (BLangTypeDefinition)node);
        }
    }

    private void defineMemberOfObjectTypeDef(SymbolEnv pkgEnv, BLangTypeDefinition node) {
        BLangTypeDefinition typeDef = node;
        if (typeDef.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            BObjectType objectType = (BObjectType)typeDef.symbol.type;
            if (objectType.mutableType != null) {
                return;
            }
            BLangObjectTypeNode objTypeNode = (BLangObjectTypeNode)typeDef.typeNode;
            SymbolEnv objMethodsEnv = SymbolEnv.createObjectMethodsEnv(objTypeNode, (BObjectTypeSymbol)objTypeNode.symbol, pkgEnv);
            this.defineObjectInitFunction(objTypeNode, objMethodsEnv);
            objTypeNode.functions.forEach(f -> {
                f.flagSet.add(Flag.FINAL);
                f.setReceiver(ASTBuilderUtil.createReceiver(typeDef.pos, objectType));
                this.defineNode((BLangNode)f, objMethodsEnv);
            });
            HashSet<String> includedFunctionNames = new HashSet<String>();
            for (BLangType typeRef : objTypeNode.typeRefs) {
                if (typeRef.type.tsymbol == null || typeRef.type.tsymbol.kind != SymbolKind.OBJECT) continue;
                List functions = ((BObjectTypeSymbol)typeRef.type.tsymbol).attachedFuncs;
                for (BAttachedFunction function : functions) {
                    this.defineReferencedFunction(typeDef.pos, typeDef.flagSet, objMethodsEnv, typeRef, function, includedFunctionNames, typeDef.symbol, ((BLangObjectTypeNode)typeDef.typeNode).functions, node.internal);
                }
            }
        }
    }

    private void validateReadOnlyIntersectionTypeDefinitions(List<BLangTypeDefinition> typeDefNodes) {
        HashSet<BType> loggedTypes = new HashSet<BType>();
        for (BLangTypeDefinition typeDefNode : typeDefNodes) {
            BStructureType immutableType;
            BStructureType mutableType;
            BStructureType currentType;
            BLangType typeNode = typeDefNode.typeNode;
            NodeKind kind = typeNode.getKind();
            if (kind == NodeKind.INTERSECTION_TYPE_NODE) {
                BType currentType2 = typeNode.type;
                if (currentType2.tag != 21) continue;
                BIntersectionType intersectionType = (BIntersectionType)currentType2;
                BType effectiveType = intersectionType.effectiveType;
                if (!loggedTypes.add(effectiveType)) continue;
                boolean hasNonReadOnlyElement = false;
                for (BType constituentType : intersectionType.getConstituentTypes()) {
                    if (constituentType == this.symTable.readonlyType || this.types.isSelectivelyImmutableType(constituentType, true, true)) continue;
                    hasNonReadOnlyElement = true;
                    break;
                }
                if (!hasNonReadOnlyElement) continue;
                this.dlog.error(typeDefNode.typeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, typeNode);
                typeNode.type = this.symTable.semanticError;
                continue;
            }
            if (kind == NodeKind.OBJECT_TYPE) {
                currentType = (BObjectType)typeNode.type;
                mutableType = currentType.mutableType;
                if (mutableType == null) continue;
                immutableType = currentType;
            } else {
                if (kind != NodeKind.RECORD_TYPE) continue;
                currentType = (BRecordType)typeNode.type;
                mutableType = ((BRecordType)currentType).mutableType;
                if (mutableType == null) continue;
                immutableType = currentType;
            }
            if (!loggedTypes.add(immutableType) || this.types.isSelectivelyImmutableType((BType)mutableType, false, true)) continue;
            this.dlog.error(typeDefNode.typeNode.pos, DiagnosticErrorCode.INVALID_INTERSECTION_TYPE, immutableType);
            typeNode.type = this.symTable.semanticError;
        }
    }

    private void defineUndefinedReadOnlyTypes(List<BLangTypeDefinition> typeDefNodes, List<BLangNode> typDefs, SymbolEnv pkgEnv) {
        this.populateImmutableTypeFieldsAndMembers(typeDefNodes, pkgEnv);
        this.validateFieldsAndSetReadOnlyType(typDefs, pkgEnv);
    }

    private void populateImmutableTypeFieldsAndMembers(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        int size = typeDefNodes.size();
        for (int i = 0; i < size; ++i) {
            BLangTypeDefinition typeDef = typeDefNodes.get(i);
            NodeKind nodeKind = typeDef.typeNode.getKind();
            if (nodeKind == NodeKind.OBJECT_TYPE ? ((BObjectType)typeDef.symbol.type).mutableType == null : nodeKind != NodeKind.RECORD_TYPE || ((BRecordType)typeDef.symbol.type).mutableType == null) continue;
            SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(typeDef.typeNode, typeDef.symbol.scope, pkgEnv);
            ImmutableTypeCloner.defineUndefinedImmutableFields(typeDef, this.types, typeDefEnv, this.symTable, this.anonymousModelHelper, this.names);
            if (nodeKind != NodeKind.OBJECT_TYPE) continue;
            BObjectType immutableObjectType = (BObjectType)typeDef.symbol.type;
            BObjectType mutableObjectType = immutableObjectType.mutableType;
            ImmutableTypeCloner.defineObjectFunctions((BObjectTypeSymbol)immutableObjectType.tsymbol, (BObjectTypeSymbol)mutableObjectType.tsymbol, this.names, this.symTable);
        }
    }

    private void validateFieldsAndSetReadOnlyType(List<BLangNode> typeDefNodes, SymbolEnv pkgEnv) {
        int origSize = typeDefNodes.size();
        for (int i = 0; i < origSize; ++i) {
            BLangNode typeDefOrClass = typeDefNodes.get(i);
            if (typeDefOrClass.getKind() == NodeKind.CLASS_DEFN) {
                this.setReadOnlynessOfClassDef((BLangClassDefinition)typeDefOrClass, pkgEnv);
                continue;
            }
            if (typeDefOrClass.getKind() != NodeKind.TYPE_DEFINITION) continue;
            BLangTypeDefinition typeDef = (BLangTypeDefinition)typeDefOrClass;
            BLangType typeNode = typeDef.typeNode;
            NodeKind nodeKind = typeNode.getKind();
            if (nodeKind != NodeKind.OBJECT_TYPE && nodeKind != NodeKind.RECORD_TYPE) continue;
            BTypeSymbol symbol = typeDef.symbol;
            BStructureType structureType = (BStructureType)symbol.type;
            if (Symbols.isFlagOn(structureType.flags, 32L)) {
                if (structureType.tag != 33) continue;
                BObjectType objectType = (BObjectType)structureType;
                if (objectType.mutableType != null) continue;
                Location pos = typeDef.pos;
                if (!this.types.isSelectivelyImmutableType(objectType, new HashSet<BType>())) {
                    this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_TYPE, objectType);
                    return;
                }
                SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(typeNode, symbol.scope, pkgEnv);
                for (BField field : objectType.fields.values()) {
                    BType type = field.type;
                    HashSet<Flag> flagSet = typeNode.getKind() == NodeKind.OBJECT_TYPE ? ((BLangObjectTypeNode)typeNode).flagSet : (typeNode.getKind() == NodeKind.USER_DEFINED_TYPE ? ((BLangUserDefinedType)typeNode).flagSet : new HashSet<Flag>());
                    if (!this.types.isInherentlyImmutableType(type)) {
                        field.type = field.symbol.type = ImmutableTypeCloner.getImmutableIntersectionType(pos, this.types, (SelectivelyImmutableReferenceType)((Object)type), typeDefEnv, this.symTable, this.anonymousModelHelper, this.names, flagSet);
                    }
                    field.symbol.flags |= 0x20L;
                }
                continue;
            }
            if (nodeKind != NodeKind.RECORD_TYPE || !((BRecordType)structureType).sealed) continue;
            boolean allImmutableFields = true;
            Collection<BField> fields = structureType.fields.values();
            if (fields.isEmpty()) continue;
            for (BField field : fields) {
                if (Symbols.isFlagOn(field.symbol.flags, 32L)) continue;
                allImmutableFields = false;
                break;
            }
            if (!allImmutableFields) continue;
            structureType.tsymbol.flags |= 0x20L;
            structureType.flags |= 0x20L;
        }
    }

    private void setReadOnlynessOfClassDef(BLangClassDefinition classDef, SymbolEnv pkgEnv) {
        BObjectType objectType = (BObjectType)classDef.type;
        Location pos = classDef.pos;
        if (Symbols.isFlagOn(classDef.type.flags, 32L)) {
            if (!this.types.isSelectivelyImmutableType(objectType, new HashSet<BType>())) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_READONLY_OBJECT_TYPE, objectType);
                return;
            }
            ImmutableTypeCloner.markFieldsAsImmutable(classDef, pkgEnv, objectType, this.types, this.anonymousModelHelper, this.symTable, this.names, pos);
        } else {
            Collection fields = objectType.fields.values();
            if (fields.isEmpty()) {
                return;
            }
            for (BField field : fields) {
                if (Symbols.isFlagOn(field.symbol.flags, 4L) && Symbols.isFlagOn(field.type.flags, 32L)) continue;
                return;
            }
            classDef.type.tsymbol.flags |= 0x20L;
            classDef.type.flags |= 0x20L;
        }
    }

    private void defineInvokableSymbol(BLangInvokableNode invokableNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv) {
        invokableNode.symbol = funcSymbol;
        this.defineSymbol(invokableNode.name.pos, funcSymbol);
        invokableEnv.scope = funcSymbol.scope;
        this.defineInvokableSymbolParams(invokableNode, funcSymbol, invokableEnv);
        if (Symbols.isFlagOn(funcSymbol.type.tsymbol.flags, 0x20000000L)) {
            funcSymbol.type.flags |= 0x20000000L;
        }
    }

    private void defineInvokableSymbolParams(BLangInvokableNode invokableNode, BInvokableSymbol invokableSymbol, SymbolEnv invokableEnv) {
        boolean foundDefaultableParam = false;
        ArrayList<BVarSymbol> paramSymbols = new ArrayList<BVarSymbol>();
        HashSet<String> requiredParamNames = new HashSet<String>();
        invokableNode.clonedEnv = invokableEnv.shallowClone();
        for (BLangSimpleVariable varNode : invokableNode.requiredParams) {
            this.defineNode(varNode, invokableEnv);
            if (varNode.expr != null) {
                foundDefaultableParam = true;
            }
            if (varNode.expr == null && foundDefaultableParam) {
                this.dlog.error(varNode.pos, DiagnosticErrorCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
            }
            BVarSymbol symbol = varNode.symbol;
            if (varNode.expr != null) {
                symbol.flags |= 0x1000L;
                symbol.defaultableParam = true;
            }
            if (varNode.flagSet.contains((Object)Flag.INCLUDED)) {
                if (varNode.type.getKind() == TypeKind.RECORD) {
                    symbol.flags |= 0x400000000L;
                    LinkedHashMap fields = ((BRecordType)varNode.type).fields;
                    for (String fieldName : fields.keySet()) {
                        BField field = (BField)fields.get(fieldName);
                        if (field.symbol.type.tag == 49 || requiredParamNames.add(fieldName)) continue;
                        this.dlog.error(varNode.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, fieldName);
                    }
                } else {
                    this.dlog.error(varNode.typeNode.pos, DiagnosticErrorCode.EXPECTED_RECORD_TYPE_AS_INCLUDED_PARAMETER, new Object[0]);
                }
            } else {
                requiredParamNames.add(symbol.name.value);
            }
            paramSymbols.add(symbol);
        }
        if (!invokableNode.desugaredReturnType) {
            this.symResolver.resolveTypeNode(invokableNode.returnTypeNode, invokableEnv);
        }
        invokableSymbol.params = paramSymbols;
        invokableSymbol.retType = invokableNode.returnTypeNode.type;
        List<BType> paramTypes = paramSymbols.stream().map(paramSym -> paramSym.type).collect(Collectors.toList());
        BInvokableTypeSymbol functionTypeSymbol = Symbols.createInvokableTypeSymbol(67108892, invokableSymbol.flags, this.env.enclPkg.symbol.pkgID, invokableSymbol.type, this.env.scope.owner, invokableNode.pos, SymbolOrigin.SOURCE);
        functionTypeSymbol.params = invokableSymbol.params;
        functionTypeSymbol.returnType = invokableSymbol.retType;
        BType restType = null;
        if (invokableNode.restParam != null) {
            this.defineNode(invokableNode.restParam, invokableEnv);
            functionTypeSymbol.restParam = invokableSymbol.restParam = invokableNode.restParam.symbol;
            restType = invokableSymbol.restParam.type;
        }
        invokableSymbol.type = new BInvokableType(paramTypes, restType, invokableNode.returnTypeNode.type, null);
        invokableSymbol.type.tsymbol = functionTypeSymbol;
    }

    private void defineSymbol(Location pos, BSymbol symbol) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
    }

    public void defineSymbol(Location pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, env, symbol)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineShadowedSymbol(Location pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbolInCurrentScope(pos, env, symbol, symbol.tag)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineTypeNarrowedSymbol(Location location, SymbolEnv targetEnv, BVarSymbol symbol, BType type, boolean isInternal) {
        if (symbol.owner.tag == 4097) {
            return;
        }
        BVarSymbol varSymbol = this.createVarSymbol(symbol.flags, type, symbol.name, targetEnv, symbol.pos, isInternal);
        if (type.tag == 16 && type.tsymbol != null) {
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)type.tsymbol;
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)varSymbol;
            invokableSymbol.params = tsymbol.params;
            invokableSymbol.restParam = tsymbol.restParam;
            invokableSymbol.retType = tsymbol.returnType;
            invokableSymbol.flags = tsymbol.flags;
        }
        varSymbol.owner = symbol.owner;
        varSymbol.originalSymbol = symbol;
        this.defineShadowedSymbol(location, varSymbol, targetEnv);
    }

    private void defineSymbolWithCurrentEnvOwner(Location pos, BSymbol symbol) {
        symbol.scope = new Scope(this.env.scope.owner);
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
    }

    public BVarSymbol defineVarSymbol(Location pos, Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env, boolean isInternal) {
        Scope enclScope = env.scope;
        BVarSymbol varSymbol = this.createVarSymbol(flagSet, varType, varName, env, pos, isInternal);
        if (!this.symResolver.checkForUniqueSymbol(pos, env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
        }
        enclScope.define(varSymbol.name, varSymbol);
        return varSymbol;
    }

    public void defineExistingVarSymbolInEnv(BVarSymbol varSymbol, SymbolEnv env) {
        if (!this.symResolver.checkForUniqueSymbol(env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
        }
        env.scope.define(varSymbol.name, varSymbol);
    }

    public BVarSymbol createVarSymbol(Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env, Location pos, boolean isInternal) {
        return this.createVarSymbol(Flags.asMask(flagSet), varType, varName, env, pos, isInternal);
    }

    public BVarSymbol createVarSymbol(long flags, BType varType, Name varName, SymbolEnv env, Location location, boolean isInternal) {
        BVarSymbol varSymbol;
        BType safeType = this.types.getSafeType(varType, true, false);
        if (safeType.tag == 16) {
            varSymbol = new BInvokableSymbol(52, flags, varName, env.enclPkg.symbol.pkgID, varType, env.scope.owner, location, isInternal ? SymbolOrigin.VIRTUAL : this.getOrigin(varName));
            varSymbol.kind = SymbolKind.FUNCTION;
        } else {
            varSymbol = new BVarSymbol(flags, varName, env.enclPkg.symbol.pkgID, varType, env.scope.owner, location, isInternal ? SymbolOrigin.VIRTUAL : this.getOrigin(varName));
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 65536L)) {
                varSymbol.tag = 32820;
            }
        }
        return varSymbol;
    }

    private void defineObjectInitFunction(BLangObjectTypeNode object, SymbolEnv conEnv) {
        BLangFunction initFunction = object.initFunction;
        if (initFunction == null) {
            return;
        }
        initFunction.receiver = ASTBuilderUtil.createReceiver(object.pos, object.type);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        this.defineNode(initFunction, conEnv);
    }

    private void defineClassInitFunction(BLangClassDefinition classDefinition, SymbolEnv conEnv) {
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction == null) {
            return;
        }
        initFunction.receiver = ASTBuilderUtil.createReceiver(classDefinition.pos, classDefinition.type);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        this.defineNode(initFunction, conEnv);
    }

    private void defineAttachedFunctions(BLangFunction funcNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv, boolean isValidAttachedFunc) {
        BTypeSymbol typeSymbol = funcNode.receiver.type.tsymbol;
        if (isValidAttachedFunc) {
            if (typeSymbol.tag == 196700) {
                this.validateFunctionsAttachedToObject(funcNode, funcSymbol);
            } else if (typeSymbol.tag == 327772) {
                this.validateFunctionsAttachedToRecords(funcNode, funcSymbol);
            }
        }
        this.defineNode(funcNode.receiver, invokableEnv);
        funcSymbol.receiverSymbol = funcNode.receiver.symbol;
    }

    private void validateFunctionsAttachedToRecords(BLangFunction funcNode, BInvokableSymbol funcSymbol) {
        BInvokableType funcType = (BInvokableType)funcSymbol.type;
        BRecordTypeSymbol recordSymbol = (BRecordTypeSymbol)funcNode.receiver.type.tsymbol;
        recordSymbol.initializerFunc = new BAttachedFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType, funcNode.pos);
    }

    private void validateFunctionsAttachedToObject(BLangFunction funcNode, BInvokableSymbol funcSymbol) {
        BInvokableType funcType = (BInvokableType)funcSymbol.type;
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)funcNode.receiver.type.tsymbol;
        BAttachedFunction attachedFunc = funcNode.getKind() == NodeKind.RESOURCE_FUNC ? this.createResourceFunction(funcNode, funcSymbol, funcType) : new BAttachedFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType, funcNode.pos);
        this.validateRemoteFunctionAttachedToObject(funcNode, objectSymbol);
        this.validateResourceFunctionAttachedToObject(funcNode, objectSymbol);
        if (!funcNode.objInitFunction) {
            objectSymbol.attachedFuncs.add(attachedFunc);
            return;
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticErrorCode.INVALID_OBJECT_CONSTRUCTOR);
        objectSymbol.initializerFunc = attachedFunc;
    }

    private BAttachedFunction createResourceFunction(BLangFunction funcNode, BInvokableSymbol funcSymbol, BInvokableType funcType) {
        BLangResourceFunction resourceFunction = (BLangResourceFunction)funcNode;
        Name accessor = this.names.fromIdNode(resourceFunction.accessorName);
        List<Name> resourcePath = resourceFunction.resourcePath.stream().map(this.names::fromIdNode).collect(Collectors.toList());
        List<BVarSymbol> pathParamSymbols = resourceFunction.pathParams.stream().map(p -> p.symbol).collect(Collectors.toList());
        BVarSymbol restPathParamSym = resourceFunction.restPathParam != null ? resourceFunction.restPathParam.symbol : null;
        return new BResourceFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType, resourcePath, accessor, pathParamSymbols, restPathParamSym, funcNode.pos);
    }

    private void validateRemoteFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 32768L)) {
            return;
        }
        funcNode.symbol.flags |= 0x8000L;
        funcNode.symbol.flags |= 1L;
        if (!this.isNetworkQualified(objectSymbol)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.REMOTE_FUNCTION_IN_NON_NETWORK_OBJECT, new Object[0]);
        }
    }

    private boolean isNetworkQualified(BObjectTypeSymbol objectSymbol) {
        return Symbols.isFlagOn(objectSymbol.flags, 65536L) || Symbols.isFlagOn(objectSymbol.flags, 262144L);
    }

    private void validateResourceFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 131072L)) {
            return;
        }
        funcNode.symbol.flags |= 0x20000L;
        if (!Symbols.isFlagOn(objectSymbol.flags, 262144L)) {
            this.dlog.error(funcNode.pos, DiagnosticErrorCode.RESOURCE_FUNCTION_IN_NON_SERVICE_OBJECT, new Object[0]);
        }
    }

    private StatementNode createAssignmentStmt(BLangSimpleVariable variable, BVarSymbol varSym, BSymbol fieldVar) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = variable.pos;
        varRef.variableName = (BLangIdentifier)this.createIdentifier(fieldVar.name.getValue());
        varRef.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        varRef.symbol = fieldVar;
        varRef.type = fieldVar.type;
        BLangSimpleVarRef exprVar = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        exprVar.pos = variable.pos;
        exprVar.variableName = (BLangIdentifier)this.createIdentifier(varSym.name.getValue());
        exprVar.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        exprVar.symbol = varSym;
        exprVar.type = varSym.type;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = exprVar;
        assignmentStmt.pos = variable.pos;
        assignmentStmt.setVariable(varRef);
        return assignmentStmt;
    }

    private IdentifierNode createIdentifier(String value) {
        IdentifierNode node = TreeBuilder.createIdentifierNode();
        if (value != null) {
            node.setValue(value);
        }
        return node;
    }

    private boolean validateFuncReceiver(BLangFunction funcNode) {
        if (funcNode.receiver == null) {
            return true;
        }
        if (funcNode.receiver.type == null) {
            funcNode.receiver.type = this.symResolver.resolveTypeNode(funcNode.receiver.typeNode, this.env);
        }
        if (funcNode.receiver.type.tag == 27) {
            return true;
        }
        if (funcNode.receiver.type.tag == 33 && !this.env.enclPkg.symbol.pkgID.equals(funcNode.receiver.type.tsymbol.pkgID)) {
            this.dlog.error(funcNode.receiver.pos, DiagnosticErrorCode.FUNC_DEFINED_ON_NON_LOCAL_TYPE, funcNode.name.value, funcNode.receiver.type.toString());
            return false;
        }
        return true;
    }

    private Name getFuncSymbolName(BLangFunction funcNode) {
        if (funcNode.receiver != null) {
            return this.names.fromString(Symbols.getAttachedFuncSymbolName(funcNode.receiver.type.tsymbol.name.value, funcNode.name.value));
        }
        return this.names.fromIdNode(funcNode.name);
    }

    private Name getFieldSymbolName(BLangSimpleVariable receiver, BLangSimpleVariable variable) {
        return this.names.fromString(Symbols.getAttachedFuncSymbolName(receiver.type.tsymbol.name.value, variable.name.value));
    }

    private MarkdownDocAttachment getMarkdownDocAttachment(BLangMarkdownDocumentation docNode) {
        if (docNode == null) {
            return new MarkdownDocAttachment();
        }
        MarkdownDocAttachment docAttachment = new MarkdownDocAttachment();
        docAttachment.description = docNode.getDocumentation();
        docNode.getParameters().forEach(p -> docAttachment.parameters.add(new MarkdownDocAttachment.Parameter(p.parameterName.value, p.getParameterDocumentation())));
        docAttachment.returnValueDescription = docNode.getReturnParameterDocumentation();
        return docAttachment;
    }

    private void resolveReferencedFields(BLangStructureTypeNode structureTypeNode, SymbolEnv typeDefEnv) {
        HashSet referencedTypes = new HashSet();
        ArrayList invalidTypeRefs = new ArrayList();
        HashMap<String, BLangSimpleVariable> fieldNames = new HashMap<String, BLangSimpleVariable>();
        for (BLangSimpleVariable fieldVariable : structureTypeNode.fields) {
            fieldNames.put(fieldVariable.name.value, fieldVariable);
        }
        structureTypeNode.referencedFields = structureTypeNode.typeRefs.stream().flatMap(typeRef -> {
            BType referredType = this.symResolver.resolveTypeNode((BLangType)typeRef, typeDefEnv);
            if (referredType == this.symTable.semanticError) {
                return Stream.empty();
            }
            if (!referencedTypes.add(referredType.tsymbol)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_TYPE_REFERENCE, typeRef);
                return Stream.empty();
            }
            if (structureTypeNode.type.tag == 33) {
                if (referredType.tag != 33) {
                    this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE, typeRef);
                    invalidTypeRefs.add(typeRef);
                    return Stream.empty();
                }
                BObjectType objectType = (BObjectType)referredType;
                if (structureTypeNode.type.tsymbol.owner != referredType.tsymbol.owner) {
                    for (BField field2 : objectType.fields.values()) {
                        if (Symbols.isPublic(field2.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                    for (BAttachedFunction func : ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs) {
                        if (Symbols.isPublic(func.symbol)) continue;
                        this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                        invalidTypeRefs.add(typeRef);
                        return Stream.empty();
                    }
                }
            }
            if (structureTypeNode.type.tag == 12 && referredType.tag != 12) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.INCOMPATIBLE_RECORD_TYPE_REFERENCE, typeRef);
                invalidTypeRefs.add(typeRef);
                return Stream.empty();
            }
            return ((BStructureType)referredType).fields.values().stream().filter(f -> {
                if (fieldNames.containsKey(f.name.value)) {
                    BLangSimpleVariable existingVariable = (BLangSimpleVariable)fieldNames.get(f.name.value);
                    return !this.types.isAssignable(existingVariable.type, f.type);
                }
                return true;
            }).map(field -> {
                BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.type);
                var.flagSet = field.symbol.getFlags();
                return var;
            });
        }).collect(Collectors.toList());
        structureTypeNode.typeRefs.removeAll(invalidTypeRefs);
    }

    private void defineReferencedFunction(Location location, Set<Flag> flagSet, SymbolEnv objEnv, BLangType typeRef, BAttachedFunction referencedFunc, Set<String> includedFunctionNames, BTypeSymbol typeDefSymbol, List<BLangFunction> declaredFunctions, boolean isInternal) {
        BAttachedFunction attachedFunc;
        String referencedFuncName = referencedFunc.funcName.value;
        Name funcName = this.names.fromString(Symbols.getAttachedFuncSymbolName(typeDefSymbol.name.value, referencedFuncName));
        BSymbol matchingObjFuncSym = this.symResolver.lookupSymbolInMainSpace(objEnv, funcName);
        if (matchingObjFuncSym != this.symTable.notFoundSymbol) {
            Location methodPos;
            BLangFunction matchingFunc;
            if (!includedFunctionNames.add(referencedFuncName)) {
                this.dlog.error(typeRef.pos, DiagnosticErrorCode.REDECLARED_SYMBOL, referencedFuncName);
                return;
            }
            if (Symbols.isFunctionDeclaration(matchingObjFuncSym) && Symbols.isFunctionDeclaration(referencedFunc.symbol)) {
                matchingFunc = this.findFunctionBySymbol(declaredFunctions, matchingObjFuncSym);
                methodPos = matchingFunc != null ? matchingFunc.pos : typeRef.pos;
                this.dlog.error(methodPos, DiagnosticErrorCode.REDECLARED_FUNCTION_FROM_TYPE_REFERENCE, referencedFunc.funcName, typeRef);
            }
            if (!this.hasSameFunctionSignature((BInvokableSymbol)matchingObjFuncSym, referencedFunc.symbol)) {
                matchingFunc = this.findFunctionBySymbol(declaredFunctions, matchingObjFuncSym);
                methodPos = matchingFunc != null ? matchingFunc.pos : typeRef.pos;
                this.dlog.error(methodPos, DiagnosticErrorCode.REFERRED_FUNCTION_SIGNATURE_MISMATCH, this.getCompleteFunctionSignature(referencedFunc.symbol), this.getCompleteFunctionSignature((BInvokableSymbol)matchingObjFuncSym));
            }
            return;
        }
        if (Symbols.isPrivate(referencedFunc.symbol)) {
            return;
        }
        BInvokableSymbol funcSymbol = ASTBuilderUtil.duplicateFunctionDeclarationSymbol(referencedFunc.symbol, typeDefSymbol, funcName, typeDefSymbol.pkgID, typeRef.pos, this.getOrigin(funcName));
        this.defineSymbol(typeRef.pos, funcSymbol, objEnv);
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(null, funcSymbol.scope, objEnv);
        funcSymbol.params.forEach(param -> this.defineSymbol(typeRef.pos, (BSymbol)param, funcEnv));
        if (funcSymbol.restParam != null) {
            this.defineSymbol(typeRef.pos, funcSymbol.restParam, funcEnv);
        }
        funcSymbol.receiverSymbol = this.defineVarSymbol(location, flagSet, typeDefSymbol.type, Names.SELF, funcEnv, isInternal);
        if (referencedFunc instanceof BResourceFunction) {
            BResourceFunction resourceFunction = (BResourceFunction)referencedFunc;
            attachedFunc = new BResourceFunction(referencedFunc.funcName, funcSymbol, (BInvokableType)funcSymbol.type, resourceFunction.resourcePath, resourceFunction.accessor, resourceFunction.pathParams, resourceFunction.restPathParam, referencedFunc.pos);
        } else {
            attachedFunc = new BAttachedFunction(referencedFunc.funcName, funcSymbol, (BInvokableType)funcSymbol.type, referencedFunc.pos);
        }
        ((BObjectTypeSymbol)typeDefSymbol).attachedFuncs.add(attachedFunc);
        ((BObjectTypeSymbol)typeDefSymbol).referencedFunctions.add(attachedFunc);
    }

    private BLangFunction findFunctionBySymbol(List<BLangFunction> declaredFunctions, BSymbol symbol) {
        for (BLangFunction fn : declaredFunctions) {
            if (fn.symbol != symbol) continue;
            return fn;
        }
        return null;
    }

    private boolean hasSameFunctionSignature(BInvokableSymbol attachedFuncSym, BInvokableSymbol referencedFuncSym) {
        if (!this.hasSameVisibilityModifier(referencedFuncSym.flags, attachedFuncSym.flags)) {
            return false;
        }
        if (!this.types.isAssignable(attachedFuncSym.type, referencedFuncSym.type)) {
            return false;
        }
        List<BVarSymbol> params = referencedFuncSym.params;
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol referencedFuncParam = params.get(i);
            BVarSymbol attachedFuncParam = attachedFuncSym.params.get(i);
            if (referencedFuncParam.name.value.equals(attachedFuncParam.name.value) && this.hasSameVisibilityModifier(referencedFuncParam.flags, attachedFuncParam.flags)) continue;
            return false;
        }
        if (referencedFuncSym.restParam != null && attachedFuncSym.restParam != null) {
            return referencedFuncSym.restParam.name.value.equals(attachedFuncSym.restParam.name.value);
        }
        return referencedFuncSym.restParam == null && attachedFuncSym.restParam == null;
    }

    private boolean hasSameVisibilityModifier(long flags1, long flags2) {
        long xorOfFlags = flags1 ^ flags2;
        return (xorOfFlags & 1L) != 1L && (xorOfFlags & 0x400L) != 1024L;
    }

    private String getCompleteFunctionSignature(BInvokableSymbol funcSymbol) {
        StringBuilder signatureBuilder = new StringBuilder();
        StringJoiner paramListBuilder = new StringJoiner(", ", "(", ")");
        String visibilityModifier = "";
        if (Symbols.isPublic(funcSymbol)) {
            visibilityModifier = "public ";
        } else if (Symbols.isPrivate(funcSymbol)) {
            visibilityModifier = "private ";
        }
        signatureBuilder.append(visibilityModifier).append("function ").append(funcSymbol.name.value.split("\\.")[1]);
        funcSymbol.params.forEach(param -> paramListBuilder.add((Symbols.isPublic(param) ? "public " : "") + param.type.toString() + " " + param.name.value));
        if (funcSymbol.restParam != null) {
            paramListBuilder.add(((BArrayType)funcSymbol.restParam.type).eType.toString() + "... " + funcSymbol.restParam.name.value);
        }
        signatureBuilder.append(paramListBuilder.toString());
        if (funcSymbol.retType != this.symTable.nilType) {
            signatureBuilder.append(" returns ").append(funcSymbol.retType.toString());
        }
        return signatureBuilder.toString();
    }

    private BPackageSymbol dupPackageSymbolAndSetCompUnit(BPackageSymbol originalSymbol, Name compUnit) {
        BPackageSymbol copy = new BPackageSymbol(originalSymbol.pkgID, originalSymbol.owner, originalSymbol.flags, originalSymbol.pos, originalSymbol.origin);
        copy.initFunctionSymbol = originalSymbol.initFunctionSymbol;
        copy.startFunctionSymbol = originalSymbol.startFunctionSymbol;
        copy.stopFunctionSymbol = originalSymbol.stopFunctionSymbol;
        copy.testInitFunctionSymbol = originalSymbol.testInitFunctionSymbol;
        copy.testStartFunctionSymbol = originalSymbol.testStartFunctionSymbol;
        copy.testStopFunctionSymbol = originalSymbol.testStopFunctionSymbol;
        copy.packageFile = originalSymbol.packageFile;
        copy.compiledPackage = originalSymbol.compiledPackage;
        copy.entryPointExists = originalSymbol.entryPointExists;
        copy.scope = originalSymbol.scope;
        copy.owner = originalSymbol.owner;
        copy.compUnit = compUnit;
        return copy;
    }

    private boolean isSameImport(BLangImportPackage importPkgNode, BPackageSymbol importSymbol) {
        if (!importPkgNode.orgName.value.equals(importSymbol.pkgID.orgName.value)) {
            return false;
        }
        BLangIdentifier pkgName = importPkgNode.pkgNameComps.get(importPkgNode.pkgNameComps.size() - 1);
        return pkgName.value.equals(importSymbol.pkgID.name.value);
    }

    private void resolveAndSetFunctionTypeFromRHSLambda(BLangSimpleVariable variable, SymbolEnv env) {
        BLangFunction function = ((BLangLambdaFunction)variable.expr).function;
        BInvokableType invokableType = (BInvokableType)this.symResolver.createInvokableType(function.getParameters(), function.restParam, function.returnTypeNode, Flags.asMask(variable.flagSet), env, function.pos);
        if (function.flagSet.contains((Object)Flag.ISOLATED)) {
            invokableType.flags |= 0x20000000L;
            invokableType.tsymbol.flags |= 0x20000000L;
        }
        variable.type = invokableType;
    }

    private SymbolOrigin getOrigin(Name name, Set<Flag> flags) {
        if (flags.contains((Object)Flag.ANONYMOUS) && flags.contains((Object)Flag.SERVICE) || this.missingNodesHelper.isMissingNode(name)) {
            return SymbolOrigin.VIRTUAL;
        }
        return SymbolOrigin.SOURCE;
    }

    private SymbolOrigin getOrigin(Name name) {
        return this.getOrigin(name.value);
    }

    private SymbolOrigin getOrigin(String name) {
        if (this.missingNodesHelper.isMissingNode(name)) {
            return SymbolOrigin.VIRTUAL;
        }
        return SymbolOrigin.SOURCE;
    }

    class LocationData {
        private String name;
        private int row;
        private int column;

        LocationData(String name, int row, int column) {
            this.name = name;
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationData that = (LocationData)o;
            return this.row == that.row && this.column == that.column && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.row, this.column);
        }
    }

    public static class ImportResolveHolder {
        public BLangImportPackage resolved;
        public List<BLangImportPackage> unresolved;

        public ImportResolveHolder() {
            this.unresolved = new ArrayList<BLangImportPackage>();
        }

        public ImportResolveHolder(BLangImportPackage resolved) {
            this.resolved = resolved;
            this.unresolved = new ArrayList<BLangImportPackage>();
        }
    }
}

