/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.model.Name;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class TypeParamAnalyzer {
    private static final CompilerContext.Key<TypeParamAnalyzer> TYPE_PARAM_ANALYZER_KEY = new CompilerContext.Key();
    private SymbolTable symTable;
    private Types types;
    private Names names;
    private BLangDiagnosticLog dlog;

    public static TypeParamAnalyzer getInstance(CompilerContext context) {
        TypeParamAnalyzer types = context.get(TYPE_PARAM_ANALYZER_KEY);
        if (types == null) {
            types = new TypeParamAnalyzer(context);
        }
        return types;
    }

    private TypeParamAnalyzer(CompilerContext context) {
        context.put(TYPE_PARAM_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    static boolean isTypeParam(BType expType) {
        return Symbols.isFlagOn(expType.flags, 0x200000L) || expType.tsymbol != null && Symbols.isFlagOn(expType.tsymbol.flags, 0x200000L);
    }

    public static boolean containsTypeParam(BType type) {
        return TypeParamAnalyzer.containsTypeParam(type, new HashSet<BType>());
    }

    void checkForTypeParamsInArg(Location loc, BType actualType, SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env)) {
            return;
        }
        FindTypeParamResult findTypeParamResult = new FindTypeParamResult();
        this.findTypeParam(loc, expType, actualType, env, new HashSet<BType>(), findTypeParamResult);
    }

    boolean notRequireTypeParams(SymbolEnv env) {
        return env.typeParamsEntries == null;
    }

    BType getReturnTypeParams(SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env) || env.typeParamsEntries.isEmpty()) {
            return expType;
        }
        return this.getMatchingBoundType(expType, env);
    }

    public BType getNominalType(BType type, Name name, long flag) {
        if (name == Names.EMPTY) {
            return type;
        }
        return this.createBuiltInType(type, name, flag);
    }

    BType createTypeParam(BType type, Name name) {
        long flag = type.flags | 0x200000L;
        return this.createBuiltInType(type, name, flag);
    }

    BType getMatchingBoundType(BType expType, SymbolEnv env) {
        return this.getMatchingBoundType(expType, env, new HashSet<BType>());
    }

    private static boolean containsTypeParam(BType type, HashSet<BType> resolvedTypes) {
        if (TypeParamAnalyzer.isTypeParam(type)) {
            return true;
        }
        if (resolvedTypes.contains(type)) {
            return false;
        }
        resolvedTypes.add(type);
        switch (type.tag) {
            case 19: {
                return TypeParamAnalyzer.containsTypeParam(((BArrayType)type).eType, resolvedTypes);
            }
            case 30: {
                BTupleType bTupleType = (BTupleType)type;
                for (BType member : bTupleType.tupleTypes) {
                    if (!TypeParamAnalyzer.containsTypeParam(member, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 15: {
                return TypeParamAnalyzer.containsTypeParam(((BMapType)type).constraint, resolvedTypes);
            }
            case 14: {
                return TypeParamAnalyzer.containsTypeParam(((BStreamType)type).constraint, resolvedTypes);
            }
            case 9: {
                return TypeParamAnalyzer.containsTypeParam(((BTableType)type).constraint, resolvedTypes) || ((BTableType)type).keyTypeConstraint != null && TypeParamAnalyzer.containsTypeParam(((BTableType)type).keyTypeConstraint, resolvedTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    BType bFieldType = field.getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 16: {
                BInvokableType invokableType = (BInvokableType)type;
                for (BType paramType : invokableType.paramTypes) {
                    if (!TypeParamAnalyzer.containsTypeParam(paramType, resolvedTypes)) continue;
                    return true;
                }
                return TypeParamAnalyzer.containsTypeParam(invokableType.retType, resolvedTypes);
            }
            case 33: {
                BObjectType objectType = (BObjectType)type;
                for (Object field : objectType.fields.values()) {
                    BType bFieldType = ((BField)field).getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
                for (BAttachedFunction fuc : objectTypeSymbol.attachedFuncs) {
                    if (!TypeParamAnalyzer.containsTypeParam(fuc.type, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 20: {
                BUnionType unionType = (BUnionType)type;
                for (BType bType : unionType.getMemberTypes()) {
                    if (!TypeParamAnalyzer.containsTypeParam(bType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 28: {
                BErrorType errorType = (BErrorType)type;
                return TypeParamAnalyzer.containsTypeParam(errorType.detailType, resolvedTypes);
            }
            case 13: {
                return TypeParamAnalyzer.containsTypeParam(((BTypedescType)type).constraint, resolvedTypes);
            }
        }
        return false;
    }

    private BType createBuiltInType(BType type, Name name, long flag) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new BType(type.tag, null, name, flag);
            }
            case 17: {
                return new BAnyType(type.tag, null, name, flag);
            }
            case 11: {
                return new BAnydataType(type.tag, null, name, flag);
            }
            case 37: {
                return new BReadonlyType(type.tag, null, name, flag);
            }
        }
        return type;
    }

    private void findTypeParam(Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType, actualType, env, resolvedTypes, result, false);
    }

    private void findTypeParam(Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result, boolean checkContravariance) {
        if (resolvedTypes.contains(expType)) {
            return;
        }
        resolvedTypes.add(expType);
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            this.updateTypeParamAndBoundType(loc, env, expType, actualType);
            if (checkContravariance) {
                this.types.checkType(loc, this.getMatchingBoundType(expType, env, new HashSet<BType>()), actualType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            } else {
                this.types.checkType(loc, actualType, this.getMatchingBoundType(expType, env, new HashSet<BType>()), (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            }
            return;
        }
        switch (expType.tag) {
            case 19: {
                if (actualType.tag == 19) {
                    this.findTypeParam(loc, ((BArrayType)expType).eType, ((BArrayType)actualType).eType, env, resolvedTypes, result);
                }
                if (actualType.tag == 30) {
                    this.findTypeParamInTupleForArray(loc, (BArrayType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(loc, ((BArrayType)expType).eType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 15: {
                if (actualType.tag == 15) {
                    this.findTypeParam(loc, ((BMapType)expType).constraint, ((BMapType)actualType).constraint, env, resolvedTypes, result);
                }
                if (actualType.tag == 12) {
                    this.findTypeParamInMapForRecord(loc, (BMapType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(loc, ((BMapType)expType).constraint, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 14: {
                if (actualType.tag == 14) {
                    this.findTypeParamInStream(loc, (BStreamType)expType, (BStreamType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20) {
                    this.findTypeParamInStreamForUnion(loc, (BStreamType)expType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 9: {
                if (actualType.tag == 9) {
                    this.findTypeParamInTable(loc, (BTableType)expType, (BTableType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 30: {
                if (actualType.tag == 30) {
                    this.findTypeParamInTuple(loc, (BTupleType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(loc, expType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 12: {
                if (actualType.tag == 12) {
                    this.findTypeParamInRecord(loc, (BRecordType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(loc, expType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 16: {
                if (actualType.tag == 16) {
                    this.findTypeParamInInvokableType(loc, (BInvokableType)expType, (BInvokableType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 33: {
                if (actualType.tag == 33) {
                    this.findTypeParamInObject(loc, (BObjectType)expType, (BObjectType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 20: {
                if (actualType.tag == 20) {
                    this.findTypeParamInUnion(loc, (BUnionType)expType, (BUnionType)actualType, env, resolvedTypes, result);
                }
                return;
            }
            case 28: {
                if (actualType.tag == 28) {
                    this.findTypeParamInError(loc, (BErrorType)expType, (BErrorType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag == 20 && this.types.isSubTypeOfBaseType(actualType, 28)) {
                    this.findTypeParamInError(loc, (BErrorType)expType, this.symTable.errorType, env, resolvedTypes, result);
                }
                return;
            }
            case 13: {
                if (actualType.tag != 13) break;
                this.findTypeParam(loc, ((BTypedescType)expType).constraint, ((BTypedescType)actualType).constraint, env, resolvedTypes, result);
            }
        }
    }

    private void updateTypeParamAndBoundType(Location location, SymbolEnv env, BType typeParamType, BType boundType) {
        for (SymbolEnv.TypeParamEntry entry : env.typeParamsEntries) {
            if (!this.isSameTypeSymbolNameAndPkg(entry.typeParam.tsymbol, typeParamType.tsymbol)) continue;
            return;
        }
        if (boundType == this.symTable.noType) {
            this.dlog.error(location, DiagnosticErrorCode.CANNOT_INFER_TYPE, new Object[0]);
            return;
        }
        env.typeParamsEntries.add(new SymbolEnv.TypeParamEntry(typeParamType, boundType));
    }

    private boolean isSameTypeSymbolNameAndPkg(BTypeSymbol source, BTypeSymbol target) {
        if (source == null || target == null) {
            return false;
        }
        return source.pkgID.equals(target.pkgID) && source.name.equals(target.name);
    }

    private void findTypeParamInTuple(Location loc, BTupleType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (int i = 0; i < expType.tupleTypes.size() && i < actualType.tupleTypes.size(); ++i) {
            this.findTypeParam(loc, expType.tupleTypes.get(i), actualType.tupleTypes.get(i), env, resolvedTypes, result);
        }
    }

    private void findTypeParamInStream(Location loc, BStreamType expType, BStreamType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType.constraint, actualType.constraint, env, resolvedTypes, result);
        this.findTypeParam(loc, expType.error, actualType.error != null ? actualType.error : this.symTable.nilType, env, resolvedTypes, result);
    }

    private void findTypeParamInStreamForUnion(Location loc, BStreamType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> constraints = new LinkedHashSet<BType>();
        LinkedHashSet<BType> errors = new LinkedHashSet<BType>();
        for (BType type : actualType.getMemberTypes()) {
            if (type.tag != 14) continue;
            constraints.add(((BStreamType)type).constraint);
            if (((BStreamType)type).error == null) continue;
            errors.add(((BStreamType)type).error);
        }
        BUnionType cUnionType = BUnionType.create(null, constraints);
        this.findTypeParam(loc, expType.constraint, cUnionType, env, resolvedTypes, result);
        if (!errors.isEmpty()) {
            BUnionType eUnionType = BUnionType.create(null, errors);
            this.findTypeParam(loc, expType.error, eUnionType, env, resolvedTypes, result);
        } else {
            this.findTypeParam(loc, expType.error, this.symTable.nilType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInTable(Location loc, BTableType expType, BTableType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType.constraint, actualType.constraint, env, resolvedTypes, result);
        if (expType.keyTypeConstraint != null) {
            if (actualType.keyTypeConstraint != null) {
                this.findTypeParam(loc, expType.keyTypeConstraint, actualType.keyTypeConstraint, env, resolvedTypes, result);
            } else if (actualType.fieldNameList != null) {
                ArrayList<BType> memberTypes = new ArrayList<BType>();
                actualType.fieldNameList.forEach(field -> memberTypes.add(this.types.getTableConstraintField((BType)actualType.constraint, (String)field).type));
                if (memberTypes.size() == 1) {
                    this.findTypeParam(loc, expType.keyTypeConstraint, (BType)memberTypes.get(0), env, resolvedTypes, result);
                } else {
                    BTupleType tupleType = new BTupleType(memberTypes);
                    this.findTypeParam(loc, expType.keyTypeConstraint, tupleType, env, resolvedTypes, result);
                }
            }
        }
    }

    private void findTypeParamInTupleForArray(Location loc, BArrayType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>(actualType.tupleTypes);
        if (actualType.restType != null) {
            tupleTypes.add(actualType.restType);
        }
        BUnionType tupleElementType = BUnionType.create(null, tupleTypes);
        this.findTypeParam(loc, expType.eType, tupleElementType, env, resolvedTypes, result);
    }

    private void findTypeParamInUnion(Location loc, BType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        for (BType type : actualType.getMemberTypes()) {
            if (type.tag == 19) {
                members.add(((BArrayType)type).eType);
            }
            if (type.tag == 15) {
                members.add(((BMapType)type).constraint);
            }
            if (type.tag == 12) {
                for (BField field : ((BRecordType)type).fields.values()) {
                    members.add(field.type);
                }
            }
            if (type.tag != 30) continue;
            members.addAll(((BTupleType)type).getTupleTypes());
        }
        BUnionType tupleElementType = BUnionType.create(null, members);
        this.findTypeParam(loc, expType, tupleElementType, env, resolvedTypes, result);
    }

    private void findTypeParamInRecord(Location loc, BRecordType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields.values()) {
            if (!actualType.fields.containsKey(exField.name.value)) continue;
            this.findTypeParam(loc, exField.type, ((BField)actualType.fields.get((Object)exField.name.value)).type, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInMapForRecord(Location loc, BMapType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> reducedTypeSet;
        LinkedHashSet<BType> fields = actualType.fields.values().stream().map(f -> f.type).collect(Collectors.toCollection(LinkedHashSet::new));
        if (actualType.restFieldType != this.symTable.noType) {
            reducedTypeSet = new LinkedHashSet<BType>();
            for (BType fType : fields) {
                if (this.types.isAssignable(fType, actualType.restFieldType)) continue;
                reducedTypeSet.add(fType);
            }
            reducedTypeSet.add(actualType.restFieldType);
        } else {
            reducedTypeSet = fields;
        }
        BType commonFieldType = reducedTypeSet.size() == 1 ? (BType)reducedTypeSet.iterator().next() : BUnionType.create(null, reducedTypeSet);
        this.findTypeParam(loc, expType.constraint, commonFieldType, env, resolvedTypes, result);
    }

    private void findTypeParamInInvokableType(Location loc, BInvokableType expType, BInvokableType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (int i = 0; i < expType.paramTypes.size() && i < actualType.paramTypes.size(); ++i) {
            this.findTypeParam(loc, expType.paramTypes.get(i), actualType.paramTypes.get(i), env, resolvedTypes, result, true);
        }
        this.findTypeParam(loc, expType.retType, actualType.retType, env, resolvedTypes, result);
    }

    private void findTypeParamInObject(Location loc, BObjectType expType, BObjectType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields.values()) {
            if (!actualType.fields.containsKey(exField.name.value)) continue;
            this.findTypeParam(loc, exField.type, ((BField)actualType.fields.get((Object)exField.name.value)).type, env, resolvedTypes, result);
        }
        List expAttFunctions = ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs;
        List actualAttFunctions = ((BObjectTypeSymbol)actualType.tsymbol).attachedFuncs;
        for (BAttachedFunction expFunc : expAttFunctions) {
            BInvokableType actFuncType = actualAttFunctions.stream().filter(actFunc -> actFunc.funcName.equals(expFunc.funcName)).findFirst().map(actFunc -> actFunc.type).orElse(null);
            if (actFuncType == null) continue;
            this.findTypeParamInInvokableType(loc, expFunc.type, actFuncType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInUnion(Location loc, BUnionType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (expType.getMemberTypes().size() != 2 || !expType.isNullable() || actualType.getMemberTypes().size() != 2 || !actualType.isNullable()) {
            return;
        }
        BType exp = expType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        BType act = actualType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        this.findTypeParam(loc, exp, act, env, resolvedTypes, result);
    }

    private void findTypeParamInError(Location loc, BErrorType expType, BErrorType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (expType == this.symTable.errorType) {
            return;
        }
        this.findTypeParam(loc, expType.detailType, actualType.detailType, env, resolvedTypes, result);
    }

    private BType getMatchingBoundType(BType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            return env.typeParamsEntries.stream().filter(typeParamEntry -> typeParamEntry.typeParam == expType).findFirst().map(typeParamEntry -> typeParamEntry.boundType).orElse(this.symTable.noType);
        }
        if (resolvedTypes.contains(expType)) {
            return expType;
        }
        resolvedTypes.add(expType);
        switch (expType.tag) {
            case 19: {
                BType elementType = ((BArrayType)expType).eType;
                return new BArrayType(this.getMatchingBoundType(elementType, env, resolvedTypes));
            }
            case 15: {
                BType constraint = ((BMapType)expType).constraint;
                return new BMapType(15, this.getMatchingBoundType(constraint, env, resolvedTypes), this.symTable.mapType.tsymbol);
            }
            case 14: {
                BType streamConstraint = this.getMatchingBoundType(((BStreamType)expType).constraint, env, resolvedTypes);
                BType streamError = ((BStreamType)expType).error != null ? this.getMatchingOptionalBoundType((BUnionType)((BStreamType)expType).error, env, resolvedTypes) : null;
                return new BStreamType(14, streamConstraint, streamError, this.symTable.streamType.tsymbol);
            }
            case 9: {
                BType tableConstraint = this.getMatchingBoundType(((BTableType)expType).constraint, env, resolvedTypes);
                BTableType tableType = new BTableType(9, tableConstraint, this.symTable.tableType.tsymbol);
                if (((BTableType)expType).keyTypeConstraint != null) {
                    BType keyTypeConstraint;
                    tableType.keyTypeConstraint = keyTypeConstraint = this.getMatchingBoundType(((BTableType)expType).keyTypeConstraint, env, resolvedTypes);
                }
                return tableType;
            }
            case 30: {
                return this.getMatchingTupleBoundType((BTupleType)expType, env, resolvedTypes);
            }
            case 12: {
                return this.getMatchingRecordBoundType((BRecordType)expType, env, resolvedTypes);
            }
            case 16: {
                return this.getMatchingFunctionBoundType((BInvokableType)expType, env, resolvedTypes);
            }
            case 33: {
                return this.getMatchingObjectBoundType((BObjectType)expType, env, resolvedTypes);
            }
            case 20: {
                return this.getMatchingOptionalBoundType((BUnionType)expType, env, resolvedTypes);
            }
            case 28: {
                return this.getMatchingErrorBoundType((BErrorType)expType, env, resolvedTypes);
            }
            case 13: {
                BType constraint = ((BTypedescType)expType).constraint;
                return new BTypedescType(this.getMatchingBoundType(constraint, env, resolvedTypes), this.symTable.typeDesc.tsymbol);
            }
        }
        return expType;
    }

    private BTupleType getMatchingTupleBoundType(BTupleType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        ArrayList<BType> tupleTypes = new ArrayList<BType>();
        expType.tupleTypes.forEach(type -> tupleTypes.add(this.getMatchingBoundType((BType)type, env, resolvedTypes)));
        return new BTupleType(tupleTypes);
    }

    private BRecordType getMatchingRecordBoundType(BRecordType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        BRecordTypeSymbol expTSymbol = (BRecordTypeSymbol)expType.tsymbol;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(expTSymbol.flags, expTSymbol.name, expTSymbol.pkgID, null, expType.tsymbol.scope.owner, expTSymbol.pos, SymbolOrigin.VIRTUAL);
        recordSymbol.scope = new Scope(recordSymbol);
        recordSymbol.initializerFunc = expTSymbol.initializerFunc;
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BField expField : expType.fields.values()) {
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(0L, expField.name, env.enclPkg.packageID, this.getMatchingBoundType(expField.type, env, resolvedTypes), env.scope.owner, expField.pos, SymbolOrigin.VIRTUAL));
            fields.put(field.name.value, field);
            recordSymbol.scope.define(expField.name, field.symbol);
        }
        BRecordType bRecordType = new BRecordType(recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        if (expType.sealed) {
            bRecordType.sealed = true;
        }
        bRecordType.restFieldType = this.getMatchingBoundType(expType.restFieldType, env, resolvedTypes);
        return bRecordType;
    }

    private BInvokableType getMatchingFunctionBoundType(BInvokableType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        List<BType> paramTypes = expType.paramTypes.stream().map(type -> this.getMatchingBoundType((BType)type, env, resolvedTypes)).collect(Collectors.toList());
        BType restType = expType.restType;
        long flags = expType.flags;
        BInvokableType invokableType = new BInvokableType(paramTypes, restType, this.getMatchingBoundType(expType.retType, env, resolvedTypes), Symbols.createInvokableTypeSymbol(67108892, flags, env.enclPkg.symbol.pkgID, expType, env.scope.owner, expType.tsymbol.pos, SymbolOrigin.VIRTUAL));
        if (Symbols.isFlagOn(flags, 0x20000000L)) {
            invokableType.flags |= 0x20000000L;
        }
        return invokableType;
    }

    private BType getMatchingObjectBoundType(BObjectType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        BObjectTypeSymbol actObjectSymbol = Symbols.createObjectSymbol(expType.tsymbol.flags, expType.tsymbol.name, expType.tsymbol.pkgID, null, expType.tsymbol.scope.owner, expType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BObjectType objectType = new BObjectType(actObjectSymbol);
        actObjectSymbol.type = objectType;
        actObjectSymbol.scope = new Scope(actObjectSymbol);
        for (BField expField : expType.fields.values()) {
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(expField.symbol.flags, expField.name, env.enclPkg.packageID, this.getMatchingBoundType(expField.type, env, resolvedTypes), env.scope.owner, expField.pos, SymbolOrigin.VIRTUAL));
            objectType.fields.put(field.name.value, field);
            objectType.tsymbol.scope.define(expField.name, field.symbol);
        }
        for (BAttachedFunction expFunc : ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs) {
            BInvokableType matchType = this.getMatchingFunctionBoundType(expFunc.type, env, resolvedTypes);
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(expFunc.symbol.tag, expFunc.symbol.flags, expFunc.symbol.name, env.enclPkg.packageID, matchType, env.scope.owner, expFunc.pos, SymbolOrigin.VIRTUAL);
            invokableSymbol.retType = invokableSymbol.getType().retType;
            matchType.tsymbol = Symbols.createTypeSymbol(67108892, invokableSymbol.flags, Names.EMPTY, env.enclPkg.symbol.pkgID, invokableSymbol.type, env.scope.owner, invokableSymbol.pos, SymbolOrigin.VIRTUAL);
            actObjectSymbol.attachedFuncs.add(this.duplicateAttachFunc(expFunc, matchType, invokableSymbol));
            String funcName = Symbols.getAttachedFuncSymbolName(actObjectSymbol.type.tsymbol.name.value, expFunc.funcName.value);
            actObjectSymbol.scope.define(this.names.fromString(funcName), invokableSymbol);
        }
        return objectType;
    }

    private BAttachedFunction duplicateAttachFunc(BAttachedFunction expFunc, BInvokableType matchType, BInvokableSymbol invokableSymbol) {
        if (expFunc instanceof BResourceFunction) {
            BResourceFunction resourceFunction = (BResourceFunction)expFunc;
            return new BResourceFunction(resourceFunction.funcName, invokableSymbol, matchType, resourceFunction.resourcePath, resourceFunction.accessor, resourceFunction.pathParams, resourceFunction.restPathParam, expFunc.pos);
        }
        return new BAttachedFunction(expFunc.funcName, invokableSymbol, matchType, expFunc.pos);
    }

    private BType getMatchingOptionalBoundType(BUnionType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        expType.getMemberTypes().forEach(type -> members.add(this.getMatchingBoundType((BType)type, env, resolvedTypes)));
        return BUnionType.create(null, members);
    }

    private BType getMatchingErrorBoundType(BErrorType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (expType == this.symTable.errorType) {
            return expType;
        }
        BType detailType = this.getMatchingBoundType(expType.detailType, env, resolvedTypes);
        BErrorTypeSymbol typeSymbol = new BErrorTypeSymbol(589852, this.symTable.errorType.tsymbol.flags, this.symTable.errorType.tsymbol.name, this.symTable.errorType.tsymbol.pkgID, null, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        BErrorType errorType = new BErrorType(typeSymbol, detailType);
        typeSymbol.type = errorType;
        return errorType;
    }

    private static class FindTypeParamResult {
        boolean found = false;
        boolean isNew = false;

        private FindTypeParamResult() {
        }
    }
}

