/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BBuiltInRefType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.NumericLiteralSupport;
import org.wso2.ballerinalang.compiler.util.ResolvedTypeBuilder;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.Lists;

public class Types {
    private static final CompilerContext.Key<Types> TYPES_KEY = new CompilerContext.Key();
    private final ResolvedTypeBuilder typeBuilder;
    private SymbolTable symTable;
    private SymbolResolver symResolver;
    private BLangDiagnosticLog dlog;
    private Names names;
    private int finiteTypeCount = 0;
    private BUnionType expandedXMLBuiltinSubtypes;

    public static Types getInstance(CompilerContext context) {
        Types types = context.get(TYPES_KEY);
        if (types == null) {
            types = new Types(context);
        }
        return types;
    }

    public Types(CompilerContext context) {
        context.put(TYPES_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.names = Names.getInstance(context);
        this.expandedXMLBuiltinSubtypes = BUnionType.create(null, this.symTable.xmlElementType, this.symTable.xmlCommentType, this.symTable.xmlPIType, this.symTable.xmlTextType);
        this.typeBuilder = new ResolvedTypeBuilder();
    }

    public List<BType> checkTypes(BLangExpression node, List<BType> actualTypes, List<BType> expTypes) {
        ArrayList<BType> resTypes = new ArrayList<BType>();
        for (int i = 0; i < actualTypes.size(); ++i) {
            resTypes.add(this.checkType(node, actualTypes.get(i), expTypes.size() > i ? expTypes.get(i) : this.symTable.noType));
        }
        return resTypes;
    }

    public BType checkType(BLangExpression node, BType actualType, BType expType) {
        return this.checkType(node, actualType, expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
    }

    public BType checkType(BLangExpression expr, BType actualType, BType expType, DiagnosticCode diagCode) {
        expr.type = this.checkType(expr.pos, actualType, expType, diagCode);
        if (expr.type.tag == 27) {
            return expr.type;
        }
        this.setImplicitCastExpr(expr, actualType, expType);
        return expr.type;
    }

    public BType checkType(Location pos, BType actualType, BType expType, DiagnosticCode diagCode) {
        if (expType.tag == 27) {
            return expType;
        }
        if (expType.tag == 23) {
            return actualType;
        }
        if (actualType.tag == 27) {
            return actualType;
        }
        if (this.isAssignable(actualType, expType)) {
            return actualType;
        }
        this.dlog.error(pos, diagCode, expType, actualType);
        return this.symTable.semanticError;
    }

    public boolean isJSONContext(BType type) {
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().anyMatch(memType -> memType.tag == 7);
        }
        return type.tag == 7;
    }

    public boolean isLax(BType type) {
        switch (type.tag) {
            case 7: 
            case 8: 
            case 45: {
                return true;
            }
            case 15: {
                return this.isLax(((BMapType)type).constraint);
            }
            case 20: {
                return ((BUnionType)type).getMemberTypes().stream().allMatch(this::isLax);
            }
        }
        return false;
    }

    public boolean isSameType(BType source, BType target) {
        return this.isSameType(source, target, new HashSet<TypePair>());
    }

    private boolean isSameType(BType source, BType target, Set<TypePair> unresolvedTypes) {
        TypePair pair = new TypePair(source, target);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BSameTypeVisitor sameTypeVisitor = new BSameTypeVisitor(unresolvedTypes);
        return target.accept(sameTypeVisitor, source);
    }

    public boolean isValueType(BType type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    boolean isBasicNumericType(BType type) {
        return type.tag < 5 || TypeTags.isIntegerTypeTag(type.tag);
    }

    boolean finiteTypeContainsNumericTypeValues(BFiniteType finiteType) {
        return finiteType.getValueSpace().stream().anyMatch(valueExpr -> this.isBasicNumericType(valueExpr.type));
    }

    public boolean containsErrorType(BType type) {
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().anyMatch(this::containsErrorType);
        }
        return type.tag == 28;
    }

    public boolean isSubTypeOfList(BType type) {
        if (type.tag != 20) {
            return this.isSubTypeOfBaseType(type, 19) || this.isSubTypeOfBaseType(type, 30);
        }
        return ((BUnionType)type).getMemberTypes().stream().allMatch(this::isSubTypeOfList);
    }

    public BType resolvePatternTypeFromMatchExpr(BLangExpression matchExpr, BTupleType listMatchPatternType) {
        if (matchExpr == null) {
            return listMatchPatternType;
        }
        BType matchExprType = matchExpr.type;
        BType intersectionType = this.getTypeIntersection(matchExprType, listMatchPatternType);
        if (intersectionType != this.symTable.semanticError) {
            return intersectionType;
        }
        if (matchExprType.tag == 11) {
            Collections.fill(listMatchPatternType.tupleTypes, this.symTable.anydataType);
            if (listMatchPatternType.restType != null) {
                listMatchPatternType.restType = this.symTable.anydataType;
            }
            return listMatchPatternType;
        }
        return this.symTable.noType;
    }

    public BType resolvePatternTypeFromMatchExpr(BLangExpression matchExpr, BLangExpression constPatternExpr) {
        if (matchExpr == null) {
            if (constPatternExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                return ((BLangSimpleVarRef)constPatternExpr).symbol.type;
            }
            return constPatternExpr.type;
        }
        BType matchExprType = matchExpr.type;
        BType constMatchPatternExprType = constPatternExpr.type;
        if (constPatternExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef constVarRef = (BLangSimpleVarRef)constPatternExpr;
            if (constVarRef.symbol == null) {
                return this.symTable.noType;
            }
            BType constVarRefSymbolType = constVarRef.symbol.type;
            if (this.isAssignable(constVarRefSymbolType, matchExprType)) {
                return constVarRefSymbolType;
            }
            return this.symTable.noType;
        }
        BLangLiteral constPatternLiteral = (BLangLiteral)constPatternExpr;
        if (this.containsAnyType(constMatchPatternExprType)) {
            return matchExprType;
        }
        if (this.containsAnyType(matchExprType)) {
            return constMatchPatternExprType;
        }
        if (matchExprType.tag == 2 && constMatchPatternExprType.tag == 1) {
            return matchExprType;
        }
        if (this.isAssignable(constMatchPatternExprType, matchExprType)) {
            return constMatchPatternExprType;
        }
        if (matchExprType.tag == 20) {
            for (BType memberType : ((BUnionType)matchExprType).getMemberTypes()) {
                if (memberType.tag == 32) {
                    if (!this.isAssignableToFiniteType(memberType, constPatternLiteral)) continue;
                    return memberType;
                }
                if (!this.isAssignable(constMatchPatternExprType, matchExprType)) continue;
                return constMatchPatternExprType;
            }
        } else if (matchExprType.tag == 32 && this.isAssignableToFiniteType(matchExprType, constPatternLiteral)) {
            return matchExprType;
        }
        return this.symTable.noType;
    }

    private boolean containsAnyType(BType type) {
        if (type.tag != 20) {
            return type.tag == 17;
        }
        for (BType memberTypes : ((BUnionType)type).getMemberTypes()) {
            if (memberTypes.tag != 17) continue;
            return true;
        }
        return false;
    }

    public BType mergeTypes(BType typeFirst, BType typeSecond) {
        if (this.containsAnyType(typeFirst)) {
            return typeSecond;
        }
        if (this.isSameBasicType(typeFirst, typeSecond)) {
            return typeFirst;
        }
        return BUnionType.create(null, typeFirst, typeSecond);
    }

    public boolean isSubTypeOfMapping(BType type) {
        if (type.tag != 20) {
            return this.isSubTypeOfBaseType(type, 15) || this.isSubTypeOfBaseType(type, 12);
        }
        return ((BUnionType)type).getMemberTypes().stream().allMatch(this::isSubTypeOfMapping);
    }

    public boolean isSubTypeOfBaseType(BType type, int baseTypeTag) {
        if (type.tag != 20) {
            return type.tag == baseTypeTag;
        }
        if (TypeTags.isXMLTypeTag(baseTypeTag)) {
            return true;
        }
        return ((BUnionType)type).getMemberTypes().stream().allMatch(memType -> memType.tag == baseTypeTag);
    }

    public boolean isAssignable(BType source, BType target) {
        return this.isAssignable(source, target, new HashSet<TypePair>());
    }

    boolean isStampingAllowed(BType source, BType target) {
        return this.isAssignable(source, target) || this.isAssignable(target, source) || this.checkTypeEquivalencyForStamping(source, target) || this.checkTypeEquivalencyForStamping(target, source);
    }

    private boolean checkTypeEquivalencyForStamping(BType source, BType target) {
        if (target.tag == 12) {
            if (source.tag == 12) {
                TypePair pair = new TypePair(source, target);
                HashSet<TypePair> unresolvedTypes = new HashSet<TypePair>();
                unresolvedTypes.add(pair);
                return this.checkRecordEquivalencyForStamping((BRecordType)source, (BRecordType)target, unresolvedTypes);
            }
            if (source.tag == 15) {
                int mapConstraintTypeTag = ((BMapType)source).constraint.tag;
                if (mapConstraintTypeTag != 17 && mapConstraintTypeTag != 11 && ((BRecordType)target).sealed) {
                    for (BField field : ((BStructureType)target).getFields().values()) {
                        if (field.getType().tag == mapConstraintTypeTag) continue;
                        return false;
                    }
                }
                return true;
            }
        } else {
            if (target.tag == 7) {
                return source.tag == 7 || source.tag == 12 || source.tag == 15;
            }
            if (target.tag == 15) {
                if (source.tag == 15) {
                    return this.isStampingAllowed(((BMapType)source).getConstraint(), ((BMapType)target).getConstraint());
                }
                if (source.tag == 20) {
                    return this.checkUnionEquivalencyForStamping(source, target);
                }
            } else if (target.tag == 19) {
                if (source.tag == 7) {
                    return true;
                }
                if (source.tag == 30) {
                    BType arrayElementType = ((BArrayType)target).eType;
                    for (BType tupleMemberType : ((BTupleType)source).getTupleTypes()) {
                        if (this.isStampingAllowed(tupleMemberType, arrayElementType)) continue;
                        return false;
                    }
                    return true;
                }
                if (source.tag == 19) {
                    return this.checkTypeEquivalencyForStamping(((BArrayType)source).eType, ((BArrayType)target).eType);
                }
            } else {
                if (target.tag == 20) {
                    return this.checkUnionEquivalencyForStamping(source, target);
                }
                if (target.tag == 30 && source.tag == 30) {
                    return this.checkTupleEquivalencyForStamping(source, target);
                }
            }
        }
        return false;
    }

    private boolean checkRecordEquivalencyForStamping(BRecordType rhsType, BRecordType lhsType, Set<TypePair> unresolvedTypes) {
        if (Symbols.isFlagOn(lhsType.tsymbol.flags ^ rhsType.tsymbol.flags, 1L)) {
            return false;
        }
        if (Symbols.isPrivate(lhsType.tsymbol) && rhsType.tsymbol.pkgID != lhsType.tsymbol.pkgID) {
            return false;
        }
        if (lhsType.fields.size() > rhsType.fields.size()) {
            return false;
        }
        if (lhsType.sealed && !rhsType.sealed) {
            return false;
        }
        return this.checkFieldEquivalencyForStamping(lhsType, rhsType, unresolvedTypes);
    }

    private boolean checkFieldEquivalencyForStamping(BStructureType lhsType, BStructureType rhsType, Set<TypePair> unresolvedTypes) {
        for (BField lhsField : lhsType.fields.values()) {
            BField rhsField = rhsType.fields.get(lhsField.name.value);
            if (rhsField != null && this.isStampingAllowed(rhsField.type, lhsField.type)) continue;
            return false;
        }
        for (BField rhsField : rhsType.fields.values()) {
            BField lhsField = lhsType.fields.get(rhsField.name.value);
            if (lhsField != null || this.isStampingAllowed(rhsField.type, ((BRecordType)lhsType).restFieldType)) continue;
            return false;
        }
        return true;
    }

    private boolean checkUnionEquivalencyForStamping(BType source, BType target) {
        LinkedHashSet<BType> sourceTypes = new LinkedHashSet<BType>();
        LinkedHashSet<BType> targetTypes = new LinkedHashSet<BType>();
        if (source.tag == 20) {
            BUnionType sourceUnionType = (BUnionType)source;
            sourceTypes.addAll(sourceUnionType.getMemberTypes());
        } else {
            sourceTypes.add(source);
        }
        if (target.tag == 20) {
            BUnionType targetUnionType = (BUnionType)target;
            targetTypes.addAll(targetUnionType.getMemberTypes());
        } else {
            targetTypes.add(target);
        }
        boolean notAssignable = sourceTypes.stream().map(s -> targetTypes.stream().anyMatch(t -> this.isStampingAllowed((BType)s, (BType)t))).anyMatch(assignable -> assignable == false);
        return !notAssignable;
    }

    private boolean checkTupleEquivalencyForStamping(BType source, BType target) {
        if (source.tag != 30 || target.tag != 30) {
            return false;
        }
        BTupleType lhsTupleType = (BTupleType)target;
        BTupleType rhsTupleType = (BTupleType)source;
        if (lhsTupleType.tupleTypes.size() != rhsTupleType.tupleTypes.size()) {
            return false;
        }
        for (int i = 0; i < lhsTupleType.tupleTypes.size(); ++i) {
            if (this.isStampingAllowed(rhsTupleType.tupleTypes.get(i), lhsTupleType.tupleTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(BType source, BType target, Set<TypePair> unresolvedTypes) {
        if (this.isSameType(source, target)) {
            return true;
        }
        int sourceTag = source.tag;
        int targetTag = target.tag;
        if (!(Symbols.isFlagOn(source.flags, 0x4000000L) || this.isInherentlyImmutableType(target) || !Symbols.isFlagOn(target.flags, 32L) || this.isInherentlyImmutableType(source) || Symbols.isFlagOn(source.flags, 32L))) {
            return false;
        }
        if (sourceTag == 21) {
            return this.isAssignable(((BIntersectionType)source).effectiveType, targetTag != 21 ? target : ((BIntersectionType)target).effectiveType, unresolvedTypes);
        }
        if (targetTag == 21) {
            return this.isAssignable(source, ((BIntersectionType)target).effectiveType, unresolvedTypes);
        }
        if (sourceTag == 51) {
            return this.isParameterizedTypeAssignable(source, target, unresolvedTypes);
        }
        if (sourceTag == 2 && targetTag == 1) {
            return true;
        }
        if (TypeTags.isXMLTypeTag(sourceTag) && TypeTags.isXMLTypeTag(targetTag)) {
            return this.isXMLTypeAssignable(source, target, unresolvedTypes);
        }
        if (sourceTag == 44 && targetTag == 5) {
            return true;
        }
        if (sourceTag == 44 && targetTag == 48) {
            return true;
        }
        if (sourceTag == 5 && targetTag == 48) {
            return true;
        }
        if (sourceTag == 48 && targetTag == 5) {
            return true;
        }
        if (sourceTag == 48 && targetTag == 44) {
            return true;
        }
        if (sourceTag == 28 && targetTag == 28) {
            return this.isErrorTypeAssignable((BErrorType)source, (BErrorType)target, unresolvedTypes);
        }
        if (sourceTag == 28 && targetTag == 17) {
            return false;
        }
        if (sourceTag == 10 && (this.isNullable(target) || targetTag == 7)) {
            return true;
        }
        if (targetTag == 17 && !this.containsErrorType(source) && !this.isValueType(source)) {
            return true;
        }
        if (targetTag == 11 && !this.containsErrorType(source) && source.isAnydata()) {
            return true;
        }
        if (targetTag == 37 && (this.isInherentlyImmutableType(source) || Symbols.isFlagOn(source.flags, 32L))) {
            return true;
        }
        if (targetTag == 15 && sourceTag == 12) {
            BRecordType recordType = (BRecordType)source;
            return this.isAssignableRecordType(recordType, target, unresolvedTypes);
        }
        if (targetTag == 12 && sourceTag == 15) {
            return this.isAssignableMapType((BMapType)source, (BRecordType)target);
        }
        if (targetTag == 13 && sourceTag == 13) {
            return this.isAssignable(((BTypedescType)source).constraint, ((BTypedescType)target).constraint, unresolvedTypes);
        }
        if (targetTag == 9 && sourceTag == 9) {
            return this.isAssignableTableType((BTableType)source, (BTableType)target);
        }
        if (targetTag == 14 && sourceTag == 14) {
            return this.isAssignable(((BStreamType)source).constraint, ((BStreamType)target).constraint, unresolvedTypes);
        }
        if (this.isBuiltInTypeWidenPossible(source, target) == TypeTestResult.TRUE) {
            return true;
        }
        if (sourceTag == 32) {
            return this.isFiniteTypeAssignable((BFiniteType)source, target, unresolvedTypes);
        }
        if ((targetTag == 20 || sourceTag == 20) && this.isAssignableToUnionType(source, target, unresolvedTypes)) {
            return true;
        }
        if (targetTag == 7) {
            if (sourceTag == 7) {
                return true;
            }
            if (sourceTag == 19) {
                return this.isArrayTypesAssignable((BArrayType)source, target, unresolvedTypes);
            }
            if (sourceTag == 15) {
                return this.isAssignable(((BMapType)source).constraint, target, unresolvedTypes);
            }
            if (sourceTag == 12) {
                return this.isAssignableRecordType((BRecordType)source, target, unresolvedTypes);
            }
        }
        if (targetTag == 31 && sourceTag == 31) {
            if (((BFutureType)target).constraint.tag == 23) {
                return true;
            }
            return this.isAssignable(((BFutureType)source).constraint, ((BFutureType)target).constraint, unresolvedTypes);
        }
        if (targetTag == 15 && sourceTag == 15) {
            if (((BMapType)target).constraint.tag == 17 && ((BMapType)source).constraint.tag != 20) {
                return true;
            }
            return this.isAssignable(((BMapType)source).constraint, ((BMapType)target).constraint, unresolvedTypes);
        }
        if (!(sourceTag != 33 && sourceTag != 12 || targetTag != 33 && targetTag != 12)) {
            return this.checkStructEquivalency(source, target, unresolvedTypes);
        }
        if (sourceTag == 30 && targetTag == 19) {
            return this.isTupleTypeAssignableToArrayType((BTupleType)source, (BArrayType)target, unresolvedTypes);
        }
        if (sourceTag == 19 && targetTag == 30) {
            return this.isArrayTypeAssignableToTupleType((BArrayType)source, (BTupleType)target, unresolvedTypes);
        }
        if (sourceTag == 30 || targetTag == 30) {
            return this.isTupleTypeAssignable(source, target, unresolvedTypes);
        }
        if (sourceTag == 16 && targetTag == 16) {
            return this.isFunctionTypeAssignable((BInvokableType)source, (BInvokableType)target, new HashSet<TypePair>());
        }
        return sourceTag == 19 && targetTag == 19 && this.isArrayTypesAssignable((BArrayType)source, target, unresolvedTypes);
    }

    private boolean isParameterizedTypeAssignable(BType source, BType target, Set<TypePair> unresolvedTypes) {
        BType resolvedSourceType = this.typeBuilder.build(source);
        if (target.tag != 51) {
            return this.isAssignable(resolvedSourceType, target, unresolvedTypes);
        }
        if (((BParameterizedType)source).paramIndex != ((BParameterizedType)target).paramIndex) {
            return false;
        }
        return this.isAssignable(resolvedSourceType, this.typeBuilder.build(target), unresolvedTypes);
    }

    private boolean isAssignableRecordType(BRecordType recordType, BType type, Set<TypePair> unresolvedTypes) {
        BType targetType;
        TypePair pair = new TypePair(recordType, type);
        if (!unresolvedTypes.add(pair)) {
            return true;
        }
        switch (type.tag) {
            case 15: {
                targetType = ((BMapType)type).constraint;
                break;
            }
            case 7: {
                targetType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Incompatible target type: " + type.toString());
            }
        }
        return this.recordFieldsAssignableToType(recordType, targetType, unresolvedTypes);
    }

    private boolean recordFieldsAssignableToType(BRecordType recordType, BType targetType, Set<TypePair> unresolvedTypes) {
        for (BField field : recordType.fields.values()) {
            if (this.isAssignable(field.type, targetType, unresolvedTypes)) continue;
            return false;
        }
        if (!recordType.sealed) {
            return this.isAssignable(recordType.restFieldType, targetType, unresolvedTypes);
        }
        return true;
    }

    private boolean isAssignableTableType(BTableType sourceTableType, BTableType targetTableType) {
        if (!this.isAssignable(sourceTableType.constraint, targetTableType.constraint)) {
            return false;
        }
        if (targetTableType.keyTypeConstraint == null && targetTableType.fieldNameList == null) {
            return true;
        }
        if (targetTableType.keyTypeConstraint != null) {
            if (sourceTableType.keyTypeConstraint != null && this.isAssignable(sourceTableType.keyTypeConstraint, targetTableType.keyTypeConstraint)) {
                return true;
            }
            if (sourceTableType.fieldNameList == null) {
                return false;
            }
            ArrayList<BType> fieldTypes = new ArrayList<BType>();
            sourceTableType.fieldNameList.forEach(field -> fieldTypes.add(this.getTableConstraintField((BType)sourceTableType.constraint, (String)field).type));
            if (fieldTypes.size() == 1) {
                return this.isAssignable((BType)fieldTypes.get(0), targetTableType.keyTypeConstraint);
            }
            BTupleType tupleType = new BTupleType(fieldTypes);
            return this.isAssignable(tupleType, targetTableType.keyTypeConstraint);
        }
        return targetTableType.fieldNameList.equals(sourceTableType.fieldNameList);
    }

    BField getTableConstraintField(BType constraintType, String fieldName) {
        switch (constraintType.tag) {
            case 12: {
                LinkedHashMap<String, BField> fieldList = ((BRecordType)constraintType).getFields();
                return (BField)fieldList.get(fieldName);
            }
            case 20: {
                BUnionType unionType = (BUnionType)constraintType;
                Set<BType> memTypes = unionType.getMemberTypes();
                List fields = memTypes.stream().map(type -> this.getTableConstraintField((BType)type, fieldName)).filter(Objects::nonNull).collect(Collectors.toList());
                if (fields.size() != memTypes.size()) {
                    return null;
                }
                if (!fields.stream().allMatch(field -> this.isAssignable(field.type, ((BField)fields.get((int)0)).type) && this.isAssignable(((BField)fields.get((int)0)).type, field.type))) break;
                return (BField)fields.get(0);
            }
            case 21: {
                return this.getTableConstraintField(((BIntersectionType)constraintType).effectiveType, fieldName);
            }
        }
        return null;
    }

    private boolean isAssignableMapType(BMapType sourceMapType, BRecordType targetRecType) {
        if (targetRecType.sealed) {
            return false;
        }
        for (BField field : targetRecType.fields.values()) {
            if (!Symbols.isFlagOn(field.symbol.flags, 4096L)) {
                return false;
            }
            if (this.hasIncompatibleReadOnlyFlags(field.symbol.flags, sourceMapType.flags)) {
                return false;
            }
            if (this.isAssignable(sourceMapType.constraint, field.type)) continue;
            return false;
        }
        return this.isAssignable(sourceMapType.constraint, targetRecType.restFieldType);
    }

    private boolean hasIncompatibleReadOnlyFlags(long targetFlags, long sourceFlags) {
        return Symbols.isFlagOn(targetFlags, 32L) && !Symbols.isFlagOn(sourceFlags, 32L);
    }

    private boolean isErrorTypeAssignable(BErrorType source, BErrorType target, Set<TypePair> unresolvedTypes) {
        if (target == this.symTable.errorType) {
            return true;
        }
        TypePair pair = new TypePair(source, target);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        return this.isAssignable(source.detailType, target.detailType, unresolvedTypes) && target.typeIdSet.isAssignableFrom(source.typeIdSet);
    }

    private boolean isXMLTypeAssignable(BType sourceType, BType targetType, Set<TypePair> unresolvedTypes) {
        int sourceTag = sourceType.tag;
        int targetTag = targetType.tag;
        if (targetTag == 8) {
            BXMLType target = (BXMLType)targetType;
            if (target.constraint != null) {
                if (TypeTags.isXMLNonSequenceType(sourceTag)) {
                    return this.isAssignable(sourceType, target.constraint, unresolvedTypes);
                }
                BXMLType source = (BXMLType)sourceType;
                return this.isAssignable(source.constraint, target.constraint, unresolvedTypes);
            }
            return true;
        }
        return sourceTag == targetTag;
    }

    private boolean isTupleTypeAssignable(BType source, BType target, Set<TypePair> unresolvedTypes) {
        if (source.tag != 30 || target.tag != 30) {
            return false;
        }
        BTupleType lhsTupleType = (BTupleType)target;
        BTupleType rhsTupleType = (BTupleType)source;
        if (lhsTupleType.restType == null && rhsTupleType.restType != null) {
            return false;
        }
        if (lhsTupleType.restType == null && lhsTupleType.tupleTypes.size() != rhsTupleType.tupleTypes.size()) {
            return false;
        }
        if (lhsTupleType.restType != null && rhsTupleType.restType != null && !this.isAssignable(rhsTupleType.restType, lhsTupleType.restType, unresolvedTypes)) {
            return false;
        }
        if (lhsTupleType.tupleTypes.size() > rhsTupleType.tupleTypes.size()) {
            return false;
        }
        for (int i = 0; i < rhsTupleType.tupleTypes.size(); ++i) {
            BType lhsType;
            BType bType = lhsType = lhsTupleType.tupleTypes.size() > i ? lhsTupleType.tupleTypes.get(i) : lhsTupleType.restType;
            if (this.isAssignable(rhsTupleType.tupleTypes.get(i), lhsType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private boolean isTupleTypeAssignableToArrayType(BTupleType source, BArrayType target, Set<TypePair> unresolvedTypes) {
        if (target.state != BArrayState.OPEN && (source.restType != null || source.tupleTypes.size() != target.size)) {
            return false;
        }
        ArrayList<BType> sourceTypes = new ArrayList<BType>(source.tupleTypes);
        if (source.restType != null) {
            sourceTypes.add(source.restType);
        }
        return sourceTypes.stream().allMatch(tupleElemType -> this.isAssignable((BType)tupleElemType, target.eType, unresolvedTypes));
    }

    private boolean isArrayTypeAssignableToTupleType(BArrayType source, BTupleType target, Set<TypePair> unresolvedTypes) {
        if (!target.tupleTypes.isEmpty()) {
            if (source.state == BArrayState.OPEN) {
                return false;
            }
            if (target.restType != null && target.tupleTypes.size() > source.size) {
                return false;
            }
            if (target.restType == null && target.tupleTypes.size() != source.size) {
                return false;
            }
        }
        ArrayList<BType> targetTypes = new ArrayList<BType>(target.tupleTypes);
        if (target.restType != null) {
            targetTypes.add(target.restType);
        }
        return targetTypes.stream().allMatch(tupleElemType -> this.isAssignable(source.eType, (BType)tupleElemType, unresolvedTypes));
    }

    private boolean isArrayTypesAssignable(BArrayType source, BType target, Set<TypePair> unresolvedTypes) {
        BType sourceElementType = source.getElementType();
        if (target.tag == 19) {
            BArrayType targetArrayType = (BArrayType)target;
            BType targetElementType = targetArrayType.getElementType();
            if (targetArrayType.state == BArrayState.OPEN) {
                return this.isAssignable(sourceElementType, targetElementType, unresolvedTypes);
            }
            if (targetArrayType.size != source.size) {
                return false;
            }
            return this.isAssignable(sourceElementType, targetElementType, unresolvedTypes);
        }
        if (target.tag == 7) {
            return this.isAssignable(sourceElementType, target, unresolvedTypes);
        }
        return false;
    }

    private boolean isFunctionTypeAssignable(BInvokableType source, BInvokableType target, Set<TypePair> unresolvedTypes) {
        if (this.hasIncompatibleIsolatedFlags(source, target)) {
            return false;
        }
        if (this.containsTypeParams(target)) {
            if (source.paramTypes.size() != target.paramTypes.size()) {
                return false;
            }
            for (int i = 0; i < source.paramTypes.size(); ++i) {
                BType sourceParam = source.paramTypes.get(i);
                BType targetParam = target.paramTypes.get(i);
                boolean isTypeParam = TypeParamAnalyzer.isTypeParam(targetParam);
                if (!(isTypeParam ? !this.isAssignable(sourceParam, targetParam) : !this.isAssignable(targetParam, sourceParam))) continue;
                return false;
            }
            if (source.retType == null && target.retType == null) {
                return true;
            }
            if (source.retType == null || target.retType == null) {
                return false;
            }
            return this.isAssignable(source.retType, target.retType, unresolvedTypes);
        }
        return this.checkFunctionTypeEquality(source, target, unresolvedTypes, (s, t, ut) -> this.isAssignable(t, s, ut));
    }

    public boolean isInherentlyImmutableType(BType type) {
        if (this.isValueType(type)) {
            return true;
        }
        switch (type.tag) {
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    boolean isSelectivelyImmutableType(BType type) {
        return this.isSelectivelyImmutableType(type, false, new HashSet<BType>(), false);
    }

    boolean isSelectivelyImmutableType(BType type, boolean disallowReadOnlyObjects, boolean forceCheck) {
        return this.isSelectivelyImmutableType(type, disallowReadOnlyObjects, new HashSet<BType>(), forceCheck);
    }

    public boolean isSelectivelyImmutableType(BType type, Set<BType> unresolvedTypes) {
        return this.isSelectivelyImmutableType(type, false, unresolvedTypes, false);
    }

    private boolean isSelectivelyImmutableType(BType type, Set<BType> unresolvedTypes, boolean forceCheck) {
        return this.isSelectivelyImmutableType(type, false, unresolvedTypes, forceCheck);
    }

    private boolean isSelectivelyImmutableType(BType type, boolean disallowReadOnlyObjects, Set<BType> unresolvedTypes, boolean forceCheck) {
        if (this.isInherentlyImmutableType(type) || !(type instanceof SelectivelyImmutableReferenceType)) {
            return false;
        }
        if (!forceCheck && ((SelectivelyImmutableReferenceType)((Object)type)).getImmutableType() != null) {
            return true;
        }
        if (!unresolvedTypes.add(type)) {
            return true;
        }
        switch (type.tag) {
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
            case 19: {
                BType elementType = ((BArrayType)type).eType;
                return this.isInherentlyImmutableType(elementType) || this.isSelectivelyImmutableType(elementType, unresolvedTypes, forceCheck);
            }
            case 30: {
                BTupleType tupleType = (BTupleType)type;
                for (BType tupMemType : tupleType.tupleTypes) {
                    if (this.isInherentlyImmutableType(tupMemType) || this.isSelectivelyImmutableType(tupMemType, unresolvedTypes, forceCheck)) continue;
                    return false;
                }
                BType tupRestType = tupleType.restType;
                if (tupRestType == null) {
                    return true;
                }
                return this.isInherentlyImmutableType(tupRestType) || this.isSelectivelyImmutableType(tupRestType, unresolvedTypes, forceCheck);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    BType fieldType = field.type;
                    if (this.isInherentlyImmutableType(fieldType) || this.isSelectivelyImmutableType(fieldType, unresolvedTypes, forceCheck)) continue;
                    return false;
                }
                BType recordRestType = recordType.restFieldType;
                if (recordRestType == null || recordRestType == this.symTable.noType) {
                    return true;
                }
                return this.isInherentlyImmutableType(recordRestType) || this.isSelectivelyImmutableType(recordRestType, unresolvedTypes, forceCheck);
            }
            case 15: {
                BType constraintType = ((BMapType)type).constraint;
                return this.isInherentlyImmutableType(constraintType) || this.isSelectivelyImmutableType(constraintType, unresolvedTypes, forceCheck);
            }
            case 33: {
                BObjectType objectType = (BObjectType)type;
                if (Symbols.isFlagOn(objectType.tsymbol.flags, 0x10000000L) && (disallowReadOnlyObjects || !Symbols.isFlagOn(objectType.flags, 32L))) {
                    return false;
                }
                for (BField field : objectType.fields.values()) {
                    BType fieldType = field.type;
                    if (this.isInherentlyImmutableType(fieldType) || this.isSelectivelyImmutableType(fieldType, unresolvedTypes, forceCheck)) continue;
                    return false;
                }
                return true;
            }
            case 9: {
                BType tableConstraintType = ((BTableType)type).constraint;
                return this.isInherentlyImmutableType(tableConstraintType) || this.isSelectivelyImmutableType(tableConstraintType, unresolvedTypes, forceCheck);
            }
            case 20: {
                boolean readonlyIntersectionExists = false;
                for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                    if (!this.isInherentlyImmutableType(memberType) && !this.isSelectivelyImmutableType(memberType, disallowReadOnlyObjects, unresolvedTypes, forceCheck)) continue;
                    readonlyIntersectionExists = true;
                }
                return readonlyIntersectionExists;
            }
            case 21: {
                return this.isSelectivelyImmutableType(((BIntersectionType)type).effectiveType, false, unresolvedTypes, forceCheck);
            }
        }
        return false;
    }

    private boolean containsTypeParams(BInvokableType type) {
        boolean hasParameterizedTypes = type.paramTypes.stream().anyMatch(t -> {
            if (t.tag == 35) {
                return this.containsTypeParams((BInvokableType)t);
            }
            return TypeParamAnalyzer.isTypeParam(t);
        });
        if (hasParameterizedTypes) {
            return hasParameterizedTypes;
        }
        if (type.retType.tag == 35) {
            return this.containsTypeParams((BInvokableType)type.retType);
        }
        return TypeParamAnalyzer.isTypeParam(type.retType);
    }

    private boolean isSameFunctionType(BInvokableType source, BInvokableType target, Set<TypePair> unresolvedTypes) {
        return this.checkFunctionTypeEquality(source, target, unresolvedTypes, this::isSameType);
    }

    private boolean checkFunctionTypeEquality(BInvokableType source, BInvokableType target, Set<TypePair> unresolvedTypes, TypeEqualityPredicate equality) {
        if (this.hasIncompatibleIsolatedFlags(source, target)) {
            return false;
        }
        if (source.paramTypes.size() != target.paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < source.paramTypes.size(); ++i) {
            if (equality.test(source.paramTypes.get(i), target.paramTypes.get(i), unresolvedTypes)) continue;
            return false;
        }
        if (source.restType != null && target.restType == null || target.restType != null && source.restType == null) {
            return false;
        }
        if (source.restType != null && !equality.test(source.restType, target.restType, unresolvedTypes)) {
            return false;
        }
        if (source.retType == null && target.retType == null) {
            return true;
        }
        if (source.retType == null || target.retType == null) {
            return false;
        }
        return this.isAssignable(source.retType, target.retType, unresolvedTypes);
    }

    private boolean hasIncompatibleIsolatedFlags(BInvokableType source, BInvokableType target) {
        return Symbols.isFlagOn(target.flags, 0x20000000L) && !Symbols.isFlagOn(source.flags, 0x20000000L);
    }

    public boolean isSameArrayType(BType source, BType target, Set<TypePair> unresolvedTypes) {
        if (target.tag != 19 || source.tag != 19) {
            return false;
        }
        BArrayType lhsArrayType = (BArrayType)target;
        BArrayType rhsArrayType = (BArrayType)source;
        boolean hasSameTypeElements = this.isSameType(lhsArrayType.eType, rhsArrayType.eType, unresolvedTypes);
        if (lhsArrayType.state == BArrayState.OPEN) {
            return rhsArrayType.state == BArrayState.OPEN && hasSameTypeElements;
        }
        return this.checkSealedArraySizeEquality(rhsArrayType, lhsArrayType) && hasSameTypeElements;
    }

    public boolean checkSealedArraySizeEquality(BArrayType rhsArrayType, BArrayType lhsArrayType) {
        return lhsArrayType.size == rhsArrayType.size;
    }

    public boolean checkStructEquivalency(BType rhsType, BType lhsType) {
        return this.checkStructEquivalency(rhsType, lhsType, new HashSet<TypePair>());
    }

    private boolean checkStructEquivalency(BType rhsType, BType lhsType, Set<TypePair> unresolvedTypes) {
        TypePair pair = new TypePair(rhsType, lhsType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        if (rhsType.tag == 33 && lhsType.tag == 33) {
            return this.checkObjectEquivalency((BObjectType)rhsType, (BObjectType)lhsType, unresolvedTypes);
        }
        if (rhsType.tag == 12 && lhsType.tag == 12) {
            return this.checkRecordEquivalency((BRecordType)rhsType, (BRecordType)lhsType, unresolvedTypes);
        }
        return false;
    }

    public boolean checkObjectEquivalency(BObjectType rhsType, BObjectType lhsType, Set<TypePair> unresolvedTypes) {
        if (Symbols.isFlagOn(lhsType.flags, 0x20000000L) && !Symbols.isFlagOn(rhsType.flags, 0x20000000L)) {
            return false;
        }
        BObjectTypeSymbol lhsStructSymbol = (BObjectTypeSymbol)lhsType.tsymbol;
        BObjectTypeSymbol rhsStructSymbol = (BObjectTypeSymbol)rhsType.tsymbol;
        List lhsFuncs = lhsStructSymbol.attachedFuncs;
        List rhsFuncs = ((BObjectTypeSymbol)rhsType.tsymbol).attachedFuncs;
        int lhsAttachedFuncCount = this.getObjectFuncCount(lhsStructSymbol);
        int rhsAttachedFuncCount = this.getObjectFuncCount(rhsStructSymbol);
        if (this.isServiceObject(lhsStructSymbol) && !this.isServiceObject(rhsStructSymbol)) {
            return false;
        }
        if (lhsType.fields.size() > rhsType.fields.size() || lhsAttachedFuncCount > rhsAttachedFuncCount) {
            return false;
        }
        for (BField bField : lhsType.fields.values()) {
            if (!Symbols.isPrivate(bField.symbol)) continue;
            return false;
        }
        for (BAttachedFunction func : lhsFuncs) {
            if (!Symbols.isPrivate(func.symbol)) continue;
            return false;
        }
        for (BField lhsField : lhsType.fields.values()) {
            BField rhsField = (BField)rhsType.fields.get(lhsField.name.value);
            if (rhsField == null || !this.isInSameVisibilityRegion(lhsField.symbol, rhsField.symbol) || !this.isAssignable(rhsField.type, lhsField.type, unresolvedTypes)) {
                return false;
            }
            if (!Symbols.isResource(lhsField.symbol) || Symbols.isResource(rhsField.symbol)) continue;
            return false;
        }
        for (BAttachedFunction lhsFunc : lhsFuncs) {
            if (lhsFunc == lhsStructSymbol.initializerFunc) continue;
            BAttachedFunction rhsFunc = this.getMatchingInvokableType(rhsFuncs, lhsFunc, unresolvedTypes);
            if (rhsFunc == null || !this.isInSameVisibilityRegion(lhsFunc.symbol, rhsFunc.symbol)) {
                return false;
            }
            if (Symbols.isRemote(lhsFunc.symbol) == Symbols.isRemote(rhsFunc.symbol)) continue;
            return false;
        }
        return lhsType.typeIdSet.isAssignableFrom(rhsType.typeIdSet);
    }

    private boolean isServiceObject(BObjectTypeSymbol rhsStructSymbol) {
        return (rhsStructSymbol.flags & 0x40000L) == 262144L;
    }

    private int getObjectFuncCount(BObjectTypeSymbol sym) {
        if (sym.initializerFunc != null && sym.attachedFuncs.contains(sym.initializerFunc)) {
            return sym.attachedFuncs.size() - 1;
        }
        return sym.attachedFuncs.size();
    }

    public boolean checkRecordEquivalency(BRecordType rhsType, BRecordType lhsType, Set<TypePair> unresolvedTypes) {
        if (lhsType.sealed && !rhsType.sealed) {
            return false;
        }
        if (!rhsType.sealed && !this.isAssignable(rhsType.restFieldType, lhsType.restFieldType, unresolvedTypes)) {
            return false;
        }
        return this.checkFieldEquivalency(lhsType, rhsType, unresolvedTypes);
    }

    public void setForeachTypedBindingPatternType(BLangForeach foreachNode) {
        BType varType;
        BType collectionType = foreachNode.collection.type;
        switch (collectionType.tag) {
            case 5: {
                varType = this.symTable.stringType;
                break;
            }
            case 19: {
                BArrayType arrayType = (BArrayType)collectionType;
                varType = arrayType.eType;
                break;
            }
            case 30: {
                BTupleType tupleType = (BTupleType)collectionType;
                LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>(tupleType.tupleTypes);
                if (tupleType.restType != null) {
                    tupleTypes.add(tupleType.restType);
                }
                varType = tupleTypes.size() == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(null, tupleTypes);
                break;
            }
            case 15: {
                BMapType bMapType = (BMapType)collectionType;
                varType = bMapType.constraint;
                break;
            }
            case 12: {
                BRecordType recordType = (BRecordType)collectionType;
                varType = this.inferRecordFieldType(recordType);
                break;
            }
            case 8: {
                varType = BUnionType.create(null, this.symTable.xmlType, this.symTable.stringType);
                break;
            }
            case 9: {
                BTableType tableType = (BTableType)collectionType;
                varType = tableType.constraint;
                break;
            }
            case 14: {
                BStreamType streamType = (BStreamType)collectionType;
                if (streamType.constraint.tag == 23) {
                    varType = this.symTable.anydataType;
                    break;
                }
                varType = streamType.constraint;
                if (streamType.error == null) break;
                BUnionType actualType = BUnionType.create(null, varType, streamType.error);
                this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, varType, actualType);
                break;
            }
            case 33: {
                BUnionType nextMethodReturnType = this.getVarTypeFromIterableObject((BObjectType)collectionType);
                if (nextMethodReturnType != null) {
                    foreachNode.resultType = this.getRecordType(nextMethodReturnType);
                    BType valueType = foreachNode.resultType != null ? ((BField)((BRecordType)foreachNode.resultType).fields.get((Object)"value")).type : null;
                    BErrorType errorType = this.getErrorType(nextMethodReturnType);
                    if (errorType != null) {
                        BUnionType actualType = BUnionType.create(null, valueType, errorType);
                        this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, valueType, actualType);
                    }
                    foreachNode.nillableResultType = nextMethodReturnType;
                    foreachNode.varType = valueType;
                    return;
                }
                this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.INCOMPATIBLE_ITERATOR_FUNCTION_SIGNATURE, new Object[0]);
            }
            case 27: {
                foreachNode.varType = this.symTable.semanticError;
                foreachNode.resultType = this.symTable.semanticError;
                foreachNode.nillableResultType = this.symTable.semanticError;
                return;
            }
            default: {
                foreachNode.varType = this.symTable.semanticError;
                foreachNode.resultType = this.symTable.semanticError;
                foreachNode.nillableResultType = this.symTable.semanticError;
                this.dlog.error(foreachNode.collection.pos, DiagnosticErrorCode.ITERABLE_NOT_SUPPORTED_COLLECTION, collectionType);
                return;
            }
        }
        BInvokableSymbol iteratorSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, this.names.fromString("iterator"));
        BUnionType nextMethodReturnType = (BUnionType)this.getResultTypeOfNextInvocation((BObjectType)iteratorSymbol.retType);
        foreachNode.varType = varType;
        foreachNode.resultType = this.getRecordType(nextMethodReturnType);
        foreachNode.nillableResultType = nextMethodReturnType;
    }

    public void setInputClauseTypedBindingPatternType(BLangInputClause bLangInputClause) {
        BType varType;
        if (bLangInputClause.collection == null) {
            return;
        }
        BType collectionType = bLangInputClause.collection.type;
        switch (collectionType.tag) {
            case 5: {
                varType = this.symTable.stringType;
                break;
            }
            case 19: {
                BArrayType arrayType = (BArrayType)collectionType;
                varType = arrayType.eType;
                break;
            }
            case 30: {
                BTupleType tupleType = (BTupleType)collectionType;
                LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>(tupleType.tupleTypes);
                if (tupleType.restType != null) {
                    tupleTypes.add(tupleType.restType);
                }
                varType = tupleTypes.size() == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(null, tupleTypes);
                break;
            }
            case 15: {
                BMapType bMapType = (BMapType)collectionType;
                varType = bMapType.constraint;
                break;
            }
            case 12: {
                BRecordType recordType = (BRecordType)collectionType;
                varType = this.inferRecordFieldType(recordType);
                break;
            }
            case 8: {
                varType = BUnionType.create(null, this.symTable.xmlType, this.symTable.stringType);
                break;
            }
            case 9: {
                BTableType tableType = (BTableType)collectionType;
                varType = tableType.constraint;
                break;
            }
            case 14: {
                BStreamType streamType = (BStreamType)collectionType;
                if (streamType.constraint.tag == 23) {
                    varType = this.symTable.anydataType;
                    break;
                }
                varType = streamType.constraint;
                break;
            }
            case 33: {
                BUnionType nextMethodReturnType = this.getVarTypeFromIterableObject((BObjectType)collectionType);
                if (nextMethodReturnType != null) {
                    bLangInputClause.resultType = this.getRecordType(nextMethodReturnType);
                    bLangInputClause.nillableResultType = nextMethodReturnType;
                    bLangInputClause.varType = ((BField)((BRecordType)bLangInputClause.resultType).fields.get((Object)"value")).type;
                    return;
                }
                this.dlog.error(bLangInputClause.collection.pos, DiagnosticErrorCode.INCOMPATIBLE_ITERATOR_FUNCTION_SIGNATURE, new Object[0]);
            }
            case 27: {
                bLangInputClause.varType = this.symTable.semanticError;
                bLangInputClause.resultType = this.symTable.semanticError;
                bLangInputClause.nillableResultType = this.symTable.semanticError;
                return;
            }
            default: {
                bLangInputClause.varType = this.symTable.semanticError;
                bLangInputClause.resultType = this.symTable.semanticError;
                bLangInputClause.nillableResultType = this.symTable.semanticError;
                this.dlog.error(bLangInputClause.collection.pos, DiagnosticErrorCode.ITERABLE_NOT_SUPPORTED_COLLECTION, collectionType);
                return;
            }
        }
        BInvokableSymbol iteratorSymbol = (BInvokableSymbol)this.symResolver.lookupLangLibMethod(collectionType, this.names.fromString("iterator"));
        BUnionType nextMethodReturnType = (BUnionType)this.getResultTypeOfNextInvocation((BObjectType)iteratorSymbol.retType);
        bLangInputClause.varType = varType;
        bLangInputClause.resultType = this.getRecordType(nextMethodReturnType);
        bLangInputClause.nillableResultType = nextMethodReturnType;
    }

    public BUnionType getVarTypeFromIterableObject(BObjectType collectionType) {
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)collectionType.tsymbol;
        for (BAttachedFunction func : objectTypeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("__iterator")) continue;
            return this.getVarTypeFromIteratorFunc(func);
        }
        return null;
    }

    private BUnionType getVarTypeFromIteratorFunc(BAttachedFunction candidateIteratorFunc) {
        if (!candidateIteratorFunc.type.paramTypes.isEmpty()) {
            return null;
        }
        BType returnType = candidateIteratorFunc.type.retType;
        return this.getVarTypeFromIteratorFuncReturnType(returnType);
    }

    public BUnionType getVarTypeFromIteratorFuncReturnType(BType returnType) {
        if (returnType.tag != 33) {
            return null;
        }
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)returnType.tsymbol;
        for (BAttachedFunction func : objectTypeSymbol.attachedFuncs) {
            if (!func.funcName.value.equals("next")) continue;
            return this.getVarTypeFromNextFunc(func);
        }
        return null;
    }

    private BUnionType getVarTypeFromNextFunc(BAttachedFunction nextFunc) {
        if (!nextFunc.type.paramTypes.isEmpty()) {
            return null;
        }
        BType returnType = nextFunc.type.retType;
        if (this.checkNextFuncReturnType(returnType)) {
            return (BUnionType)returnType;
        }
        return null;
    }

    private boolean checkNextFuncReturnType(BType returnType) {
        if (returnType.tag != 20) {
            return false;
        }
        ArrayList<BType> types = new ArrayList<BType>(((BUnionType)returnType).getMemberTypes());
        if (!types.removeIf(type -> type.tag == 10)) {
            return false;
        }
        types.removeIf(type -> type.tag == 28);
        if (types.size() != 1) {
            return false;
        }
        if (((BType)types.get((int)0)).tag != 12) {
            return false;
        }
        BRecordType recordType = (BRecordType)types.get(0);
        return this.checkRecordTypeInNextFuncReturnType(recordType);
    }

    private boolean checkRecordTypeInNextFuncReturnType(BRecordType recordType) {
        if (!recordType.sealed) {
            return false;
        }
        if (recordType.fields.size() != 1) {
            return false;
        }
        return recordType.fields.containsKey("value");
    }

    private BRecordType getRecordType(BUnionType type) {
        for (BType member : type.getMemberTypes()) {
            if (member.tag != 12) continue;
            return (BRecordType)member;
        }
        return null;
    }

    public BErrorType getErrorType(BUnionType type) {
        for (BType member : type.getMemberTypes()) {
            BErrorType e;
            if (member.tag == 28) {
                return (BErrorType)member;
            }
            if (member.tag != 20 || (e = this.getErrorType((BUnionType)member)) == null) continue;
            return e;
        }
        return null;
    }

    public BType getResultTypeOfNextInvocation(BObjectType iteratorType) {
        BAttachedFunction nextFunc = this.getAttachedFuncFromObject(iteratorType, "next");
        return Objects.requireNonNull(nextFunc).type.retType;
    }

    public BAttachedFunction getAttachedFuncFromObject(BObjectType objectType, String funcName) {
        BObjectTypeSymbol iteratorSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        for (BAttachedFunction bAttachedFunction : iteratorSymbol.attachedFuncs) {
            if (!funcName.equals(bAttachedFunction.funcName.value)) continue;
            return bAttachedFunction;
        }
        return null;
    }

    public BType inferRecordFieldType(BRecordType recordType) {
        LinkedHashMap fields = recordType.fields;
        BUnionType unionType = BUnionType.create(null, new BType[0]);
        if (!recordType.sealed) {
            unionType.add(recordType.restFieldType);
        }
        for (BField field : fields.values()) {
            if (this.isAssignable(field.type, unionType)) continue;
            if (this.isAssignable(unionType, field.type)) {
                unionType = BUnionType.create(null, new BType[0]);
            }
            unionType.add(field.type);
        }
        if (unionType.getMemberTypes().size() > 1) {
            unionType.tsymbol = Symbols.createTypeSymbol(2162716, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, recordType.tsymbol.pkgID, null, recordType.tsymbol.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            return unionType;
        }
        return unionType.getMemberTypes().iterator().next();
    }

    TypeTestResult isBuiltInTypeWidenPossible(BType actualType, BType targetType) {
        int targetTag = targetType.tag;
        int actualTag = actualType.tag;
        if (actualTag < 7 && targetTag < 7) {
            switch (actualTag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (targetTag != 6 && targetTag != 5) break;
                    return TypeTestResult.FALSE;
                }
                case 6: {
                    if (targetTag != 1 && targetTag != 2 && targetTag != 3 && targetTag != 4 && targetTag != 5) break;
                    return TypeTestResult.FALSE;
                }
                case 5: {
                    if (targetTag != 1 && targetTag != 2 && targetTag != 3 && targetTag != 4 && targetTag != 6) break;
                    return TypeTestResult.FALSE;
                }
            }
        }
        switch (actualTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (targetTag != 7 && targetTag != 11 && targetTag != 17 && targetTag != 37) break;
                return TypeTestResult.TRUE;
            }
            case 11: 
            case 13: {
                if (targetTag != 17) break;
                return TypeTestResult.TRUE;
            }
        }
        if (TypeTags.isIntegerTypeTag(targetTag) && actualTag == targetTag) {
            return TypeTestResult.FALSE;
        }
        if ((TypeTags.isIntegerTypeTag(actualTag) || actualTag == 2) && (TypeTags.isIntegerTypeTag(targetTag) || targetTag == 2)) {
            return this.checkBuiltInIntSubtypeWidenPossible(actualType, targetType);
        }
        if (actualTag == 44 && 5 == targetTag) {
            return TypeTestResult.TRUE;
        }
        return TypeTestResult.NOT_FOUND;
    }

    private TypeTestResult checkBuiltInIntSubtypeWidenPossible(BType actualType, BType targetType) {
        int actualTag = actualType.tag;
        switch (targetType.tag) {
            case 1: {
                if (actualTag != 2 && !TypeTags.isIntegerTypeTag(actualTag)) break;
                return TypeTestResult.TRUE;
            }
            case 38: {
                if (actualTag != 39 && actualTag != 40 && actualTag != 42 && actualTag != 43 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 39: {
                if (actualTag != 40 && actualTag != 43 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 41: {
                if (actualTag != 42 && actualTag != 43 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 42: {
                if (actualTag != 43 && actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
            case 2: {
                if (actualTag != 43) break;
                return TypeTestResult.TRUE;
            }
            case 43: {
                if (actualTag != 2) break;
                return TypeTestResult.TRUE;
            }
        }
        return TypeTestResult.NOT_FOUND;
    }

    public boolean isImplicityCastable(BType actualType, BType targetType) {
        BType newTargetType = targetType;
        if ((targetType.tag == 20 || targetType.tag == 32) && this.isValueType(actualType)) {
            newTargetType = this.symTable.anyType;
        } else if (targetType.tag == 21) {
            newTargetType = ((BIntersectionType)targetType).effectiveType;
        }
        TypeTestResult result = this.isBuiltInTypeWidenPossible(actualType, newTargetType);
        if (result != TypeTestResult.NOT_FOUND) {
            return result == TypeTestResult.TRUE;
        }
        if (this.isValueType(targetType) && (actualType.tag == 32 || actualType.tag == 20 && ((BUnionType)actualType).getMemberTypes().stream().anyMatch(type -> type.tag == 32 && this.isAssignable((BType)type, targetType)))) {
            return targetType.tag == 1 || targetType.tag == 2 || targetType.tag == 3 || targetType.tag == 5 || targetType.tag == 6;
        }
        if (targetType.tag == 28 && actualType.tag == 20 && this.isAllErrorMembers((BUnionType)actualType)) {
            return true;
        }
        return targetType.tag == 5 && actualType.tag == 48;
    }

    public boolean isTypeCastable(BLangExpression expr, BType sourceType, BType targetType) {
        if (sourceType.tag == 27 || targetType.tag == 27 || sourceType == targetType) {
            return true;
        }
        if (this.isAssignable(sourceType, targetType) || this.isAssignable(targetType, sourceType)) {
            return true;
        }
        if (this.isNumericConversionPossible(expr, sourceType, targetType)) {
            return true;
        }
        boolean validTypeCast = false;
        if (sourceType.tag == 20 && this.getTypeForUnionTypeMembersAssignableToType((BUnionType)sourceType, targetType) != this.symTable.semanticError) {
            validTypeCast = true;
        }
        if (targetType.tag == 20 && this.getTypeForUnionTypeMembersAssignableToType((BUnionType)targetType, sourceType) != this.symTable.semanticError) {
            validTypeCast = true;
        }
        if (sourceType.tag == 32 && this.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)sourceType, targetType) != this.symTable.semanticError) {
            validTypeCast = true;
        }
        if (targetType.tag == 32 && this.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)targetType, sourceType) != this.symTable.semanticError) {
            validTypeCast = true;
        }
        if (validTypeCast) {
            if (this.isValueType(sourceType)) {
                this.setImplicitCastExpr(expr, sourceType, this.symTable.anyType);
            }
            return true;
        }
        return false;
    }

    boolean isNumericConversionPossible(BLangExpression expr, BType sourceType, BType targetType) {
        boolean isSourceNumericType = this.isBasicNumericType(sourceType);
        boolean isTargetNumericType = this.isBasicNumericType(targetType);
        if (isSourceNumericType && isTargetNumericType) {
            return true;
        }
        if (targetType.tag == 20) {
            HashSet<Integer> typeTags = new HashSet<Integer>();
            for (BType bType : ((BUnionType)targetType).getMemberTypes()) {
                if (!this.isBasicNumericType(bType)) continue;
                typeTags.add(bType.tag);
                if (typeTags.size() <= 1) continue;
                return false;
            }
        }
        if (!isTargetNumericType && targetType.tag != 20) {
            return false;
        }
        if (isSourceNumericType) {
            this.setImplicitCastExpr(expr, sourceType, this.symTable.anyType);
            return true;
        }
        switch (sourceType.tag) {
            case 7: 
            case 11: 
            case 17: {
                return true;
            }
            case 20: {
                for (BType memType : ((BUnionType)sourceType).getMemberTypes()) {
                    if (!this.isBasicNumericType(memType) && (memType.tag != 32 || !this.finiteTypeContainsNumericTypeValues((BFiniteType)memType))) continue;
                    return true;
                }
                break;
            }
            case 32: {
                if (!this.finiteTypeContainsNumericTypeValues((BFiniteType)sourceType)) break;
                return true;
            }
        }
        return false;
    }

    private boolean isAllErrorMembers(BUnionType actualType) {
        return actualType.getMemberTypes().stream().allMatch(t -> this.isAssignable((BType)t, this.symTable.errorType));
    }

    public void setImplicitCastExpr(BLangExpression expr, BType actualType, BType expType) {
        if (!this.isImplicityCastable(actualType, expType)) {
            return;
        }
        BLangTypeConversionExpr implicitConversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        implicitConversionExpr.pos = expr.pos;
        implicitConversionExpr.expr = expr.impConversionExpr == null ? expr : expr.impConversionExpr;
        implicitConversionExpr.type = expType;
        implicitConversionExpr.targetType = expType;
        implicitConversionExpr.internal = true;
        expr.impConversionExpr = implicitConversionExpr;
    }

    public BType getElementType(BType type) {
        if (type.tag != 19) {
            return type;
        }
        return this.getElementType(((BArrayType)type).getElementType());
    }

    public boolean checkListenerCompatibility(BType type) {
        if (type.tag != 33) {
            return false;
        }
        BObjectType rhsType = (BObjectType)type;
        List<BAttachedFunction> rhsFuncs = ((BStructureTypeSymbol)rhsType.tsymbol).attachedFuncs;
        ListenerValidationModel listenerValidationModel = new ListenerValidationModel(this, this.symTable);
        return listenerValidationModel.checkMethods(rhsFuncs);
    }

    public boolean isValidErrorDetailType(BType detailType) {
        switch (detailType.tag) {
            case 15: {
                return this.isAssignable(detailType, this.symTable.detailType);
            }
            case 12: {
                if (this.isSealed((BRecordType)detailType)) {
                    return false;
                }
                return this.isAssignable(detailType, this.symTable.detailType);
            }
        }
        return false;
    }

    private boolean isSealed(BRecordType recordType) {
        return recordType.sealed;
    }

    private boolean isNullable(BType fieldType) {
        return fieldType.isNullable();
    }

    private boolean checkFieldEquivalency(BRecordType lhsType, BRecordType rhsType, Set<TypePair> unresolvedTypes) {
        LinkedHashMap rhsFields = new LinkedHashMap(rhsType.fields);
        for (BField lhsField : lhsType.fields.values()) {
            BField rhsField = (BField)rhsFields.get(lhsField.name.value);
            if (rhsField == null) {
                return false;
            }
            if (this.hasIncompatibleReadOnlyFlags(lhsField.symbol.flags, rhsField.symbol.flags)) {
                return false;
            }
            if (!Symbols.isOptional(lhsField.symbol) && Symbols.isOptional(rhsField.symbol)) {
                return false;
            }
            if (!this.isAssignable(rhsField.type, lhsField.type, unresolvedTypes)) {
                return false;
            }
            rhsFields.remove(lhsField.name.value);
        }
        return rhsFields.entrySet().stream().allMatch(fieldEntry -> this.isAssignable(((BField)fieldEntry.getValue()).type, lhsType.restFieldType, unresolvedTypes));
    }

    private BAttachedFunction getMatchingInvokableType(List<BAttachedFunction> rhsFuncList, BAttachedFunction lhsFunc, Set<TypePair> unresolvedTypes) {
        return rhsFuncList.stream().filter(rhsFunc -> lhsFunc.funcName.equals(rhsFunc.funcName)).filter(rhsFunc -> this.isFunctionTypeAssignable(rhsFunc.type, lhsFunc.type, unresolvedTypes)).findFirst().orElse(null);
    }

    private boolean isInSameVisibilityRegion(BSymbol lhsSym, BSymbol rhsSym) {
        if (Symbols.isPrivate(lhsSym)) {
            return Symbols.isPrivate(rhsSym) && lhsSym.pkgID.equals(rhsSym.pkgID) && lhsSym.owner.name.equals(rhsSym.owner.name);
        }
        if (Symbols.isPublic(lhsSym)) {
            return Symbols.isPublic(rhsSym);
        }
        return !Symbols.isPrivate(rhsSym) && !Symbols.isPublic(rhsSym) && lhsSym.pkgID.equals(rhsSym.pkgID);
    }

    private boolean isAssignableToUnionType(BType source, BType target, Set<TypePair> unresolvedTypes) {
        LinkedHashSet<BType> sourceTypes = new LinkedHashSet<BType>();
        LinkedHashSet<BType> targetTypes = new LinkedHashSet<BType>();
        if (source.tag == 20) {
            sourceTypes.addAll(this.getEffectiveMemberTypes((BUnionType)source));
        } else {
            sourceTypes.add(source);
        }
        if (target.tag == 20) {
            targetTypes.addAll(this.getEffectiveMemberTypes((BUnionType)target));
        } else {
            targetTypes.add(target);
        }
        for (BType s : sourceTypes) {
            if (s.tag == 49) continue;
            boolean isAssignableToAnyTargetType = true;
            for (BType t : targetTypes) {
                if (!this.isAssignable(s, t, unresolvedTypes)) continue;
                isAssignableToAnyTargetType = false;
                break;
            }
            if (!isAssignableToAnyTargetType || s.tag == 32 && this.isAssignable(s, target, unresolvedTypes) || s.tag == 8 && this.isAssignableToUnionType(this.expandedXMLBuiltinSubtypes, target, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private Set<BType> getEffectiveMemberTypes(BUnionType unionType) {
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>();
        for (BType memberType : unionType.getMemberTypes()) {
            if (memberType.tag == 21) {
                BType effectiveType = ((BIntersectionType)memberType).effectiveType;
                if (effectiveType.tag == 20) {
                    memTypes.addAll(this.getEffectiveMemberTypes((BUnionType)effectiveType));
                    continue;
                }
                memTypes.add(effectiveType);
                continue;
            }
            memTypes.add(memberType);
        }
        return memTypes;
    }

    private boolean isFiniteTypeAssignable(BFiniteType finiteType, BType targetType, Set<TypePair> unresolvedTypes) {
        if (targetType.tag == 32) {
            return finiteType.getValueSpace().stream().allMatch(expression -> this.isAssignableToFiniteType(targetType, (BLangLiteral)expression));
        }
        if (targetType.tag == 20) {
            List<BType> unionMemberTypes = this.getAllTypes(targetType);
            return finiteType.getValueSpace().stream().allMatch(valueExpr -> unionMemberTypes.stream().anyMatch(targetMemType -> targetMemType.tag == 32 ? this.isAssignableToFiniteType((BType)targetMemType, (BLangLiteral)valueExpr) : this.isAssignable(valueExpr.type, targetType, unresolvedTypes)));
        }
        return finiteType.getValueSpace().stream().allMatch(expression -> this.isAssignable(expression.type, targetType, unresolvedTypes));
    }

    boolean isAssignableToFiniteType(BType type, BLangLiteral literalExpr) {
        if (type.tag != 32) {
            return false;
        }
        BFiniteType expType = (BFiniteType)type;
        return expType.getValueSpace().stream().anyMatch(memberLiteral -> {
            if (((BLangLiteral)memberLiteral).value == null) {
                return literalExpr.value == null;
            }
            return this.checkLiteralAssignabilityBasedOnType((BLangLiteral)memberLiteral, literalExpr);
        });
    }

    boolean checkLiteralAssignabilityBasedOnType(BLangLiteral baseLiteral, BLangLiteral candidateLiteral) {
        if (baseLiteral.getKind() != candidateLiteral.getKind()) {
            return false;
        }
        Object baseValue = baseLiteral.value;
        Object candidateValue = candidateLiteral.value;
        int candidateTypeTag = candidateLiteral.type.tag;
        switch (baseLiteral.type.tag) {
            case 2: {
                if (candidateTypeTag != 2 && (candidateTypeTag != 1 || candidateLiteral.isConstant || !this.isByteLiteralValue((Long)candidateValue))) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 1: {
                if (candidateTypeTag != 1) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 38: {
                if (candidateTypeTag != 1 || !this.isSigned32LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 39: {
                if (candidateTypeTag != 1 || !this.isSigned16LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 40: {
                if (candidateTypeTag != 1 || !this.isSigned8LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 41: {
                if (candidateTypeTag != 1 || !this.isUnsigned32LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 42: {
                if (candidateTypeTag != 1 || !this.isUnsigned16LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 43: {
                if (candidateTypeTag != 1 || !this.isUnsigned8LiteralValue((Long)candidateValue)) break;
                return ((Number)baseValue).longValue() == ((Number)candidateValue).longValue();
            }
            case 3: {
                String originalValue;
                String baseValueStr = String.valueOf(baseValue);
                String string = originalValue = baseLiteral.originalValue != null ? baseLiteral.originalValue : baseValueStr;
                if (NumericLiteralSupport.isDecimalDiscriminated(originalValue)) {
                    return false;
                }
                double baseDoubleVal = Double.parseDouble(baseValueStr);
                if (candidateTypeTag == 1 && !candidateLiteral.isConstant) {
                    double candidateDoubleVal = ((Long)candidateValue).doubleValue();
                    return baseDoubleVal == candidateDoubleVal;
                }
                if (candidateTypeTag != 3) break;
                double candidateDoubleVal = Double.parseDouble(String.valueOf(candidateValue));
                return baseDoubleVal == candidateDoubleVal;
            }
            case 4: {
                BigDecimal baseDecimalVal = NumericLiteralSupport.parseBigDecimal(baseValue);
                if (candidateTypeTag == 1 && !candidateLiteral.isConstant) {
                    BigDecimal candidateDecimalVal = new BigDecimal((Long)candidateValue, MathContext.DECIMAL128);
                    return baseDecimalVal.compareTo(candidateDecimalVal) == 0;
                }
                if ((candidateTypeTag != 3 || candidateLiteral.isConstant) && candidateTypeTag != 4) break;
                if (NumericLiteralSupport.isFloatDiscriminated(String.valueOf(candidateValue))) {
                    return false;
                }
                BigDecimal candidateDecimalVal = NumericLiteralSupport.parseBigDecimal(candidateValue);
                return baseDecimalVal.compareTo(candidateDecimalVal) == 0;
            }
            default: {
                return baseValue.equals(candidateValue);
            }
        }
        return false;
    }

    boolean isByteLiteralValue(Long longObject) {
        return longObject.intValue() >= SymbolTable.BBYTE_MIN_VALUE && longObject.intValue() <= SymbolTable.BBYTE_MAX_VALUE;
    }

    boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)SymbolTable.SIGNED32_MIN_VALUE.intValue() && longObject <= (long)SymbolTable.SIGNED32_MAX_VALUE.intValue();
    }

    boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= SymbolTable.SIGNED16_MIN_VALUE && longObject.intValue() <= SymbolTable.SIGNED16_MAX_VALUE;
    }

    boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= SymbolTable.SIGNED8_MIN_VALUE && longObject.intValue() <= SymbolTable.SIGNED8_MAX_VALUE;
    }

    boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= SymbolTable.UNSIGNED32_MAX_VALUE;
    }

    boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= SymbolTable.UNSIGNED16_MAX_VALUE;
    }

    boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= SymbolTable.UNSIGNED8_MAX_VALUE;
    }

    boolean isCharLiteralValue(String literal) {
        return literal.codePoints().count() == 1L;
    }

    BType getTypeForFiniteTypeValuesAssignableToType(BFiniteType finiteType, BType targetType) {
        if (this.isAssignable(finiteType, targetType)) {
            return finiteType;
        }
        Set<BLangExpression> matchingValues = finiteType.getValueSpace().stream().filter(expr -> this.isAssignable(expr.type, targetType) || this.isAssignableToFiniteType(targetType, (BLangLiteral)expr) || targetType.tag == 20 && ((BUnionType)targetType).getMemberTypes().stream().filter(memType -> memType.tag == 32).anyMatch(filteredType -> this.isAssignableToFiniteType((BType)filteredType, (BLangLiteral)expr))).collect(Collectors.toSet());
        if (matchingValues.isEmpty()) {
            return this.symTable.semanticError;
        }
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(0x10001C, finiteType.tsymbol.flags, this.names.fromString("$anonType$_" + this.finiteTypeCount++), finiteType.tsymbol.pkgID, null, finiteType.tsymbol.owner, finiteType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BFiniteType intersectingFiniteType = new BFiniteType(finiteTypeSymbol, matchingValues);
        finiteTypeSymbol.type = intersectingFiniteType;
        return intersectingFiniteType;
    }

    BType getTypeForUnionTypeMembersAssignableToType(BUnionType unionType, BType targetType) {
        LinkedList intersection = new LinkedList();
        unionType.getMemberTypes().forEach(memType -> {
            if (memType.tag == 32) {
                BType finiteTypeWithMatches = this.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)memType, targetType);
                if (finiteTypeWithMatches != this.symTable.semanticError) {
                    intersection.add(finiteTypeWithMatches);
                }
            } else if (this.isAssignable((BType)memType, targetType)) {
                intersection.add(memType);
            }
        });
        if (intersection.isEmpty()) {
            return this.symTable.semanticError;
        }
        if (intersection.size() == 1) {
            return (BType)intersection.get(0);
        }
        return BUnionType.create(null, new LinkedHashSet<BType>(intersection));
    }

    boolean validEqualityIntersectionExists(BType lhsType, BType rhsType) {
        if (!lhsType.isPureType() || !rhsType.isPureType()) {
            return false;
        }
        if (this.isAssignable(lhsType, rhsType) || this.isAssignable(rhsType, lhsType)) {
            return true;
        }
        Set<BType> lhsTypes = this.expandAndGetMemberTypesRecursive(lhsType);
        Set<BType> rhsTypes = this.expandAndGetMemberTypesRecursive(rhsType);
        return this.equalityIntersectionExists(lhsTypes, rhsTypes);
    }

    private boolean equalityIntersectionExists(Set<BType> lhsTypes, Set<BType> rhsTypes) {
        if (lhsTypes.contains(this.symTable.anydataType) && rhsTypes.stream().anyMatch(type -> type.tag != 28) || rhsTypes.contains(this.symTable.anydataType) && lhsTypes.stream().anyMatch(type -> type.tag != 28)) {
            return true;
        }
        boolean matchFound = lhsTypes.stream().anyMatch(s -> rhsTypes.stream().anyMatch(t -> this.isSameType((BType)s, (BType)t)));
        if (!matchFound) {
            matchFound = this.equalityIntersectionExistsForComplexTypes(lhsTypes, rhsTypes);
        }
        return matchFound;
    }

    public Set<BType> expandAndGetMemberTypesRecursive(BType bType) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>();
        switch (bType.tag) {
            case 1: 
            case 2: {
                memberTypes.add(this.symTable.intType);
                memberTypes.add(this.symTable.byteType);
                break;
            }
            case 32: {
                BFiniteType expType = (BFiniteType)bType;
                expType.getValueSpace().forEach(value -> memberTypes.add(value.type));
                break;
            }
            case 20: {
                BUnionType unionType = (BUnionType)bType;
                unionType.getMemberTypes().forEach(member -> memberTypes.addAll(this.expandAndGetMemberTypesRecursive((BType)member)));
                break;
            }
            case 19: {
                BType arrayElementType = ((BArrayType)bType).getElementType();
                if (((BArrayType)bType).getSize() != -1) {
                    memberTypes.add(new BArrayType(arrayElementType));
                }
                if (arrayElementType.tag == 20) {
                    Set<BType> elementUnionTypes = this.expandAndGetMemberTypesRecursive(arrayElementType);
                    elementUnionTypes.forEach(elementUnionType -> memberTypes.add(new BArrayType((BType)elementUnionType)));
                }
                memberTypes.add(bType);
                break;
            }
            case 15: {
                BType mapConstraintType = ((BMapType)bType).getConstraint();
                if (mapConstraintType.tag == 20) {
                    Set<BType> constraintUnionTypes = this.expandAndGetMemberTypesRecursive(mapConstraintType);
                    constraintUnionTypes.forEach(constraintUnionType -> memberTypes.add(new BMapType(15, (BType)constraintUnionType, this.symTable.mapType.tsymbol)));
                }
                memberTypes.add(bType);
                break;
            }
            default: {
                memberTypes.add(bType);
            }
        }
        return memberTypes;
    }

    private boolean tupleIntersectionExists(BTupleType lhsType, BTupleType rhsType) {
        if (lhsType.getTupleTypes().size() != rhsType.getTupleTypes().size()) {
            return false;
        }
        List<BType> lhsMemberTypes = lhsType.getTupleTypes();
        List<BType> rhsMemberTypes = rhsType.getTupleTypes();
        for (int i = 0; i < lhsType.getTupleTypes().size(); ++i) {
            if (this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(lhsMemberTypes.get(i)), this.expandAndGetMemberTypesRecursive(rhsMemberTypes.get(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean equalityIntersectionExistsForComplexTypes(Set<BType> lhsTypes, Set<BType> rhsTypes) {
        for (BType lhsMemberType : lhsTypes) {
            switch (lhsMemberType.tag) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: {
                    if (!rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 7)) break;
                    return true;
                }
                case 7: {
                    if (!this.jsonEqualityIntersectionExists(rhsTypes)) break;
                    return true;
                }
                case 30: {
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 30 && this.tupleIntersectionExists((BTupleType)lhsMemberType, (BTupleType)rhsMemberType))) {
                        return true;
                    }
                    if (!rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 19 && this.arrayTupleEqualityIntersectionExists((BArrayType)rhsMemberType, (BTupleType)lhsMemberType))) break;
                    return true;
                }
                case 19: {
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 19 && this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(((BArrayType)lhsMemberType).eType), this.expandAndGetMemberTypesRecursive(((BArrayType)rhsMemberType).eType)))) {
                        return true;
                    }
                    if (!rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 30 && this.arrayTupleEqualityIntersectionExists((BArrayType)lhsMemberType, (BTupleType)rhsMemberType))) break;
                    return true;
                }
                case 15: {
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 15 && this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(((BMapType)lhsMemberType).constraint), this.expandAndGetMemberTypesRecursive(((BMapType)rhsMemberType).constraint)))) {
                        return true;
                    }
                    if (!this.isAssignable(((BMapType)lhsMemberType).constraint, this.symTable.errorType) && rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 7)) {
                        return true;
                    }
                    if (!rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 12 && this.mapRecordEqualityIntersectionExists((BMapType)lhsMemberType, (BRecordType)rhsMemberType))) break;
                    return true;
                }
                case 12: 
                case 33: {
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> this.checkStructEquivalency((BType)rhsMemberType, lhsMemberType) || this.checkStructEquivalency(lhsMemberType, (BType)rhsMemberType))) {
                        return true;
                    }
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 12 && this.recordEqualityIntersectionExists((BRecordType)lhsMemberType, (BRecordType)rhsMemberType))) {
                        return true;
                    }
                    if (rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 7) && this.jsonEqualityIntersectionExists(this.expandAndGetMemberTypesRecursive(lhsMemberType))) {
                        return true;
                    }
                    if (!rhsTypes.stream().anyMatch(rhsMemberType -> rhsMemberType.tag == 15 && this.mapRecordEqualityIntersectionExists((BMapType)rhsMemberType, (BRecordType)lhsMemberType))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean arrayTupleEqualityIntersectionExists(BArrayType arrayType, BTupleType tupleType) {
        Set<BType> elementTypes = this.expandAndGetMemberTypesRecursive(arrayType.eType);
        return tupleType.tupleTypes.stream().allMatch(tupleMemType -> this.equalityIntersectionExists(elementTypes, this.expandAndGetMemberTypesRecursive((BType)tupleMemType)));
    }

    private boolean recordEqualityIntersectionExists(BRecordType lhsType, BRecordType rhsType) {
        LinkedHashMap lhsFields = lhsType.fields;
        LinkedHashMap rhsFields = rhsType.fields;
        ArrayList<Name> matchedFieldNames = new ArrayList<Name>();
        for (BField lhsField : lhsFields.values()) {
            if (rhsFields.containsKey(lhsField.name.value)) {
                if (!this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(lhsField.type), this.expandAndGetMemberTypesRecursive(((BField)rhsFields.get((Object)lhsField.name.value)).type))) {
                    return false;
                }
                matchedFieldNames.add(lhsField.getName());
                continue;
            }
            if (Symbols.isFlagOn(lhsField.symbol.flags, 4096L)) break;
            if (rhsType.sealed) {
                return false;
            }
            if (this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(lhsField.type), this.expandAndGetMemberTypesRecursive(rhsType.restFieldType))) continue;
            return false;
        }
        for (BField rhsField : rhsFields.values()) {
            if (matchedFieldNames.contains(rhsField.getName()) || Symbols.isFlagOn(rhsField.symbol.flags, 4096L)) continue;
            if (lhsType.sealed) {
                return false;
            }
            if (this.equalityIntersectionExists(this.expandAndGetMemberTypesRecursive(rhsField.type), this.expandAndGetMemberTypesRecursive(lhsType.restFieldType))) continue;
            return false;
        }
        return true;
    }

    private boolean mapRecordEqualityIntersectionExists(BMapType mapType, BRecordType recordType) {
        Set<BType> mapConstrTypes = this.expandAndGetMemberTypesRecursive(mapType.getConstraint());
        for (BField field : recordType.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 4096L) || this.equalityIntersectionExists(mapConstrTypes, this.expandAndGetMemberTypesRecursive(field.type))) continue;
            return false;
        }
        return true;
    }

    private boolean jsonEqualityIntersectionExists(Set<BType> typeSet) {
        block4: for (BType type : typeSet) {
            switch (type.tag) {
                case 15: {
                    if (this.isAssignable(((BMapType)type).constraint, this.symTable.errorType)) continue block4;
                    return true;
                }
                case 12: {
                    BRecordType recordType = (BRecordType)type;
                    if (!recordType.fields.values().stream().allMatch(field -> Symbols.isFlagOn(field.symbol.flags, 4096L) || !this.isAssignable(field.type, this.symTable.errorType))) continue block4;
                    return true;
                }
            }
            if (!this.isAssignable(type, this.symTable.jsonType)) continue;
            return true;
        }
        return false;
    }

    public BType getRemainingType(BType originalType, BType typeToRemove) {
        switch (originalType.tag) {
            case 20: {
                return this.getRemainingType((BUnionType)originalType, this.getAllTypes(typeToRemove));
            }
            case 32: {
                return this.getRemainingType((BFiniteType)originalType, this.getAllTypes(typeToRemove));
            }
        }
        return originalType;
    }

    BType getTypeIntersection(BType lhsType, BType rhsType) {
        List<BType> narrowingTypes = this.getAllTypes(rhsType);
        LinkedHashSet intersection = narrowingTypes.stream().map(type -> {
            if (this.isAssignable((BType)type, lhsType)) {
                return type;
            }
            if (this.isAssignable(lhsType, (BType)type)) {
                return lhsType;
            }
            if (lhsType.tag == 32) {
                BType intersectionType = this.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)lhsType, (BType)type);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else if (type.tag == 32) {
                BType intersectionType = this.getTypeForFiniteTypeValuesAssignableToType((BFiniteType)type, lhsType);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else if (lhsType.tag == 20) {
                BType intersectionType = this.getTypeForUnionTypeMembersAssignableToType((BUnionType)lhsType, (BType)type);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else if (type.tag == 20) {
                BType intersectionType = this.getTypeForUnionTypeMembersAssignableToType((BUnionType)type, lhsType);
                if (intersectionType != this.symTable.semanticError) {
                    return intersectionType;
                }
            } else if (type.tag == 50) {
                return type;
            }
            return null;
        }).filter(type -> type != null).collect(Collectors.toCollection(LinkedHashSet::new));
        if (intersection.isEmpty()) {
            if (lhsType.tag == 50) {
                return lhsType;
            }
            return this.symTable.semanticError;
        }
        if (intersection.contains(this.symTable.semanticError)) {
            return this.symTable.semanticError;
        }
        if (intersection.size() == 1) {
            return intersection.toArray(new BType[0])[0];
        }
        return BUnionType.create(null, intersection);
    }

    private BType getRemainingType(BUnionType originalType, List<BType> removeTypes) {
        List<BType> remainingTypes = this.getAllTypes(originalType);
        removeTypes.forEach(removeType -> remainingTypes.removeIf(type -> this.isAssignable((BType)type, (BType)removeType)));
        ArrayList<BFiniteType> finiteTypesToRemove = new ArrayList<BFiniteType>();
        ArrayList<BType> finiteTypesToAdd = new ArrayList<BType>();
        for (BType remainingType : remainingTypes) {
            if (remainingType.tag != 32) continue;
            BFiniteType finiteType = (BFiniteType)remainingType;
            finiteTypesToRemove.add(finiteType);
            BType remainingTypeWithMatchesRemoved = this.getRemainingType(finiteType, removeTypes);
            if (remainingTypeWithMatchesRemoved == this.symTable.semanticError) continue;
            finiteTypesToAdd.add(remainingTypeWithMatchesRemoved);
        }
        remainingTypes.removeAll(finiteTypesToRemove);
        remainingTypes.addAll(finiteTypesToAdd);
        if (remainingTypes.size() == 1) {
            return remainingTypes.get(0);
        }
        if (remainingTypes.isEmpty()) {
            return this.symTable.nullSet;
        }
        return BUnionType.create(null, new LinkedHashSet<BType>(remainingTypes));
    }

    private BType getRemainingType(BFiniteType originalType, List<BType> removeTypes) {
        LinkedHashSet<BLangExpression> remainingValueSpace = new LinkedHashSet<BLangExpression>();
        for (BLangExpression valueExpr : originalType.getValueSpace()) {
            boolean matchExists = false;
            for (BType remType : removeTypes) {
                if (!this.isAssignable(valueExpr.type, remType) && !this.isAssignableToFiniteType(remType, (BLangLiteral)valueExpr)) continue;
                matchExists = true;
                break;
            }
            if (matchExists) continue;
            remainingValueSpace.add(valueExpr);
        }
        if (remainingValueSpace.isEmpty()) {
            return this.symTable.semanticError;
        }
        BTypeSymbol finiteTypeSymbol = Symbols.createTypeSymbol(0x10001C, originalType.tsymbol.flags, this.names.fromString("$anonType$_" + this.finiteTypeCount++), originalType.tsymbol.pkgID, null, originalType.tsymbol.owner, originalType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BFiniteType intersectingFiniteType = new BFiniteType(finiteTypeSymbol, remainingValueSpace);
        finiteTypeSymbol.type = intersectingFiniteType;
        return intersectingFiniteType;
    }

    public BType getSafeType(BType type, boolean liftNil, boolean liftError) {
        switch (type.tag) {
            case 7: {
                BJSONType jsonType = (BJSONType)type;
                return new BJSONType(jsonType.tag, jsonType.tsymbol, false);
            }
            case 17: {
                return new BAnyType(type.tag, type.tsymbol, false);
            }
            case 11: {
                return new BAnydataType(type.tag, type.tsymbol, false);
            }
            case 37: {
                return new BReadonlyType(type.tag, type.tsymbol, false);
            }
        }
        if (type.tag != 20) {
            return type;
        }
        BUnionType unionType = (BUnionType)type;
        LinkedHashSet<BType> memTypes = new LinkedHashSet<BType>(unionType.getMemberTypes());
        BUnionType errorLiftedType = BUnionType.create(null, memTypes);
        if (liftNil) {
            errorLiftedType.remove(this.symTable.nilType);
        }
        if (liftError) {
            errorLiftedType.remove(this.symTable.errorType);
        }
        if (errorLiftedType.getMemberTypes().size() == 1) {
            return errorLiftedType.getMemberTypes().toArray(new BType[0])[0];
        }
        return errorLiftedType;
    }

    public List<BType> getAllTypes(BType type) {
        if (type.tag != 20) {
            return Lists.of(type);
        }
        ArrayList<BType> memberTypes = new ArrayList<BType>();
        ((BUnionType)type).getMemberTypes().forEach(memberType -> memberTypes.addAll(this.getAllTypes((BType)memberType)));
        return memberTypes;
    }

    public boolean isAllowedConstantType(BType type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 15: {
                return this.isAllowedConstantType(((BMapType)type).constraint);
            }
            case 32: {
                BLangExpression finiteValue = ((BFiniteType)type).getValueSpace().toArray(new BLangExpression[0])[0];
                return this.isAllowedConstantType(finiteValue.type);
            }
        }
        return false;
    }

    public boolean isValidLiteral(BLangLiteral literal, BType targetType) {
        BType literalType = literal.type;
        if (literalType.tag == targetType.tag) {
            return true;
        }
        switch (targetType.tag) {
            case 2: {
                return literalType.tag == 1 && this.isByteLiteralValue((Long)literal.value);
            }
            case 4: {
                return literalType.tag == 3 || literalType.tag == 1;
            }
            case 3: {
                return literalType.tag == 1;
            }
            case 38: {
                return literalType.tag == 1 && this.isSigned32LiteralValue((Long)literal.value);
            }
            case 39: {
                return literalType.tag == 1 && this.isSigned16LiteralValue((Long)literal.value);
            }
            case 40: {
                return literalType.tag == 1 && this.isSigned8LiteralValue((Long)literal.value);
            }
            case 41: {
                return literalType.tag == 1 && this.isUnsigned32LiteralValue((Long)literal.value);
            }
            case 42: {
                return literalType.tag == 1 && this.isUnsigned16LiteralValue((Long)literal.value);
            }
            case 43: {
                return literalType.tag == 1 && this.isUnsigned8LiteralValue((Long)literal.value);
            }
            case 44: {
                return literalType.tag == 5 && this.isCharLiteralValue((String)literal.value);
            }
        }
        return false;
    }

    public void validateErrorOrNilReturn(BLangFunction function, DiagnosticCode diagnosticCode) {
        BType returnType = function.returnTypeNode.type;
        if (returnType.tag == 10) {
            return;
        }
        if (returnType.tag == 20) {
            Set<BType> memberTypes = ((BUnionType)returnType).getMemberTypes();
            if (returnType.isNullable() && memberTypes.stream().allMatch(type -> type.tag == 10 || type.tag == 28)) {
                return;
            }
        }
        this.dlog.error(function.returnTypeNode.pos, diagnosticCode, function.returnTypeNode.type.toString());
    }

    public boolean hasFillerValue(BType type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: {
                return true;
            }
            case 19: {
                return this.checkFillerValue((BArrayType)type);
            }
            case 32: {
                return this.checkFillerValue((BFiniteType)type);
            }
            case 20: {
                return this.checkFillerValue((BUnionType)type);
            }
            case 33: {
                return this.checkFillerValue((BObjectType)type);
            }
            case 12: {
                return this.checkFillerValue((BRecordType)type);
            }
            case 30: {
                BTupleType tupleType = (BTupleType)type;
                return tupleType.getTupleTypes().stream().allMatch(eleType -> this.hasFillerValue((BType)eleType));
            }
        }
        return TypeTags.isIntegerTypeTag(type.tag);
    }

    private boolean checkFillerValue(BObjectType type) {
        if ((type.tsymbol.flags & 0x10000000L) != 0x10000000L) {
            return false;
        }
        BAttachedFunction initFunction = ((BObjectTypeSymbol)type.tsymbol).initializerFunc;
        if (initFunction == null) {
            return true;
        }
        if (initFunction.symbol.getReturnType().getKind() != TypeKind.NIL) {
            return false;
        }
        for (BVarSymbol bVarSymbol : initFunction.symbol.getParameters()) {
            if (bVarSymbol.defaultableParam) continue;
            return false;
        }
        return true;
    }

    private boolean checkFillerValue(BFiniteType type) {
        if (type.isNullable()) {
            return true;
        }
        if (type.getValueSpace().size() == 1) {
            return true;
        }
        Iterator<BLangExpression> iterator = type.getValueSpace().iterator();
        BLangExpression firstElement = iterator.next();
        boolean defaultFillValuePresent = this.isImplicitDefaultValue(firstElement);
        while (iterator.hasNext()) {
            BLangExpression value = iterator.next();
            if (!this.isSameBasicType(value.type, firstElement.type)) {
                return false;
            }
            if (defaultFillValuePresent || !this.isImplicitDefaultValue(value)) continue;
            defaultFillValuePresent = true;
        }
        return defaultFillValuePresent;
    }

    private boolean hasImplicitDefaultValue(Set<BLangExpression> valueSpace) {
        for (BLangExpression expression : valueSpace) {
            if (!this.isImplicitDefaultValue(expression)) continue;
            return true;
        }
        return false;
    }

    private boolean checkFillerValue(BUnionType type) {
        if (type.isNullable()) {
            return true;
        }
        HashSet<BType> memberTypes = new HashSet<BType>();
        boolean hasFillerValue = false;
        boolean defaultValuePresent = false;
        boolean finiteTypePresent = false;
        for (BType member : type.getMemberTypes()) {
            if (member.tag == 32) {
                Set<BType> uniqueValues = this.getValueTypes(((BFiniteType)member).getValueSpace());
                memberTypes.addAll(uniqueValues);
                if (!defaultValuePresent && this.hasImplicitDefaultValue(((BFiniteType)member).getValueSpace())) {
                    defaultValuePresent = true;
                }
                finiteTypePresent = true;
            } else {
                memberTypes.add(member);
            }
            if (hasFillerValue || !this.hasFillerValue(member)) continue;
            hasFillerValue = true;
        }
        if (!hasFillerValue) {
            return false;
        }
        Iterator iterator = memberTypes.iterator();
        BType firstMember = (BType)iterator.next();
        while (iterator.hasNext()) {
            if (this.isSameBasicType(firstMember, (BType)iterator.next())) continue;
            return false;
        }
        if (finiteTypePresent) {
            return defaultValuePresent;
        }
        return true;
    }

    private boolean isSameBasicType(BType source, BType target) {
        if (this.isSameType(source, target)) {
            return true;
        }
        return TypeTags.isIntegerTypeTag(source.tag) && TypeTags.isIntegerTypeTag(target.tag);
    }

    private Set<BType> getValueTypes(Set<BLangExpression> valueSpace) {
        HashSet<BType> uniqueType = new HashSet<BType>();
        for (BLangExpression expression : valueSpace) {
            uniqueType.add(expression.type);
        }
        return uniqueType;
    }

    private boolean isImplicitDefaultValue(BLangExpression expression) {
        if (expression.getKind() == NodeKind.LITERAL || expression.getKind() == NodeKind.NUMERIC_LITERAL) {
            BLangLiteral literalExpression = (BLangLiteral)expression;
            BType literalExprType = literalExpression.type;
            Object value = literalExpression.getValue();
            switch (literalExprType.getKind()) {
                case INT: 
                case BYTE: {
                    return value.equals(0L);
                }
                case STRING: {
                    return value == null || value.equals("");
                }
                case DECIMAL: 
                case FLOAT: {
                    return value.equals(String.valueOf(0.0));
                }
                case BOOLEAN: {
                    return value.equals(false);
                }
                case NIL: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean checkFillerValue(BRecordType type) {
        for (BField field : type.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 4096L) || !Symbols.isFlagOn(field.symbol.flags, 256L)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFillerValue(BArrayType type) {
        if (type.size == -1) {
            return true;
        }
        return this.hasFillerValue(type.eType);
    }

    public BType resolveExprType(BType type) {
        switch (type.tag) {
            case 14: {
                return ((BStreamType)type).constraint;
            }
            case 9: {
                return ((BTableType)type).constraint;
            }
            case 19: {
                return ((BArrayType)type).eType;
            }
            case 20: {
                ArrayList<BType> exprTypes = new ArrayList<BType>(((BUnionType)type).getMemberTypes());
                for (BType returnType : exprTypes) {
                    switch (returnType.tag) {
                        case 14: {
                            return ((BStreamType)returnType).constraint;
                        }
                        case 9: {
                            return ((BTableType)returnType).constraint;
                        }
                        case 19: {
                            return ((BArrayType)returnType).eType;
                        }
                        case 5: 
                        case 8: {
                            return returnType;
                        }
                    }
                }
                break;
            }
        }
        return type;
    }

    private boolean isSimpleBasicType(int tag) {
        switch (tag) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return TypeTags.isIntegerTypeTag(tag) || TypeTags.isStringTypeTag(tag);
    }

    public boolean isOrderedType(BType type) {
        switch (type.tag) {
            case 20: {
                Set<BType> memberTypes = ((BUnionType)type).getMemberTypes();
                for (BType memType : memberTypes) {
                    if (this.isOrderedType(memType)) continue;
                    return false;
                }
                return memberTypes.size() <= 2 && memberTypes.contains(this.symTable.nilType);
            }
            case 19: {
                BType elementType = ((BArrayType)type).eType;
                return this.isOrderedType(elementType);
            }
        }
        return this.isSimpleBasicType(type.tag);
    }

    public boolean isUnionOfSimpleBasicTypes(BType type) {
        if (type.tag == 20) {
            Set<BType> memberTypes = ((BUnionType)type).getMemberTypes();
            for (BType memType : memberTypes) {
                if (this.isSimpleBasicType(memType.tag)) continue;
                return false;
            }
            return true;
        }
        return this.isSimpleBasicType(type.tag);
    }

    public boolean isSubTypeOfReadOnlyOrIsolatedObjectUnion(BType type) {
        if (this.isInherentlyImmutableType(type) || Symbols.isFlagOn(type.flags, 32L)) {
            return true;
        }
        int tag = type.tag;
        if (tag == 33) {
            return this.isIsolated(type);
        }
        if (tag != 20) {
            return false;
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isSubTypeOfReadOnlyOrIsolatedObjectUnion(memberType)) continue;
            return false;
        }
        return true;
    }

    private boolean isIsolated(BType type) {
        return Symbols.isFlagOn(type.flags, 0x20000000L);
    }

    private static class ListenerValidationModel {
        private final Types types;
        private final SymbolTable symtable;
        private final BObjectType emptyServiceType;
        private final BType serviceNameType;
        boolean attachFound;
        boolean detachFound;
        boolean startFound;
        boolean gracefulStopFound;
        boolean immediateStopFound;

        public ListenerValidationModel(Types types, SymbolTable symTable) {
            this.types = types;
            this.symtable = symTable;
            this.emptyServiceType = new BObjectType(new BObjectTypeSymbol(196700, 0L, new Name(""), null, null, null, null, SymbolOrigin.BUILTIN));
            this.emptyServiceType.tsymbol.type = this.emptyServiceType;
            this.serviceNameType = BUnionType.create(null, this.symtable.stringType, this.symtable.arrayStringType, this.symtable.nilType);
        }

        boolean isValidListener() {
            return this.attachFound && this.detachFound && this.startFound && this.gracefulStopFound && this.immediateStopFound;
        }

        private boolean checkMethods(List<BAttachedFunction> rhsFuncs) {
            for (BAttachedFunction func : rhsFuncs) {
                switch (func.funcName.value) {
                    case "attach": {
                        if (this.checkAttachMethod(func)) break;
                        return false;
                    }
                    case "detach": {
                        if (this.checkDetachMethod(func)) break;
                        return false;
                    }
                    case "start": {
                        if (this.checkStartMethod(func)) break;
                        return true;
                    }
                    case "gracefulStop": {
                        if (this.checkGracefulStop(func)) break;
                        return false;
                    }
                    case "immediateStop": {
                        if (this.checkImmediateStop(func)) break;
                        return false;
                    }
                }
            }
            return this.isValidListener();
        }

        private boolean emptyParamList(BAttachedFunction func) {
            return func.type.paramTypes.isEmpty() && func.type.restType != this.symtable.noType;
        }

        private boolean publicAndReturnsErrorOrNil(BAttachedFunction func) {
            if (!Symbols.isPublic(func.symbol)) {
                return false;
            }
            return this.types.isAssignable(func.type.retType, this.symtable.errorOrNilType);
        }

        private boolean isPublicNoParamReturnsErrorOrNil(BAttachedFunction func) {
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            return this.emptyParamList(func);
        }

        private boolean checkImmediateStop(BAttachedFunction func) {
            this.immediateStopFound = this.isPublicNoParamReturnsErrorOrNil(func);
            return this.immediateStopFound;
        }

        private boolean checkGracefulStop(BAttachedFunction func) {
            this.gracefulStopFound = this.isPublicNoParamReturnsErrorOrNil(func);
            return this.gracefulStopFound;
        }

        private boolean checkStartMethod(BAttachedFunction func) {
            this.startFound = this.publicAndReturnsErrorOrNil(func);
            return this.startFound;
        }

        private boolean checkDetachMethod(BAttachedFunction func) {
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            if (func.type.paramTypes.size() != 1) {
                return false;
            }
            BType firstParamType = func.type.paramTypes.get(0);
            this.detachFound = this.isServiceObject(firstParamType);
            return this.detachFound;
        }

        private boolean checkAttachMethod(BAttachedFunction func) {
            boolean sameType;
            if (!this.publicAndReturnsErrorOrNil(func)) {
                return false;
            }
            if (func.type.paramTypes.size() != 2) {
                return false;
            }
            BType firstParamType = func.type.paramTypes.get(0);
            if (!this.isServiceObject(firstParamType)) {
                return false;
            }
            BType secondParamType = func.type.paramTypes.get(1);
            this.attachFound = sameType = this.types.isAssignable(secondParamType, this.serviceNameType);
            return this.attachFound;
        }

        private boolean isServiceObject(BType type) {
            if (type.tag != 33) {
                return false;
            }
            return this.types.isServiceObject((BObjectTypeSymbol)type.tsymbol);
        }
    }

    private static interface TypeEqualityPredicate {
        public boolean test(BType var1, BType var2, Set<TypePair> var3);
    }

    private static class TypePair {
        BType sourceType;
        BType targetType;

        public TypePair(BType sourceType, BType targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.targetType);
        }
    }

    private class BSameTypeVisitor
    implements BTypeVisitor<BType, Boolean> {
        Set<TypePair> unresolvedTypes;

        BSameTypeVisitor(Set<TypePair> unresolvedTypes) {
            this.unresolvedTypes = unresolvedTypes;
        }

        @Override
        public Boolean visit(BType t, BType s) {
            if (t == s) {
                return true;
            }
            switch (t.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return t.tag == s.tag && (TypeParamAnalyzer.isTypeParam(t) || TypeParamAnalyzer.isTypeParam(s));
                }
                case 11: 
                case 17: {
                    return t.tag == s.tag && this.hasSameReadonlyFlag(s, t) && (TypeParamAnalyzer.isTypeParam(t) || TypeParamAnalyzer.isTypeParam(s));
                }
            }
            return false;
        }

        @Override
        public Boolean visit(BBuiltInRefType t, BType s) {
            return t == s;
        }

        @Override
        public Boolean visit(BAnyType t, BType s) {
            return t == s;
        }

        @Override
        public Boolean visit(BAnydataType t, BType s) {
            return t == s;
        }

        @Override
        public Boolean visit(BMapType t, BType s) {
            if (s.tag != 15 || !this.hasSameReadonlyFlag(s, t)) {
                return false;
            }
            BMapType sType = (BMapType)s;
            return Types.this.isSameType(sType.constraint, t.constraint, this.unresolvedTypes);
        }

        @Override
        public Boolean visit(BFutureType t, BType s) {
            return s.tag == 31 && t.constraint.tag == ((BFutureType)s).constraint.tag;
        }

        @Override
        public Boolean visit(BXMLType t, BType s) {
            return this.visit((BBuiltInRefType)t, s);
        }

        @Override
        public Boolean visit(BJSONType t, BType s) {
            return s.tag == 7 && this.hasSameReadonlyFlag(s, t);
        }

        @Override
        public Boolean visit(BArrayType t, BType s) {
            return s.tag == 19 && this.hasSameReadonlyFlag(s, t) && Types.this.isSameArrayType(s, t, this.unresolvedTypes);
        }

        @Override
        public Boolean visit(BObjectType t, BType s) {
            if (t == s) {
                return true;
            }
            if (s.tag != 33) {
                return false;
            }
            return t.tsymbol.pkgID.equals(s.tsymbol.pkgID) && t.tsymbol.name.equals(s.tsymbol.name);
        }

        @Override
        public Boolean visit(BRecordType t, BType s) {
            if (t == s) {
                return true;
            }
            if (s.tag != 12 || !this.hasSameReadonlyFlag(s, t)) {
                return false;
            }
            BRecordType source = (BRecordType)s;
            if (source.fields.size() != t.fields.size()) {
                return false;
            }
            for (BField sourceField : source.fields.values()) {
                if (t.fields.containsKey(sourceField.name.value)) {
                    BField targetField = (BField)t.fields.get(sourceField.name.value);
                    if (Types.this.isSameType(sourceField.type, targetField.type, this.unresolvedTypes) && this.hasSameOptionalFlag(sourceField.symbol, targetField.symbol) && (!Symbols.isFlagOn(targetField.symbol.flags, 32L) || Symbols.isFlagOn(sourceField.symbol.flags, 32L))) continue;
                }
                return false;
            }
            return Types.this.isSameType(source.restFieldType, t.restFieldType, this.unresolvedTypes);
        }

        private boolean hasSameOptionalFlag(BVarSymbol s, BVarSymbol t) {
            return (s.flags & 0x1000L ^ t.flags & 0x1000L) != 4096L;
        }

        private boolean hasSameReadonlyFlag(BType source, BType target) {
            return Symbols.isFlagOn(target.flags, 32L) == Symbols.isFlagOn(source.flags, 32L);
        }

        @Override
        public Boolean visit(BTupleType t, BType s) {
            if (s.tag != 30 || !this.hasSameReadonlyFlag(s, t)) {
                return false;
            }
            BTupleType source = (BTupleType)s;
            if (source.tupleTypes.size() != t.tupleTypes.size()) {
                return false;
            }
            for (int i = 0; i < source.tupleTypes.size(); ++i) {
                if (t.getTupleTypes().get(i) == Types.this.symTable.noType || Types.this.isSameType(source.getTupleTypes().get(i), t.tupleTypes.get(i), this.unresolvedTypes)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visit(BStreamType t, BType s) {
            return t == s;
        }

        @Override
        public Boolean visit(BTableType t, BType s) {
            return t == s;
        }

        @Override
        public Boolean visit(BInvokableType t, BType s) {
            return s.tag == 16 && Types.this.isSameFunctionType((BInvokableType)s, t, this.unresolvedTypes);
        }

        @Override
        public Boolean visit(BUnionType tUnionType, BType s) {
            if (s.tag != 20 || !this.hasSameReadonlyFlag(s, tUnionType)) {
                return false;
            }
            BUnionType sUnionType = (BUnionType)s;
            if (sUnionType.getMemberTypes().size() != tUnionType.getMemberTypes().size()) {
                return false;
            }
            LinkedHashSet<BType> sourceTypes = new LinkedHashSet<BType>(sUnionType.getMemberTypes());
            LinkedHashSet<BType> targetTypes = new LinkedHashSet<BType>(tUnionType.getMemberTypes());
            boolean notSameType = sourceTypes.stream().map(sT -> targetTypes.stream().anyMatch(it -> Types.this.isSameType((BType)it, (BType)sT, this.unresolvedTypes))).anyMatch(foundSameType -> foundSameType == false);
            return !notSameType;
        }

        @Override
        public Boolean visit(BIntersectionType tIntersectionType, BType s) {
            if (s.tag != 21 || !this.hasSameReadonlyFlag(s, tIntersectionType)) {
                return false;
            }
            BIntersectionType sIntersectionType = (BIntersectionType)s;
            if (sIntersectionType.getConstituentTypes().size() != tIntersectionType.getConstituentTypes().size()) {
                return false;
            }
            LinkedHashSet<BType> sourceTypes = new LinkedHashSet<BType>(sIntersectionType.getConstituentTypes());
            LinkedHashSet<BType> targetTypes = new LinkedHashSet<BType>(tIntersectionType.getConstituentTypes());
            for (BType sourceType : sourceTypes) {
                boolean foundSameType = false;
                for (BType targetType : targetTypes) {
                    if (!Types.this.isSameType(sourceType, targetType, this.unresolvedTypes)) continue;
                    foundSameType = true;
                    break;
                }
                if (foundSameType) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visit(BErrorType t, BType s) {
            if (s.tag != 28) {
                return false;
            }
            BErrorType source = (BErrorType)s;
            if (!source.typeIdSet.equals(t.typeIdSet)) {
                return false;
            }
            if (source.detailType == t.detailType) {
                return true;
            }
            return Types.this.isSameType(source.detailType, t.detailType, this.unresolvedTypes);
        }

        @Override
        public Boolean visit(BTypedescType t, BType s) {
            if (s.tag != 13) {
                return false;
            }
            BTypedescType sType = (BTypedescType)s;
            return Types.this.isSameType(sType.constraint, t.constraint, this.unresolvedTypes);
        }

        @Override
        public Boolean visit(BFiniteType t, BType s) {
            return s == t;
        }

        @Override
        public Boolean visit(BParameterizedType t, BType s) {
            if (s.tag != 51) {
                return false;
            }
            BParameterizedType sType = (BParameterizedType)s;
            return Types.this.isSameType(sType.paramValueType, t.paramValueType) && sType.paramSymbol.equals(t.paramSymbol);
        }
    }

    static enum TypeTestResult {
        NOT_FOUND,
        TRUE,
        FALSE;

    }
}

