/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.repository.CompiledPackage;
import org.wso2.ballerinalang.compiler.CompiledJarFile;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;

public class BPackageSymbol
extends BTypeSymbol {
    public BInvokableSymbol initFunctionSymbol;
    public BInvokableSymbol startFunctionSymbol;
    public BInvokableSymbol stopFunctionSymbol;
    public BInvokableSymbol testInitFunctionSymbol;
    public BInvokableSymbol testStartFunctionSymbol;
    public BInvokableSymbol testStopFunctionSymbol;
    public List<BPackageSymbol> imports = new ArrayList<BPackageSymbol>();
    public CompiledBinaryFile.PackageFile packageFile;
    public CompiledPackage compiledPackage;
    public Name compUnit;
    public boolean isUsed = false;
    public BIRNode.BIRPackage bir;
    public CompiledBinaryFile.BIRPackageFile birPackageFile;
    public CompiledJarFile compiledJarFile;
    public boolean entryPointExists = false;

    public BPackageSymbol(PackageID pkgID, BSymbol owner, Location pos, SymbolOrigin origin) {
        super(4097, 0L, pkgID.name, pkgID, null, owner, pos, origin);
        this.type = new BPackageType(this);
    }

    public BPackageSymbol(PackageID pkgID, BSymbol owner, long flags, Location pos, SymbolOrigin origin) {
        this(pkgID, owner, pos, origin);
        this.flags = flags;
    }

    @Override
    public SymbolKind getKind() {
        return SymbolKind.PACKAGE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BPackageSymbol that = (BPackageSymbol)o;
        return this.pkgID.equals(that.pkgID) && Symbols.isFlagOn(this.flags, that.flags);
    }

    public int hashCode() {
        return Objects.hash(this.pkgID, this.flags);
    }

    @Override
    public BPackageSymbol createLabelSymbol() {
        BPackageSymbol copy = new BPackageSymbol(this.pkgID, this.owner, this.pos, this.origin);
        copy.initFunctionSymbol = this.initFunctionSymbol;
        copy.startFunctionSymbol = this.startFunctionSymbol;
        copy.stopFunctionSymbol = this.stopFunctionSymbol;
        copy.testInitFunctionSymbol = this.testInitFunctionSymbol;
        copy.testStartFunctionSymbol = this.testStartFunctionSymbol;
        copy.testStopFunctionSymbol = this.testStopFunctionSymbol;
        copy.packageFile = this.packageFile;
        copy.compiledPackage = this.compiledPackage;
        copy.entryPointExists = this.entryPointExists;
        copy.isLabel = true;
        return copy;
    }

    @Override
    public String toString() {
        return this.pkgID.toString();
    }

    public BIRNode.BIRPackage getBir() {
        return this.bir;
    }
}

