/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.types.IntersectionType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BIntersectionType
extends BType
implements IntersectionType {
    public BType effectiveType;
    private LinkedHashSet<BType> constituentTypes;

    public BIntersectionType(BTypeSymbol tsymbol, LinkedHashSet<BType> types, BType effectiveType) {
        super(21, tsymbol);
        this.constituentTypes = BIntersectionType.toFlatTypeSet(types);
        this.effectiveType = effectiveType;
        for (BType constituentType : this.constituentTypes) {
            if (constituentType.tag != 37) continue;
            this.flags |= 0x20L;
            break;
        }
    }

    public BIntersectionType(BTypeSymbol tsymbol, LinkedHashSet<BType> types, BType effectiveType, long flags) {
        super(21, tsymbol, flags);
        this.constituentTypes = BIntersectionType.toFlatTypeSet(types);
        this.effectiveType = effectiveType;
    }

    public Set<BType> getConstituentTypes() {
        return Collections.unmodifiableSet(this.constituentTypes);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.INTERSECTION;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isNullable() {
        return this.effectiveType.isNullable();
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(" & ", "(", ")");
        for (BType constituentType : this.constituentTypes) {
            if (constituentType.tag == 10) {
                joiner.add("()");
                continue;
            }
            joiner.add(constituentType.toString());
        }
        return joiner.toString();
    }

    @Override
    public boolean isAnydata() {
        return this.effectiveType.isAnydata();
    }

    @Override
    public boolean isPureType() {
        return this.effectiveType.isPureType();
    }

    private static LinkedHashSet<BType> toFlatTypeSet(LinkedHashSet<BType> types) {
        LinkedHashSet<BType> flatSet = new LinkedHashSet<BType>();
        for (BType type : types) {
            if (type.tag != 21) {
                flatSet.add(type);
                continue;
            }
            flatSet.addAll(((BIntersectionType)type).constituentTypes);
        }
        return flatSet;
    }

    public BType getEffectiveType() {
        return this.effectiveType;
    }

    @Override
    public BIntersectionType getImmutableType() {
        return Symbols.isFlagOn(this.flags, 32L) ? this : null;
    }
}

