/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import org.ballerinalang.model.Name;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.types.ValueType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Names;

public class BType
implements ValueType {
    public int tag;
    public BTypeSymbol tsymbol;
    public Name name;
    public long flags;

    public BType(int tag, BTypeSymbol tsymbol) {
        this.tag = tag;
        this.tsymbol = tsymbol;
        this.name = Names.EMPTY;
        this.flags = 0L;
    }

    public BType(int tag, BTypeSymbol tsymbol, long flags) {
        this.tag = tag;
        this.tsymbol = tsymbol;
        this.name = Names.EMPTY;
        this.flags = flags;
    }

    public BType(int tag, BTypeSymbol tsymbol, Name name, long flags) {
        this.tag = tag;
        this.tsymbol = tsymbol;
        this.name = name;
        this.flags = flags;
    }

    public BType getReturnType() {
        return null;
    }

    public boolean isNullable() {
        return false;
    }

    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        switch (this.tag) {
            case 1: {
                return TypeKind.INT;
            }
            case 2: {
                return TypeKind.BYTE;
            }
            case 3: {
                return TypeKind.FLOAT;
            }
            case 4: {
                return TypeKind.DECIMAL;
            }
            case 5: {
                return TypeKind.STRING;
            }
            case 6: {
                return TypeKind.BOOLEAN;
            }
            case 13: {
                return TypeKind.TYPEDESC;
            }
            case 10: {
                return TypeKind.NIL;
            }
            case 49: {
                return TypeKind.NEVER;
            }
            case 28: {
                return TypeKind.ERROR;
            }
            case 37: {
                return TypeKind.READONLY;
            }
        }
        return TypeKind.OTHER;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getKind().typeName();
    }

    protected String getQualifiedTypeName() {
        return this.tsymbol.pkgID.toString() + ":" + this.tsymbol.name;
    }

    public boolean isAnydata() {
        return this.tag <= 11;
    }

    public boolean isPureType() {
        return this.tag == 28 || this.isAnydata();
    }

    public static class NarrowedTypes {
        public BType trueType;
        public BType falseType;

        public NarrowedTypes(BType trueType, BType falseType) {
            this.trueType = trueType;
            this.falseType = falseType;
        }

        public String toString() {
            return "(" + this.trueType + ", " + this.falseType + ")";
        }
    }
}

